/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameStage;
import forge.game.IIdentifiable;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardState;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityCantAttackBlock;
import forge.game.staticability.StaticAbilityContinuous;
import forge.game.staticability.StaticAbilityLayer;
import forge.game.staticability.StaticAbilityView;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Expressions;
import forge.util.FileSection;
import forge.util.ITranslatable;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StaticAbility
extends CardTraitBase
implements IIdentifiable,
Cloneable,
Comparable<StaticAbility> {
    private static int maxId = 0;
    private int id;
    private Set<StaticAbilityLayer> layers;
    private CardCollectionView ignoreEffectCards = new CardCollection();
    private final List<Player> ignoreEffectPlayers = Lists.newArrayList();
    private int mayPlayTurn = 0;
    private SpellAbility payingTrigSA;
    private StaticAbilityView view = null;

    private static int nextId() {
        return ++maxId;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(StaticAbility.class, this.getId());
    }

    public boolean equals(Object obj) {
        return obj instanceof StaticAbility && this.id == ((StaticAbility)obj).id;
    }

    public SpellAbility getPayingTrigSA() {
        if (this.payingTrigSA == null && this.hasParam("Trigger")) {
            this.payingTrigSA = AbilityFactory.getAbility(this.getSVar(this.getParam("Trigger")), this.getHostCard());
            this.payingTrigSA.setIntrinsic(true);
        }
        return this.payingTrigSA;
    }

    private static Map<String, String> parseParams(String abString, Card hostCard) {
        if (abString.length() <= 0) {
            throw new RuntimeException("StaticEffectFactory : getAbility -- abString too short in " + hostCard.getName() + ": [" + abString + "]");
        }
        return FileSection.parseToMap(abString, FileSection.DOLLAR_SIGN_KV_SEPARATOR);
    }

    private Set<StaticAbilityLayer> generateLayer() {
        if (!this.checkMode("Continuous")) {
            return EnumSet.noneOf(StaticAbilityLayer.class);
        }
        EnumSet<StaticAbilityLayer> layers = EnumSet.noneOf(StaticAbilityLayer.class);
        if (this.hasParam("GainControl")) {
            layers.add(StaticAbilityLayer.CONTROL);
        }
        if (this.hasParam("ChangeColorWordsTo") || this.hasParam("GainTextOf") || this.hasParam("AddNames") || this.hasParam("SetName")) {
            layers.add(StaticAbilityLayer.TEXT);
        }
        if (this.hasParam("AddType") || this.hasParam("RemoveType") || this.hasParam("AddAllCreatureTypes") || this.hasParam("RemoveCardTypes") || this.hasParam("RemoveSubTypes") || this.hasParam("RemoveSuperTypes") || this.hasParam("RemoveLandTypes") || this.hasParam("RemoveCreatureTypes") || this.hasParam("RemoveArtifactTypes") || this.hasParam("RemoveEnchantmentTypes")) {
            layers.add(StaticAbilityLayer.TYPE);
        }
        if (this.hasParam("AddColor") || this.hasParam("RemoveColor") || this.hasParam("SetColor")) {
            layers.add(StaticAbilityLayer.COLOR);
        }
        if (this.hasParam("RemoveAllAbilities") || this.hasParam("GainsAbilitiesOf") || this.hasParam("GainsAbilitiesOfDefined") || this.hasParam("GainsTriggerAbsOf") || this.hasParam("AddKeyword") || this.hasParam("AddAbility") || this.hasParam("AddTrigger") || this.hasParam("AddReplacementEffect") || this.hasParam("AddStaticAbility") || this.hasParam("AddSVar") || this.hasParam("CantHaveKeyword") || this.hasParam("ShareRememberedKeywords") || this.hasParam("RemoveKeyword")) {
            layers.add(StaticAbilityLayer.ABILITIES);
        }
        if (this.hasParam("SetPower") || this.hasParam("SetToughness")) {
            layers.add(this.hasParam("CharacteristicDefining") ? StaticAbilityLayer.CHARACTERISTIC : StaticAbilityLayer.SETPT);
        }
        if (this.hasParam("AddPower") || this.hasParam("AddToughness")) {
            layers.add(StaticAbilityLayer.MODIFYPT);
        }
        if (this.hasParam("AddHiddenKeyword") || this.hasParam("MayPlay") || this.hasParam("IgnoreEffectCost") || this.hasParam("Goad") || this.hasParam("CanBlockAny") || this.hasParam("CanBlockAmount") || this.hasParam("AdjustLandPlays") || this.hasParam("ControlVote") || this.hasParam("AdditionalVote") || this.hasParam("AdditionalOptionalVote") || this.hasParam("DeclaresAttackers") || this.hasParam("DeclaresBlockers")) {
            layers.add(StaticAbilityLayer.RULES);
        }
        if (layers.isEmpty()) {
            layers.add(StaticAbilityLayer.RULES);
        }
        return layers;
    }

    public final String toString() {
        if (this.hasParam("Description") && !this.isSuppressed()) {
            ITranslatable nameSource = this.getHostName(this);
            String desc = CardTranslation.translateSingleDescriptionText(this.getParam("Description"), nameSource);
            String translatedName = CardTranslation.getTranslatedName(nameSource);
            desc = TextUtil.fastReplace(desc, "CARDNAME", translatedName);
            desc = TextUtil.fastReplace(desc, "NICKNAME", Lang.getInstance().getNickName(translatedName));
            return desc;
        }
        return "";
    }

    public StaticAbility(String params, Card host, CardState state) {
        this(StaticAbility.parseParams(params, host), host, state);
    }

    public static StaticAbility create(String params, Card host, CardState state, boolean intrinsic) {
        StaticAbility st = new StaticAbility(params, host, state);
        st.setIntrinsic(intrinsic);
        return st;
    }

    private StaticAbility(Map<String, String> params, Card host, CardState state) {
        this.id = StaticAbility.nextId();
        this.originalMapParams.putAll(params);
        this.mapParams.putAll(params);
        this.layers = this.generateLayer();
        this.hostCard = host;
        this.setCardState(state);
    }

    public StaticAbilityView getView() {
        if (this.view == null) {
            this.view = new StaticAbilityView(this);
        } else {
            this.view.updateHostCard(this);
            this.view.updateDescription(this);
        }
        return this.view;
    }

    public final CardCollectionView applyContinuousAbilityBefore(StaticAbilityLayer layer, CardCollectionView preList) {
        if (!this.shouldApplyContinuousAbility(layer, false)) {
            return null;
        }
        return StaticAbilityContinuous.applyContinuousAbility(this, layer, preList);
    }

    public final CardCollectionView applyContinuousAbility(StaticAbilityLayer layer, CardCollectionView affected) {
        if (!this.shouldApplyContinuousAbility(layer, true)) {
            return null;
        }
        return StaticAbilityContinuous.applyContinuousAbility(this, affected, layer);
    }

    private boolean shouldApplyContinuousAbility(StaticAbilityLayer layer, boolean previousRun) {
        return this.layers.contains((Object)layer) && this.checkConditions("Continuous") && (previousRun || this.getHostCard().getStaticAbilities().contains(this));
    }

    public final Cost getAttackCost(Card attacker, GameEntity target, List<Card> attackersWithOptionalCost) {
        if (!(this.checkMode("CantAttackUnless") || this.checkMode("OptionalAttackCost") && attackersWithOptionalCost.contains(attacker))) {
            return null;
        }
        if (!this.checkConditions()) {
            return null;
        }
        return StaticAbilityCantAttackBlock.getAttackCost(this, attacker, target);
    }

    public final boolean hasAttackCost(Card attacker, Class<? extends CostPart> costType) {
        if (!this.checkConditions("OptionalAttackCost")) {
            return false;
        }
        return StaticAbilityCantAttackBlock.getAttackCost(this, attacker, null).hasSpecificCostType(costType);
    }

    public final Cost getBlockCost(Card blocker, Card attacker) {
        if (!this.checkConditions("CantBlockUnless")) {
            return null;
        }
        return StaticAbilityCantAttackBlock.getBlockCost(this, blocker, attacker);
    }

    public final boolean checkMode(String mode) {
        return this.getParam("Mode").equals(mode);
    }

    public final boolean checkConditions(String mode) {
        return this.checkMode(mode) && this.checkConditions();
    }

    public final boolean checkConditions() {
        String svarOperand;
        int operandValue;
        String comparator;
        String svarOperator;
        int sVar;
        int levelMin;
        int level;
        PlayerCollection players;
        Zone zone;
        Player controller = this.getHostCard().getController();
        Game game = this.getHostCard().getGame();
        PhaseHandler ph = game.getPhaseHandler();
        if (this.isSuppressed()) {
            return false;
        }
        if (this.getHostCard().isPhasedOut()) {
            return false;
        }
        if (this.hasParam("EffectZone") ? !this.getParam("EffectZone").equals("All") && ((zone = game.getZoneOf(this.getHostCard())) == null || !ZoneType.listValueOf(this.getParam("EffectZone")).contains((Object)zone.getZoneType())) : !this.hasParam("CharacteristicDefining") && !this.getHostCard().isInPlay()) {
            return false;
        }
        String condition = this.getParam("Condition");
        if (null != condition) {
            if (condition.equals("Threshold") && !controller.hasThreshold()) {
                return false;
            }
            if (condition.equals("Hellbent") && !controller.hasHellbent()) {
                return false;
            }
            if (condition.equals("Metalcraft") && !controller.hasMetalcraft()) {
                return false;
            }
            if (condition.equals("Delirium") && !controller.hasDelirium()) {
                return false;
            }
            if (condition.equals("Ferocious") && !controller.hasFerocious()) {
                return false;
            }
            if (condition.equals("Desert") && !controller.hasDesert()) {
                return false;
            }
            if (condition.equals("Blessing") && !controller.hasBlessing()) {
                return false;
            }
            if (condition.equals("Monarch") & !controller.isMonarch()) {
                return false;
            }
            if (condition.equals("Night") & !game.isNight()) {
                return false;
            }
            if (condition.equals("PlayerTurn") ? !ph.isPlayerTurn(controller) : (condition.equals("NotPlayerTurn") ? ph.isPlayerTurn(controller) : (condition.equals("ExtraTurn") ? !game.getPhaseHandler().getPlayerTurn().isExtraTurn() : condition.equals("FatefulHour") && controller.getLife() > 5))) {
                return false;
            }
        }
        if (this.hasParam("Phases") && !PhaseType.parseRange(this.getParam("Phases")).contains((Object)ph.getPhase())) {
            return false;
        }
        if (this.hasParam("PlayerTurn") && !(players = AbilityUtils.getDefinedPlayers(this.hostCard, this.getParam("PlayerTurn"), this)).contains(ph.getPlayerTurn())) {
            return false;
        }
        if (this.hasParam("UnlessDefinedPlayer") && !(players = AbilityUtils.getDefinedPlayers(this.hostCard, this.getParam("UnlessDefinedPlayer"), this)).isEmpty()) {
            return false;
        }
        if (this.hasParam("TopCardOfLibraryIs")) {
            if (controller.getCardsIn(ZoneType.Library).isEmpty()) {
                return false;
            }
            Card topCard = (Card)controller.getCardsIn(ZoneType.Library).get(false);
            if (!topCard.isValid(this.getParam("TopCardOfLibraryIs").split(","), controller, this.hostCard, (CardTraitBase)this)) {
                return false;
            }
        }
        if (this.hasParam("IsPresent")) {
            ZoneType zone2 = this.hasParam("PresentZone") ? ZoneType.valueOf(this.getParam("PresentZone")) : ZoneType.Battlefield;
            String compare = this.getParamOrDefault("PresentCompare", "GE1");
            Object list = game.getCardsIn(zone2);
            String present = this.getParam("IsPresent");
            list = CardLists.getValidCards((Iterable<Card>)list, present, controller, this.hostCard, (CardTraitBase)this);
            int right = 1;
            String rightString = compare.substring(2);
            right = AbilityUtils.calculateAmount(this.hostCard, rightString, this);
            int left = list.size();
            if (!Expressions.compare(left, compare, right)) {
                return false;
            }
        }
        if (this.hasParam("GameStage")) {
            String[] stageDefs = TextUtil.split(this.getParam("GameStage"), ',');
            boolean isRelevantStage = false;
            for (String stage : stageDefs) {
                isRelevantStage |= game.getAge() == GameStage.valueOf(stage);
            }
            return isRelevantStage;
        }
        if (this.hasParam("Presence")) {
            int ctrl;
            if (this.hostCard.getCastFrom() == null || this.hostCard.getCastSA() == null) {
                return false;
            }
            String type = this.getParam("Presence");
            int revealed = AbilityUtils.calculateAmount(this.hostCard, "Revealed$Valid " + type, this.hostCard.getCastSA());
            if (revealed + (ctrl = AbilityUtils.calculateAmount(this.hostCard, "Count$LastStateBattlefield " + type + ".YouCtrl", this.hostCard.getCastSA())) == 0) {
                return false;
            }
        }
        if (this.hasParam("ClassLevel") && (level = this.hostCard.getClassLevel()) < (levelMin = Integer.parseInt(this.getParam("ClassLevel")))) {
            return false;
        }
        if (this.hasParam("CheckSVar")) {
            sVar = AbilityUtils.calculateAmount(this.hostCard, this.getParam("CheckSVar"), this);
            if (!Expressions.compare(sVar, svarOperator = (comparator = this.getParamOrDefault("SVarCompare", "GE1")).substring(0, 2), operandValue = AbilityUtils.calculateAmount(this.hostCard, svarOperand = comparator.substring(2), this))) {
                return false;
            }
        } else {
            return true;
        }
        if (this.hasParam("CheckSecondSVar")) {
            sVar = AbilityUtils.calculateAmount(this.hostCard, this.getParam("CheckSecondSVar"), this);
            if (!Expressions.compare(sVar, svarOperator = (comparator = this.getParamOrDefault("SecondSVarCompare", "GE1")).substring(0, 2), operandValue = AbilityUtils.calculateAmount(this.hostCard, svarOperand = comparator.substring(2), this))) {
                return false;
            }
        } else {
            return true;
        }
        if (this.hasParam("CheckThirdSVar")) {
            sVar = AbilityUtils.calculateAmount(this.hostCard, this.getParam("CheckThirdSVar"), this);
            if (!Expressions.compare(sVar, svarOperator = (comparator = this.getParamOrDefault("ThirdSVarCompare", "GE1")).substring(0, 2), operandValue = AbilityUtils.calculateAmount(this.hostCard, svarOperand = comparator.substring(2), this))) {
                return false;
            }
        } else {
            return true;
        }
        return !this.hasParam("CheckFourthSVar") || Expressions.compare(sVar = AbilityUtils.calculateAmount(this.hostCard, this.getParam("CheckFourthSVar"), this), svarOperator = (comparator = this.getParamOrDefault("FourthSVarCompare", "GE1")).substring(0, 2), operandValue = AbilityUtils.calculateAmount(this.hostCard, svarOperand = comparator.substring(2), this));
    }

    public CardCollectionView getIgnoreEffectCards() {
        return this.ignoreEffectCards;
    }

    public void setIgnoreEffectCards(CardCollectionView cards) {
        this.ignoreEffectCards = cards;
    }

    public List<Player> getIgnoreEffectPlayers() {
        return this.ignoreEffectPlayers;
    }

    public void addIgnoreEffectPlayers(Player p) {
        this.ignoreEffectPlayers.add(p);
    }

    public void clearIgnoreEffects() {
        this.ignoreEffectPlayers.clear();
        this.ignoreEffectCards = new CardCollection();
    }

    public Set<StaticAbilityLayer> getLayers() {
        return this.layers;
    }

    public int getMayPlayTurn() {
        return this.mayPlayTurn;
    }

    public void incMayPlayTurn() {
        ++this.mayPlayTurn;
    }

    public void resetMayPlayTurn() {
        this.mayPlayTurn = 0;
    }

    @Override
    public int compareTo(StaticAbility arg0) {
        return ComparisonChain.start().compare(this.getHostCard(), arg0.getHostCard()).compare(this.getId(), arg0.getId()).result();
    }

    @Override
    public void setHostCard(Card host) {
        super.setHostCard(host);
        if (this.payingTrigSA != null) {
            this.payingTrigSA.setHostCard(host);
        }
    }

    public StaticAbility copy(Card host, boolean lki) {
        StaticAbility clone = null;
        try {
            clone = (StaticAbility)this.clone();
            clone.id = lki ? this.id : StaticAbility.nextId();
            this.copyHelper(clone, host);
            clone.payingTrigSA = null;
            if (!lki) {
                clone.mayPlayTurn = 0;
            }
            clone.layers = this.generateLayer();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
        }
        return clone;
    }

    @Override
    public List<Object> getTriggerRemembered() {
        return ImmutableList.of();
    }
}

