/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.base.Predicates;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.collect.FCollection;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TargetChoices
extends ForwardingList<GameObject>
implements Cloneable {
    private final FCollection<GameObject> targets = new FCollection();
    private final Map<Card, Player> cardControllers = Maps.newHashMap();
    private final Map<GameObject, Integer> dividedMap = Maps.newHashMap();

    public final int getTotalTargetedCMC() {
        int totalCMC = 0;
        for (Card c : Iterables.filter(this.targets, Card.class)) {
            totalCMC += c.getCMC();
        }
        return totalCMC;
    }

    public final int getTotalTargetedPower() {
        int totalPower = 0;
        for (Card c : Iterables.filter(this.targets, Card.class)) {
            totalPower += c.getNetPower();
        }
        return totalPower;
    }

    public final boolean forEachControllerChanged(Card c) {
        return !c.getController().equals(this.cardControllers.get(c));
    }

    @Override
    public final boolean add(GameObject o) {
        if (o instanceof Player || o instanceof Card || o instanceof SpellAbility) {
            if (o instanceof Card) {
                Card c = (Card)o;
                this.cardControllers.put(c, c.getController());
            }
            return super.add(o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = super.removeAll(collection);
        for (Object e : collection) {
            this.dividedMap.remove(e);
        }
        for (Object e : collection) {
            this.cardControllers.remove(e);
        }
        return result;
    }

    @Override
    public boolean remove(Object object) {
        boolean result = super.remove(object);
        this.dividedMap.remove(object);
        this.cardControllers.remove(object);
        return result;
    }

    public final CardCollectionView getTargetCards() {
        return new CardCollection(Iterables.filter(this.targets, Card.class));
    }

    public final Iterable<Player> getTargetPlayers() {
        return Iterables.filter(this.targets, Player.class);
    }

    public final Iterable<SpellAbility> getTargetSpells() {
        return Iterables.filter(this.targets, SpellAbility.class);
    }

    public final Iterable<GameEntity> getTargetEntities() {
        return Iterables.filter(this.targets, GameEntity.class);
    }

    public final boolean isTargetingAnyCard() {
        return Iterables.any(this.targets, Predicates.instanceOf(Card.class));
    }

    public final boolean isTargetingAnyPlayer() {
        return Iterables.any(this.targets, Predicates.instanceOf(Player.class));
    }

    public final boolean isTargetingAnySpell() {
        return Iterables.any(this.targets, Predicates.instanceOf(SpellAbility.class));
    }

    public final Card getFirstTargetedCard() {
        return Iterables.getFirst(this.getTargetCards(), null);
    }

    public final Player getFirstTargetedPlayer() {
        return Iterables.getFirst(this.getTargetPlayers(), null);
    }

    public final SpellAbility getFirstTargetedSpell() {
        return Iterables.getFirst(this.getTargetSpells(), null);
    }

    public final void replaceTargetCard(Card old, CardCollectionView replace) {
        this.targets.remove(old);
        this.targets.addAll(replace);
    }

    public TargetChoices clone() {
        TargetChoices tc = new TargetChoices();
        tc.targets.addAll((Collection<GameObject>)this.targets);
        tc.dividedMap.putAll(this.dividedMap);
        tc.cardControllers.putAll(this.cardControllers);
        return tc;
    }

    @Override
    protected List<GameObject> delegate() {
        return this.targets;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Card) {
            return Iterables.any(Iterables.filter(this.targets, Card.class), c -> c.equalsWithGameTimestamp((Card)o));
        }
        return super.contains(o);
    }

    public final void addDividedAllocation(GameObject tgt, Integer portionAllocated) {
        this.dividedMap.put(tgt, portionAllocated);
    }

    public Integer getDividedValue(GameObject c) {
        return this.dividedMap.get(c);
    }

    public Collection<Integer> getDividedValues() {
        return this.dividedMap.values();
    }

    public int getTotalDividedValue() {
        int result = 0;
        for (Integer i : this.getDividedValues()) {
            if (i == null) continue;
            result += i.intValue();
        }
        return result;
    }
}

