/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import forge.game.card.CardView;
import forge.game.card.IHasCardView;
import forge.game.player.PlayerView;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.trackable.TrackableCollection;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableProperty;
import forge.util.collect.FCollectionView;

public class StackItemView
extends TrackableObject
implements IHasCardView {
    private static final long serialVersionUID = 6733415646691356052L;

    public static StackItemView get(SpellAbilityStackInstance si) {
        return si == null ? null : si.getView();
    }

    public static TrackableCollection<StackItemView> getCollection(Iterable<SpellAbilityStackInstance> instances) {
        if (instances == null) {
            return null;
        }
        TrackableCollection<StackItemView> collection = new TrackableCollection<StackItemView>();
        for (SpellAbilityStackInstance si : instances) {
            collection.add(si.getView());
        }
        return collection;
    }

    public StackItemView(SpellAbilityStackInstance si) {
        super(si.getId(), si.getSourceCard().getGame().getTracker());
        this.updateKey(si);
        this.updateSourceTrigger(si);
        this.updateText(si);
        this.updateSourceCard(si);
        this.updateActivatingPlayer(si);
        this.updateTargetCards(si);
        this.updateTargetPlayers(si);
        this.updateAbility(si);
        this.updateOptionalTrigger(si);
        this.updateSubInstance(si);
        this.updateOptionalCost(si);
    }

    public String getKey() {
        return (String)this.get(TrackableProperty.Key);
    }

    void updateKey(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.Key, si.getSpellAbility().yieldKey());
    }

    public String getOptionalCostString() {
        return (String)this.get(TrackableProperty.OptionalCosts);
    }

    void updateOptionalCost(SpellAbilityStackInstance si) {
        String OptionalCostString = "";
        boolean kicked = false;
        boolean entwined = false;
        boolean buyback = false;
        boolean retraced = false;
        boolean jumpstart = false;
        boolean additional = false;
        boolean alternate = false;
        boolean generic = false;
        for (OptionalCost cost : si.getSpellAbility().getOptionalCosts()) {
            if (cost == OptionalCost.Kicker1 || cost == OptionalCost.Kicker2) {
                kicked = true;
            }
            if (cost == OptionalCost.Entwine) {
                entwined = true;
            }
            if (cost == OptionalCost.Buyback) {
                buyback = true;
            }
            if (cost == OptionalCost.Retrace) {
                retraced = true;
            }
            if (cost == OptionalCost.Jumpstart) {
                jumpstart = true;
            }
            if (cost == OptionalCost.Flash) {
                additional = true;
            }
            if (cost == OptionalCost.Generic) {
                generic = true;
            }
            if (cost != OptionalCost.AltCost) continue;
            alternate = true;
        }
        if (!alternate) {
            if (kicked && !generic) {
                OptionalCostString = OptionalCostString + "Kicked";
            }
            if (entwined) {
                OptionalCostString = OptionalCostString + (OptionalCostString.isEmpty() ? "Entwined" : ", Entwined");
            }
            if (buyback) {
                OptionalCostString = OptionalCostString + (OptionalCostString.isEmpty() ? "Buyback" : ", Buyback");
            }
            if (retraced) {
                OptionalCostString = OptionalCostString + (OptionalCostString.isEmpty() ? "Retraced" : ", Retraced");
            }
            if (jumpstart) {
                OptionalCostString = OptionalCostString + (OptionalCostString.isEmpty() ? "Jumpstart" : ", Jumpstart");
            }
            if (additional || generic) {
                OptionalCostString = OptionalCostString + (OptionalCostString.isEmpty() ? "Additional" : ", Additional");
            }
        }
        this.set(TrackableProperty.OptionalCosts, OptionalCostString);
    }

    public int getSourceTrigger() {
        return (Integer)this.get(TrackableProperty.SourceTrigger);
    }

    void updateSourceTrigger(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.SourceTrigger, si.getSpellAbility().getSourceTrigger());
    }

    public String getText() {
        return (String)this.get(TrackableProperty.Text);
    }

    void updateText(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.Text, si.getStackDescription());
    }

    public CardView getSourceCard() {
        return (CardView)this.get(TrackableProperty.SourceCard);
    }

    void updateSourceCard(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.SourceCard, CardView.get(si.getSourceCard()));
    }

    public PlayerView getActivatingPlayer() {
        return (PlayerView)this.get(TrackableProperty.ActivatingPlayer);
    }

    void updateActivatingPlayer(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.ActivatingPlayer, PlayerView.get(si.getActivatingPlayer()));
    }

    public FCollectionView<CardView> getTargetCards() {
        return (FCollectionView)this.get(TrackableProperty.TargetCards);
    }

    void updateTargetCards(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.TargetCards, CardView.getCollection(si.getTargetChoices().getTargetCards()));
    }

    public FCollectionView<PlayerView> getTargetPlayers() {
        return (FCollectionView)this.get(TrackableProperty.TargetPlayers);
    }

    void updateTargetPlayers(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.TargetPlayers, PlayerView.getCollection(si.getTargetChoices().getTargetPlayers()));
    }

    public boolean isAbility() {
        return (Boolean)this.get(TrackableProperty.Ability);
    }

    void updateAbility(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.Ability, si.isAbility());
    }

    public boolean isOptionalTrigger() {
        return (Boolean)this.get(TrackableProperty.OptionalTrigger);
    }

    void updateOptionalTrigger(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.OptionalTrigger, si.isOptionalTrigger());
    }

    public StackItemView getSubInstance() {
        return (StackItemView)this.get(TrackableProperty.SubInstance);
    }

    void updateSubInstance(SpellAbilityStackInstance si) {
        this.set(TrackableProperty.SubInstance, si.getSubInstance() == null ? null : new StackItemView(si.getSubInstance()));
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public CardView getCardView() {
        return this.getSourceCard();
    }
}

