/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.collect.Maps;
import forge.game.card.CardView;
import forge.game.card.IHasCardView;
import forge.game.spellability.SpellAbility;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableProperty;
import forge.trackable.Tracker;
import java.util.LinkedHashMap;
import java.util.Map;

public class SpellAbilityView
extends TrackableObject
implements IHasCardView {
    private static final long serialVersionUID = 2514234930798754769L;

    public static SpellAbilityView get(SpellAbility spab) {
        return spab == null ? null : spab.getView();
    }

    public static <T extends SpellAbility> Map<SpellAbilityView, T> getMap(Iterable<T> spabs) {
        LinkedHashMap<SpellAbilityView, SpellAbility> spellViewCache = Maps.newLinkedHashMap();
        for (SpellAbility spellAbility : spabs) {
            spellViewCache.put(spellAbility.getView(), spellAbility);
        }
        return spellViewCache;
    }

    SpellAbilityView(SpellAbility sa) {
        this(sa, sa.getHostCard() == null || sa.getHostCard().getGame() == null ? null : sa.getHostCard().getGame().getTracker());
    }

    SpellAbilityView(SpellAbility sa, Tracker tracker) {
        super(sa.getId(), tracker);
        this.updateHostCard(sa);
        this.updateDescription(sa);
        this.updatePromptIfOnlyPossibleAbility(sa);
    }

    public String toString() {
        return this.getDescription();
    }

    public CardView getHostCard() {
        return (CardView)this.get(TrackableProperty.HostCard);
    }

    void updateHostCard(SpellAbility sa) {
        this.set(TrackableProperty.HostCard, CardView.get(sa.getHostCard()));
    }

    public String getDescription() {
        return (String)this.get(TrackableProperty.Description);
    }

    void updateDescription(SpellAbility sa) {
        this.set(TrackableProperty.Description, sa.toUnsuppressedString());
    }

    public boolean canPlay() {
        return (Boolean)this.get(TrackableProperty.CanPlay);
    }

    void updateCanPlay(SpellAbility sa, boolean optionalCost) {
        this.set(TrackableProperty.CanPlay, sa.canPlay(optionalCost));
    }

    public boolean promptIfOnlyPossibleAbility() {
        return (Boolean)this.get(TrackableProperty.PromptIfOnlyPossibleAbility);
    }

    void updatePromptIfOnlyPossibleAbility(SpellAbility sa) {
        this.set(TrackableProperty.PromptIfOnlyPossibleAbility, sa.promptIfOnlyPossibleAbility());
    }

    @Override
    public CardView getCardView() {
        return this.getHostCard();
    }
}

