/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import forge.card.CardStateName;
import forge.card.mana.ManaCost;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactory;
import forge.game.cost.Cost;
import forge.game.cost.CostPayment;
import forge.game.player.Player;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityCantBeCast;
import forge.game.zone.ZoneType;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public abstract class Spell
extends SpellAbility
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7930920571482203460L;
    private static boolean performanceMode = false;
    private boolean castFaceDown = false;

    public static void setPerformanceMode(boolean performanceMode) {
        Spell.performanceMode = performanceMode;
    }

    public Spell(Card sourceCard, Cost abCost) {
        super(sourceCard, abCost);
        this.setStackDescription(sourceCard.getSpellText());
        this.getRestrictions().setZone(ZoneType.Hand);
    }

    @Override
    public boolean canPlay() {
        Card card = this.getHostCard();
        if (card.isInPlay()) {
            return false;
        }
        Player activator = this.getActivatingPlayer();
        if (activator == null && (activator = card.getController()) == null) {
            return false;
        }
        Game game = activator.getGame();
        if (game.getStack().isSplitSecondOnStack()) {
            return false;
        }
        ManaCost origCost = card.getState(card.isFaceDown() ? CardStateName.Original : card.getCurrentStateName()).getManaCost();
        if (!performanceMode && !card.getController().equals(activator)) {
            card = CardCopyService.getLKICopy(card);
            card.setController(activator, 0L);
        }
        card = ObjectUtils.firstNonNull(this.getAlternateHost(card), card);
        if (!this.getRestrictions().canPlay(card, this)) {
            return false;
        }
        if (!this.isCastFaceDown() && !this.isCastFromPlayEffect() && this.isBasicSpell() && origCost.isNoCost()) {
            return false;
        }
        return CostPayment.canPayAdditionalCosts(this.getPayCosts(), this, false);
    }

    @Override
    public boolean checkRestrictions(Card host, Player activator) {
        return !StaticAbilityCantBeCast.cantBeCastAbility(this, host, activator);
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new RuntimeException("Spell : clone() error, " + ex);
        }
    }

    @Override
    public boolean isSpell() {
        return true;
    }

    @Override
    public boolean isAbility() {
        return false;
    }

    @Override
    public boolean isCastFaceDown() {
        return this.castFaceDown;
    }

    public void setCastFaceDown(boolean faceDown) {
        this.castFaceDown = faceDown;
    }

    @Override
    public Card getAlternateHost(Card source) {
        boolean lkicheck = false;
        if (source.isFaceDown() && source.isInZone(ZoneType.Exile)) {
            if (!source.isLKI()) {
                source = CardCopyService.getLKICopy(source);
            }
            source.forceTurnFaceUp();
            lkicheck = true;
        }
        if (this.isBestow() && !source.isBestowed()) {
            if (!source.isLKI()) {
                source = CardCopyService.getLKICopy(source);
            }
            source.animateBestow(false);
            lkicheck = true;
        } else if (this.isCastFaceDown()) {
            if (!source.isLKI()) {
                source = CardCopyService.getLKICopy(source);
            }
            source.turnFaceDownNoUpdate();
            lkicheck = true;
        } else if (this.getCardState() != null && source.getCurrentStateName() != this.getCardStateName() && this.getHostCard().getState(this.getCardStateName()) != null) {
            CardStateName stateName;
            if (!source.isLKI()) {
                source = CardCopyService.getLKICopy(source);
            }
            if (!source.hasState(stateName = this.getCardStateName())) {
                source.addAlternateState(stateName, false);
                source.getState(stateName).copyFrom(this.getHostCard().getState(stateName), true);
            }
            source.setState(stateName, false);
            if (this.getHostCard().isDoubleFaced()) {
                source.setBackSide(this.getHostCard().getRules().getSplitType().getChangedStateName().equals((Object)stateName));
            }
            source.setLKICMC(-1);
            source.setLKICMC(source.getCMC());
            lkicheck = true;
        } else if (this.hasParam("Prototype")) {
            if (!source.isLKI()) {
                source = CardCopyService.getLKICopy(source);
            }
            long next = source.getGame().getNextTimestamp();
            source.addCloneState(CardFactory.getCloneStates(source, source, this), next);
            lkicheck = true;
        }
        return lkicheck ? source : null;
    }

    @Override
    public boolean isCounterableBy(SpellAbility sa) {
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this.getHostCard());
        repParams.put(AbilityKey.SpellAbility, this);
        repParams.put(AbilityKey.Cause, sa);
        return !this.getHostCard().getGame().getReplacementHandler().cantHappenCheck(ReplacementType.Counter, repParams);
    }
}

