/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import forge.card.CardStateName;
import forge.card.mana.ManaCost;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.player.Player;
import forge.game.spellability.AbilityStatic;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Localizer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class LandAbility
extends AbilityStatic {
    public LandAbility(Card sourceCard) {
        super(sourceCard, ManaCost.NO_COST);
        this.getRestrictions().setZone(ZoneType.Hand);
    }

    public boolean canPlay(Card newHost) {
        Player p = this.getActivatingPlayer();
        return p.canPlayLand(newHost, false, this);
    }

    @Override
    public boolean isLandAbility() {
        return true;
    }

    @Override
    public boolean isSecondary() {
        return true;
    }

    @Override
    public boolean canPlay() {
        Card land = this.getHostCard();
        Player p = this.getActivatingPlayer();
        if (p == null || land.isInZone(ZoneType.Battlefield)) {
            return false;
        }
        if (this.getCardState() != null && land.getCurrentStateName() != this.getCardStateName()) {
            CardStateName stateName;
            if (!land.isLKI()) {
                land = CardCopyService.getLKICopy(land);
            }
            if (!land.hasState(stateName = this.getCardStateName())) {
                land.addAlternateState(stateName, false);
                land.getState(stateName).copyFrom(this.getHostCard().getState(stateName), true);
            }
            land.setState(stateName, false);
            land.setLKICMC(-1);
            land.setLKICMC(land.getCMC());
        }
        return p.canPlayLand(land, false, this);
    }

    @Override
    public void resolve() {
        this.getHostCard().setSplitStateToPlayAbility(this);
        Card result = this.getActivatingPlayer().playLandNoCheck(this.getHostCard(), this);
        if (this.getMayPlay() != null) {
            this.getMayPlay().incMayPlayTurn();
        }
        if (result != null && !result.isInPlay()) {
            result.setState(CardStateName.Original, true);
        }
    }

    @Override
    public String toUnsuppressedString() {
        Card source;
        StaticAbility sta;
        Localizer localizer = Localizer.getInstance();
        StringBuilder sb = new StringBuilder(StringUtils.capitalize(localizer.getMessage("lblPlayLand", new Object[0])));
        if (this.getHostCard().isModal()) {
            sb.append(" (").append(CardTranslation.getTranslatedName(this.getHostCard().getName(ObjectUtils.firstNonNull(this.getCardStateName(), CardStateName.Original)))).append(")");
        }
        if ((sta = this.getMayPlay()) != null && !(source = sta.getHostCard()).equals(this.getHostCard())) {
            sb.append(" by ");
            if (source.isImmutable() && source.getEffectSource() != null) {
                sb.append(source.getEffectSource());
            } else {
                sb.append(source);
            }
            if (sta.hasParam("MayPlayText")) {
                sb.append(" (").append(sta.getParam("MayPlayText")).append(")");
            }
        }
        return sb.toString();
    }

    @Override
    public Card getAlternateHost(Card source) {
        boolean lkicheck = false;
        if (source.isFaceDown() && source.isInZone(ZoneType.Exile)) {
            if (!source.isLKI()) {
                source = CardCopyService.getLKICopy(source);
            }
            source.forceTurnFaceUp();
            lkicheck = true;
        }
        if (this.getCardState() != null && source.getCurrentStateName() != this.getCardStateName()) {
            CardStateName stateName;
            if (!source.isLKI()) {
                source = CardCopyService.getLKICopy(source);
            }
            if (!source.hasState(stateName = this.getCardState().getStateName())) {
                source.addAlternateState(stateName, false);
                source.getState(stateName).copyFrom(this.getHostCard().getState(stateName), true);
            }
            source.setState(stateName, false);
            if (this.getHostCard().isDoubleFaced()) {
                source.setBackSide(this.getHostCard().getRules().getSplitType().getChangedStateName().equals((Object)stateName));
            }
            source.setLKICMC(-1);
            source.setLKICMC(source.getCMC());
            lkicheck = true;
        }
        return lkicheck ? source : null;
    }
}

