/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.esotericsoftware.minlog.Log;
import forge.card.mana.ManaCost;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityView;

public abstract class Ability
extends SpellAbility {
    protected Ability(Card sourceCard, ManaCost manaCost) {
        this(sourceCard, new Cost(manaCost, true), null);
    }

    protected Ability(Card sourceCard, ManaCost manaCost, SpellAbilityView view0) {
        this(sourceCard, new Cost(manaCost, true), view0);
    }

    protected Ability(Card sourceCard, Cost cost) {
        this(sourceCard, cost, null);
    }

    protected Ability(Card sourceCard, Cost cost, SpellAbilityView view0) {
        super(sourceCard, cost, view0);
    }

    public Ability(Card sourceCard, ManaCost manaCost, String stackDescription) {
        this(sourceCard, manaCost);
        this.setStackDescription(stackDescription);
        Log.debug("an ability is being played from" + sourceCard.getName());
    }

    @Override
    public boolean canPlay() {
        Game game = this.getActivatingPlayer().getGame();
        if (game.getStack().isSplitSecondOnStack() && !this.isManaAbility()) {
            return false;
        }
        return this.getHostCard().isInPlay() && !this.getHostCard().isFaceDown();
    }
}

