/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.TokenCreateTable;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class ReplaceToken
extends ReplacementEffect {
    public ReplaceToken(Map<String, String> mapParams, Card host, boolean intrinsic) {
        super(mapParams, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        Boolean effectOnly;
        if (this.hasParam("EffectOnly") && !(effectOnly = (Boolean)runParams.get((Object)AbilityKey.EffectOnly)).booleanValue()) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        return this.filterAmount((TokenCreateTable)runParams.get((Object)AbilityKey.Token)) > 0;
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.TokenNum, this.filterAmount((TokenCreateTable)runParams.get((Object)AbilityKey.Token)));
        sa.setReplacingObjectsFrom(runParams, AbilityKey.Token, AbilityKey.Cause);
        sa.setReplacingObject(AbilityKey.Player, runParams.get((Object)AbilityKey.Affected));
    }

    public int filterAmount(TokenCreateTable table) {
        return table.getFilterAmount(this.getParamOrDefault("ValidPlayer", null), this.getParamOrDefault("ValidToken", null), this);
    }
}

