/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.util.Expressions;
import java.util.Map;

public class ReplaceRemoveCounter
extends ReplacementEffect {
    public ReplaceRemoveCounter(Map<String, String> map, Card host, boolean intrinsic) {
        super(map, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        int operandValue;
        String comparator;
        String operator;
        int n;
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (this.hasParam("IsDamage") && this.getParam("IsDamage").equals("True") != ((Boolean)runParams.get((Object)AbilityKey.IsDamage)).booleanValue()) {
            return false;
        }
        if (this.hasParam("ValidCounterType")) {
            CounterType cType = (CounterType)runParams.get((Object)AbilityKey.CounterType);
            String type = this.getParam("ValidCounterType");
            if (!type.equals(cType.toString())) {
                return false;
            }
        }
        return !this.hasParam("Result") || Expressions.compare(n = ((Integer)runParams.get((Object)AbilityKey.Result)).intValue(), operator = (comparator = this.getParam("Result")).substring(0, 2), operandValue = Integer.parseInt(comparator.substring(2)));
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.CounterMap, runParams.get((Object)AbilityKey.CounterMap));
        Object o = runParams.get((Object)AbilityKey.Affected);
        if (o instanceof Card) {
            sa.setReplacingObject(AbilityKey.Card, o);
        } else if (o instanceof Player) {
            sa.setReplacingObject(AbilityKey.Player, o);
        }
        sa.setReplacingObject(AbilityKey.Object, o);
    }
}

