/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.util.Expressions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ReplaceProduceMana
extends ReplacementEffect {
    public ReplaceProduceMana(Map<String, String> mapParams, Card host, boolean intrinsic) {
        super(mapParams, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (!this.matchesValidParam("ValidActivator", runParams.get((Object)AbilityKey.Activator))) {
            return false;
        }
        if (!this.matchesValid(runParams.get((Object)AbilityKey.AbilityMana), this.getParamOrDefault("ValidSA", "Activated.hasTapCost+ManaAbility").split(","), this.getHostCard())) {
            return false;
        }
        if (this.hasParam("ManaAmount")) {
            String full = this.getParam("ManaAmount");
            String operator = full.substring(0, 2);
            String operand = full.substring(2);
            int intoperand = AbilityUtils.calculateAmount(this.getHostCard(), operand, this);
            int manaAmount = StringUtils.countMatches((CharSequence)((String)runParams.get((Object)AbilityKey.Mana)), " ") + 1;
            if (!Expressions.compare(manaAmount, operator, intoperand)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.Mana, runParams.get((Object)AbilityKey.Mana));
    }
}

