/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.zone.ZoneType;
import forge.util.Expressions;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlayerProperty {
    public static boolean playerHasProperty(Player player, String property, Player sourceController, Card source, CardTraitBase spellAbility) {
        Game game = player.getGame();
        if (property.equals("Activator")) {
            if (!player.equals(spellAbility.getHostCard().getController())) {
                return false;
            }
        } else if (property.equals("You")) {
            if (!player.equals(sourceController)) {
                return false;
            }
        } else if (property.equals("Opponent")) {
            if (player.equals(sourceController) || !player.isOpponentOf(sourceController)) {
                return false;
            }
        } else if (property.startsWith("OpponentOf ")) {
            String v = property.split(" ")[1];
            PlayerCollection players = AbilityUtils.getDefinedPlayers(source, v, spellAbility);
            for (Player p : players) {
                if (!player.equals(p) && player.isOpponentOf(p)) continue;
                return false;
            }
        } else if (property.startsWith("PlayerUID_")) {
            if (player.getId() != Integer.parseInt(property.split("PlayerUID_")[1])) {
                return false;
            }
        } else if (property.equals("YourTeam")) {
            if (!player.sameTeam(sourceController)) {
                return false;
            }
        } else if (property.equals("Allies")) {
            if (player.equals(sourceController) || player.isOpponentOf(sourceController)) {
                return false;
            }
        } else if (property.equals("Active")) {
            if (!game.getPhaseHandler().isPlayerTurn(player)) {
                return false;
            }
        } else if (property.equals("NonActive")) {
            if (game.getPhaseHandler().isPlayerTurn(player)) {
                return false;
            }
        } else if (property.equals("OpponentToActive")) {
            Player active = game.getPhaseHandler().getPlayerTurn();
            if (player.equals(active) || !player.isOpponentOf(active)) {
                return false;
            }
        } else if (property.equals("Other")) {
            if (player.equals(sourceController)) {
                return false;
            }
        } else if (property.equals("CardOwner")) {
            if (!player.equals(source.getOwner())) {
                return false;
            }
        } else if (property.equals("descended")) {
            if (player.getDescended() < 1) {
                return false;
            }
        } else if (property.equals("committedCrimeThisTurn")) {
            if (player.getCommittedCrimeThisTurn() < 1) {
                return false;
            }
        } else if (property.equals("isMonarch")) {
            if (!player.isMonarch()) {
                return false;
            }
        } else if (property.equals("hasInitiative")) {
            if (!player.hasInitiative()) {
                return false;
            }
        } else if (property.equals("hasBlessing")) {
            if (!player.hasBlessing()) {
                return false;
            }
        } else if (property.startsWith("damageDoneSingleSource")) {
            int maxDmg;
            String props = property.split(" ")[1];
            List<Integer> sourceDmg = game.getDamageDoneThisTurn(null, false, "Card.YouCtrl", null, source, sourceController, spellAbility);
            int n = maxDmg = sourceDmg.isEmpty() ? 0 : Collections.max(sourceDmg);
            if (!Expressions.compare(maxDmg, props.substring(0, 2), AbilityUtils.calculateAmount(source, props.substring(2), spellAbility))) {
                return false;
            }
        } else if (property.startsWith("wasDealtCombatDamageThisCombatBy ")) {
            String v = property.split(" ")[1];
            boolean found = false;
            CardCollection cards = AbilityUtils.getDefinedCards(source, v, spellAbility);
            for (Card card : cards) {
                if (!card.getDamageHistory().getThisCombatDamaged().contains(player)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        } else if (property.startsWith("wasDealtDamageThisGameBy ")) {
            String v = property.split(" ")[1];
            boolean found = false;
            CardCollection cards = AbilityUtils.getDefinedCards(source, v, spellAbility);
            for (Card card : cards) {
                if (!card.getDamageHistory().getThisGameDamaged().contains(player)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        } else if (property.startsWith("wasDealt")) {
            boolean found = false;
            String validCard = null;
            Boolean combat = null;
            if (property.contains("CombatDamage")) {
                combat = true;
            }
            if (property.contains("ThisTurnBySource")) {
                found = source.getDamageHistory().getDamageDoneThisTurn(combat, validCard == null, validCard, "You", source, player, spellAbility) > 0;
            } else {
                String comp = "GE";
                int right = 1;
                int numValid = 0;
                if (property.contains("ThisTurnBy")) {
                    String[] props = property.split(" ");
                    validCard = props[1];
                    if (props.length > 2) {
                        comp = props[2].substring(0, 2);
                        right = AbilityUtils.calculateAmount(source, props[2].substring(2), spellAbility);
                    }
                }
                numValid = game.getDamageDoneThisTurn(combat, validCard == null, validCard, "You", source, player, spellAbility).size();
                found = Expressions.compare(numValid, comp, right);
            }
            if (!found) {
                return false;
            }
        } else if (property.equals("attackedBySourceThisCombat")) {
            if (game.getCombat() == null || !player.equals(game.getCombat().getDefenderPlayerByAttacker(source))) {
                return false;
            }
        } else if (property.equals("attackedBySourceThisTurn")) {
            if (!source.getDamageHistory().hasAttackedThisTurn(player)) {
                return false;
            }
        } else if (property.equals("Attacking")) {
            if (game.getCombat() == null || !player.equals(game.getCombat().getAttackingPlayer())) {
                return false;
            }
        } else if (property.equals("Defending")) {
            if (game.getCombat() == null || !game.getCombat().getAttackersAndDefenders().values().contains(player)) {
                return false;
            }
        } else if (property.startsWith("LostLifeThisTurn")) {
            String comparator = "GE";
            int value = 1;
            if (!property.equals("LostLifeThisTurn")) {
                String compareAndValue = property.split(" ")[1];
                comparator = compareAndValue.substring(0, 2);
                String rightString = compareAndValue.substring(2);
                value = AbilityUtils.calculateAmount(source, rightString, spellAbility);
            }
            if (!Expressions.compare(player.getLifeLostThisTurn(), comparator, value)) {
                return false;
            }
        } else if (property.equals("TappedLandForManaThisTurn")) {
            if (!player.hasTappedLandForManaThisTurn()) {
                return false;
            }
        } else if (property.equals("CardsInHandAtBeginningOfTurn")) {
            if (player.getNumCardsInHandStartedThisTurnWith() <= 0) {
                return false;
            }
        } else if (property.equals("IsRemembered")) {
            if (!source.isRemembered(player)) {
                return false;
            }
        } else if (property.equals("IsRememberedOrController")) {
            boolean found = false;
            for (Object o : source.getRemembered()) {
                Card c;
                if (o instanceof Player) {
                    Player p = (Player)o;
                    if (!p.equals(player)) continue;
                    found = true;
                    break;
                }
                if (!(o instanceof Card) || !(c = (Card)o).getController().equals(player)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        } else if (property.equals("IsNotRemembered")) {
            if (source.isRemembered(player)) {
                return false;
            }
        } else if (property.equals("IsTriggerRemembered")) {
            boolean found = false;
            for (Object o : spellAbility.getTriggerRemembered()) {
                Player trigRem;
                if (!(o instanceof Player) || !(trigRem = (Player)o).equals(player)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        } else if (property.equals("EnchantedBy")) {
            if (!player.isEnchantedBy(source)) {
                return false;
            }
        } else if (property.equals("EnchantedController")) {
            Card enchanting = source.getEnchantingCard();
            if (enchanting == null || !player.equals(enchanting.getController())) {
                return false;
            }
        } else if (property.equals("Chosen")) {
            if (source.getChosenPlayer() == null || !source.getChosenPlayer().equals(player)) {
                return false;
            }
        } else {
            if (property.equals("NotedDefender")) {
                String tracker = player.getDraftNotes().getOrDefault("Cogwork Tracker", "");
                return Iterables.contains(Arrays.asList(tracker.split(",")), String.valueOf(player));
            }
            if (property.startsWith("life")) {
                int amount;
                int life = player.getLife();
                if (!Expressions.compare(life, property, amount = AbilityUtils.calculateAmount(source, property.substring(6), spellAbility))) {
                    return false;
                }
            } else if (property.equals("IsPoisoned")) {
                if (player.getPoisonCounters() <= 0) {
                    return false;
                }
            } else if (property.equals("IsCorrupted")) {
                if (player.getPoisonCounters() <= 2) {
                    return false;
                }
            } else if (property.startsWith("controls")) {
                int y;
                ArrayList<String> type = new ArrayList<String>();
                Pattern regex = Pattern.compile("(?:\\\\.|[^_\\\\]++)+");
                Matcher regexMatcher = regex.matcher(property.substring(8));
                while (regexMatcher.find()) {
                    type.add(regexMatcher.group());
                }
                CardCollection list = CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), ((String)type.get(0)).replace("\\_", "_"), sourceController, source, spellAbility);
                String comparator = type.size() > 1 ? (String)type.get(1) : "GE";
                int n = y = type.size() > 1 ? AbilityUtils.calculateAmount(source, comparator.substring(2), spellAbility) : 1;
                if (!Expressions.compare(list.size(), comparator, y)) {
                    return false;
                }
            } else if (property.startsWith("HasCardsIn")) {
                String[] type = property.substring(10).split("_");
                CardCollection list = CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.smartValueOf(type[0])), type[1], sourceController, source, spellAbility);
                String comparator = type[2];
                int y = AbilityUtils.calculateAmount(source, comparator.substring(2), spellAbility);
                if (!Expressions.compare(list.size(), comparator, y)) {
                    return false;
                }
            } else if (property.startsWith("withMore")) {
                String cardType = property.split("sThan")[0].substring(8);
                Player controller = "Active".equals(property.split("sThan")[1]) ? game.getPhaseHandler().getPlayerTurn() : sourceController;
                CardCollection oppList = CardLists.getType(player.getCardsIn(ZoneType.Battlefield), cardType);
                CardCollection yourList = CardLists.getType(controller.getCardsIn(ZoneType.Battlefield), cardType);
                if (oppList.size() <= yourList.size()) {
                    return false;
                }
            } else if (property.startsWith("withAtLeast")) {
                String cardType = property.split("More")[1].split("sThan")[0];
                int amount = Integer.parseInt(property.substring(11, 12));
                Player controller = "Active".equals(property.split("sThan")[1]) ? game.getPhaseHandler().getPlayerTurn() : sourceController;
                CardCollection oppList = CardLists.getType(player.getCardsIn(ZoneType.Battlefield), cardType);
                CardCollection yourList = CardLists.getType(controller.getCardsIn(ZoneType.Battlefield), cardType);
                if (oppList.size() < yourList.size() + amount) {
                    return false;
                }
            } else if (property.startsWith("hasMore")) {
                Player controller;
                Player player2 = controller = property.contains("Than") && "Active".equals(property.split("Than")[1]) ? game.getPhaseHandler().getPlayerTurn() : sourceController;
                if (property.substring(7).startsWith("Life") && player.getLife() <= controller.getLife()) {
                    return false;
                }
                if (property.substring(7).startsWith("CardsInHand") && player.getCardsIn(ZoneType.Hand).size() <= controller.getCardsIn(ZoneType.Hand).size()) {
                    return false;
                }
            } else if (property.startsWith("hasFewer")) {
                String cardType = property.split("sIn")[0].substring(8);
                Player controller = "Active".equals(property.split("Than")[1]) ? game.getPhaseHandler().getPlayerTurn() : sourceController;
                ZoneType zt = property.substring(8).startsWith("CreaturesInYard") ? ZoneType.Graveyard : ZoneType.Battlefield;
                CardCollection oppList = CardLists.getType(player.getCardsIn(zt), cardType);
                CardCollection yourList = CardLists.getType(controller.getCardsIn(zt), cardType);
                if (oppList.size() >= yourList.size()) {
                    return false;
                }
            } else if (property.startsWith("withMost")) {
                String kind = property.substring(8);
                if (kind.equals("Life")) {
                    int highestLife = player.getLife();
                    for (Player p : game.getPlayers()) {
                        if (p.getLife() <= highestLife) continue;
                        highestLife = p.getLife();
                    }
                    if (player.getLife() != highestLife) {
                        return false;
                    }
                } else if (kind.equals("PermanentInPlay")) {
                    int typeNum = 0;
                    ArrayList<Player> controlmost = new ArrayList<Player>();
                    for (Player p : game.getPlayers()) {
                        int num = p.getCardsIn(ZoneType.Battlefield).size();
                        if (num > typeNum) {
                            typeNum = num;
                            controlmost.clear();
                        }
                        if (num != typeNum) continue;
                        controlmost.add(p);
                    }
                    if (controlmost.size() != 1 || !controlmost.contains(player)) {
                        return false;
                    }
                } else if (kind.equals("CardsInHand")) {
                    int largestHand = 0;
                    Player withLargestHand = null;
                    for (Player p : game.getPlayers()) {
                        if (p.getCardsIn(ZoneType.Hand).size() <= largestHand) continue;
                        largestHand = p.getCardsIn(ZoneType.Hand).size();
                        withLargestHand = p;
                    }
                    if (!player.equals(withLargestHand)) {
                        return false;
                    }
                } else if (kind.startsWith("Type")) {
                    String type = property.split("Type")[1];
                    boolean checkOnly = false;
                    if (type.endsWith("Only")) {
                        checkOnly = true;
                        type = TextUtil.fastReplace(type, "Only", "");
                    }
                    int typeNum = 0;
                    ArrayList<Player> controlmost = new ArrayList<Player>();
                    for (Player p : game.getPlayers()) {
                        int num = CardLists.getType(p.getCardsIn(ZoneType.Battlefield), type).size();
                        if (num > typeNum) {
                            typeNum = num;
                            controlmost.clear();
                        }
                        if (num != typeNum) continue;
                        controlmost.add(p);
                    }
                    if (checkOnly && controlmost.size() != 1) {
                        return false;
                    }
                    if (!controlmost.contains(player)) {
                        return false;
                    }
                }
            } else if (property.startsWith("withLowest")) {
                if (property.substring(10).equals("Life")) {
                    int lowestLife = player.getLife();
                    ArrayList<Player> lowestlifep = new ArrayList<Player>();
                    for (Player p : game.getPlayers()) {
                        if (p.getLife() == lowestLife) {
                            lowestlifep.add(p);
                            continue;
                        }
                        if (p.getLife() >= lowestLife) continue;
                        lowestLife = p.getLife();
                        lowestlifep.clear();
                        lowestlifep.add(p);
                    }
                    if (!lowestlifep.contains(player)) {
                        return false;
                    }
                }
            } else if (property.startsWith("LessThanHalfStartingLifeTotal")) {
                if (player.getLife() >= (int)Math.ceil((double)player.getStartingLife() / 2.0)) {
                    return false;
                }
            } else if (property.startsWith("Triggered") || property.equals("OriginalHostRemembered")) {
                if (!AbilityUtils.getDefinedPlayers(source, property, spellAbility).contains(player)) {
                    return false;
                }
            } else if (property.equals("castSpellThisTurn")) {
                if (player.getSpellsCastThisTurn() == 0) {
                    return false;
                }
            } else if (property.equals("attackedWithCreaturesThisTurn")) {
                if (player.getCreaturesAttackedThisTurn().isEmpty()) {
                    return false;
                }
            } else {
                if (property.startsWith("wasAttackedThisTurnBy")) {
                    String restriction = property.split(" ")[1];
                    for (Card c : sourceController.getCreaturesAttackedThisTurn(player)) {
                        if (!c.isValid(restriction, sourceController, source, spellAbility)) continue;
                        return true;
                    }
                    return false;
                }
                if (property.equals("attackedYouTheirCurrentTurn")) {
                    if (!Iterables.contains(player.getAttackedPlayersMyTurn(), sourceController)) {
                        return false;
                    }
                } else {
                    if (property.startsWith("attackedYouCtrlTheirCurrentTurn")) {
                        CardCollection cardsYouCtrl = CardLists.filter((Iterable<Card>)sourceController.getCardsIn(ZoneType.Battlefield), CardPredicates.isType(property.split("_")[1]));
                        for (Card card : cardsYouCtrl) {
                            if (player.getCreaturesAttackedThisTurn(card).isEmpty()) continue;
                            return true;
                        }
                        return false;
                    }
                    if (property.equals("attackedYouTheirLastTurn")) {
                        if (!player.getAttackedPlayersMyLastTurn().contains(sourceController)) {
                            return false;
                        }
                    } else {
                        if (property.equals("BeenAttackedThisCombat")) {
                            for (Player p : game.getRegisteredPlayers()) {
                                if (!p.getAttackedPlayersMyCombat().contains(player)) continue;
                                return true;
                            }
                            return false;
                        }
                        if (property.equals("VenturedThisTurn")) {
                            if (player.getVenturedThisTurn() < 1) {
                                return false;
                            }
                        } else if (property.startsWith("Condition")) {
                            if (AbilityUtils.playerXCount(Lists.newArrayList(player), property, source, spellAbility) == 0) {
                                return false;
                            }
                        } else if (property.startsWith("NotedFor")) {
                            String key = property.substring("NotedFor".length());
                            for (String note : player.getNotesForName(key)) {
                                if (note.equals("Name:" + source.getName())) {
                                    return true;
                                }
                                if (!note.equals("Id:" + source.getId())) continue;
                                return true;
                            }
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }
}

