/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.game.CardTraitBase;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Comparator;

public final class PlayerPredicates {
    public static final Predicate<Player> NOT_LOST = p -> p.getOutcome() == null || p.getOutcome().hasWon();

    public static Predicate<Player> isTargetableBy(SpellAbility source) {
        return source::canTarget;
    }

    public static Predicate<Player> canDiscardBy(SpellAbility source, boolean effect) {
        return p -> p.canDiscardBy(source, effect);
    }

    public static Predicate<Player> isOpponentOf(Player player) {
        return p -> p.isOpponentOf(player);
    }

    public static Predicate<Player> sameTeam(Player player) {
        return player::sameTeam;
    }

    public static Predicate<Player> isCardInPlay(String cardName) {
        return p -> p.isCardInPlay(cardName);
    }

    public static Predicate<Player> isNotCardInPlay(String cardName) {
        return Predicates.not(PlayerPredicates.isCardInPlay(cardName));
    }

    public static Predicate<Player> hasCounters() {
        return GameEntity::hasCounters;
    }

    public static Predicate<Player> lifeLessOrEqualTo(int n) {
        return p -> p.getLife() <= n;
    }

    public static Predicate<Player> lifeGreaterOrEqualTo(int n) {
        return p -> p.getLife() >= n;
    }

    public static Predicate<Player> hasCounter(CounterType type) {
        return PlayerPredicates.hasCounter(type, 1);
    }

    public static Predicate<Player> hasCounter(CounterType type, int n) {
        return p -> p.getCounters(type) >= n;
    }

    public static Predicate<Player> hasCounter(CounterEnumType type) {
        return PlayerPredicates.hasCounter(CounterType.get(type), 1);
    }

    public static Predicate<Player> hasCounter(CounterEnumType type, int n) {
        return PlayerPredicates.hasCounter(CounterType.get(type), n);
    }

    public static Predicate<Player> hasKeyword(String keyword) {
        return p -> p.hasKeyword(keyword);
    }

    public static Predicate<Player> canBeAttached(Card aura, SpellAbility sa) {
        return p -> p.canBeAttached(aura, sa);
    }

    public static Predicate<Player> restriction(String[] restrictions, Player sourceController, Card source, CardTraitBase spellAbility) {
        return c -> c != null && c.isValid(restrictions, sourceController, source, spellAbility);
    }

    public static Comparator<Player> compareByZoneSize(ZoneType zone) {
        return Comparator.comparingInt(arg0 -> arg0.getCardsIn(zone).size());
    }

    public static Comparator<Player> compareByZoneSize(ZoneType zone, Predicate<Card> pred) {
        return Comparator.comparingInt(arg0 -> CardLists.count(arg0.getCardsIn(zone), pred));
    }

    public static Comparator<Player> compareByLife() {
        return Comparator.comparingInt(Player::getLife);
    }

    public static Comparator<Player> compareByPoison() {
        return Comparator.comparingInt(Player::getPoisonCounters);
    }
}

