/*
 * Decompiled with CFR 0.152.
 */
package forge.game.phase;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardType;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.phase.Phase;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityCantPhase;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Untap
extends Phase {
    private static final long serialVersionUID = 4515266331266259123L;
    protected final Game game;
    public static final Predicate<Card> CANUNTAP = Untap::canUntap;

    public Untap(Game game0) {
        super(PhaseType.UNTAP);
        this.game = game0;
    }

    @Override
    public void executeAt() {
        super.executeAt();
        Untap.doPhasing(this.game.getPhaseHandler().getPlayerTurn());
        Untap.doDayTime(this.game.getPhaseHandler().getPreviousPlayerTurn());
        this.game.getAction().checkStaticAbilities();
        this.doUntap();
    }

    public static boolean canUntap(Card c) {
        if (c.hasKeyword("CARDNAME doesn't untap during your untap step.") || c.hasKeyword("This card doesn't untap during your next untap step.") || c.hasKeyword("This card doesn't untap during your next two untap steps.") || c.hasKeyword("This card doesn't untap.")) {
            return false;
        }
        Player playerTurn = c.getGame().getPhaseHandler().getPlayerTurn();
        return !c.isExertedBy(playerTurn);
    }

    private void doUntap() {
        Player player = this.game.getPhaseHandler().getPlayerTurn();
        Predicate<Card> tappedCanUntap = Predicates.and(CardPredicates.Presets.TAPPED, CANUNTAP);
        HashMap<Player, CardCollection> untapMap = Maps.newHashMap();
        CardCollection list = new CardCollection(player.getCardsIn(ZoneType.Battlefield));
        CardZoneTable triggerList = new CardZoneTable(this.game.getLastStateBattlefield(), this.game.getLastStateGraveyard());
        CardCollection bounceList = CardLists.getKeyword((Iterable<Card>)list, "During your next untap step, as you untap your permanents, return CARDNAME to its owner's hand.");
        for (Card c2 : bounceList) {
            Card moved = this.game.getAction().moveToHand(c2, null);
            triggerList.put(ZoneType.Battlefield, moved.getZone().getZoneType(), moved);
        }
        triggerList.triggerChangesZoneAll(this.game, null);
        list.removeAll(bounceList);
        HashMap<String, Integer> restrictUntap = Maps.newHashMap();
        boolean hasChosen = false;
        for (KeywordInterface ki : player.getKeywords()) {
            String[] parse;
            String kw = ki.getOriginal();
            if (kw.startsWith("UntapAdjust") && (!restrictUntap.containsKey((parse = kw.split(":"))[1]) || Integer.parseInt(parse[2]) < (Integer)restrictUntap.get(parse[1]))) {
                restrictUntap.put(parse[1], Integer.parseInt(parse[2]));
            }
            if (!kw.startsWith("OnlyUntapChosen") || hasChosen) continue;
            List<String> validTypes = Arrays.asList(kw.split(":")[1].split(","));
            ArrayList<String> invalidTypes = Lists.newArrayList(CardType.getAllCardTypes());
            invalidTypes.removeAll(validTypes);
            String chosen = player.getController().chooseSomeType("Card", new SpellAbility.EmptySa(ApiType.ChooseType, null, player), validTypes, invalidTypes);
            list = CardLists.getType(list, chosen);
            hasChosen = true;
        }
        CardCollection untapList = new CardCollection(list);
        String[] restrict = restrictUntap.keySet().toArray(new String[0]);
        list = CardLists.filter((Iterable<Card>)list, c -> {
            if (!Untap.canUntap(c)) {
                return false;
            }
            return !c.isValid(restrict, player, null, null);
        });
        for (Card c3 : list) {
            if (!Untap.optionalUntap(c3)) continue;
            untapMap.computeIfAbsent(player, i -> new CardCollection()).add(c3);
        }
        CardCollection cardsWithKW = CardLists.getKeyword((Iterable<Card>)player.getAllOtherPlayers().getCardsIn(ZoneType.Battlefield), "CARDNAME untaps during each other player's untap step.");
        cardsWithKW = CardLists.getNotKeyword((Iterable<Card>)cardsWithKW, "This card doesn't untap.");
        CardCollection cardsWithKW2 = CardLists.getKeyword((Iterable<Card>)player.getOpponents().getCardsIn(ZoneType.Battlefield), "CARDNAME untaps during each opponent's untap step.");
        cardsWithKW2 = CardLists.getNotKeyword((Iterable<Card>)cardsWithKW2, "This card doesn't untap.");
        cardsWithKW.addAll(cardsWithKW2);
        for (Card cardWithKW : cardsWithKW) {
            if (cardWithKW.isExertedBy(player) || !cardWithKW.untap(true)) continue;
            untapMap.computeIfAbsent(cardWithKW.getController(), i -> new CardCollection()).add(cardWithKW);
        }
        CardCollection restrictUntapped = new CardCollection();
        CardCollection cardList = CardLists.filter((Iterable<Card>)untapList, tappedCanUntap);
        cardList = CardLists.getValidCards((Iterable<Card>)cardList, restrict, player, null, null);
        while (!cardList.isEmpty()) {
            Iterator remaining = Maps.newHashMap(restrictUntap);
            for (Map.Entry entry : remaining.entrySet()) {
                if ((Integer)entry.getValue() != 0) continue;
                cardList.removeAll(CardLists.getValidCards((Iterable<Card>)cardList, (String)entry.getKey(), player, null, null));
                restrictUntap.remove(entry.getKey());
            }
            Card chosen = player.getController().chooseSingleEntityForEffect(cardList, new SpellAbility.EmptySa(ApiType.Untap, null, player), "Select a card to untap\r\n(Selected:" + restrictUntapped + ")\r\nRemaining cards that can untap: " + remaining, null);
            if (chosen == null) continue;
            for (Map.Entry rest : restrictUntap.entrySet()) {
                if (!chosen.isValid((String)rest.getKey(), player, null, null)) continue;
                restrictUntap.put((String)rest.getKey(), (Integer)rest.getValue() - 1);
            }
            restrictUntapped.add(chosen);
            cardList.remove(chosen);
        }
        for (Card c4 : restrictUntapped) {
            if (!Untap.optionalUntap(c4)) continue;
            untapMap.computeIfAbsent(player, i -> new CardCollection()).add(c4);
        }
        for (Card c4 : player.getCardsIn(ZoneType.Battlefield)) {
            c4.removeHiddenExtrinsicKeyword("This card doesn't untap during your next untap step.");
            if (!c4.hasKeyword("This card doesn't untap during your next two untap steps.")) continue;
            c4.removeHiddenExtrinsicKeyword("This card doesn't untap during your next two untap steps.");
            c4.addHiddenExtrinsicKeywords(this.game.getNextTimestamp(), 0L, Lists.newArrayList("This card doesn't untap during your next untap step."));
        }
        for (Card c4 : this.game.getCardsIn(ZoneType.Battlefield)) {
            c4.removeExertedBy(player);
        }
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Map, untapMap);
        this.game.getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
    }

    private static boolean optionalUntap(Card c) {
        boolean untap = true;
        if (c.hasKeyword("You may choose not to untap CARDNAME during your untap step.") && c.isTapped()) {
            StringBuilder prompt = new StringBuilder("Untap " + c.toString() + "?");
            boolean defaultChoice = true;
            if (c.hasGainControlTarget()) {
                CardCollectionView targets = c.getGainControlTargets();
                prompt.append("\r\n").append(c).append(" is controlling: ");
                for (Card target : targets) {
                    prompt.append(target);
                    if (!target.isInPlay()) continue;
                    defaultChoice = false;
                }
            }
            untap = c.getController().getController().chooseBinary((SpellAbility)new SpellAbility.EmptySa(c, c.getController()), prompt.toString(), PlayerController.BinaryChoiceType.UntapOrLeaveTapped, defaultChoice);
        }
        if (untap && !c.untap(true)) {
            untap = false;
        }
        return untap;
    }

    public static void doPhasing(Player turn) {
        CardCollection list = CardLists.filter((Iterable<Card>)turn.getGame().getCardsIncludePhasingIn(ZoneType.Battlefield), c -> c.isPhasedOut(turn) && c.isDirectlyPhasedOut() || c.hasKeyword(Keyword.PHASING) && c.getController().equals(turn));
        CardCollection toPhase = new CardCollection();
        for (Object tgtC : list) {
            if (((Card)tgtC).isPhasedOut() && StaticAbilityCantPhase.cantPhaseIn((Card)tgtC) || !((Card)tgtC).isPhasedOut() && StaticAbilityCantPhase.cantPhaseOut((Card)tgtC)) continue;
            toPhase.add(tgtC);
        }
        CardCollection phasedOut = new CardCollection();
        for (Card c2 : toPhase) {
            Card ent;
            if (c2.isPhasedOut() && c2.isDirectlyPhasedOut()) {
                c2.phase(true);
                continue;
            }
            if (!c2.hasKeyword(Keyword.PHASING) || c2.isAttachment() && (ent = c2.getAttachedTo()) != null && list.contains(ent) && !StaticAbilityCantPhase.cantPhaseOut(ent)) continue;
            c2.phase(true);
            phasedOut.add(c2);
        }
        if (!phasedOut.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, phasedOut);
            turn.getGame().getTriggerHandler().runTrigger(TriggerType.PhaseOutAll, runParams, false);
        }
        if (!toPhase.isEmpty()) {
            turn.getGame().getTriggerHandler().collectTriggerForWaiting();
        }
    }

    private static void doDayTime(Player previous) {
        if (previous == null) {
            return;
        }
        Game game = previous.getGame();
        List<Card> casted = game.getStack().getSpellsCastLastTurn();
        if (game.isDay() && !Iterables.any(casted, CardPredicates.isController(previous))) {
            game.setDayTime(true);
        } else if (game.isNight() && CardLists.count(casted, CardPredicates.isController(previous)) > 1) {
            game.setDayTime(false);
        }
    }
}

