/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mulligan;

import forge.game.card.Card;
import forge.game.mulligan.AbstractMulligan;
import forge.game.player.Player;

public class LondonMulligan
extends AbstractMulligan {
    public LondonMulligan(Player p, boolean firstMullFree) {
        super(p, firstMullFree);
    }

    @Override
    public boolean canMulligan() {
        return !this.kept && this.timesMulliganed < this.player.getMaxHandSize();
    }

    @Override
    public int handSizeAfterNextMulligan() {
        return this.player.getMaxHandSize();
    }

    @Override
    public void mulliganDraw() {
        this.player.drawCards(this.handSizeAfterNextMulligan());
        int tuckingCards = this.tuckCardsAfterKeepHand();
        for (Card c : this.player.getController().londonMulliganReturnCards(this.player, tuckingCards)) {
            this.player.getGame().getAction().moveToLibrary(c, -1, null);
        }
    }

    @Override
    public int tuckCardsAfterKeepHand() {
        if (this.timesMulliganed == 0) {
            return 0;
        }
        int extraCard = this.firstMulliganFree ? 1 : 0;
        return this.timesMulliganed - extraCard;
    }
}

