/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mana;

import com.google.common.collect.Lists;
import forge.game.event.EventValueChangeType;
import forge.game.event.GameEventZone;
import forge.game.mana.Mana;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ManaRefundService {
    private final SpellAbility sa;
    private final Player activator;

    public ManaRefundService(SpellAbility sa) {
        this.sa = sa;
        this.activator = sa.getActivatingPlayer();
    }

    public void refundManaPaid() {
        ArrayList<Player> payers = Lists.newArrayList();
        for (Mana mana : this.sa.getPayingMana()) {
            Player pl = mana.getManaAbility().getSourceSA() == null ? mana.getManaAbility().getSourceCard().getOwner() : mana.getManaAbility().getSourceSA().getActivatingPlayer();
            pl.getManaPool().addMana(mana);
            if (payers.contains(pl)) continue;
            payers.add(pl);
        }
        this.sa.getPayingMana().clear();
        List<SpellAbility> payingAbilities = this.sa.getPayingManaAbilities();
        Collections.reverse(payingAbilities);
        for (SpellAbility am : payingAbilities) {
            am.undo();
        }
        for (SpellAbility am : payingAbilities) {
            ManaRefundService refundService = new ManaRefundService(am);
            refundService.refundManaPaid();
            this.activator.getGame().getStack().clearUndoStack(am);
        }
        payingAbilities.clear();
        for (Player p : payers) {
            p.getGame().fireEvent(new GameEventZone(ZoneType.Battlefield, p, EventValueChangeType.ComplexUpdate, null));
        }
    }
}

