/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mana;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.IParserManaCost;
import forge.card.mana.ManaAtom;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.game.mana.Mana;
import forge.game.mana.ManaPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ManaCostBeingPaid {
    private final Map<ManaCostShard, ShardCount> unpaidShards = Maps.newHashMap();
    private Map<String, Integer> xManaCostPaidByColor;
    private byte sunburstMap = 0;
    private int cntX = 0;

    public ManaCostBeingPaid(ManaCostBeingPaid manaCostBeingPaid) {
        for (Map.Entry<ManaCostShard, ShardCount> m4 : manaCostBeingPaid.unpaidShards.entrySet()) {
            this.unpaidShards.put(m4.getKey(), new ShardCount(m4.getValue()));
        }
        if (manaCostBeingPaid.xManaCostPaidByColor != null) {
            this.xManaCostPaidByColor = Maps.newHashMap(manaCostBeingPaid.xManaCostPaidByColor);
        }
        this.sunburstMap = manaCostBeingPaid.sunburstMap;
        this.cntX = manaCostBeingPaid.cntX;
    }

    public ManaCostBeingPaid(ManaCost manaCost) {
        if (manaCost == null) {
            return;
        }
        for (ManaCostShard shard : manaCost) {
            if (shard == ManaCostShard.X) {
                ++this.cntX;
                continue;
            }
            this.increaseShard(shard, 1, false);
        }
        this.increaseGenericMana(manaCost.getGenericCost());
    }

    public Map<String, Integer> getXManaCostPaidByColor() {
        return this.xManaCostPaidByColor;
    }

    public final int getSunburst() {
        return ColorSet.fromMask(this.sunburstMap).countColors();
    }

    public final byte getColorsPaid() {
        return this.sunburstMap;
    }

    public final boolean containsPhyrexianMana() {
        for (ManaCostShard shard : this.unpaidShards.keySet()) {
            if (!shard.isPhyrexian()) continue;
            return true;
        }
        return false;
    }

    public final boolean containsOnlyPhyrexianMana() {
        for (ManaCostShard shard : this.unpaidShards.keySet()) {
            if (shard.isPhyrexian()) continue;
            return false;
        }
        return true;
    }

    public final boolean payPhyrexian() {
        ManaCostShard phy = null;
        for (ManaCostShard mcs : this.unpaidShards.keySet()) {
            if (!mcs.isPhyrexian()) continue;
            phy = mcs;
            break;
        }
        if (phy == null) {
            return false;
        }
        this.decreaseShard(phy, 1);
        return true;
    }

    public final boolean needsColor(byte colorMask, ManaPool pool) {
        for (ManaCostShard shard : this.unpaidShards.keySet()) {
            if (shard == ManaCostShard.GENERIC || !(shard.isOr2Generic() ? (shard.getColorMask() & colorMask) != 0 : pool.canPayForShardWithColor(shard, colorMask))) continue;
            return true;
        }
        return false;
    }

    public final boolean isAnyPartPayableWith(byte colorMask, ManaPool pool) {
        for (ManaCostShard shard : this.unpaidShards.keySet()) {
            if (!pool.canPayForShardWithColor(shard, colorMask)) continue;
            return true;
        }
        return false;
    }

    public final boolean isNeeded(Mana paid, ManaPool pool) {
        for (ManaCostShard shard : this.unpaidShards.keySet()) {
            if (!ManaCostBeingPaid.canBePaidWith(shard, paid, pool, this.xManaCostPaidByColor)) continue;
            return true;
        }
        return false;
    }

    public final boolean isPaid() {
        return this.unpaidShards.isEmpty();
    }

    public final void setXManaCostPaid(int xPaid, String xColor) {
        int xCost = xPaid * this.cntX;
        this.cntX = 0;
        ManaCostShard shard = StringUtils.isEmpty(xColor) ? ManaCostShard.GENERIC : ManaCostShard.parseNonGeneric(xColor);
        this.increaseShard(shard, xCost, true);
    }

    public final void increaseGenericMana(int toAdd) {
        this.increaseShard(ManaCostShard.GENERIC, toAdd, false);
    }

    public final void increaseShard(ManaCostShard shard, int toAdd) {
        this.increaseShard(shard, toAdd, false);
    }

    private void increaseShard(ManaCostShard shard, int toAdd, boolean forX) {
        if (toAdd <= 0) {
            return;
        }
        ShardCount sc = this.unpaidShards.computeIfAbsent(shard, k -> new ShardCount());
        if (forX) {
            sc.xCount += toAdd;
        }
        sc.totalCount += toAdd;
    }

    public final void decreaseGenericMana(int manaToSubtract) {
        this.decreaseShard(ManaCostShard.GENERIC, manaToSubtract);
    }

    public final void decreaseShard(ManaCostShard shard, int manaToSubtract) {
        if (manaToSubtract <= 0) {
            return;
        }
        ShardCount sc = this.unpaidShards.get((Object)shard);
        if (sc == null) {
            if (!shard.isMonoColor() && shard != ManaCostShard.GENERIC) {
                return;
            }
            int otherSubtract = manaToSubtract;
            ArrayList<ManaCostShard> toRemove = Lists.newArrayList();
            if (shard.isMonoColor()) {
                ManaCostShard eShard;
                for (Map.Entry<ManaCostShard, ShardCount> e : this.unpaidShards.entrySet()) {
                    eShard = e.getKey();
                    sc = e.getValue();
                    if (eShard == ManaCostShard.COLORED_X || !eShard.isOfKind(shard.getShard()) || !eShard.isMultiColor()) continue;
                    if (otherSubtract >= sc.totalCount) {
                        otherSubtract -= sc.totalCount;
                        sc.xCount = (sc.totalCount = 0);
                        toRemove.add(eShard);
                        continue;
                    }
                    sc.totalCount -= otherSubtract;
                    if (sc.xCount <= sc.totalCount) break;
                    sc.xCount = sc.totalCount;
                    break;
                }
                for (Map.Entry<ManaCostShard, ShardCount> e : this.unpaidShards.entrySet()) {
                    eShard = e.getKey();
                    sc = e.getValue();
                    if (!eShard.isOfKind(shard.getShard()) || !eShard.isOr2Generic()) continue;
                    if (otherSubtract >= sc.totalCount) {
                        otherSubtract -= sc.totalCount;
                        sc.xCount = (sc.totalCount = 0);
                        toRemove.add(eShard);
                        continue;
                    }
                    sc.totalCount -= otherSubtract;
                    if (sc.xCount <= sc.totalCount) break;
                    sc.xCount = sc.totalCount;
                    break;
                }
                for (Map.Entry<ManaCostShard, ShardCount> e : this.unpaidShards.entrySet()) {
                    eShard = e.getKey();
                    sc = e.getValue();
                    if (!eShard.isOfKind(shard.getShard()) || !eShard.isColorless()) continue;
                    if (otherSubtract >= sc.totalCount) {
                        otherSubtract -= sc.totalCount;
                        sc.xCount = (sc.totalCount = 0);
                        toRemove.add(eShard);
                        continue;
                    }
                    sc.totalCount -= otherSubtract;
                    if (sc.xCount <= sc.totalCount) break;
                    sc.xCount = sc.totalCount;
                    break;
                }
                for (Map.Entry<ManaCostShard, ShardCount> e : this.unpaidShards.entrySet()) {
                    eShard = e.getKey();
                    sc = e.getValue();
                    if (!eShard.isOfKind(shard.getShard()) || !eShard.isPhyrexian()) continue;
                    if (otherSubtract >= sc.totalCount) {
                        otherSubtract -= sc.totalCount;
                        sc.xCount = (sc.totalCount = 0);
                        toRemove.add(eShard);
                        continue;
                    }
                    sc.totalCount -= otherSubtract;
                    if (sc.xCount <= sc.totalCount) break;
                    sc.xCount = sc.totalCount;
                    break;
                }
            } else if (shard == ManaCostShard.GENERIC) {
                int shardAmount = otherSubtract / 2;
                for (Map.Entry<ManaCostShard, ShardCount> e : this.unpaidShards.entrySet()) {
                    ManaCostShard eShard = e.getKey();
                    sc = e.getValue();
                    if (eShard.isOr2Generic()) {
                        if (shardAmount >= sc.totalCount) {
                            shardAmount -= sc.totalCount;
                            otherSubtract -= sc.totalCount * 2;
                            sc.xCount = (sc.totalCount = 0);
                            toRemove.add(eShard);
                            continue;
                        }
                        sc.totalCount -= shardAmount;
                        if (sc.xCount <= sc.totalCount) break;
                        sc.xCount = sc.totalCount;
                        break;
                    }
                    if (sc.xCount <= 0) continue;
                    if (otherSubtract >= sc.xCount) {
                        otherSubtract -= sc.xCount;
                        sc.totalCount -= sc.xCount;
                        sc.xCount = 0;
                        if (sc.totalCount != 0) continue;
                        toRemove.add(eShard);
                        continue;
                    }
                    sc.totalCount -= otherSubtract;
                    sc.xCount -= otherSubtract;
                    break;
                }
            }
            this.unpaidShards.keySet().removeAll(toRemove);
            return;
        }
        int difference = manaToSubtract - sc.totalCount;
        if (manaToSubtract >= sc.totalCount) {
            sc.xCount = 0;
            sc.totalCount = 0;
            this.unpaidShards.remove((Object)shard);
            this.decreaseShard(shard, difference);
            return;
        }
        sc.totalCount -= manaToSubtract;
        if (sc.xCount > sc.totalCount) {
            sc.xCount = sc.totalCount;
        }
    }

    public final int getGenericManaAmount() {
        ShardCount sc = this.unpaidShards.get((Object)ManaCostShard.GENERIC);
        if (sc != null) {
            return sc.totalCount;
        }
        return 0;
    }

    public final boolean ai_payMana(String mana, ManaPool pool) {
        byte colorMask = ManaAtom.fromName(mana);
        if (!this.isAnyPartPayableWith(colorMask, pool)) {
            return false;
        }
        Predicate predCanBePaid = ms -> {
            if (ms == ManaCostShard.COLORED_X && !ManaCostBeingPaid.canColoredXShardBePaidByColor(MagicColor.toShortString(colorMask), this.xManaCostPaidByColor)) {
                return false;
            }
            return pool.canPayForShardWithColor((ManaCostShard)((Object)ms), colorMask);
        };
        return this.tryPayMana(colorMask, Iterables.filter(this.unpaidShards.keySet(), predCanBePaid), pool.getPossibleColorUses(colorMask)) != null;
    }

    public final boolean payMana(Mana mana, ManaPool pool) {
        if (!this.isNeeded(mana, pool)) {
            throw new RuntimeException("ManaCost : addMana() error, mana not needed - " + mana);
        }
        Predicate predCanBePaid = ms -> ManaCostBeingPaid.canBePaidWith(ms, mana, pool, this.xManaCostPaidByColor);
        byte inColor = mana.getColor();
        byte outColor = pool.getPossibleColorUses(inColor);
        return this.tryPayMana(inColor, Iterables.filter(this.unpaidShards.keySet(), predCanBePaid), outColor) != null;
    }

    public final ManaCostShard payManaViaConvoke(byte color) {
        Predicate predCanBePaid = ms -> !ms.isSnow() && !ms.isColorless() && ms.canBePaidWithManaOfColor(color);
        return this.tryPayMana(color, Iterables.filter(this.unpaidShards.keySet(), predCanBePaid), (byte)-1);
    }

    public ManaCostShard getShardToPayByPriority(Iterable<ManaCostShard> payableShards, byte possibleUses) {
        ArrayList<ManaCostShard> choice = Lists.newArrayList();
        int priority = Integer.MIN_VALUE;
        for (ManaCostShard toPay : payableShards) {
            int toPayPriority = ManaCostBeingPaid.getPayPriority(toPay, possibleUses);
            if (toPayPriority > priority) {
                priority = toPayPriority;
                choice.clear();
            }
            if (toPayPriority != priority) continue;
            choice.add(toPay);
        }
        if (choice.isEmpty()) {
            return null;
        }
        return Iterables.getFirst(choice, null);
    }

    private ManaCostShard tryPayMana(byte colorMask, Iterable<ManaCostShard> payableShards, byte possibleUses) {
        ManaCostShard chosenShard = this.getShardToPayByPriority(payableShards, possibleUses);
        if (chosenShard == null) {
            return null;
        }
        ShardCount sc = this.unpaidShards.get((Object)chosenShard);
        if (sc != null && sc.xCount > 0) {
            Integer xColor;
            sc.xCount--;
            String color = MagicColor.toShortString(colorMask);
            if (this.xManaCostPaidByColor == null) {
                this.xManaCostPaidByColor = Maps.newHashMap();
            }
            if ((xColor = this.xManaCostPaidByColor.get(color)) == null) {
                xColor = 0;
            }
            this.xManaCostPaidByColor.put(color, xColor + 1);
        }
        this.decreaseShard(chosenShard, 1);
        if (chosenShard.isOr2Generic() && 0 == (chosenShard.getColorMask() & possibleUses)) {
            this.increaseGenericMana(1);
        }
        this.sunburstMap = (byte)(this.sunburstMap | colorMask);
        return chosenShard;
    }

    private static int getPayPriority(ManaCostShard bill, byte paymentColor) {
        if (bill == ManaCostShard.GENERIC) {
            return 2;
        }
        if (bill.isMonoColor()) {
            if (bill.isOr2Generic()) {
                return !ColorSet.fromMask(bill.getColorMask() & paymentColor).isColorless() ? 9 : 1;
            }
            if (!bill.isPhyrexian()) {
                return 10;
            }
            return 8;
        }
        return 5;
    }

    public static boolean canColoredXShardBePaidByColor(String color, Map<String, Integer> xManaCostPaidByColor) {
        return xManaCostPaidByColor == null || xManaCostPaidByColor.get(color) == null;
    }

    private static boolean canBePaidWith(ManaCostShard shard, Mana mana, ManaPool pool, Map<String, Integer> xManaCostPaidByColor) {
        if (shard.isSnow() && !mana.isSnow()) {
            return false;
        }
        if (mana.isRestricted() && !mana.getManaAbility().meetsManaShardRestrictions(shard, mana.getColor())) {
            return false;
        }
        if (shard.getColorMask() != 0 && mana.isSnow() && pool.isSnowForColor()) {
            return true;
        }
        if (shard == ManaCostShard.COLORED_X && !ManaCostBeingPaid.canColoredXShardBePaidByColor(MagicColor.toShortString(mana.getColor()), xManaCostPaidByColor)) {
            return false;
        }
        byte color = mana.getColor();
        return pool.canPayForShardWithColor(shard, color);
    }

    public final void addManaCost(ManaCost extra) {
        for (ManaCostShard shard : extra) {
            if (shard == ManaCostShard.X) {
                ++this.cntX;
                continue;
            }
            this.increaseShard(shard, 1, false);
        }
        this.increaseGenericMana(extra.getGenericCost());
    }

    public final void subtractManaCost(ManaCost subThisManaCost) {
        for (ManaCostShard shard : subThisManaCost) {
            if (shard == ManaCostShard.X) {
                --this.cntX;
                continue;
            }
            if (this.unpaidShards.containsKey((Object)shard)) {
                this.decreaseShard(shard, 1);
                continue;
            }
            this.decreaseGenericMana(1);
        }
        this.decreaseGenericMana(subThisManaCost.getGenericCost());
    }

    public final String toString(boolean addX, ManaPool pool) {
        StringBuilder sb = new StringBuilder();
        if (addX) {
            for (int i = 0; i < this.getXcounter(); ++i) {
                sb.append("{X}");
            }
        }
        int nGeneric = this.getGenericManaAmount();
        ArrayList<ManaCostShard> shards = Lists.newArrayList(this.unpaidShards.keySet());
        if (nGeneric > 0) {
            if (nGeneric <= 20) {
                sb.append("{").append(nGeneric).append("}");
            } else {
                String genericStr = String.valueOf(nGeneric);
                for (int i = 0; i < genericStr.length(); ++i) {
                    sb.append("{").append(genericStr.charAt(i)).append("}");
                }
            }
        }
        Collections.sort(shards);
        for (ManaCostShard shard : shards) {
            if (shard == ManaCostShard.GENERIC) continue;
            String str = shard.toString();
            int count = this.unpaidShards.get((Object)shard).totalCount;
            for (int i = 0; i < count; ++i) {
                sb.append(str);
            }
        }
        return sb.length() == 0 ? "0" : sb.toString();
    }

    public final String toString() {
        return this.toString(true, null);
    }

    public final int getConvertedManaCost() {
        int cmc = 0;
        for (Map.Entry<ManaCostShard, ShardCount> s2 : this.unpaidShards.entrySet()) {
            cmc += s2.getKey().getCmc() * s2.getValue().totalCount;
        }
        return cmc;
    }

    public ManaCost toManaCost() {
        return new ManaCost(new ManaCostBeingPaidIterator());
    }

    public final int getXcounter() {
        return this.cntX;
    }

    public final List<ManaCostShard> getUnpaidShards() {
        ArrayList<ManaCostShard> result = new ArrayList<ManaCostShard>();
        for (Map.Entry<ManaCostShard, ShardCount> kv : this.unpaidShards.entrySet()) {
            for (int i = kv.getValue().totalCount; i > 0; --i) {
                result.add(kv.getKey());
            }
        }
        for (int i = this.cntX; i > 0; --i) {
            result.add(ManaCostShard.X);
        }
        return result;
    }

    public final void removeGenericMana() {
        this.unpaidShards.remove((Object)ManaCostShard.GENERIC);
    }

    public Iterable<ManaCostShard> getDistinctShards() {
        return this.unpaidShards.keySet();
    }

    public int getUnpaidShards(ManaCostShard key) {
        ShardCount sc = this.unpaidShards.get((Object)key);
        if (sc != null) {
            return sc.totalCount;
        }
        return 0;
    }

    public final byte getUnpaidColors() {
        byte result = 0;
        for (ManaCostShard s2 : this.unpaidShards.keySet()) {
            result = (byte)(result | s2.getColorMask());
        }
        return result;
    }

    public boolean hasAnyKind(int kind) {
        for (Map.Entry<ManaCostShard, ShardCount> e : this.unpaidShards.entrySet()) {
            if (!e.getKey().isOfKind(kind) || e.getValue().totalCount <= e.getValue().xCount) continue;
            return true;
        }
        return false;
    }

    private class ShardCount {
        private int xCount;
        private int totalCount;

        private ShardCount() {
        }

        private ShardCount(ShardCount copy) {
            this.xCount = copy.xCount;
            this.totalCount = copy.totalCount;
        }

        public String toString() {
            return "{x=" + this.xCount + " total=" + this.totalCount + "}";
        }
    }

    private class ManaCostBeingPaidIterator
    implements IParserManaCost {
        private Iterator<ManaCostShard> mch;
        private ManaCostShard nextShard = null;
        private int remainingShards = 0;
        private boolean hasSentX = false;

        public ManaCostBeingPaidIterator() {
            this.mch = ManaCostBeingPaid.this.unpaidShards.keySet().iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ManaCostShard next() {
            if (this.remainingShards == 0) {
                throw new UnsupportedOperationException("All shards were depleted, call hasNext()");
            }
            --this.remainingShards;
            return this.nextShard;
        }

        @Override
        public boolean hasNext() {
            if (this.remainingShards > 0) {
                return true;
            }
            if (!this.hasSentX) {
                if (this.nextShard != ManaCostShard.X && ManaCostBeingPaid.this.cntX > 0) {
                    this.nextShard = ManaCostShard.X;
                    this.remainingShards = ManaCostBeingPaid.this.cntX;
                    return true;
                }
                this.hasSentX = true;
            }
            if (!this.mch.hasNext()) {
                return false;
            }
            this.nextShard = this.mch.next();
            if (this.nextShard == ManaCostShard.GENERIC) {
                return this.hasNext();
            }
            this.remainingShards = ((ShardCount)ManaCostBeingPaid.this.unpaidShards.get((Object)this.nextShard)).totalCount;
            return true;
        }

        @Override
        public int getTotalGenericCost() {
            ShardCount c = (ShardCount)ManaCostBeingPaid.this.unpaidShards.get((Object)ManaCostShard.GENERIC);
            return c == null ? 0 : c.totalCount;
        }
    }
}

