/*
 * Decompiled with CFR 0.152.
 */
package forge.game.keyword;

import com.google.common.collect.Lists;
import forge.game.card.Card;
import forge.game.keyword.KeywordCollection;
import forge.game.keyword.KeywordInterface;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KeywordsChange
implements Cloneable {
    private KeywordCollection keywords = new KeywordCollection();
    private List<KeywordInterface> removeKeywordInterfaces = Lists.newArrayList();
    private List<String> removeKeywords = Lists.newArrayList();
    private boolean removeAllKeywords;

    public KeywordsChange(Iterable<KeywordInterface> keywordList, Collection<String> removeKeywordList, boolean removeAll) {
        if (keywordList != null) {
            this.keywords.insertAll(keywordList);
        }
        if (removeKeywordList != null) {
            this.removeKeywords.addAll(removeKeywordList);
        }
        this.removeAllKeywords = removeAll;
    }

    public KeywordsChange(Collection<KeywordInterface> keywordList, Collection<KeywordInterface> removeKeywordInterfaces, boolean removeAll) {
        if (keywordList != null) {
            this.keywords.insertAll(keywordList);
        }
        if (removeKeywordInterfaces != null) {
            this.removeKeywordInterfaces.addAll(removeKeywordInterfaces);
        }
        this.removeAllKeywords = removeAll;
    }

    public final Collection<KeywordInterface> getKeywords() {
        return this.keywords.getValues();
    }

    public final Collection<KeywordInterface> getRemovedKeywordInstances() {
        return this.removeKeywordInterfaces;
    }

    public final List<String> getRemoveKeywords() {
        return this.removeKeywords;
    }

    public final boolean isRemoveAllKeywords() {
        return this.removeAllKeywords;
    }

    public final boolean isEmpty() {
        return !this.removeAllKeywords && this.keywords.isEmpty() && this.removeKeywords.isEmpty();
    }

    public void setHostCard(Card host) {
        this.keywords.setHostCard(host);
        for (KeywordInterface k : this.removeKeywordInterfaces) {
            k.setHostCard(host);
        }
    }

    public KeywordsChange copy(Card host, boolean lki) {
        try {
            KeywordsChange result = (KeywordsChange)super.clone();
            result.keywords = new KeywordCollection();
            for (KeywordInterface ki : this.keywords.getValues()) {
                result.keywords.insert(ki.copy(host, lki));
            }
            result.removeKeywords = Lists.newArrayList(this.removeKeywords);
            result.removeKeywordInterfaces = Lists.newArrayList();
            for (KeywordInterface ki : this.removeKeywordInterfaces) {
                result.removeKeywordInterfaces.add(ki.copy(host, lki));
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException("KeywordsChange : clone() error", ex);
        }
    }

    public Collection<Trigger> getTriggers() {
        ArrayList<Trigger> result = Lists.newArrayList();
        for (KeywordInterface k : this.keywords.getValues()) {
            result.addAll(k.getTriggers());
        }
        return result;
    }

    public Collection<ReplacementEffect> getReplacements() {
        ArrayList<ReplacementEffect> result = Lists.newArrayList();
        for (KeywordInterface k : this.keywords.getValues()) {
            result.addAll(k.getReplacements());
        }
        return result;
    }

    public Collection<SpellAbility> getAbilities() {
        ArrayList<SpellAbility> result = Lists.newArrayList();
        for (KeywordInterface k : this.keywords.getValues()) {
            result.addAll(k.getAbilities());
        }
        return result;
    }

    public Collection<StaticAbility> getStaticAbilities() {
        ArrayList<StaticAbility> result = Lists.newArrayList();
        for (KeywordInterface k : this.keywords.getValues()) {
            result.addAll(k.getStaticAbilities());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<+");
        sb.append(this.keywords);
        sb.append("|-");
        sb.append(this.removeKeywordInterfaces);
        sb.append("|-");
        sb.append(this.removeKeywords);
        sb.append(">");
        return sb.toString();
    }
}

