/*
 * Decompiled with CFR 0.152.
 */
package forge.game.keyword;

import forge.game.keyword.KeywordInstance;

public class KeywordWithAmount
extends KeywordInstance<KeywordWithAmount> {
    private int amount;
    private boolean withX;
    private String extra = "";

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    protected void parse(String details) {
        if (details.startsWith("X")) {
            this.withX = true;
            if (details.contains(":")) {
                this.extra = details.split(":")[1];
            }
        } else if (!details.isEmpty()) {
            this.amount = details.contains(":") ? Integer.parseInt(details.split(":")[0]) : Integer.parseInt(details);
        }
    }

    @Override
    protected String formatReminderText(String reminderText) {
        if (this.withX) {
            StringBuilder result = new StringBuilder(String.format(reminderText.replaceAll("\\%(\\d+\\$)?d", "%$1s"), "X"));
            if (!this.extra.isEmpty() && !this.extra.contains("$")) {
                result.insert(result.length() - 1, this.extra);
            }
            return result.toString();
        }
        return String.format(reminderText, this.amount);
    }
}

