/*
 * Decompiled with CFR 0.152.
 */
package forge.game.keyword;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import forge.game.card.Card;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.keyword.KeywordsChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class KeywordCollection
implements Iterable<KeywordInterface> {
    private transient KeywordCollectionView view;
    private final Multimap<Keyword, KeywordInterface> map = MultimapBuilder.hashKeys().arrayListValues().build();

    public boolean contains(Keyword keyword) {
        return this.map.containsKey((Object)keyword);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.values().size();
    }

    public int getAmount(Keyword keyword) {
        int amount = 0;
        for (KeywordInterface inst : this.map.get(keyword)) {
            amount += inst.getAmount();
        }
        return amount;
    }

    public KeywordInterface add(String k) {
        KeywordInterface inst = Keyword.getInstance(k);
        if (this.insert(inst)) {
            return inst;
        }
        return null;
    }

    public boolean insert(KeywordInterface inst) {
        Keyword keyword = inst.getKeyword();
        Collection<KeywordInterface> list = this.map.get(keyword);
        if (list.isEmpty() || !inst.redundant(list)) {
            list.add(inst);
            return true;
        }
        return false;
    }

    public void addAll(Iterable<String> keywords) {
        for (String k : keywords) {
            this.add(k);
        }
    }

    public boolean insertAll(Iterable<KeywordInterface> inst) {
        boolean result = false;
        for (KeywordInterface k : inst) {
            if (!this.insert(k)) continue;
            result = true;
        }
        return result;
    }

    public boolean remove(String keyword) {
        Iterator<KeywordInterface> it = this.map.values().iterator();
        boolean result = false;
        while (it.hasNext()) {
            KeywordInterface k = it.next();
            if (!k.getOriginal().startsWith(keyword)) continue;
            it.remove();
            result = true;
        }
        return result;
    }

    public boolean remove(KeywordInterface keyword) {
        return this.map.remove((Object)keyword.getKeyword(), keyword);
    }

    public boolean removeAll(Keyword kenum) {
        return !this.map.removeAll((Object)kenum).isEmpty();
    }

    public boolean removeAll(Iterable<String> keywords) {
        boolean result = false;
        for (String k : keywords) {
            if (!this.remove(k)) continue;
            result = true;
        }
        return result;
    }

    public boolean removeInstances(Iterable<KeywordInterface> keywords) {
        boolean result = false;
        for (KeywordInterface k : keywords) {
            if (!this.map.remove((Object)k.getKeyword(), k)) continue;
            result = true;
        }
        return result;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean contains(String keyword) {
        for (KeywordInterface inst : this.map.values()) {
            if (!keyword.equals(inst.getOriginal())) continue;
            return true;
        }
        return false;
    }

    public int getAmount(String k) {
        int amount = 0;
        for (KeywordInterface inst : this.map.values()) {
            if (!k.equals(inst.getOriginal())) continue;
            ++amount;
        }
        return amount;
    }

    public Collection<KeywordInterface> getValues() {
        return this.map.values();
    }

    public Collection<KeywordInterface> getValues(Keyword keyword) {
        return this.map.get(keyword);
    }

    public List<String> asStringList() {
        ArrayList<String> result = Lists.newArrayList();
        for (KeywordInterface kw : this.getValues()) {
            result.add(kw.getOriginal());
        }
        return result;
    }

    public void setHostCard(Card host) {
        for (KeywordInterface k : this.map.values()) {
            k.setHostCard(host);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.map.values());
        return sb.toString();
    }

    public KeywordCollectionView getView() {
        if (this.view == null) {
            this.view = new KeywordCollectionView();
        }
        return this.view;
    }

    public void applyChanges(Iterable<KeywordsChange> changes) {
        for (KeywordsChange ck : changes) {
            if (ck.isRemoveAllKeywords()) {
                this.clear();
            } else if (ck.getRemoveKeywords() != null) {
                this.removeAll(ck.getRemoveKeywords());
            }
            this.removeInstances(ck.getRemovedKeywordInstances());
            if (ck.getKeywords() == null) continue;
            this.insertAll(ck.getKeywords());
        }
    }

    @Override
    public Iterator<KeywordInterface> iterator() {
        return this.map.values().iterator();
    }

    public class KeywordCollectionView
    implements Iterable<KeywordInterface> {
        protected KeywordCollectionView() {
        }

        public boolean isEmpty() {
            return KeywordCollection.this.isEmpty();
        }

        public int size() {
            return KeywordCollection.this.size();
        }

        public int getAmount(String keyword) {
            return KeywordCollection.this.getAmount(keyword);
        }

        public boolean contains(Keyword keyword) {
            return KeywordCollection.this.contains(keyword);
        }

        public boolean contains(String keyword) {
            return KeywordCollection.this.contains(keyword);
        }

        public List<String> asStringList() {
            return KeywordCollection.this.asStringList();
        }

        @Override
        public Iterator<KeywordInterface> iterator() {
            return KeywordCollection.this.iterator();
        }
    }
}

