/*
 * Decompiled with CFR 0.152.
 */
package forge.game.event;

import forge.game.event.GameEvent;
import forge.game.event.IGameEventVisitor;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.util.Lang;
import forge.util.TextUtil;

public class GameEventTurnPhase
extends GameEvent {
    public final Player playerTurn;
    public final PhaseType phase;
    public final String phaseDesc;

    public GameEventTurnPhase(Player player, PhaseType ph, String desc) {
        this.playerTurn = player;
        this.phase = ph;
        this.phaseDesc = desc;
    }

    @Override
    public <T> T visit(IGameEventVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        String playerName = Lang.getInstance().getPossesive(this.playerTurn.getName());
        return TextUtil.concatWithSpace(playerName, "turn,", this.phaseDesc + this.phase.nameForUi, "phase");
    }
}

