/*
 * Decompiled with CFR 0.152.
 */
package forge.game.event;

import com.google.common.collect.Iterables;
import forge.game.event.GameEvent;
import forge.game.event.IGameEventVisitor;
import forge.game.player.Player;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;

public class GameEventPlayerStatsChanged
extends GameEvent {
    public final Collection<Player> players;
    public final boolean updateCards;

    public GameEventPlayerStatsChanged(Player affected, boolean updateCards) {
        this.players = Arrays.asList(affected);
        this.updateCards = updateCards;
    }

    public GameEventPlayerStatsChanged(Collection<Player> affected, boolean updateCards) {
        this.players = affected;
        this.updateCards = updateCards;
    }

    @Override
    public <T> T visit(IGameEventVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        if (null == this.players || Iterables.isEmpty(this.players)) {
            return "Player state changes: (empty list)";
        }
        return TextUtil.concatWithSpace("Player state changes:", Lang.joinHomogenous(this.players));
    }
}

