/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.EnumMap;
import java.util.HashMap;

public class CostUntap
extends CostPart {
    private static final long serialVersionUID = 1L;

    @Override
    public int paymentOrder() {
        return 20;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean isRenewable() {
        return true;
    }

    @Override
    public final String toString() {
        return "{Q}";
    }

    @Override
    public final void refund(Card source) {
        source.setTapped(true);
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        return source.isTapped() && !source.isAbilitySick() && (source.getCounters(CounterEnumType.STUN) == 0 || source.canRemoveCounters(CounterType.get(CounterEnumType.STUN)));
    }

    @Override
    public boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        Card c = ability.getHostCard();
        if (c.untap(true)) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            HashMap<Player, CardCollection> map = Maps.newHashMap();
            map.put(ai, new CardCollection(c));
            runParams.put(AbilityKey.Map, map);
            ai.getGame().getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
        }
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

