/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.TextUtil;

public class CostUnattach
extends CostPartWithList {
    private static final long serialVersionUID = 1L;

    public CostUnattach(String type, String desc) {
        super("1", type, desc);
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public final String toString() {
        return TextUtil.concatWithSpace("Unattach", this.getTypeDescription());
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return this.findCardToUnattach(ability.getHostCard(), payer, ability) != null;
    }

    public Card findCardToUnattach(Card source, Player activator, SpellAbility ability) {
        if (this.payCostFromSource()) {
            if (source.isEquipping()) {
                return source;
            }
        } else if (this.getType().equals("OriginalHost")) {
            Card originalEquipment = ability.getOriginalHost();
            if (originalEquipment.isEquipping()) {
                return originalEquipment;
            }
        } else {
            CardCollection attachees = CardLists.getValidCards((Iterable<Card>)source.getEquippedBy(), this.getType(), activator, source, (CardTraitBase)ability);
            if (attachees.size() > 0) {
                return (Card)attachees.get(0);
            }
        }
        return null;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        targetCard.unattachFromEntity(targetCard.getEntityAttachedTo());
        return targetCard;
    }

    @Override
    public String getHashForLKIList() {
        return "Unattached";
    }

    @Override
    public String getHashForCardList() {
        return "UnattachedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

