/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.EnumMap;

public class CostTapType
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    public final boolean canTapSource;

    public CostTapType(String amount, String type, String description, boolean costHasTapSource) {
        super(amount, type, description);
        this.canTapSource = !costHasTapSource;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)payer.getCardsIn(ZoneType.Battlefield), this.getType().split(";"), payer, source, (CardTraitBase)ability);
        if (!this.canTapSource) {
            typeList.remove(source);
        }
        typeList = CardLists.filter((Iterable<Card>)typeList, ability.isCrew() ? CardPredicates.Presets.CAN_CREW : CardPredicates.Presets.CAN_TAP);
        return typeList.size();
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isRenewable() {
        return true;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        String desc = this.getDescriptiveType();
        String type = this.getType();
        String amt = this.getAmount();
        if (type.contains("+withTotalPowerGE")) {
            String num = type.split("\\+withTotalPowerGE")[1];
            sb.append("Tap any number of untapped creatures you control other than CARDNAME with total power ");
            sb.append(num).append("or greater");
            return sb.toString();
        }
        sb.append("Tap ");
        if (type.contains("Other")) {
            String rep = type.contains(".Other") ? ".Other" : "+Other";
            String descTrim = desc.replace(rep, "");
            if (CardType.CoreType.isValidEnum(descTrim)) {
                descTrim = descTrim.toLowerCase();
            }
            sb.append(amt.equals("1") ? "another untapped " + descTrim : Lang.nounWithNumeral(amt, "other untapped " + descTrim));
            if (!descTrim.contains("you control")) {
                sb.append(" you control");
            }
        } else if (amt.equals("X")) {
            sb.append("any number of untapped ").append(desc).append("s you control");
        } else {
            sb.append(Lang.nounWithNumeralExceptOne(amt, "untapped " + desc)).append(" you control");
        }
        if (type.contains("sharesCreatureTypeWith")) {
            sb.append(" that share a creature type");
        }
        return sb.toString();
    }

    @Override
    public final void refund(Card source) {
        for (Card c : this.cardList) {
            c.setTapped(false);
        }
        this.cardList.clear();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        String type = this.getType();
        boolean sameType = false;
        if (type.contains(".sharesCreatureTypeWith")) {
            sameType = true;
            type = TextUtil.fastReplace(type, ".sharesCreatureTypeWith", "");
        }
        boolean totalPower = false;
        String totalP = "";
        if (type.contains("+withTotalPowerGE")) {
            totalPower = true;
            totalP = type.split("withTotalPowerGE")[1];
            type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTotalPowerGE", totalP), "");
        }
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)payer.getCardsIn(ZoneType.Battlefield), type.split(";"), payer, source, (CardTraitBase)ability);
        if (!this.canTapSource) {
            typeList.remove(source);
        }
        typeList = CardLists.filter((Iterable<Card>)typeList, ability.isCrew() ? CardPredicates.Presets.CAN_CREW : CardPredicates.Presets.CAN_TAP);
        if (sameType) {
            for (Card card : typeList) {
                if (CardLists.count(typeList, CardPredicates.sharesCreatureTypeWith(card)) <= 1) continue;
                return true;
            }
            return false;
        }
        if (totalPower) {
            int i = Integer.parseInt(totalP);
            return CardLists.getTotalPower(typeList, true, ability.isCrew()) >= i;
        }
        int amount = this.getAbilityAmount(ability);
        return typeList.size() >= amount;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        targetCard.tap(true, ability, payer);
        return targetCard;
    }

    @Override
    protected boolean canPayListAtOnce() {
        return true;
    }

    @Override
    protected CardCollectionView doListPayment(Player payer, SpellAbility ability, CardCollectionView targetCards, boolean effect) {
        CardCollection tapped = new CardCollection();
        for (Card c : targetCards) {
            if (!c.tap(true, ability, payer)) continue;
            tapped.add(c);
        }
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Cards, tapped);
        payer.getGame().getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        return targetCards;
    }

    @Override
    public String getHashForLKIList() {
        return "Tapped";
    }

    @Override
    public String getHashForCardList() {
        return "TappedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

