/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.EnumMap;

public class CostTap
extends CostPart {
    private static final long serialVersionUID = 1L;

    @Override
    public int paymentOrder() {
        return -1;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isRenewable() {
        return true;
    }

    @Override
    public final String toString() {
        return "{T}";
    }

    @Override
    public final void refund(Card source) {
        source.setTapped(false);
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        return source.canTap() && !source.isAbilitySick();
    }

    @Override
    public boolean payAsDecided(Player payer, PaymentDecision decision, SpellAbility ability, boolean effect) {
        Card hostCard = ability.getHostCard();
        if (hostCard.tap(true, ability, payer)) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, new CardCollection(hostCard));
            payer.getGame().getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        }
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

