/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.ability.effects.RollDiceEffect;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class CostRollDice
extends CostPart {
    private static final long serialVersionUID = 1L;
    private final String resultSVar;

    public CostRollDice(String amount, String sides, String resultSVar, String description) {
        super(amount, sides, description);
        this.resultSVar = resultSVar;
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return true;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Roll ").append(this.getAmount());
        if (this.getTypeDescription() == null) {
            sb.append("d").append(this.getType());
        } else {
            sb.append(" ").append(this.getTypeDescription());
        }
        return sb.toString();
    }

    @Override
    public boolean payAsDecided(Player payer, PaymentDecision pd, SpellAbility sa, boolean effect) {
        int sides = Integer.parseInt(this.getType());
        int result = RollDiceEffect.rollDiceForPlayer(sa, payer, pd.c, sides);
        sa.setSVar(this.resultSVar, Integer.toString(result));
        return true;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

