/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.EnumMap;

public class CostReturn
extends CostPartWithList {
    private static final long serialVersionUID = 1L;

    public CostReturn(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public int paymentOrder() {
        return 10;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        CardCollectionView typeList = payer.getCardsIn(ZoneType.Battlefield);
        typeList = CardLists.getValidCards((Iterable<Card>)typeList, this.getType().split(";"), payer, source, (CardTraitBase)ability);
        return typeList.size();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Return ");
        Integer i = this.convertAmount();
        String pronoun = "its";
        if (this.payCostFromSource()) {
            sb.append(this.getType());
        } else {
            String desc = this.getDescriptiveType();
            if (i != null) {
                sb.append(Cost.convertIntAndTypeToWords(i, desc));
                if (i > 1) {
                    pronoun = "their";
                }
            } else {
                sb.append(Cost.convertAmountTypeToWords(this.getAmount(), desc));
            }
            sb.append(" you control");
        }
        sb.append(" to ").append(pronoun).append(" owner's hand");
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        if (this.payCostFromSource()) {
            return source.isInPlay();
        }
        return this.getMaxAmountX(ability, payer, effect) >= this.getAbilityAmount(ability);
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(moveParams, this.table);
        return targetCard.getGame().getAction().moveToHand(targetCard, null, moveParams);
    }

    @Override
    public String getHashForLKIList() {
        return "Returned";
    }

    @Override
    public String getHashForCardList() {
        return "ReturnedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

