/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public abstract class CostPart
implements Comparable<CostPart>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String originalAmount;
    private String amount;
    private final String originalType;
    private final String originalTypeDescription;
    private String typeDescription;
    private String type;
    protected transient SpellAbility payingTrigSA;

    public CostPart() {
        this("1", "Card", null);
    }

    public CostPart(String amount, String type, String description) {
        this.setAmount(amount);
        this.type = this.originalType = type;
        this.typeDescription = this.originalTypeDescription = description;
    }

    public final String getAmount() {
        return this.amount;
    }

    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        return null;
    }

    public final String getType() {
        return this.type;
    }

    public final boolean payCostFromSource() {
        return this.getType().equals("CARDNAME") || this.getType().equals("NICKNAME");
    }

    public final String getTypeDescription() {
        return this.typeDescription;
    }

    public final String getDescriptiveType() {
        String typeDesc = this.getTypeDescription();
        if (typeDesc == null) {
            String typeS = this.getType();
            typeDesc = CardType.CoreType.isValidEnum(typeS) || typeS.equals("Card") ? typeS.toLowerCase() : typeS;
        }
        return typeDesc;
    }

    public boolean isReusable() {
        return false;
    }

    public boolean isRenewable() {
        return false;
    }

    public boolean isUndoable() {
        return false;
    }

    public final Integer convertAmount() {
        return StringUtils.isNumeric(this.amount) ? Integer.valueOf(Integer.parseInt(this.amount)) : null;
    }

    public final int getAbilityAmount(SpellAbility ability) {
        return AbilityUtils.calculateAmount(ability.getHostCard(), this.getAmount(), ability);
    }

    public void setTrigger(SpellAbility sa) {
        this.payingTrigSA = sa;
    }

    public abstract boolean canPay(SpellAbility var1, Player var2, boolean var3);

    public abstract <T> T accept(ICostVisitor<T> var1);

    public abstract String toString();

    public void refund(Card source) {
    }

    public void setAmount(String amountIn) {
        this.amount = this.originalAmount = amountIn;
    }

    public final void applyTextChangeEffects(CardTraitBase trait) {
        this.amount = AbilityUtils.applyAbilityTextChangeEffects(this.originalAmount, trait);
        this.type = AbilityUtils.applyAbilityTextChangeEffects(this.originalType, trait);
        this.typeDescription = AbilityUtils.applyDescriptionTextChangeEffects(this.originalTypeDescription, trait);
    }

    public abstract boolean payAsDecided(Player var1, PaymentDecision var2, SpellAbility var3, boolean var4);

    public int paymentOrder() {
        return 5;
    }

    public CostPart copy() {
        CostPart clone = null;
        try {
            clone = (CostPart)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
        }
        return clone;
    }

    @Override
    public int compareTo(CostPart o) {
        return this.paymentOrder() - o.paymentOrder();
    }
}

