/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.card.CardZoneTable;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.EnumMap;

public class CostMill
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostMill(String amount) {
        this.setAmount(amount);
    }

    @Override
    public int paymentOrder() {
        return 20;
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return this.getAbilityAmount(ability) < payer.getZone(ZoneType.Library).size();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        Integer i = this.convertAmount();
        sb.append("Mill ");
        if (i != null) {
            sb.append(i);
        } else {
            sb.append(this.getAmount());
        }
        sb.append(" card");
        if (i == null || i > 1) {
            sb.append("s");
        }
        return sb.toString();
    }

    @Override
    public final boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        Game game = ai.getGame();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, ability);
        ability.getPaidHash().put((Object)"Milled", (Object)true, (Object)game.getAction().mill(new PlayerCollection(ai), decision.c, ZoneType.Graveyard, ability, moveParams));
        zoneMovements.triggerChangesZoneAll(game, ability);
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

