/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.ability.effects.FlipCoinEffect;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class CostFlipCoin
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostFlipCoin(String amount) {
        this.setAmount(amount);
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return true;
    }

    @Override
    public int paymentOrder() {
        return 22;
    }

    @Override
    public final String toString() {
        return Cost.convertAmountTypeToWords(this.convertAmount(), this.getAmount(), "Coin");
    }

    @Override
    public boolean payAsDecided(Player payer, PaymentDecision pd, SpellAbility sa, boolean effect) {
        int m4 = FlipCoinEffect.getFlipMultiplier(payer);
        for (int i = 0; i < pd.c; ++i) {
            FlipCoinEffect.flipCoinCall(payer, sa, m4);
        }
        return true;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

