/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithTrigger;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class CostExert
extends CostPartWithTrigger {
    private static final long serialVersionUID = 1L;

    public CostExert(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Exert ");
        Integer i = this.convertAmount();
        if (this.payCostFromSource()) {
            sb.append(this.getType());
        } else {
            String desc;
            String string = desc = this.getTypeDescription() == null ? this.getType() : this.getTypeDescription();
            if (i != null) {
                sb.append(Cost.convertIntAndTypeToWords(i, desc));
            } else {
                sb.append(Cost.convertAmountTypeToWords(this.getAmount(), desc));
            }
        }
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        if (!this.payCostFromSource()) {
            boolean needsAnnoucement = ability.hasParam("Announce") && this.getType().contains(ability.getParam("Announce"));
            CardCollectionView typeList = payer.getCardsIn(ZoneType.Battlefield);
            typeList = CardLists.getValidCards((Iterable<Card>)typeList, this.getType().split(";"), payer, source, (CardTraitBase)ability);
            int amount = this.getAbilityAmount(ability);
            return needsAnnoucement || typeList.size() >= amount;
        }
        return true;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        targetCard.exert(payer);
        return targetCard;
    }

    @Override
    public String getHashForLKIList() {
        return "Exerted";
    }

    @Override
    public String getHashForCardList() {
        return "ExertedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

