/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import java.util.EnumMap;

public class CostDraw
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostDraw(String amount, String playerSelector) {
        super(amount, playerSelector, null);
    }

    @Override
    public int paymentOrder() {
        return 20;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        Integer i = this.convertAmount();
        sb.append("Draw ").append(Cost.convertAmountTypeToWords(i, this.getAmount(), "Card"));
        return sb.toString();
    }

    public PlayerCollection getPotentialPlayers(Player payer, SpellAbility ability) {
        PlayerCollection res = new PlayerCollection();
        String type = this.getType();
        Card source = ability.getHostCard();
        int c = this.getAbilityAmount(ability);
        for (Player p : payer.getGame().getPlayers()) {
            if (!p.isValid(type, payer, source, (CardTraitBase)ability) || !p.canDrawAmount(c)) continue;
            res.add(p);
        }
        return res;
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return !this.getPotentialPlayers(payer, ability).isEmpty();
    }

    @Override
    public final boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        Game game = ai.getGame();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, game.getLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, game.getLastStateGraveyard());
        for (Player p : decision.players) {
            p.drawCards(decision.c, ability, moveParams);
        }
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

