/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CostDiscard
extends CostPartWithList {
    protected List<Card> discardedBefore;
    private static final long serialVersionUID = 1L;

    public CostDiscard(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public int paymentOrder() {
        return 10;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        CardCollectionView handList;
        Card source = ability.getHostCard();
        String type = this.getType();
        CardCollectionView cardCollectionView = handList = payer.canDiscardBy(ability, effect) ? payer.getCardsIn(ZoneType.Hand) : CardCollection.EMPTY;
        if (!type.equals("Random")) {
            handList = CardLists.getValidCards((Iterable<Card>)handList, type.split(";"), payer, source, (CardTraitBase)ability);
        }
        return handList.size();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Discard ");
        Integer i = this.convertAmount();
        if (this.payCostFromSource()) {
            sb.append(this.getType());
        } else if (this.getType().equals("Hand")) {
            sb.append("your hand");
        } else if (this.getType().equals("LastDrawn")) {
            sb.append("the last card you drew this turn");
        } else if (this.getType().equals("DifferentNames")) {
            sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), "Card")).append(" with different names");
        } else {
            StringBuilder desc = new StringBuilder();
            if (this.getType().equals("Card") || this.getType().equals("Random")) {
                desc.append("card");
            } else {
                desc.append(this.getDescriptiveType());
                desc.append(" card");
            }
            sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), desc.toString()));
            if (this.getType().equals("Random")) {
                sb.append(" at random");
            }
        }
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        CardCollectionView handList = payer.canDiscardBy(ability, effect) ? payer.getCardsIn(ZoneType.Hand) : CardCollection.EMPTY;
        String type = this.getType();
        int amount = this.getAbilityAmount(ability);
        if (this.payCostFromSource()) {
            return source.canBeDiscardedBy(ability, effect);
        }
        if (type.equals("Hand")) {
            if (payer.getZone(ZoneType.Hand).isEmpty()) {
                return true;
            }
            return payer.canDiscardBy(ability, effect);
        }
        if (type.equals("LastDrawn")) {
            Card c = payer.getLastDrawnCard();
            return handList.contains(c);
        }
        if (type.equals("DifferentNames")) {
            HashSet<String> cardNames = Sets.newHashSet();
            for (Card c : handList) {
                if (c.hasNoName()) continue;
                cardNames.add(c.getName());
            }
            return cardNames.size() >= amount;
        }
        boolean sameName = false;
        if (type.contains("+WithSameName")) {
            sameName = true;
            type = TextUtil.fastReplace(type, "+WithSameName", "");
        }
        if (!(type.contains("ChosenColor") && !source.hasChosenColor() || type.equals("Random") || type.contains("X"))) {
            handList = CardLists.getValidCards((Iterable<Card>)handList, type.split(";"), payer, source, (CardTraitBase)ability);
        }
        if (sameName) {
            for (Card c : handList) {
                if (CardLists.count(handList, CardPredicates.nameEquals(c.getName())) <= 1) continue;
                return true;
            }
            return false;
        }
        int adjustment = 0;
        if (source.isInZone(ZoneType.Hand) && payer.equals(source.getOwner()) && handList.contains(source)) {
            adjustment = 1;
        }
        return amount <= handList.size() - adjustment;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(runParams, this.table);
        if (ability.isCycling() && targetCard.equals(ability.getHostCard())) {
            runParams.put(AbilityKey.Cycling, (Object)true);
        }
        SpellAbility cause = targetCard.getGame().getStack().isResolving(ability.getHostCard()) ? ability : null;
        return payer.discard(targetCard, cause, effect, runParams);
    }

    @Override
    public String getHashForLKIList() {
        return "Discarded";
    }

    @Override
    public String getHashForCardList() {
        return "DiscardedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected void handleBeforePayment(Player ai, SpellAbility ability, CardCollectionView targetCards) {
        this.discardedBefore = Lists.newArrayList(ai.getDiscardedThisTurn());
    }

    @Override
    protected void handleChangeZoneTrigger(Player payer, SpellAbility ability, CardCollectionView targetCards) {
        super.handleChangeZoneTrigger(payer, ability, targetCards);
        if (!this.cardList.isEmpty()) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(payer);
            runParams.put(AbilityKey.Cards, new CardCollection(this.cardList));
            runParams.put(AbilityKey.Cause, ability);
            runParams.put(AbilityKey.DiscardedBefore, this.discardedBefore);
            payer.getGame().getTriggerHandler().runTrigger(TriggerType.DiscardedAll, runParams, false);
        }
    }
}

