/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import forge.card.CardStateName;
import forge.card.mana.ManaAtom;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.card.mana.ManaCostShard;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CardZoneTable;
import forge.game.cost.Cost;
import forge.game.cost.IndividualCostPaymentInstance;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.spellability.TargetChoices;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CostAdjustment {
    public static Cost adjust(Cost cost, SpellAbility sa) {
        if (sa.isTrigger() || cost == null) {
            return cost;
        }
        Player player = sa.getActivatingPlayer();
        Card host = sa.getHostCard();
        Game game = player.getGame();
        Cost result = cost.copy();
        boolean isStateChangeToFaceDown = false;
        if (sa.isSpell()) {
            int n;
            if (sa.isCastFaceDown() && !host.isFaceDown()) {
                host.turnFaceDownNoUpdate();
                isStateChangeToFaceDown = true;
            }
            if (host.isCommander() && host.getCastFrom() != null && ZoneType.Command.equals((Object)host.getCastFrom().getZoneType()) && (n = player.getCommanderCast(host) * 2) > 0) {
                result.add(new Cost(ManaCost.get(n), false));
            }
        }
        CardCollection cardsOnBattlefield = new CardCollection(game.getCardsIn(ZoneType.Battlefield));
        cardsOnBattlefield.addAll(game.getCardsIn(ZoneType.Stack));
        cardsOnBattlefield.addAll(game.getCardsIn(ZoneType.Command));
        if (!cardsOnBattlefield.contains(host)) {
            cardsOnBattlefield.add(host);
        }
        ArrayList<StaticAbility> raiseAbilities = Lists.newArrayList();
        for (Card c : cardsOnBattlefield) {
            for (StaticAbility stAb : c.getStaticAbilities()) {
                if (!stAb.checkMode("RaiseCost")) continue;
                raiseAbilities.add(stAb);
            }
        }
        if (sa.hasParam("RaiseCost")) {
            String raise = sa.getParam("RaiseCost");
            Cost inc = sa.hasSVar(raise) ? new Cost(ManaCost.get(AbilityUtils.calculateAmount(host, raise, sa)), false) : new Cost(raise, false);
            result.add(inc);
        }
        for (StaticAbility stAb : raiseAbilities) {
            CostAdjustment.applyRaise(result, sa, stAb);
        }
        if (isStateChangeToFaceDown) {
            host.setState(CardStateName.Original, false);
            host.setFaceDown(false);
        }
        return result;
    }

    private static void applyRaise(Cost cost, SpellAbility sa, StaticAbility st) {
        Card hostCard = st.getHostCard();
        if (!CostAdjustment.checkRequirement(sa, st)) {
            return;
        }
        String scost = st.getParamOrDefault("Cost", "1");
        int count = 0;
        if (st.hasParam("ForEachShard")) {
            ManaCost mc = ManaCost.ZERO;
            if (sa.isSpell()) {
                mc = sa.getHostCard().getManaCost();
            } else if (sa.isAbility() && sa.getPayCosts().hasManaCost()) {
                mc = sa.getPayCosts().getCostMana().getMana();
            }
            byte atom = ManaAtom.fromName(st.getParam("ForEachShard").toLowerCase());
            for (ManaCostShard shard : mc) {
                if ((shard.getColorMask() & atom) == 0) continue;
                ++count;
            }
        } else if (st.hasParam("Amount")) {
            String amount = st.getParam("Amount");
            if ("Escalate".equals(amount)) {
                for (SpellAbility sub = sa; sub != null; sub = sub.getSubAbility()) {
                    if (!sub.getDirectSVars().containsKey("CharmOrder")) continue;
                    ++count;
                }
                --count;
            } else if ("Strive".equals(amount)) {
                for (TargetChoices tc : sa.getAllTargetChoices()) {
                    count += tc.size();
                }
                --count;
            } else if ("Spree".equals(amount)) {
                for (SpellAbility sub = sa; sub != null; sub = sub.getSubAbility()) {
                    if (!sub.hasParam("SpreeCost")) continue;
                    Cost part = new Cost(sub.getParam("SpreeCost"), sa.isAbility(), sa.getHostCard().equals(hostCard));
                    cost.mergeTo(part, count, sa);
                }
            } else {
                count = StringUtils.isNumeric(amount) ? Integer.parseInt(amount) : (st.hasParam("Relative") ? AbilityUtils.calculateAmount(hostCard, st.hasSVar(amount) ? st.getSVar(amount) : amount, sa) : AbilityUtils.calculateAmount(hostCard, amount, st));
            }
        } else {
            count = 1;
        }
        if (count > 0) {
            Cost part = new Cost(scost, sa.isAbility(), sa.getHostCard().equals(hostCard));
            cost.mergeTo(part, count, sa);
        }
    }

    public static boolean adjust(ManaCostBeingPaid cost, SpellAbility sa, CardCollection cardsToDelveOut, boolean test) {
        if (sa.isTrigger() || sa.isReplacementAbility()) {
            return true;
        }
        Game game = sa.getActivatingPlayer().getGame();
        Card originalCard = sa.getHostCard();
        boolean isStateChangeToFaceDown = false;
        if (sa.isSpell() && sa.isCastFaceDown() && !originalCard.isFaceDown()) {
            originalCard.turnFaceDownNoUpdate();
            isStateChangeToFaceDown = true;
        }
        CardCollection cardsOnBattlefield = new CardCollection(game.getCardsIn(ZoneType.Battlefield));
        cardsOnBattlefield.addAll(game.getCardsIn(ZoneType.Stack));
        cardsOnBattlefield.addAll(game.getCardsIn(ZoneType.Command));
        if (!cardsOnBattlefield.contains(originalCard)) {
            cardsOnBattlefield.add(originalCard);
        }
        ArrayList<StaticAbility> reduceAbilities = Lists.newArrayList();
        ArrayList<StaticAbility> setAbilities = Lists.newArrayList();
        for (Card c : cardsOnBattlefield) {
            for (StaticAbility stAb : c.getStaticAbilities()) {
                if (stAb.checkMode("ReduceCost") && CostAdjustment.checkRequirement(sa, stAb)) {
                    reduceAbilities.add(stAb);
                    continue;
                }
                if (!stAb.checkMode("SetCost")) continue;
                setAbilities.add(stAb);
            }
        }
        int sumGeneric = 0;
        if (sa.hasParam("ReduceCost")) {
            String cst = sa.getParam("ReduceCost");
            String amt = sa.getParamOrDefault("ReduceAmount", cst);
            int num = AbilityUtils.calculateAmount(originalCard, amt, sa);
            if (sa.hasParam("ReduceAmount") && num > 0) {
                cost.subtractManaCost(new ManaCost(new ManaCostParser(Strings.repeat(cst + " ", num))));
            } else {
                sumGeneric += num;
            }
        }
        while (!reduceAbilities.isEmpty()) {
            Iterator choice = sa.getActivatingPlayer().getController().chooseSingleStaticAbility(Localizer.getInstance().getMessage("lblChooseCostReduction", new Object[0]), reduceAbilities);
            reduceAbilities.remove(choice);
            sumGeneric += CostAdjustment.applyReduceCostAbility(choice, sa, cost, sumGeneric);
        }
        cost.decreaseGenericMana(sumGeneric);
        if (sa.isSpell()) {
            for (String pip : sa.getPipsToReduce()) {
                cost.decreaseShard(ManaCostShard.parseNonGeneric(pip), 1);
            }
        }
        if (sa.isSpell() && sa.isOffering()) {
            CostAdjustment.adjustCostByOffering(cost, sa);
        }
        if (sa.isSpell() && sa.isEmerge()) {
            CostAdjustment.adjustCostByEmerge(cost, sa);
        }
        for (StaticAbility stAb : setAbilities) {
            CostAdjustment.applySetCostAbility(stAb, sa, cost);
        }
        if (sa.isSpell()) {
            if (sa.getHostCard().hasKeyword(Keyword.ASSIST) && !CostAdjustment.adjustCostByAssist(cost, sa, test)) {
                return false;
            }
            if (sa.getHostCard().hasKeyword(Keyword.DELVE)) {
                sa.getHostCard().clearDelved();
                CardZoneTable table = new CardZoneTable();
                Player pc = sa.getActivatingPlayer();
                CardCollection mutableGrave = new CardCollection(pc.getCardsIn(ZoneType.Graveyard));
                CardCollectionView toExile = pc.getController().chooseCardsToDelve(cost.getUnpaidShards(ManaCostShard.GENERIC), mutableGrave);
                for (Card c : toExile) {
                    cost.decreaseGenericMana(1);
                    if (cardsToDelveOut != null) {
                        cardsToDelveOut.add(c);
                        continue;
                    }
                    if (test) continue;
                    sa.getHostCard().addDelved(c);
                    Card d = game.getAction().exile(c, null, null);
                    Card host = sa.getHostCard();
                    host.addExiledCard(d);
                    d.setExiledWith(host);
                    d.setExiledBy(host.getController());
                    table.put(ZoneType.Graveyard, d.getZone().getZoneType(), d);
                }
                table.triggerChangesZoneAll(game, sa);
            }
            if (sa.getHostCard().hasKeyword(Keyword.CONVOKE)) {
                CostAdjustment.adjustCostByConvokeOrImprovise(cost, sa, false, test);
            }
            if (sa.getHostCard().hasKeyword(Keyword.IMPROVISE)) {
                CostAdjustment.adjustCostByConvokeOrImprovise(cost, sa, true, test);
            }
        }
        if (sa.hasParam("TapCreaturesForMana")) {
            CostAdjustment.adjustCostByConvokeOrImprovise(cost, sa, false, test);
        }
        if (isStateChangeToFaceDown) {
            originalCard.setFaceDown(false);
            originalCard.setState(CardStateName.Original, false);
        }
        return true;
    }

    private static boolean adjustCostByAssist(ManaCostBeingPaid cost, SpellAbility sa, boolean test) {
        int genericLeft = cost.getUnpaidShards(ManaCostShard.GENERIC);
        if (genericLeft == 0) {
            return true;
        }
        Player activator = sa.getActivatingPlayer();
        PlayerCollection otherPlayers = activator.getAllOtherPlayers();
        Player assistant = activator.getController().choosePlayerToAssistPayment(otherPlayers, sa, "Choose a player to assist paying this spell", genericLeft);
        if (assistant == null) {
            return true;
        }
        int requestedAmount = genericLeft;
        return assistant.getController().helpPayForAssistSpell(cost, sa, genericLeft, requestedAmount);
    }

    private static void adjustCostByConvokeOrImprovise(ManaCostBeingPaid cost, SpellAbility sa, boolean improvise, boolean test) {
        if (!improvise) {
            sa.clearTappedForConvoke();
        }
        Player activator = sa.getActivatingPlayer();
        CardCollection untappedCards = CardLists.filter((Iterable<Card>)activator.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CAN_TAP);
        untappedCards = improvise ? CardLists.filter((Iterable<Card>)untappedCards, CardPredicates.Presets.ARTIFACTS) : CardLists.filter((Iterable<Card>)untappedCards, CardPredicates.Presets.CREATURES);
        Map<Card, ManaCostShard> convokedCards = activator.getController().chooseCardsForConvokeOrImprovise(sa, cost.toManaCost(), untappedCards, improvise);
        CardCollection tapped = new CardCollection();
        for (Map.Entry<Card, ManaCostShard> conv : convokedCards.entrySet()) {
            Card c = conv.getKey();
            if (!improvise) {
                sa.addTappedForConvoke(c);
            }
            cost.decreaseShard(conv.getValue(), 1);
            if (test || !c.tap(true, sa, activator)) continue;
            tapped.add(c);
        }
        if (!tapped.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, tapped);
            activator.getGame().getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        }
    }

    private static void adjustCostByOffering(ManaCostBeingPaid cost, SpellAbility sa) {
        String offeringType = "";
        Iterator<KeywordInterface> iterator = sa.getHostCard().getKeywords(Keyword.OFFERING).iterator();
        if (iterator.hasNext()) {
            KeywordInterface inst = iterator.next();
            String kw = inst.getOriginal();
            offeringType = kw.split(" ")[0];
        }
        CardCollection canOffer = CardLists.filter(sa.getActivatingPlayer().getCardsIn(ZoneType.Battlefield), CardPredicates.isType(offeringType), CardPredicates.canBeSacrificedBy(sa, false));
        CardCollectionView toSacList = sa.getHostCard().getController().getController().choosePermanentsToSacrifice(sa, 0, 1, canOffer, offeringType);
        if (toSacList.isEmpty()) {
            return;
        }
        Card toSac = (Card)toSacList.getFirst();
        cost.subtractManaCost(toSac.getManaCost());
        sa.setSacrificedAsOffering(toSac);
        toSac.setUsedToPay(true);
    }

    private static void adjustCostByEmerge(ManaCostBeingPaid cost, SpellAbility sa) {
        String kw = sa.getKeyword().getOriginal();
        String[] k = kw.split(":");
        String validStr = k.length > 2 ? k[2] : "Creature";
        Player p = sa.getActivatingPlayer();
        CardCollection canEmerge = CardLists.filter(p.getCardsIn(ZoneType.Battlefield), CardPredicates.restriction(validStr, p, sa.getHostCard(), (CardTraitBase)sa), CardPredicates.canBeSacrificedBy(sa, false));
        CardCollectionView toSacList = p.getController().choosePermanentsToSacrifice(sa, 0, 1, canEmerge, validStr);
        if (toSacList.isEmpty()) {
            return;
        }
        Card toSac = (Card)toSacList.getFirst();
        cost.decreaseGenericMana(toSac.getCMC());
        sa.setSacrificedAsEmerge(toSac);
        toSac.setUsedToPay(true);
    }

    private static void applySetCostAbility(StaticAbility staticAbility, SpellAbility sa, ManaCostBeingPaid manaCost) {
        String amount = staticAbility.getParam("Amount");
        if (!CostAdjustment.checkRequirement(sa, staticAbility)) {
            return;
        }
        int value = Integer.parseInt(amount);
        if (staticAbility.hasParam("RaiseTo")) {
            value = Math.max(value - manaCost.getConvertedManaCost(), 0);
        }
        manaCost.increaseGenericMana(value);
    }

    private static int applyReduceCostAbility(StaticAbility staticAbility, SpellAbility sa, ManaCostBeingPaid manaCost, int sumReduced) {
        if (manaCost.toString().equals("{0}")) {
            return 0;
        }
        Card hostCard = staticAbility.getHostCard();
        Card card = sa.getHostCard();
        String amount = staticAbility.getParam("Amount");
        int value = "AffectedX".equals(amount) ? AbilityUtils.calculateAmount(card, amount, staticAbility) : ("Undaunted".equals(amount) ? card.getController().getOpponents().size() : (staticAbility.hasParam("Relative") ? AbilityUtils.calculateAmount(hostCard, staticAbility.hasSVar(amount) ? staticAbility.getSVar(amount) : amount, sa) : AbilityUtils.calculateAmount(hostCard, amount, staticAbility)));
        if (staticAbility.hasParam("UpTo")) {
            value = sa.getActivatingPlayer().getController().chooseNumberForCostReduction(sa, 0, value);
        }
        if (!staticAbility.hasParam("Cost") && !staticAbility.hasParam("Color")) {
            int maxReduction;
            int minMana = 0;
            if (staticAbility.hasParam("MinMana")) {
                minMana = Integer.parseInt(staticAbility.getParam("MinMana"));
            }
            if ((maxReduction = manaCost.getConvertedManaCost() - minMana - sumReduced) > 0) {
                return Math.min(value, maxReduction);
            }
        } else {
            String color = staticAbility.getParamOrDefault("Cost", staticAbility.getParam("Color"));
            int sumGeneric = 0;
            for (String cost : color.split(" ")) {
                if (StringUtils.isNumeric(cost)) {
                    sumGeneric += Integer.parseInt(cost) * value;
                    continue;
                }
                if (staticAbility.hasParam("IgnoreGeneric")) {
                    manaCost.decreaseShard(ManaCostShard.parseNonGeneric(cost), value);
                    continue;
                }
                manaCost.subtractManaCost(new ManaCost(new ManaCostParser(Strings.repeat(cost + " ", value))));
            }
            return sumGeneric;
        }
        return 0;
    }

    private static boolean checkRequirement(SpellAbility sa, StaticAbility st) {
        if (!st.checkConditions()) {
            return false;
        }
        Card hostCard = st.getHostCard();
        Player controller = hostCard.getController();
        Player activator = sa.getActivatingPlayer();
        Card card = sa.getHostCard();
        Game game = hostCard.getGame();
        if (!st.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (!st.matchesValidParam("ValidSpell", sa)) {
            return false;
        }
        if (!st.matchesValidParam("Activator", activator)) {
            return false;
        }
        if (st.hasParam("Type")) {
            String type = st.getParam("Type");
            if (type.equals("Spell")) {
                if (!sa.isSpell()) {
                    return false;
                }
                if (st.hasParam("OnlyFirstSpell")) {
                    if (activator == null) {
                        return false;
                    }
                    List<Card> list = st.hasParam("ValidCard") ? CardUtil.getThisTurnCast(st.getParam("ValidCard"), hostCard, st, controller) : game.getStack().getSpellsCastThisTurn();
                    if (st.hasParam("ValidSpell")) {
                        list = CardLists.filterAsList(list, CardPredicates.castSA(SpellAbilityPredicates.isValid(st.getParam("ValidSpell").split(","), controller, hostCard, st)));
                    }
                    if (CardLists.filterControlledBy(list, activator).size() > 0) {
                        return false;
                    }
                }
            } else if (type.equals("Ability")) {
                if (!sa.isActivatedAbility() || sa.isReplacementAbility()) {
                    return false;
                }
                if (st.hasParam("OnlyFirstActivation")) {
                    int times = 0;
                    for (IndividualCostPaymentInstance i : game.costPaymentStack) {
                        SpellAbility paymentSa = i.getPayment().getAbility();
                        if (!paymentSa.isActivatedAbility() || !st.matchesValidParam("ValidCard", paymentSa.getHostCard()) || ++times <= 1) continue;
                        return false;
                    }
                }
            } else if (type.equals("NonManaAbility")) {
                if (!sa.isActivatedAbility() || sa.isManaAbility() || sa.isReplacementAbility()) {
                    return false;
                }
            } else if (type.equals("MorphDown")) {
                if (!sa.isSpell() || !sa.isCastFaceDown()) {
                    return false;
                }
            } else if (type.equals("Foretell")) {
                if (!sa.isForetelling()) {
                    return false;
                }
                if (st.hasParam("FirstForetell") && activator.getNumForetoldThisTurn() > 0) {
                    return false;
                }
            }
        }
        if (st.hasParam("AffectedZone")) {
            Zone z;
            List<ZoneType> zones = ZoneType.listValueOf(st.getParam("AffectedZone"));
            if (sa.isSpell() && card.wasCast() ? !zones.contains((Object)card.getCastFrom().getZoneType()) : (z = card.getLastKnownZone()) == null || !zones.contains((Object)z.getZoneType())) {
                return false;
            }
        }
        if (st.hasParam("ValidTarget")) {
            SpellAbility curSa = sa;
            boolean targetValid = false;
            block1: while (curSa != null) {
                if (!curSa.usesTargeting()) {
                    curSa = curSa.getSubAbility();
                    continue;
                }
                for (GameObject target : curSa.getTargets()) {
                    if (!target.isValid(st.getParam("ValidTarget").split(","), controller, hostCard, (CardTraitBase)curSa)) continue;
                    targetValid = true;
                    break block1;
                }
                curSa = curSa.getSubAbility();
            }
            if (st.hasParam("UnlessValidTarget") ? targetValid : !targetValid) {
                return false;
            }
        }
        return true;
    }
}

