/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import com.google.common.collect.Lists;
import forge.game.GameEntityView;
import forge.game.card.CardView;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableProperty;
import forge.trackable.Tracker;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CombatView
extends TrackableObject {
    private static final long serialVersionUID = 68085618912864941L;

    public CombatView(Tracker tracker) {
        super(-1, tracker);
        this.set(TrackableProperty.AttackersWithDefenders, new ConcurrentHashMap());
        this.set(TrackableProperty.AttackersWithBlockers, new ConcurrentHashMap());
        this.set(TrackableProperty.BandsWithDefenders, new ConcurrentHashMap());
        this.set(TrackableProperty.BandsWithBlockers, new ConcurrentHashMap());
        this.set(TrackableProperty.AttackersWithPlannedBlockers, new ConcurrentHashMap());
        this.set(TrackableProperty.BandsWithPlannedBlockers, new ConcurrentHashMap());
    }

    private Map<CardView, GameEntityView> getAttackersWithDefenders() {
        return (Map)this.get(TrackableProperty.AttackersWithDefenders);
    }

    private Map<CardView, FCollection<CardView>> getAttackersWithBlockers() {
        return (Map)this.get(TrackableProperty.AttackersWithBlockers);
    }

    private Map<FCollection<CardView>, GameEntityView> getBandsWithDefenders() {
        return (Map)this.get(TrackableProperty.BandsWithDefenders);
    }

    private Map<FCollection<CardView>, FCollection<CardView>> getBandsWithBlockers() {
        return (Map)this.get(TrackableProperty.BandsWithBlockers);
    }

    private Map<CardView, FCollection<CardView>> getAttackersWithPlannedBlockers() {
        return (Map)this.get(TrackableProperty.AttackersWithPlannedBlockers);
    }

    private Map<FCollection<CardView>, FCollection<CardView>> getBandsWithPlannedBlockers() {
        return (Map)this.get(TrackableProperty.BandsWithPlannedBlockers);
    }

    public int getNumAttackers() {
        return this.getAttackersWithDefenders().size();
    }

    public boolean isAttacking(CardView card) {
        return this.getAttackersWithDefenders().containsKey(card);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<CardView> getAttackers() {
        HashSet<CardView> allAttackers;
        CombatView combatView = this;
        synchronized (combatView) {
            allAttackers = new HashSet<CardView>(this.getAttackersWithDefenders().keySet());
        }
        return allAttackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<GameEntityView> getDefenders() {
        HashSet<GameEntityView> allDefenders;
        CombatView combatView = this;
        synchronized (combatView) {
            allDefenders = new HashSet<GameEntityView>(this.getAttackersWithDefenders().values());
        }
        return allDefenders;
    }

    public GameEntityView getDefender(CardView attacker) {
        return this.getAttackersWithDefenders().get(attacker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocking(CardView card) {
        ArrayList<FCollection<CardView>> allBlockers;
        CombatView combatView = this;
        synchronized (combatView) {
            allBlockers = Lists.newArrayList(this.getAttackersWithBlockers().values());
        }
        for (FCollection fCollection : allBlockers) {
            if (fCollection == null || !fCollection.contains(card)) continue;
            return true;
        }
        return false;
    }

    public FCollection<CardView> getBlockers(CardView attacker) {
        return this.getAttackersWithBlockers().get(attacker);
    }

    public FCollection<CardView> getPlannedBlockers(CardView attacker) {
        return this.getAttackersWithPlannedBlockers().get(attacker);
    }

    public FCollection<CardView> getBlockers(FCollection<CardView> attackingBand) {
        return this.getBandsWithBlockers().get(attackingBand);
    }

    public FCollection<CardView> getPlannedBlockers(FCollection<CardView> attackingBand) {
        return this.getBandsWithPlannedBlockers().get(attackingBand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCollection<CardView> getAttackersOf(GameEntityView defender) {
        ArrayList<Map.Entry<CardView, GameEntityView>> attackersWithDefenders;
        CombatView combatView = this;
        synchronized (combatView) {
            attackersWithDefenders = Lists.newArrayList(this.getAttackersWithDefenders().entrySet());
        }
        FCollection<CardView> views = new FCollection<CardView>();
        for (Map.Entry entry : attackersWithDefenders) {
            if (defender == null || !defender.equals(entry.getValue())) continue;
            views.add((CardView)entry.getKey());
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<FCollection<CardView>> getAttackingBandsOf(GameEntityView defender) {
        ArrayList<Map.Entry<FCollection<CardView>, GameEntityView>> bandsWithDefenders;
        CombatView combatView = this;
        synchronized (combatView) {
            bandsWithDefenders = Lists.newArrayList(this.getBandsWithDefenders().entrySet());
        }
        ArrayList<FCollection<CardView>> views = new ArrayList<FCollection<CardView>>();
        for (Map.Entry entry : bandsWithDefenders) {
            if (defender == null || !defender.equals(entry.getValue())) continue;
            views.add((FCollection)entry.getKey());
        }
        return views;
    }

    public void addAttackingBand(Iterable<CardView> attackingBand, GameEntityView defender, Iterable<CardView> blockers, Iterable<CardView> plannedBlockers) {
        if (defender == null) {
            return;
        }
        FCollection<CardView> attackingBandCopy = new FCollection<CardView>();
        FCollection<CardView> blockersCopy = new FCollection<CardView>();
        FCollection<CardView> plannedBlockersCopy = new FCollection<CardView>();
        attackingBandCopy.addAll(attackingBand);
        if (blockers != null) {
            blockersCopy.addAll(blockers);
        }
        if (plannedBlockers != null) {
            plannedBlockersCopy.addAll(plannedBlockers);
        }
        for (CardView attacker : attackingBandCopy) {
            this.getAttackersWithDefenders().put(attacker, defender);
            this.getAttackersWithBlockers().put(attacker, blockersCopy);
            this.getAttackersWithPlannedBlockers().put(attacker, plannedBlockersCopy);
        }
        this.getBandsWithDefenders().put(attackingBandCopy, defender);
        this.getBandsWithBlockers().put(attackingBandCopy, blockersCopy);
        this.getBandsWithPlannedBlockers().put(attackingBandCopy, plannedBlockersCopy);
    }
}

