/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import java.util.List;

public class AttackingBand {
    private CardCollection attackers = new CardCollection();
    private Boolean blocked = null;

    public AttackingBand(List<Card> band) {
        this.attackers.addAll(band);
    }

    public AttackingBand(Card card) {
        this.attackers.add(card);
    }

    public CardCollectionView getAttackers() {
        return this.attackers;
    }

    public void addAttacker(Card card) {
        this.attackers.add(card);
    }

    public void removeAttacker(Card card) {
        this.attackers.remove(card);
    }

    public static boolean isValidBand(CardCollectionView band, boolean shareDamage) {
        int neededBandingCreatures;
        if (band.isEmpty()) {
            return false;
        }
        int bandingCreatures = CardLists.getKeyword((Iterable<Card>)band, Keyword.BANDING).size();
        int n = neededBandingCreatures = shareDamage ? 1 : band.size() - 1;
        if (neededBandingCreatures <= bandingCreatures) {
            return true;
        }
        for (Card c : CardLists.getKeyword((Iterable<Card>)band, Keyword.BANDSWITH)) {
            for (KeywordInterface kw : c.getKeywords(Keyword.BANDSWITH)) {
                String o = kw.getOriginal();
                String[] m4 = o.split(":");
                if (CardLists.getValidCards((Iterable<Card>)band, m4[1], c.getController(), c, null).size() != band.size()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canJoinBand(Card card) {
        CardCollection newBand = new CardCollection(this.attackers);
        if (card != null) {
            newBand.add(card);
        }
        return AttackingBand.isValidBand(newBand, false);
    }

    public boolean contains(Card c) {
        return this.attackers.contains(c);
    }

    public Boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean value) {
        this.blocked = value;
    }

    public boolean isEmpty() {
        return this.attackers.isEmpty();
    }

    public String toString() {
        return String.format("%s %s", this.attackers.toString(), this.blocked == null ? " ? " : (this.blocked != false ? ">||" : ">>>"));
    }
}

