/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.combat.AttackRestriction;
import forge.game.combat.AttackRestrictionType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.combat.GlobalAttackRestrictions;
import forge.game.player.Player;
import forge.game.staticability.StaticAbilityMustAttack;
import forge.util.collect.FCollectionView;
import forge.util.maps.LinkedHashMapToAmount;
import forge.util.maps.MapToAmount;
import forge.util.maps.MapToAmountUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class AttackRequirement {
    private final MapToAmount<GameEntity> defenderSpecific = new LinkedHashMapToAmount<GameEntity>();
    private final MapToAmount<Card> causesToAttack;
    private final Card attacker;

    public AttackRequirement(Card attacker, MapToAmount<Card> causesToAttack, FCollectionView<GameEntity> possibleDefenders) {
        this.attacker = attacker;
        this.causesToAttack = causesToAttack;
        Game game = attacker.getGame();
        int nAttackAnything = 0;
        if (attacker.isGoaded()) {
            nAttackAnything += attacker.getGoaded().size();
        }
        List<GameEntity> mustAttack = StaticAbilityMustAttack.entitiesMustAttack(attacker);
        nAttackAnything += Collections.frequency(mustAttack, attacker);
        for (GameEntity e : mustAttack) {
            if (e.equals(attacker)) continue;
            this.defenderSpecific.add(e);
        }
        for (GameEntity defender : possibleDefenders) {
            this.defenderSpecific.put(defender, this.defenderSpecific.count(defender) + nAttackAnything);
        }
        ArrayList<GameEntity> toRemove = Lists.newArrayListWithCapacity(this.defenderSpecific.size());
        for (GameEntity entity : this.defenderSpecific.keySet()) {
            Card reqPW;
            Card gamePW;
            boolean removeThis = false;
            if (entity instanceof Player) {
                if (!((Player)entity).isInGame()) {
                    removeThis = true;
                }
            } else if (!(!(entity instanceof Card) || (gamePW = game.getCardState(reqPW = (Card)entity, null)) != null && gamePW.getController().isInGame() && gamePW.equalsWithGameTimestamp(reqPW) && (gamePW.isBattle() || gamePW.getController().isOpponentOf(attacker.getController())))) {
                removeThis = true;
            }
            if (!removeThis) continue;
            toRemove.add(entity);
        }
        this.defenderSpecific.keySet().removeAll(toRemove);
    }

    public Card getAttacker() {
        return this.attacker;
    }

    public boolean hasRequirement() {
        return this.defenderSpecific.countAll() > 0 || this.causesToAttack.countAll() > 0;
    }

    public final MapToAmount<Card> getCausesToAttack() {
        return this.causesToAttack;
    }

    public int countViolations(GameEntity defender, Map<Card, GameEntity> attackers) {
        if (!this.hasRequirement()) {
            return 0;
        }
        boolean isAttacking = defender != null;
        int violations = this.defenderSpecific.countAll() - (isAttacking ? this.defenderSpecific.count(defender) : 0);
        if (isAttacking) {
            Combat combat = defender.getGame().getCombat();
            Map<Card, AttackRestriction> constraints = combat.getAttackConstraints().getRestrictions();
            if (attackers.size() != 1 || !constraints.get(attackers.entrySet().iterator().next().getKey()).getTypes().contains((Object)AttackRestrictionType.ONLY_ALONE)) {
                for (Map.Entry mustAttack : this.causesToAttack.entrySet()) {
                    if (constraints.get(mustAttack.getKey()).getTypes().contains((Object)AttackRestrictionType.ONLY_ALONE)) continue;
                    int max = GlobalAttackRestrictions.getGlobalRestrictions(((Card)mustAttack.getKey()).getController(), combat.getDefenders()).getMax();
                    if (max == -1) {
                        max = Integer.MAX_VALUE;
                    }
                    if (attackers.size() >= max || attackers.containsKey(mustAttack.getKey()) || !CombatUtil.canAttack((Card)mustAttack.getKey()) || CombatUtil.getAttackCost(defender.getGame(), (Card)mustAttack.getKey(), defender) != null) continue;
                    violations += ((Integer)mustAttack.getValue()).intValue();
                }
            }
        }
        return violations;
    }

    public List<Pair<GameEntity, Integer>> getSortedRequirements() {
        return MapToAmountUtil.sort(this.defenderSpecific);
    }
}

