/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forge.ImageKeys;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.CardTypeView;
import forge.card.ColorSet;
import forge.card.GamePieceType;
import forge.card.mana.ManaCost;
import forge.game.Direction;
import forge.game.EvenOdd;
import forge.game.GameEntityView;
import forge.game.GameType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardState;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.item.IPaperCard;
import forge.trackable.TrackableCollection;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableProperty;
import forge.trackable.Tracker;
import forge.util.CardTranslation;
import forge.util.ITranslatable;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.collect.FCollectionView;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class CardView
extends GameEntityView {
    private static final long serialVersionUID = -3624090829028979255L;
    private String zoneText = "";

    public static CardView get(Card c) {
        return c == null ? null : c.getView();
    }

    public static CardStateView getState(Card c, CardStateName state) {
        if (c == null) {
            return null;
        }
        CardState s2 = c.getState(state);
        return s2 == null ? null : s2.getView();
    }

    public static Map<CardStateView, CardState> getStateMap(Iterable<CardState> states) {
        LinkedHashMap<CardStateView, CardState> stateViewCache = Maps.newLinkedHashMap();
        for (CardState state : states) {
            stateViewCache.put(state.getView(), state);
        }
        return stateViewCache;
    }

    public CardView getBackup() {
        if (this.get(TrackableProperty.PaperCardBackup) == null) {
            return null;
        }
        return CardView.getCardForUi((IPaperCard)this.get(TrackableProperty.PaperCardBackup));
    }

    public static CardView getCardForUi(IPaperCard pc) {
        return Card.getCardForUi(pc).getView();
    }

    public static TrackableCollection<CardView> getCollection(Iterable<Card> cards) {
        if (cards == null) {
            return null;
        }
        TrackableCollection<CardView> collection = new TrackableCollection<CardView>();
        for (Card c : cards) {
            if (c.getCardForUi() != c) continue;
            collection.add(c.getView());
        }
        return collection;
    }

    public static boolean mayViewAny(Iterable<CardView> cards, Iterable<PlayerView> viewers) {
        if (cards == null) {
            return false;
        }
        for (CardView cv : cards) {
            if (!cv.canBeShownToAny(viewers)) continue;
            return true;
        }
        return false;
    }

    public CardView(int id0, Tracker tracker) {
        super(id0, tracker);
        this.set(TrackableProperty.CurrentState, new CardStateView(id0, CardStateName.Original, tracker));
    }

    public CardView(int id0, Tracker tracker, String name0) {
        this(id0, tracker);
        this.getCurrentState().setName(name0);
        this.set(TrackableProperty.Name, name0);
        this.set(TrackableProperty.ChangedColorWords, new HashMap());
        this.set(TrackableProperty.ChangedTypes, new HashMap());
        this.set(TrackableProperty.Sickness, true);
    }

    public CardView(int id0, Tracker tracker, String name0, PlayerView ownerAndController, String imageKey) {
        this(id0, tracker, name0);
        this.set(TrackableProperty.Owner, ownerAndController);
        this.set(TrackableProperty.Controller, ownerAndController);
        this.set(TrackableProperty.ImageKey, imageKey);
    }

    public PlayerView getOwner() {
        return (PlayerView)this.get(TrackableProperty.Owner);
    }

    void updateOwner(Card c) {
        this.set(TrackableProperty.Owner, PlayerView.get(c.getOwner()));
    }

    public PlayerView getController() {
        return (PlayerView)this.get(TrackableProperty.Controller);
    }

    void updateController(Card c) {
        this.set(TrackableProperty.Controller, PlayerView.get(c.getController()));
    }

    public ZoneType getZone() {
        return (ZoneType)((Object)this.get(TrackableProperty.Zone));
    }

    void updateZone(Card c) {
        this.set(TrackableProperty.Zone, c.getZone() == null ? null : c.getZone().getZoneType());
    }

    public boolean isInZone(Iterable<ZoneType> zones) {
        return Iterables.contains(zones, (Object)this.getZone());
    }

    public boolean isCloned() {
        return (Boolean)this.get(TrackableProperty.Cloned);
    }

    public boolean isFaceDown() {
        return (Boolean)this.get(TrackableProperty.Facedown);
    }

    public boolean isForeTold() {
        return (Boolean)this.get(TrackableProperty.Foretold);
    }

    public boolean isManifested() {
        return (Boolean)this.get(TrackableProperty.Manifested);
    }

    public boolean isCloaked() {
        return (Boolean)this.get(TrackableProperty.Cloaked);
    }

    public boolean isFlipCard() {
        return (Boolean)this.get(TrackableProperty.FlipCard);
    }

    public boolean isFlipped() {
        return (Boolean)this.get(TrackableProperty.Flipped);
    }

    public boolean isSplitCard() {
        return (Boolean)this.get(TrackableProperty.SplitCard);
    }

    public boolean isDoubleFacedCard() {
        return (Boolean)this.get(TrackableProperty.DoubleFaced);
    }

    public boolean isAdventureCard() {
        return (Boolean)this.get(TrackableProperty.Adventure);
    }

    public boolean isModalCard() {
        return (Boolean)this.get(TrackableProperty.Modal);
    }

    public boolean isAttacking() {
        return (Boolean)this.get(TrackableProperty.Attacking);
    }

    void updateAttacking(Card c) {
        Combat combat = c.getGame().getCombat();
        this.set(TrackableProperty.Attacking, combat != null && combat.isAttacking(c));
    }

    public boolean isExertedThisTurn() {
        return (Boolean)this.get(TrackableProperty.ExertedThisTurn);
    }

    void updateExertedThisTurn(Card c, boolean exerted) {
        this.set(TrackableProperty.ExertedThisTurn, exerted);
    }

    public boolean isBlocking() {
        return (Boolean)this.get(TrackableProperty.Blocking);
    }

    void updateBlocking(Card c) {
        Combat combat = c.getGame().getCombat();
        this.set(TrackableProperty.Blocking, combat != null && combat.isBlocking(c));
    }

    public boolean isPhasedOut() {
        return (Boolean)this.get(TrackableProperty.PhasedOut);
    }

    void updatePhasedOut(Card c) {
        this.set(TrackableProperty.PhasedOut, c.isPhasedOut());
    }

    public boolean isFirstTurnControlled() {
        return (Boolean)this.get(TrackableProperty.Sickness);
    }

    public boolean hasSickness() {
        return this.isFirstTurnControlled() && !this.getCurrentState().hasHaste();
    }

    public boolean isSick() {
        return this.getZone() == ZoneType.Battlefield && this.getCurrentState().isCreature() && this.hasSickness();
    }

    void updateSickness(Card c) {
        this.set(TrackableProperty.Sickness, c.isFirstTurnControlled());
    }

    public boolean isTapped() {
        return (Boolean)this.get(TrackableProperty.Tapped);
    }

    void updateTapped(Card c) {
        this.set(TrackableProperty.Tapped, c.isTapped());
    }

    public GamePieceType getGamePieceType() {
        return (GamePieceType)((Object)this.get(TrackableProperty.GamePieceType));
    }

    void updateGamePieceType(Card c) {
        this.set(TrackableProperty.GamePieceType, c.getGamePieceType());
    }

    public boolean isToken() {
        return (Boolean)this.get(TrackableProperty.Token);
    }

    void updateToken(Card c) {
        this.set(TrackableProperty.Token, c.isToken());
    }

    public boolean isImmutable() {
        return this.get(TrackableProperty.GamePieceType) == GamePieceType.EFFECT;
    }

    public boolean isEmblem() {
        return (Boolean)this.get(TrackableProperty.IsEmblem);
    }

    public void updateEmblem(Card c) {
        this.set(TrackableProperty.IsEmblem, c.isEmblem());
    }

    public boolean isBoon() {
        return (Boolean)this.get(TrackableProperty.IsBoon);
    }

    public void updateBoon(Card c) {
        this.set(TrackableProperty.IsBoon, c.isBoon());
    }

    public boolean canSpecialize() {
        return (Boolean)this.get(TrackableProperty.CanSpecialize);
    }

    public void updateSpecialize(Card c) {
        this.set(TrackableProperty.CanSpecialize, c.canSpecialize());
    }

    public boolean isTokenCard() {
        return (Boolean)this.get(TrackableProperty.TokenCard);
    }

    void updateTokenCard(Card c) {
        this.set(TrackableProperty.TokenCard, c.isTokenCard());
    }

    public boolean isCommander() {
        return (Boolean)this.get(TrackableProperty.IsCommander);
    }

    void updateCommander(Card c) {
        boolean isCommander = c.isCommander();
        this.set(TrackableProperty.IsCommander, isCommander);
        if (isCommander) {
            if (c.getGame().getRules().hasAppliedVariant(GameType.Oathbreaker)) {
                if (c.getPaperCard().getRules().canBeSignatureSpell()) {
                    this.set(TrackableProperty.CommanderAltType, "Signature Spell");
                } else {
                    this.set(TrackableProperty.CommanderAltType, "Oathbreaker");
                }
            } else {
                this.set(TrackableProperty.CommanderAltType, "Commander");
            }
        }
    }

    public String getCommanderType() {
        return (String)this.get(TrackableProperty.CommanderAltType);
    }

    public Map<CounterType, Integer> getCounters() {
        return (Map)this.get(TrackableProperty.Counters);
    }

    public int getCounters(CounterType counterType) {
        Integer count;
        Map<CounterType, Integer> counters = this.getCounters();
        if (counters != null && (count = counters.get(counterType)) != null) {
            return count;
        }
        return 0;
    }

    public boolean hasSameCounters(CardView otherCard) {
        Map<CounterType, Integer> counters = this.getCounters();
        if (counters == null) {
            return otherCard.getCounters() == null;
        }
        return counters.equals(otherCard.getCounters());
    }

    public boolean hasSamePT(CardView otherCard) {
        if (this.getCurrentState().getPower() != otherCard.getCurrentState().getPower()) {
            return false;
        }
        return this.getCurrentState().getToughness() == otherCard.getCurrentState().getToughness();
    }

    void updateCounters(Card c) {
        this.set(TrackableProperty.Counters, c.getCounters());
        this.updateLethalDamage(c);
        CardStateView state = this.getCurrentState();
        state.updatePower(c);
        state.updateToughness(c);
        state.updateLoyalty(c);
        state.updateDefense(c);
    }

    public int getCrackOverlayInt() {
        if (this.get(TrackableProperty.CrackOverlay) == null) {
            return 0;
        }
        return (Integer)this.get(TrackableProperty.CrackOverlay);
    }

    public int getDamage() {
        return (Integer)this.get(TrackableProperty.Damage);
    }

    void updateDamage(Card c) {
        this.set(TrackableProperty.Damage, c.getDamage());
        this.updateLethalDamage(c);
        int randCrackLevel = 0;
        if (c.getDamage() > 0) {
            switch (c.getDamage()) {
                case 1: 
                case 2: {
                    randCrackLevel = 0;
                    break;
                }
                case 3: 
                case 4: {
                    randCrackLevel = 1;
                    break;
                }
                case 5: 
                case 6: {
                    randCrackLevel = 2;
                    break;
                }
                default: {
                    randCrackLevel = 3;
                }
            }
        }
        this.set(TrackableProperty.CrackOverlay, randCrackLevel);
    }

    public int getAssignedDamage() {
        return (Integer)this.get(TrackableProperty.AssignedDamage);
    }

    void updateAssignedDamage(Card c) {
        this.set(TrackableProperty.AssignedDamage, c.getTotalAssignedDamage());
        this.updateLethalDamage(c);
    }

    public int getLethalDamage() {
        return (Integer)this.get(TrackableProperty.LethalDamage);
    }

    void updateLethalDamage(Card c) {
        this.set(TrackableProperty.LethalDamage, c.getLethalDamage());
    }

    public int getShieldCount() {
        return (Integer)this.get(TrackableProperty.ShieldCount);
    }

    void updateShieldCount(Card c) {
        this.set(TrackableProperty.ShieldCount, c.getShieldCount());
    }

    public String getChosenType() {
        return (String)this.get(TrackableProperty.ChosenType);
    }

    void updateChosenType(Card c) {
        this.set(TrackableProperty.ChosenType, c.getChosenType());
    }

    public String getChosenType2() {
        return (String)this.get(TrackableProperty.ChosenType2);
    }

    void updateChosenType2(Card c) {
        this.set(TrackableProperty.ChosenType2, c.getChosenType2());
    }

    public List<String> getNotedTypes() {
        return (List)this.get(TrackableProperty.NotedTypes);
    }

    void updateNotedTypes(Card c) {
        this.set(TrackableProperty.NotedTypes, c.getNotedTypes());
    }

    public String getChosenNumber() {
        return (String)this.get(TrackableProperty.ChosenNumber);
    }

    void updateChosenNumber(Card c) {
        this.set(TrackableProperty.ChosenNumber, c.getChosenNumber().toString());
    }

    void clearChosenNumber() {
        this.set(TrackableProperty.ChosenNumber, "");
    }

    public List<String> getStoredRolls() {
        return (List)this.get(TrackableProperty.StoredRolls);
    }

    void updateStoredRolls(Card c) {
        this.set(TrackableProperty.StoredRolls, c.getStoredRollsForView());
    }

    public List<String> getChosenColors() {
        return (List)this.get(TrackableProperty.ChosenColors);
    }

    void updateChosenColors(Card c) {
        this.set(TrackableProperty.ChosenColors, c.getChosenColors());
    }

    public FCollectionView<CardView> getMergedCardsCollection() {
        return (FCollectionView)this.get(TrackableProperty.MergedCardsCollection);
    }

    public FCollectionView<CardView> getChosenCards() {
        return (FCollectionView)this.get(TrackableProperty.ChosenCards);
    }

    public PlayerView getChosenPlayer() {
        return (PlayerView)this.get(TrackableProperty.ChosenPlayer);
    }

    void updateChosenPlayer(Card c) {
        this.set(TrackableProperty.ChosenPlayer, PlayerView.get(c.getChosenPlayer()));
    }

    public PlayerView getPromisedGift() {
        return (PlayerView)this.get(TrackableProperty.PromisedGift);
    }

    void updatePromisedGift(Card c) {
        this.set(TrackableProperty.PromisedGift, PlayerView.get(c.getPromisedGift()));
    }

    public PlayerView getProtectingPlayer() {
        return (PlayerView)this.get(TrackableProperty.ProtectingPlayer);
    }

    void updateProtectingPlayer(Card c) {
        this.set(TrackableProperty.ProtectingPlayer, PlayerView.get(c.getProtectingPlayer()));
    }

    public Direction getChosenDirection() {
        return (Direction)((Object)this.get(TrackableProperty.ChosenDirection));
    }

    void updateChosenDirection(Card c) {
        this.set(TrackableProperty.ChosenDirection, c.getChosenDirection());
    }

    public EvenOdd getChosenEvenOdd() {
        return (EvenOdd)((Object)this.get(TrackableProperty.ChosenEvenOdd));
    }

    void updateChosenEvenOdd(Card c) {
        this.set(TrackableProperty.ChosenEvenOdd, c.getChosenEvenOdd());
    }

    public String getChosenMode() {
        return (String)this.get(TrackableProperty.ChosenMode);
    }

    void updateChosenMode(Card c) {
        this.set(TrackableProperty.ChosenMode, c.getChosenMode());
    }

    public String getCurrentRoom() {
        return (String)this.get(TrackableProperty.CurrentRoom);
    }

    void updateCurrentRoom(Card c) {
        this.set(TrackableProperty.CurrentRoom, c.getCurrentRoom());
    }

    public int getIntensity() {
        return (Integer)this.get(TrackableProperty.Intensity);
    }

    void updateIntensity(Card c) {
        this.set(TrackableProperty.Intensity, c.getIntensity(true));
    }

    public boolean wasDestroyed() {
        if (this.get(TrackableProperty.WasDestroyed) == null) {
            return false;
        }
        return (Boolean)this.get(TrackableProperty.WasDestroyed);
    }

    void updateWasDestroyed(boolean value) {
        this.set(TrackableProperty.WasDestroyed, value);
    }

    public int getClassLevel() {
        return (Integer)this.get(TrackableProperty.ClassLevel);
    }

    void updateClassLevel(Card c) {
        this.set(TrackableProperty.ClassLevel, c.getClassLevel());
    }

    public int getRingLevel() {
        return (Integer)this.get(TrackableProperty.RingLevel);
    }

    void updateRingLevel(Card c) {
        Player p = c.getController();
        if (p != null && p.getTheRing() == c) {
            this.set(TrackableProperty.RingLevel, p.getNumRingTemptedYou());
        }
    }

    private String getRemembered() {
        return (String)this.get(TrackableProperty.Remembered);
    }

    void updateRemembered(Card c) {
        if (c.getRemembered() == null || Iterables.isEmpty(c.getRemembered())) {
            this.set(TrackableProperty.Remembered, null);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\r\nRemembered: \r\n");
        for (Object o : c.getRemembered()) {
            if (o == null) continue;
            sb.append(o.toString());
            sb.append("\r\n");
        }
        this.set(TrackableProperty.Remembered, sb.toString());
    }

    public String getSector() {
        return (String)this.get(TrackableProperty.Sector);
    }

    void updateSector(Card c) {
        this.set(TrackableProperty.Sector, c.getSector());
    }

    public List<String> getDraftAction() {
        return (List)this.get(TrackableProperty.DraftAction);
    }

    void updateDraftAction(Card c) {
        this.set(TrackableProperty.DraftAction, c.getDraftActions());
    }

    public List<String> getNamedCard() {
        return (List)this.get(TrackableProperty.NamedCard);
    }

    void updateNamedCard(Card c) {
        this.set(TrackableProperty.NamedCard, c.getNamedCards());
    }

    public boolean getMayPlayPlayers(PlayerView pv) {
        TrackableCollection col = (TrackableCollection)this.get(TrackableProperty.MayPlayPlayers);
        return col != null && col.indexOf(pv) != -1;
    }

    void setMayPlayPlayers(Iterable<Player> list) {
        if (Iterables.isEmpty(list)) {
            this.set(TrackableProperty.MayPlayPlayers, null);
        } else {
            this.set(TrackableProperty.MayPlayPlayers, PlayerView.getCollection(list));
        }
    }

    public boolean mayPlayerLook(PlayerView pv) {
        TrackableCollection col = (TrackableCollection)this.get(TrackableProperty.PlayerMayLook);
        return col != null && col.indexOf(pv) != -1;
    }

    void setPlayerMayLook(Iterable<Player> list) {
        if (Iterables.isEmpty(list)) {
            this.set(TrackableProperty.PlayerMayLook, null);
        } else {
            this.set(TrackableProperty.PlayerMayLook, PlayerView.getCollection(list));
        }
    }

    public boolean canBeShownToAny(Iterable<PlayerView> viewers) {
        if (viewers == null || Iterables.isEmpty(viewers)) {
            return true;
        }
        return Iterables.any(viewers, this::canBeShownTo);
    }

    public boolean canBeShownTo(PlayerView viewer) {
        if (viewer == null) {
            return false;
        }
        ZoneType zone = this.getZone();
        if (zone == null) {
            return true;
        }
        PlayerView controller = this.getController();
        switch (zone) {
            case Ante: 
            case Command: 
            case Battlefield: 
            case Graveyard: 
            case Flashback: 
            case Stack: 
            case Junkyard: {
                return true;
            }
            case Exile: 
            case Merged: {
                if (this.isFaceDown()) break;
                return true;
            }
            case Hand: {
                if (!controller.equals(viewer)) break;
                return true;
            }
            case Sideboard: {
                if (controller.isOpponentOf(viewer) && !this.mayPlayerLook(viewer)) break;
                return true;
            }
            case Library: 
            case PlanarDeck: 
            case AttractionDeck: {
                break;
            }
            case SchemeDeck: {
                return true;
            }
        }
        if (this.mayPlayerLook(viewer)) {
            return true;
        }
        PlayerView mindSlaveMaster = controller.getMindSlaveMaster();
        if (mindSlaveMaster != null && mindSlaveMaster != controller && mindSlaveMaster == viewer) {
            return this.canBeShownTo(controller);
        }
        return false;
    }

    public boolean canFaceDownBeShownToAny(Iterable<PlayerView> viewers) {
        if (viewers == null || Iterables.isEmpty(viewers)) {
            return true;
        }
        return Iterables.any(viewers, this::canFaceDownBeShownTo);
    }

    public boolean canFaceDownBeShownTo(PlayerView viewer) {
        if (!this.isFaceDown()) {
            return true;
        }
        if (this.mayPlayerLook(viewer)) {
            return true;
        }
        PlayerView mindSlaveMaster = this.getController().getMindSlaveMaster();
        if (mindSlaveMaster != null && mindSlaveMaster != this.getController() && mindSlaveMaster == viewer) {
            return this.canFaceDownBeShownTo(this.getController());
        }
        return this.isInZone(EnumSet.of(ZoneType.Battlefield, ZoneType.Stack, ZoneType.Sideboard)) && this.getController().equals(viewer);
    }

    public FCollectionView<CardView> getEncodedCards() {
        return (FCollectionView)this.get(TrackableProperty.EncodedCards);
    }

    public FCollectionView<CardView> getUntilLeavesBattlefield() {
        return (FCollectionView)this.get(TrackableProperty.UntilLeavesBattlefield);
    }

    public GameEntityView getEntityAttachedTo() {
        return (GameEntityView)this.get(TrackableProperty.EntityAttachedTo);
    }

    void updateAttachedTo(Card c) {
        this.set(TrackableProperty.EntityAttachedTo, GameEntityView.get(c.getEntityAttachedTo()));
    }

    public CardView getAttachedTo() {
        GameEntityView enchanting = this.getEntityAttachedTo();
        if (enchanting instanceof CardView) {
            return (CardView)enchanting;
        }
        return null;
    }

    public PlayerView getEnchantedPlayer() {
        GameEntityView enchanting = this.getEntityAttachedTo();
        if (enchanting instanceof PlayerView) {
            return (PlayerView)enchanting;
        }
        return null;
    }

    public FCollectionView<CardView> getGainControlTargets() {
        return (FCollectionView)this.get(TrackableProperty.GainControlTargets);
    }

    public CardView getCloneOrigin() {
        return (CardView)this.get(TrackableProperty.CloneOrigin);
    }

    public CardView getExiledWith() {
        return (CardView)this.get(TrackableProperty.ExiledWith);
    }

    public FCollectionView<CardView> getImprintedCards() {
        return (FCollectionView)this.get(TrackableProperty.ImprintedCards);
    }

    public FCollectionView<CardView> getExiledCards() {
        return (FCollectionView)this.get(TrackableProperty.ExiledCards);
    }

    public FCollectionView<CardView> getHauntedBy() {
        return (FCollectionView)this.get(TrackableProperty.HauntedBy);
    }

    public CardView getHaunting() {
        return (CardView)this.get(TrackableProperty.Haunting);
    }

    public FCollectionView<CardView> getMustBlockCards() {
        return (FCollectionView)this.get(TrackableProperty.MustBlockCards);
    }

    void updateMustBlockCards(Card c) {
        this.setCards(null, c.getMustBlockCards(), TrackableProperty.MustBlockCards);
    }

    public CardView getPairedWith() {
        return (CardView)this.get(TrackableProperty.PairedWith);
    }

    public Map<String, String> getChangedColorWords() {
        return (Map)this.get(TrackableProperty.ChangedColorWords);
    }

    void updateChangedColorWords(Card c) {
        this.set(TrackableProperty.ChangedColorWords, c.getChangedTextColorWords());
    }

    public Map<String, String> getChangedTypes() {
        return (Map)this.get(TrackableProperty.ChangedTypes);
    }

    void updateChangedTypes(Card c) {
        this.set(TrackableProperty.ChangedTypes, c.getChangedTextTypeWords());
    }

    void updateNonAbilityText(Card c) {
        this.set(TrackableProperty.NonAbilityText, c.getNonAbilityText());
    }

    public String getText() {
        return this.getText(this.getCurrentState(), null);
    }

    public String getText(CardStateView state, HashMap<String, String> translationsText) {
        String mergedCards;
        String cloner;
        CardView pairedWith;
        EvenOdd chosenEvenOdd;
        Set attractionLights;
        StringBuilder sb = new StringBuilder();
        String tname = "";
        String toracle = "";
        String taltname = "";
        String taltoracle = "";
        if (translationsText != null) {
            tname = translationsText.get("name");
            taltname = translationsText.get("altname");
            toracle = translationsText.get("oracle");
            taltoracle = translationsText.get("altoracle");
        }
        if (this.isSplitCard()) {
            tname = tname.isEmpty() ? this.getLeftSplitState().getName() : tname;
            String string = taltname = taltname.isEmpty() ? this.getRightSplitState().getName() : taltname;
            if (this.getId() < 0) {
                toracle = toracle.isEmpty() ? this.getLeftSplitState().getOracleText() : toracle;
                taltoracle = taltoracle.isEmpty() ? this.getRightSplitState().getOracleText() : taltoracle;
            }
        } else {
            String string = tname = tname.isEmpty() ? state.getName() : tname;
            if (this.getId() < 0) {
                String string2 = toracle = toracle.isEmpty() ? state.getOracleText() : toracle;
            }
        }
        if (this.getId() < 0) {
            if (this.isSplitCard() && !toracle.isEmpty()) {
                sb.append("(").append(tname).append(") ");
                sb.append(toracle);
                sb.append("\r\n\r\n");
                sb.append("(").append(taltname).append(") ");
                sb.append(taltoracle);
            } else {
                sb.append(toracle);
            }
            return sb.toString();
        }
        String rulesText = state.getRulesText();
        if (!rulesText.isEmpty()) {
            sb.append(rulesText).append("\r\n\r\n");
        }
        if (this.isCommander()) {
            sb.append(this.getOwner()).append("'s ").append(this.getCommanderType()).append("\r\n");
            sb.append(this.getOwner().getCommanderInfo(this)).append("\r\n");
        }
        if (this.isSplitCard() && !this.isFaceDown() && this.getZone() != ZoneType.Stack && this.getZone() != ZoneType.Battlefield) {
            sb.append("(").append(this.getLeftSplitState().getName()).append(") ");
            sb.append(this.getLeftSplitState().getAbilityText());
            sb.append("\r\n\r\n").append("(").append(this.getRightSplitState().getName()).append(") ");
            sb.append(this.getRightSplitState().getAbilityText());
        } else {
            sb.append(state.getAbilityText());
        }
        String nonAbilityText = (String)this.get(TrackableProperty.NonAbilityText);
        if (!nonAbilityText.isEmpty()) {
            sb.append("\r\n \r\nNon ability features: \r\n");
            sb.append(nonAbilityText.replaceAll("CARDNAME", this.getName()));
        }
        if ((attractionLights = (Set)this.get(TrackableProperty.AttractionLights)) != null && !attractionLights.isEmpty()) {
            sb.append("\r\n\r\nLights: ");
            sb.append(StringUtils.join(attractionLights, ", "));
        }
        sb.append(this.getRemembered());
        Direction chosenDirection = this.getChosenDirection();
        if (chosenDirection != null) {
            sb.append("\r\n[Chosen direction: ");
            sb.append((Object)chosenDirection);
            sb.append("]\r\n");
        }
        if ((chosenEvenOdd = this.getChosenEvenOdd()) != null) {
            sb.append("\r\n[Chosen value: ");
            sb.append((Object)chosenEvenOdd);
            sb.append("]\r\n");
        }
        if ((pairedWith = this.getPairedWith()) != null) {
            sb.append("\r\n \r\nPaired With: ").append(pairedWith);
            sb.append("\r\n");
        }
        if (this.getCanBlockAny()) {
            sb.append("\r\n\r\n");
            sb.append("CARDNAME can block any number of creatures.".replaceAll("CARDNAME", this.getName()));
            sb.append("\r\n");
        } else {
            int i = this.getBlockAdditional();
            if (i > 0) {
                sb.append("\r\n\r\n");
                sb.append("CARDNAME can block an additional ".replaceAll("CARDNAME", this.getName()));
                sb.append(i == 1 ? "creature" : Lang.nounWithNumeral(i, "creature"));
                sb.append(" each combat.");
                sb.append("\r\n");
            }
        }
        Set<String> cantHaveKeyword = this.getCantHaveKeyword();
        if (cantHaveKeyword != null && !cantHaveKeyword.isEmpty()) {
            sb.append("\r\n\r\n");
            for (String k : cantHaveKeyword) {
                sb.append("CARDNAME can't have or gain ".replaceAll("CARDNAME", this.getName()));
                sb.append(k);
                sb.append(".");
                sb.append("\r\n");
            }
        }
        if (!(cloner = (String)this.get(TrackableProperty.Cloner)).isEmpty()) {
            sb.append("\r\nCloned by: ").append(cloner);
        }
        if (!(mergedCards = (String)this.get(TrackableProperty.MergedCards)).isEmpty()) {
            sb.append("\r\n\r\nMerged Cards: ").append(mergedCards);
        }
        return sb.toString().trim();
    }

    public CardStateView getCurrentState() {
        return (CardStateView)this.get(TrackableProperty.CurrentState);
    }

    public boolean hasAlternateState() {
        return this.getAlternateState() != null;
    }

    public CardStateView getAlternateState() {
        return (CardStateView)this.get(TrackableProperty.AlternateState);
    }

    public boolean hasLeftSplitState() {
        return this.getLeftSplitState() != null;
    }

    public CardStateView getLeftSplitState() {
        return (CardStateView)this.get(TrackableProperty.LeftSplitState);
    }

    public boolean hasRightSplitState() {
        return this.getRightSplitState() != null;
    }

    public CardStateView getRightSplitState() {
        return (CardStateView)this.get(TrackableProperty.RightSplitState);
    }

    public boolean hasBackSide() {
        return (Boolean)this.get(TrackableProperty.HasBackSide);
    }

    public String getBackSideName() {
        return (String)this.get(TrackableProperty.BackSideName);
    }

    CardStateView createAlternateState(CardStateName state0) {
        return new CardStateView(this.getId(), state0, this.tracker);
    }

    public CardStateView getState(boolean alternate0) {
        return alternate0 ? this.getAlternateState() : this.getCurrentState();
    }

    void updateBackSide(String stateName, boolean hasBackSide) {
        this.set(TrackableProperty.HasBackSide, hasBackSide);
        this.set(TrackableProperty.BackSideName, stateName);
    }

    public boolean needsUntapAnimation() {
        if (this.get(TrackableProperty.NeedsUntapAnimation) == null) {
            return false;
        }
        return (Boolean)this.get(TrackableProperty.NeedsUntapAnimation);
    }

    public void updateNeedsUntapAnimation(boolean value) {
        this.set(TrackableProperty.NeedsUntapAnimation, value);
    }

    public boolean needsTapAnimation() {
        if (this.get(TrackableProperty.NeedsTapAnimation) == null) {
            return false;
        }
        return (Boolean)this.get(TrackableProperty.NeedsTapAnimation);
    }

    public void updateNeedsTapAnimation(boolean value) {
        this.set(TrackableProperty.NeedsTapAnimation, value);
    }

    public boolean needsTransformAnimation() {
        if (this.get(TrackableProperty.NeedsTransformAnimation) == null) {
            return false;
        }
        return (Boolean)this.get(TrackableProperty.NeedsTransformAnimation);
    }

    public void updateNeedsTransformAnimation(boolean value) {
        this.set(TrackableProperty.NeedsTransformAnimation, value);
    }

    void updateState(Card c) {
        CardState alternateState;
        Card cloner;
        this.updateName(c);
        this.updateZoneText(c);
        this.updateDamage(c);
        this.updateSpecialize(c);
        this.updateRingLevel(c);
        if (c.getIntensity(false) > 0) {
            this.updateIntensity(c);
        }
        if (this.getBackup() == null && !c.isFaceDown() && (c.isDoubleFaced() || c.isFlipCard() || c.isAdventureCard() || c.isCloned())) {
            this.set(TrackableProperty.PaperCardBackup, c.getPaperCard());
        }
        boolean isSplitCard = c.isSplitCard();
        this.set(TrackableProperty.Cloned, c.isCloned());
        this.set(TrackableProperty.SplitCard, isSplitCard);
        this.set(TrackableProperty.FlipCard, c.isFlipCard());
        this.set(TrackableProperty.Facedown, c.isFaceDown());
        this.set(TrackableProperty.Foretold, c.isForetold());
        this.set(TrackableProperty.Manifested, c.isManifested());
        this.set(TrackableProperty.Cloaked, c.isCloaked());
        this.set(TrackableProperty.Adventure, c.isAdventureCard());
        this.set(TrackableProperty.DoubleFaced, c.isDoubleFaced());
        this.set(TrackableProperty.Modal, c.isModal());
        if (c.getAlternateState() != null) {
            this.updateBackSide(c.getAlternateState().getName(), c.isDoubleFaced());
        }
        this.set(TrackableProperty.Cloner, (cloner = c.getCloner()) == null ? null : cloner.getName() + " (" + cloner.getId() + ")");
        CardCollection mergedCollection = new CardCollection();
        if (c.hasMergedCard()) {
            Card card;
            int i;
            StringBuilder sb = new StringBuilder();
            CardCollectionView mergedCards = c.getMergedCards();
            for (i = 1; i < mergedCards.size(); ++i) {
                card = (Card)mergedCards.get(i);
                if (i > 1) {
                    sb.append(", ");
                }
                sb.append(card.getOriginalState(card.getCurrentStateName()).getName());
                sb.append(" (").append(card.getId()).append(")");
            }
            this.set(TrackableProperty.MergedCards, sb.toString());
            for (i = 0; i < mergedCards.size(); ++i) {
                card = (Card)mergedCards.get(i);
                if (i == 0) {
                    if (!card.isFaceDown()) {
                        mergedCollection.add(Card.getCardForUi(c.getPaperCard()));
                        continue;
                    }
                    mergedCollection.add(card);
                    continue;
                }
                mergedCollection.add(card);
            }
        }
        this.updateMergeCollections(mergedCollection);
        CardState currentState = c.getCurrentState();
        if (isSplitCard) {
            this.set(TrackableProperty.LeftSplitState, c.getState(CardStateName.LeftSplit).getView());
            this.set(TrackableProperty.RightSplitState, c.getState(CardStateName.RightSplit).getView());
        }
        CardStateView currentStateView = currentState.getView();
        if (this.getCurrentState() != currentStateView || c.hasPerpetual()) {
            this.set(TrackableProperty.CurrentState, currentStateView);
            currentStateView.updateName(currentState);
            currentStateView.updatePower(c);
            currentStateView.updateToughness(c);
            currentStateView.updateLoyalty(c);
            currentStateView.updateDefense(c);
            if (c.getGame() != null) {
                if (c.hasPerpetual()) {
                    currentStateView.updateColors(c);
                } else {
                    currentStateView.updateColors(currentState);
                }
                currentStateView.updateHasChangeColors(!Iterables.isEmpty(c.getChangedCardColors()));
            }
        } else {
            currentStateView.updateLoyalty(currentState);
            currentStateView.updateDefense(currentState);
        }
        currentState.getView().updateKeywords(c, currentState);
        currentState.getView().setOriginalColors(c);
        currentStateView.updateAttractionLights(currentState);
        CardState cardState = alternateState = isSplitCard && this.isFaceDown() ? c.getState(CardStateName.RightSplit) : c.getAlternateState();
        if (isSplitCard && this.isFaceDown()) {
            alternateState = c.getState(CardStateName.Original);
        }
        if (c.isDoubleFaced() && this.isFaceDown()) {
            alternateState = c.getState(CardStateName.Original);
        }
        if (alternateState == null) {
            this.set(TrackableProperty.AlternateState, null);
        } else {
            CardStateView alternateStateView = alternateState.getView();
            if (this.getAlternateState() != alternateStateView) {
                this.set(TrackableProperty.AlternateState, alternateStateView);
                alternateStateView.updateName(alternateState);
                alternateStateView.updatePower(c);
                alternateStateView.updateToughness(c);
                alternateStateView.updateLoyalty(c);
                alternateStateView.updateDefense(c);
                if (c.getGame() != null) {
                    alternateStateView.updateColors(alternateState);
                }
            } else {
                alternateStateView.updateLoyalty(alternateState);
                alternateStateView.updateDefense(alternateState);
            }
            alternateState.getView().updateKeywords(c, alternateState);
        }
    }

    public int getHiddenId() {
        Integer hiddenId = (Integer)this.get(TrackableProperty.HiddenId);
        if (hiddenId == null) {
            return this.getId();
        }
        return hiddenId;
    }

    void updateHiddenId(int hiddenId) {
        this.set(TrackableProperty.HiddenId, hiddenId);
    }

    int getBlockAdditional() {
        return (Integer)this.get(TrackableProperty.BlockAdditional);
    }

    boolean getCanBlockAny() {
        return (Boolean)this.get(TrackableProperty.BlockAny);
    }

    void updateBlockAdditional(Card c) {
        this.set(TrackableProperty.BlockAdditional, c.canBlockAdditional());
        this.set(TrackableProperty.BlockAny, c.canBlockAny());
    }

    public boolean isRingBearer() {
        return (Boolean)this.get(TrackableProperty.IsRingBearer);
    }

    void updateRingBearer(Card c) {
        this.set(TrackableProperty.IsRingBearer, c.isRingBearer());
    }

    Set<String> getCantHaveKeyword() {
        return (Set)this.get(TrackableProperty.CantHaveKeyword);
    }

    void updateCantHaveKeyword(Card c) {
        TreeSet<String> keywords = Sets.newTreeSet();
        for (Keyword k : c.getCantHaveKeyword()) {
            keywords.add(k.toString());
        }
        this.set(TrackableProperty.CantHaveKeyword, keywords);
    }

    private String getZoneText() {
        return this.zoneText;
    }

    void updateZoneText(Card c) {
        if (c.getZone() != null && c.getZone().is(ZoneType.Sideboard) && c.getGame().getMaingame() != null) {
            Card parentCard = c.getOwner().getMappingMaingameCard(c);
            StringBuilder sb = new StringBuilder();
            int parentLevel = 0;
            while (parentCard != null) {
                ++parentLevel;
                if (!parentCard.getZone().is(ZoneType.Sideboard)) {
                    sb.append('[');
                    if (parentCard.getGame().getMaingame() == null) {
                        sb.append(Localizer.getInstance().getMessage("lblMainGame", new Object[0]));
                    } else {
                        sb.append(Localizer.getInstance().getMessage("lblSubgame", parentLevel));
                    }
                    sb.append(": ");
                    sb.append(TextUtil.capitalize(parentCard.getZone().getZoneType().getTranslatedName()));
                    sb.append(']');
                    break;
                }
                parentCard = parentCard.getOwner().getMappingMaingameCard(parentCard);
            }
            this.zoneText = sb.toString();
        }
    }

    public String toString() {
        CardStateView alternate;
        String name = this.getName();
        String zone = this.getZoneText();
        if (this.getId() <= 0) {
            return name;
        }
        if (name.isEmpty() && (alternate = this.getAlternateState()) != null) {
            if (this.isFaceDown()) {
                return "Face-down card (H" + this.getHiddenId() + ")";
            }
            return this.getAlternateState().getName() + " (" + this.getId() + ")";
        }
        return (zone + ' ' + CardTranslation.getTranslatedName(name) + " (" + this.getId() + ")").trim();
    }

    Card setCard(Card oldCard, Card newCard, TrackableProperty key) {
        if (newCard != oldCard) {
            this.set(key, CardView.get(newCard));
        }
        return newCard;
    }

    CardCollection setCards(CardCollection oldCards, CardCollection newCards, TrackableProperty key) {
        if (newCards == null || newCards.isEmpty()) {
            this.set(key, null);
            return null;
        }
        this.set(key, CardView.getCollection(newCards));
        return newCards;
    }

    CardCollection setCards(CardCollection oldCards, Iterable<Card> newCards, TrackableProperty key) {
        if (newCards == null) {
            this.set(key, null);
            return null;
        }
        return this.setCards(oldCards, new CardCollection(newCards), key);
    }

    CardCollection addCard(CardCollection oldCards, Card cardToAdd, TrackableProperty key) {
        if (cardToAdd == null) {
            return oldCards;
        }
        if (oldCards == null) {
            oldCards = new CardCollection();
        }
        if (oldCards.add(cardToAdd)) {
            TrackableCollection<CardView> views = (TrackableCollection<CardView>)this.get(key);
            if (views == null) {
                views = new TrackableCollection<CardView>();
                views.add(cardToAdd.getView());
                this.set(key, views);
            } else if (views.add(cardToAdd.getView())) {
                this.flagAsChanged(key);
            }
        }
        return oldCards;
    }

    CardCollection addCards(CardCollection oldCards, Iterable<Card> cardsToAdd, TrackableProperty key) {
        if (cardsToAdd == null) {
            return oldCards;
        }
        TrackableCollection<CardView> views = (TrackableCollection<CardView>)this.get(key);
        if (oldCards == null) {
            oldCards = new CardCollection();
        }
        boolean needFlagAsChanged = false;
        for (Card c : cardsToAdd) {
            if (c == null || !oldCards.add(c)) continue;
            if (views == null) {
                views = new TrackableCollection<CardView>();
                views.add(c.getView());
                this.set(key, views);
                continue;
            }
            if (!views.add(c.getView())) continue;
            needFlagAsChanged = true;
        }
        if (needFlagAsChanged) {
            this.flagAsChanged(key);
        }
        return oldCards;
    }

    CardCollection removeCard(CardCollection oldCards, Card cardToRemove, TrackableProperty key) {
        if (cardToRemove == null || oldCards == null) {
            return oldCards;
        }
        if (oldCards.remove(cardToRemove)) {
            TrackableCollection views = (TrackableCollection)this.get(key);
            if (views == null) {
                this.set(key, null);
            } else if (views.remove(cardToRemove.getView())) {
                if (views.isEmpty()) {
                    this.set(key, null);
                } else {
                    this.flagAsChanged(key);
                }
            }
            if (oldCards.isEmpty()) {
                oldCards = null;
            }
        }
        return oldCards;
    }

    CardCollection removeCards(CardCollection oldCards, Iterable<Card> cardsToRemove, TrackableProperty key) {
        if (cardsToRemove == null || oldCards == null) {
            return oldCards;
        }
        TrackableCollection views = (TrackableCollection)this.get(key);
        boolean needFlagAsChanged = false;
        for (Card c : cardsToRemove) {
            if (!oldCards.remove(c)) continue;
            if (views == null) {
                this.set(key, null);
            } else if (views.remove(c.getView())) {
                if (views.isEmpty()) {
                    views = null;
                    this.set(key, null);
                    needFlagAsChanged = false;
                } else {
                    needFlagAsChanged = true;
                }
            }
            if (!oldCards.isEmpty()) continue;
            oldCards = null;
            break;
        }
        if (needFlagAsChanged) {
            this.flagAsChanged(key);
        }
        return oldCards;
    }

    CardCollection clearCards(CardCollection oldCards, TrackableProperty key) {
        if (oldCards != null) {
            this.set(key, null);
        }
        return null;
    }

    void updateMergeCollections(CardCollection cards) {
        TrackableCollection<CardView> views = (TrackableCollection<CardView>)this.get(TrackableProperty.MergedCardsCollection);
        boolean needFlagAsChanged = false;
        if (views == null) {
            views = new TrackableCollection<CardView>();
            this.set(TrackableProperty.MergedCardsCollection, views);
        } else {
            if (!views.isEmpty()) {
                needFlagAsChanged = true;
            }
            views.clear();
        }
        if (cards != null) {
            for (Card c : cards) {
                if (!views.add(c.getView())) continue;
                needFlagAsChanged = true;
            }
        }
        if (needFlagAsChanged) {
            this.flagAsChanged(TrackableProperty.MergedCardsCollection);
        }
    }

    public class CardStateView
    extends TrackableObject
    implements ITranslatable {
        private static final long serialVersionUID = 6673944200513430607L;
        private final CardStateName state;
        private int foilIndexOverride;

        public CardStateView(int id0, CardStateName state0, Tracker tracker) {
            super(id0, tracker);
            this.foilIndexOverride = -1;
            this.state = state0;
        }

        public String getDisplayId() {
            if (this.getState().equals((Object)CardStateName.FaceDown)) {
                return "H" + CardView.this.getHiddenId();
            }
            int id = this.getId();
            if (id > 0) {
                return String.valueOf(this.getId());
            }
            return "";
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.getId(), this.state});
        }

        public String toString() {
            return (this.getName() + " (" + this.getDisplayId() + ")").trim();
        }

        public CardView getCard() {
            return CardView.this;
        }

        public CardStateName getState() {
            return this.state;
        }

        @Override
        public String getName() {
            return (String)this.get(TrackableProperty.Name);
        }

        void updateName(CardState c) {
            Card card = c.getCard();
            this.setName(card.getName(c, false));
            if (CardView.this.getCurrentState() == this && card != null) {
                CardView.this.updateName(card);
            }
        }

        private void setName(String name0) {
            this.set(TrackableProperty.Name, name0);
        }

        public ColorSet getColors() {
            return (ColorSet)this.get(TrackableProperty.Colors);
        }

        public ColorSet getOriginalColors() {
            return (ColorSet)this.get(TrackableProperty.OriginalColors);
        }

        public ColorSet getLeftSplitColors() {
            return (ColorSet)this.get(TrackableProperty.LeftSplitColors);
        }

        public ColorSet getRightSplitColors() {
            return (ColorSet)this.get(TrackableProperty.RightSplitColors);
        }

        void updateColors(Card c) {
            this.set(TrackableProperty.Colors, c.getColor());
        }

        void updateColors(CardState c) {
            this.set(TrackableProperty.Colors, ColorSet.fromMask(c.getColor()));
        }

        void setOriginalColors(Card c) {
            this.set(TrackableProperty.OriginalColors, c.getColor());
            if (c.isSplitCard()) {
                this.set(TrackableProperty.LeftSplitColors, c.getColor(c.getState(CardStateName.LeftSplit)));
                this.set(TrackableProperty.RightSplitColors, c.getColor(c.getState(CardStateName.RightSplit)));
            }
        }

        void updateHasChangeColors(boolean hasChangeColor) {
            this.set(TrackableProperty.HasChangedColors, hasChangeColor);
        }

        public boolean hasChangeColors() {
            return (Boolean)this.get(TrackableProperty.HasChangedColors);
        }

        public String getImageKey() {
            return this.getImageKey(null);
        }

        public String getImageKey(Iterable<PlayerView> viewers) {
            if (this.getState() == CardStateName.FaceDown) {
                if (this.getCard().getZone() == ZoneType.Exile) {
                    return ImageKeys.getTokenKey(this.getCard().isForeTold() ? "foretell" : "hidden");
                }
                if (this.getCard().isManifested()) {
                    return ImageKeys.getTokenKey("manifest");
                }
                if (this.getCard().isCloaked()) {
                    return ImageKeys.getTokenKey("cloaked");
                }
                return ImageKeys.getTokenKey(this.getType().getCreatureTypes().isEmpty() ? (this.isCreature() ? "morph" : "hidden") : this.getType().getCreatureTypes().toString().toLowerCase().replace(" ", "_").replace("[", "").replace("]", ""));
            }
            if (CardView.this.canBeShownToAny(viewers)) {
                if (CardView.this.isCloned() && StaticData.instance().useSourceImageForClone()) {
                    return CardView.this.getBackup().getCurrentState().getImageKey(viewers);
                }
                return (String)this.get(TrackableProperty.ImageKey);
            }
            return ImageKeys.getTokenKey("hidden");
        }

        public String getTrackableImageKey() {
            return (String)this.get(TrackableProperty.ImageKey);
        }

        void updateImageKey(Card c) {
            this.set(TrackableProperty.ImageKey, c.getImageKey());
        }

        void updateImageKey(CardState c) {
            this.set(TrackableProperty.ImageKey, c.getImageKey());
        }

        public CardTypeView getType() {
            if (this.getState() != CardStateName.Original && CardView.this.isFaceDown() && !CardView.this.isInZone(EnumSet.of(ZoneType.Battlefield, ZoneType.Stack))) {
                return CardType.EMPTY;
            }
            return (CardTypeView)this.get(TrackableProperty.Type);
        }

        void updateType(CardState c) {
            Card card;
            CardTypeView type = c.getType();
            if (CardView.this.getCurrentState() == this && (card = c.getCard()) != null) {
                type = type.getTypeWithChanges(card.getChangedCardTypes());
                this.updateRulesText(card.getRules(), type);
            }
            this.set(TrackableProperty.Type, type);
        }

        public ManaCost getManaCost() {
            return (ManaCost)this.get(TrackableProperty.ManaCost);
        }

        void updateManaCost(CardState c) {
            this.set(TrackableProperty.ManaCost, c.getManaCost());
        }

        void updateManaCost(Card c) {
            this.set(TrackableProperty.ManaCost, c.getManaCost());
        }

        public String getOracleText() {
            return (String)this.get(TrackableProperty.OracleText);
        }

        void setOracleText(String oracleText) {
            this.set(TrackableProperty.OracleText, oracleText.replace("\\n", "\r\n\r\n").trim());
        }

        public String getFunctionalVariantName() {
            return (String)this.get(TrackableProperty.FunctionalVariant);
        }

        void setFunctionalVariantName(String functionalVariant) {
            this.set(TrackableProperty.FunctionalVariant, functionalVariant);
        }

        public String getRulesText() {
            return (String)this.get(TrackableProperty.RulesText);
        }

        void updateRulesText(CardRules rules, CardTypeView type) {
            String rulesText = null;
            if (type.isVanguard() && rules != null) {
                boolean decHand = rules.getHand() < 0;
                boolean decLife = rules.getLife() < 0;
                String handSize = Localizer.getInstance().getMessageorUseDefault("lblHandSize", "Hand Size", new Object[0]) + (!decHand ? ": +" : ": ") + rules.getHand();
                String startingLife = Localizer.getInstance().getMessageorUseDefault("lblStartingLife", "Starting Life", new Object[0]) + (!decLife ? ": +" : ": ") + rules.getLife();
                rulesText = handSize + "\r\n" + startingLife;
            }
            this.set(TrackableProperty.RulesText, rulesText);
        }

        public int getPower() {
            return (Integer)this.get(TrackableProperty.Power);
        }

        void updatePower(Card c) {
            int num = this.getType().hasSubtype("Vehicle") && !this.isCreature() ? c.getCurrentPower() : c.getNetPower();
            if (c.getCurrentState().getView() != this && c.getAlternateState() != null) {
                num = num - c.getBasePower() + c.getAlternateState().getBasePower();
            }
            this.set(TrackableProperty.Power, num);
        }

        void updatePower(CardState c) {
            Card card = c.getCard();
            if (card != null) {
                this.updatePower(card);
                return;
            }
            this.set(TrackableProperty.Power, c.getBasePower());
        }

        public int getToughness() {
            return (Integer)this.get(TrackableProperty.Toughness);
        }

        void updateToughness(Card c) {
            int num = this.getType().hasSubtype("Vehicle") && !this.isCreature() ? c.getCurrentToughness() : c.getNetToughness();
            if (c.getCurrentState().getView() != this && c.getAlternateState() != null) {
                num = num - c.getBaseToughness() + c.getAlternateState().getBaseToughness();
            }
            this.set(TrackableProperty.Toughness, num);
        }

        void updateToughness(CardState c) {
            Card card = c.getCard();
            if (card != null) {
                this.updateToughness(card);
                return;
            }
            this.set(TrackableProperty.Toughness, c.getBaseToughness());
        }

        public String getLoyalty() {
            return (String)this.get(TrackableProperty.Loyalty);
        }

        void updateLoyalty(Card c) {
            if (c.isInZone(ZoneType.Battlefield)) {
                this.updateLoyalty(String.valueOf(c.getCurrentLoyalty()));
            } else {
                this.updateLoyalty(c.getCurrentState().getBaseLoyalty());
            }
        }

        void updateLoyalty(String loyalty) {
            this.set(TrackableProperty.Loyalty, loyalty);
        }

        void updateLoyalty(CardState c) {
            Card card;
            if (CardView.this.getCurrentState() == this && (card = c.getCard()) != null) {
                if (card.isInZone(ZoneType.Battlefield)) {
                    this.updateLoyalty(card);
                } else {
                    this.updateLoyalty(c.getBaseLoyalty());
                }
                return;
            }
            this.set(TrackableProperty.Loyalty, "0");
        }

        public String getDefense() {
            return (String)this.get(TrackableProperty.Defense);
        }

        void updateDefense(Card c) {
            if (c.isInZone(ZoneType.Battlefield)) {
                this.updateDefense(String.valueOf(c.getCurrentDefense()));
            } else {
                this.updateDefense(c.getCurrentState().getBaseDefense());
            }
        }

        void updateDefense(String defense) {
            this.set(TrackableProperty.Defense, defense);
        }

        void updateDefense(CardState c) {
            Card card;
            if (CardView.this.getCurrentState() == this && (card = c.getCard()) != null) {
                if (card.isInZone(ZoneType.Battlefield)) {
                    this.updateDefense(card);
                } else {
                    this.updateDefense(c.getBaseDefense());
                }
                return;
            }
            this.updateDefense("0");
        }

        public Set<Integer> getAttractionLights() {
            return (Set)this.get(TrackableProperty.AttractionLights);
        }

        void updateAttractionLights(CardState c) {
            this.set(TrackableProperty.AttractionLights, c.getAttractionLights());
        }

        public String getSetCode() {
            return (String)this.get(TrackableProperty.SetCode);
        }

        void updateSetCode(CardState c) {
            this.set(TrackableProperty.SetCode, c.getSetCode());
        }

        public CardRarity getRarity() {
            return (CardRarity)((Object)this.get(TrackableProperty.Rarity));
        }

        void updateRarity(CardState c) {
            this.set(TrackableProperty.Rarity, c.getRarity());
        }

        public int getFoilIndex() {
            if (this.foilIndexOverride >= 0) {
                return this.foilIndexOverride;
            }
            return (Integer)this.get(TrackableProperty.FoilIndex);
        }

        void updateFoilIndex(Card c) {
            this.updateFoilIndex(c.getCurrentState());
        }

        void updateFoilIndex(CardState c) {
            this.set(TrackableProperty.FoilIndex, c.getFoil());
        }

        public void setFoilIndexOverride(int index0) {
            if (index0 < 0) {
                index0 = CardEdition.getRandomFoil(this.getSetCode());
            }
            this.foilIndexOverride = index0;
        }

        public String getKeywordKey() {
            return (String)this.get(TrackableProperty.KeywordKey);
        }

        public String getProtectionKey() {
            return (String)this.get(TrackableProperty.ProtectionKey);
        }

        public String getHexproofKey() {
            return (String)this.get(TrackableProperty.HexproofKey);
        }

        public boolean hasAnnihilator() {
            return (Boolean)this.get(TrackableProperty.HasAnnihilator);
        }

        public boolean hasDeathtouch() {
            return (Boolean)this.get(TrackableProperty.HasDeathtouch);
        }

        public boolean hasToxic() {
            return (Boolean)this.get(TrackableProperty.HasToxic);
        }

        public boolean hasDevoid() {
            return (Boolean)this.get(TrackableProperty.HasDevoid);
        }

        public boolean hasDefender() {
            return (Boolean)this.get(TrackableProperty.HasDefender);
        }

        public boolean hasDivideDamage() {
            return (Boolean)this.get(TrackableProperty.HasDivideDamage);
        }

        public boolean hasDoubleStrike() {
            return (Boolean)this.get(TrackableProperty.HasDoubleStrike);
        }

        public boolean hasDoubleTeam() {
            return (Boolean)this.get(TrackableProperty.HasDoubleTeam);
        }

        public boolean hasExalted() {
            return (Boolean)this.get(TrackableProperty.HasExalted);
        }

        public boolean hasFirstStrike() {
            return (Boolean)this.get(TrackableProperty.HasFirstStrike);
        }

        public boolean hasFlying() {
            return (Boolean)this.get(TrackableProperty.HasFlying);
        }

        public boolean hasFear() {
            return (Boolean)this.get(TrackableProperty.HasFear);
        }

        public boolean hasHexproof() {
            return (Boolean)this.get(TrackableProperty.HasHexproof);
        }

        public boolean hasHorsemanship() {
            return (Boolean)this.get(TrackableProperty.HasHorsemanship);
        }

        public boolean hasWard() {
            return (Boolean)this.get(TrackableProperty.HasWard);
        }

        public boolean hasWither() {
            return (Boolean)this.get(TrackableProperty.HasWither);
        }

        public boolean hasIndestructible() {
            return (Boolean)this.get(TrackableProperty.HasIndestructible);
        }

        public boolean hasIntimidate() {
            return (Boolean)this.get(TrackableProperty.HasIntimidate);
        }

        public boolean hasLifelink() {
            return (Boolean)this.get(TrackableProperty.HasLifelink);
        }

        public boolean hasMenace() {
            return (Boolean)this.get(TrackableProperty.HasMenace);
        }

        public boolean hasReach() {
            return (Boolean)this.get(TrackableProperty.HasReach);
        }

        public boolean hasShadow() {
            return (Boolean)this.get(TrackableProperty.HasShadow);
        }

        public boolean hasShroud() {
            return (Boolean)this.get(TrackableProperty.HasShroud);
        }

        public boolean hasTrample() {
            return (Boolean)this.get(TrackableProperty.HasTrample);
        }

        public boolean hasVigilance() {
            return (Boolean)this.get(TrackableProperty.HasVigilance);
        }

        public boolean hasHaste() {
            return (Boolean)this.get(TrackableProperty.HasHaste);
        }

        public boolean hasInfect() {
            return (Boolean)this.get(TrackableProperty.HasInfect);
        }

        public boolean hasStorm() {
            return (Boolean)this.get(TrackableProperty.HasStorm);
        }

        public boolean hasLandwalk() {
            return (Boolean)this.get(TrackableProperty.HasLandwalk);
        }

        public boolean hasAftermath() {
            return (Boolean)this.get(TrackableProperty.HasAftermath);
        }

        public boolean origProduceAnyMana() {
            return (Boolean)this.get(TrackableProperty.OrigProduceAnyMana);
        }

        public boolean origProduceManaR() {
            return (Boolean)this.get(TrackableProperty.OrigProduceManaR);
        }

        public boolean origProduceManaG() {
            return (Boolean)this.get(TrackableProperty.OrigProduceManaG);
        }

        public boolean origProduceManaB() {
            return (Boolean)this.get(TrackableProperty.OrigProduceManaB);
        }

        public boolean origProduceManaU() {
            return (Boolean)this.get(TrackableProperty.OrigProduceManaU);
        }

        public boolean origProduceManaW() {
            return (Boolean)this.get(TrackableProperty.OrigProduceManaW);
        }

        public boolean origProduceManaC() {
            return (Boolean)this.get(TrackableProperty.OrigProduceManaC);
        }

        public int origCanProduceColoredMana() {
            return (Integer)this.get(TrackableProperty.CountOrigProduceColoredMana);
        }

        public int countBasicLandTypes() {
            return (Integer)this.get(TrackableProperty.CountBasicLandTypes);
        }

        public String getAbilityText() {
            return (String)this.get(TrackableProperty.AbilityText);
        }

        void updateAbilityText(Card c, CardState state) {
            this.set(TrackableProperty.AbilityText, c.getAbilityText(state));
        }

        void updateKeywords(Card c, CardState state) {
            c.updateKeywordsCache(state);
            this.set(TrackableProperty.HasAnnihilator, c.hasKeyword(Keyword.ANNIHILATOR, state));
            this.set(TrackableProperty.HasDeathtouch, c.hasKeyword(Keyword.DEATHTOUCH, state));
            this.set(TrackableProperty.HasToxic, c.hasKeyword(Keyword.TOXIC, state));
            this.set(TrackableProperty.HasDevoid, c.hasKeyword(Keyword.DEVOID, state));
            this.set(TrackableProperty.HasDefender, c.hasKeyword(Keyword.DEFENDER, state));
            this.set(TrackableProperty.HasDivideDamage, c.hasKeyword("You may assign CARDNAME's combat damage divided as you choose among defending player and/or any number of creatures they control."));
            this.set(TrackableProperty.HasDoubleStrike, c.hasKeyword(Keyword.DOUBLE_STRIKE, state));
            this.set(TrackableProperty.HasExalted, c.hasKeyword(Keyword.EXALTED, state));
            this.set(TrackableProperty.HasFirstStrike, c.hasKeyword(Keyword.FIRST_STRIKE, state));
            this.set(TrackableProperty.HasFlying, c.hasKeyword(Keyword.FLYING, state));
            this.set(TrackableProperty.HasFear, c.hasKeyword(Keyword.FEAR, state));
            this.set(TrackableProperty.HasHexproof, c.hasKeyword(Keyword.HEXPROOF, state));
            this.set(TrackableProperty.HasHorsemanship, c.hasKeyword(Keyword.HORSEMANSHIP, state));
            this.set(TrackableProperty.HasWard, c.hasKeyword(Keyword.WARD, state));
            this.set(TrackableProperty.HasWither, c.hasKeyword(Keyword.WITHER, state));
            this.set(TrackableProperty.HasIndestructible, c.hasKeyword(Keyword.INDESTRUCTIBLE, state));
            this.set(TrackableProperty.HasIntimidate, c.hasKeyword(Keyword.INTIMIDATE, state));
            this.set(TrackableProperty.HasLifelink, c.hasKeyword(Keyword.LIFELINK, state));
            this.set(TrackableProperty.HasMenace, c.hasKeyword(Keyword.MENACE, state));
            this.set(TrackableProperty.HasReach, c.hasKeyword(Keyword.REACH, state));
            this.set(TrackableProperty.HasShadow, c.hasKeyword(Keyword.SHADOW, state));
            this.set(TrackableProperty.HasShroud, c.hasKeyword(Keyword.SHROUD, state));
            this.set(TrackableProperty.HasTrample, c.hasKeyword(Keyword.TRAMPLE, state));
            this.set(TrackableProperty.HasVigilance, c.hasKeyword(Keyword.VIGILANCE, state));
            this.set(TrackableProperty.HasHaste, c.hasKeyword(Keyword.HASTE, state));
            this.set(TrackableProperty.HasInfect, c.hasKeyword(Keyword.INFECT, state));
            this.set(TrackableProperty.HasStorm, c.hasKeyword(Keyword.STORM, state));
            this.set(TrackableProperty.HasLandwalk, c.hasKeyword(Keyword.LANDWALK, state));
            this.set(TrackableProperty.HasAftermath, c.hasKeyword(Keyword.AFTERMATH, state));
            this.updateAbilityText(c, state);
            this.set(TrackableProperty.ProtectionKey, c.getProtectionKey());
            this.set(TrackableProperty.HexproofKey, c.getHexproofKey());
            this.set(TrackableProperty.KeywordKey, c.getKeywordKey());
            this.updateManaColorBG(state);
        }

        void updateManaColorBG(CardState state) {
            boolean anyMana = false;
            boolean rMana = false;
            boolean gMana = false;
            boolean bMana = false;
            boolean uMana = false;
            boolean wMana = false;
            boolean cMana = false;
            int count = 0;
            int basicLandTypes = 0;
            for (SpellAbility sa : state.getManaAbilities()) {
                if (sa == null) continue;
                for (AbilityManaPart mp : sa.getAllManaParts()) {
                    String[] colorsProduced;
                    if (mp.isAnyMana()) {
                        anyMana = true;
                    }
                    block18: for (String s2 : colorsProduced = mp.mana(sa).split(" ")) {
                        switch (s2.toUpperCase()) {
                            case "R": {
                                if (rMana) continue block18;
                                ++count;
                                rMana = true;
                                continue block18;
                            }
                            case "G": {
                                if (gMana) continue block18;
                                ++count;
                                gMana = true;
                                continue block18;
                            }
                            case "B": {
                                if (bMana) continue block18;
                                ++count;
                                bMana = true;
                                continue block18;
                            }
                            case "U": {
                                if (uMana) continue block18;
                                ++count;
                                uMana = true;
                                continue block18;
                            }
                            case "W": {
                                if (wMana) continue block18;
                                ++count;
                                wMana = true;
                                continue block18;
                            }
                            case "C": {
                                if (cMana) continue block18;
                                cMana = true;
                            }
                        }
                    }
                }
            }
            if (this.isForest()) {
                ++basicLandTypes;
            }
            if (this.isMountain()) {
                ++basicLandTypes;
            }
            if (this.isSwamp()) {
                ++basicLandTypes;
            }
            if (this.isPlains()) {
                ++basicLandTypes;
            }
            if (this.isIsland()) {
                ++basicLandTypes;
            }
            this.set(TrackableProperty.CountBasicLandTypes, basicLandTypes);
            this.set(TrackableProperty.OrigProduceManaR, rMana);
            this.set(TrackableProperty.OrigProduceManaG, gMana);
            this.set(TrackableProperty.OrigProduceManaB, bMana);
            this.set(TrackableProperty.OrigProduceManaU, uMana);
            this.set(TrackableProperty.OrigProduceManaW, wMana);
            this.set(TrackableProperty.OrigProduceManaC, cMana);
            this.set(TrackableProperty.CountOrigProduceColoredMana, count);
            this.set(TrackableProperty.OrigProduceAnyMana, anyMana);
        }

        public boolean isBasicLand() {
            return this.getType().isBasicLand();
        }

        public boolean isCreature() {
            return this.getType().isCreature();
        }

        public boolean isLand() {
            return this.getType().isLand();
        }

        public boolean isPlane() {
            return this.getType().isPlane();
        }

        public boolean isPhenomenon() {
            return this.getType().isPhenomenon();
        }

        public boolean isPlaneswalker() {
            return this.getType().isPlaneswalker();
        }

        public boolean isBattle() {
            return this.getType().isBattle();
        }

        public boolean isMountain() {
            return this.getType().hasSubtype("Mountain");
        }

        public boolean isPlains() {
            return this.getType().hasSubtype("Plains");
        }

        public boolean isSwamp() {
            return this.getType().hasSubtype("Swamp");
        }

        public boolean isForest() {
            return this.getType().hasSubtype("Forest");
        }

        public boolean isIsland() {
            return this.getType().hasSubtype("Island");
        }

        public boolean isVehicle() {
            return this.getType().hasSubtype("Vehicle");
        }

        public boolean isArtifact() {
            return this.getType().isArtifact();
        }

        public boolean isNyx() {
            if (!this.getType().isEnchantment() || this.getType().getCoreTypes() == null) {
                return false;
            }
            return Iterables.size(this.getType().getCoreTypes()) > 1;
        }

        public boolean isAttraction() {
            return this.getType().isAttraction();
        }

        @Override
        public String getTranslationKey() {
            String key = this.getName();
            String variant = this.getFunctionalVariantName();
            if (StringUtils.isNotEmpty(variant)) {
                key = key + " $" + variant;
            }
            return key;
        }

        @Override
        public String getUntranslatedType() {
            return this.getType().toString();
        }

        @Override
        public String getUntranslatedOracle() {
            return this.getOracleText();
        }
    }
}

