/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.Lists;
import forge.game.card.Card;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import java.util.Collection;
import java.util.List;

public class CardTraitChanges
implements Cloneable {
    private List<Trigger> triggers = Lists.newArrayList();
    private List<ReplacementEffect> replacements = Lists.newArrayList();
    private List<SpellAbility> abilities = Lists.newArrayList();
    private List<StaticAbility> staticAbilities = Lists.newArrayList();
    private List<SpellAbility> removedAbilities = Lists.newArrayList();
    private boolean removeAll = false;
    private boolean removeNonMana = false;

    public CardTraitChanges(Collection<SpellAbility> spells, Collection<SpellAbility> removedAbilities, Collection<Trigger> trigger, Collection<ReplacementEffect> res, Collection<StaticAbility> st, boolean removeAll, boolean removeNonMana) {
        if (spells != null) {
            this.abilities.addAll(spells);
        }
        if (removedAbilities != null) {
            this.removedAbilities.addAll(removedAbilities);
        }
        if (trigger != null) {
            this.triggers.addAll(trigger);
        }
        if (res != null) {
            this.replacements.addAll(res);
        }
        if (st != null) {
            this.staticAbilities.addAll(st);
        }
        this.removeAll |= removeAll;
        this.removeNonMana |= removeNonMana;
    }

    public Collection<Trigger> getTriggers() {
        return this.triggers;
    }

    public Collection<ReplacementEffect> getReplacements() {
        return this.replacements;
    }

    public Collection<SpellAbility> getAbilities() {
        return this.abilities;
    }

    public Collection<SpellAbility> getRemovedAbilities() {
        return this.removedAbilities;
    }

    public Collection<StaticAbility> getStaticAbilities() {
        return this.staticAbilities;
    }

    public boolean isRemoveAll() {
        return this.removeAll;
    }

    public boolean isRemoveNonMana() {
        return this.removeNonMana;
    }

    public CardTraitChanges copy(Card host, boolean lki) {
        try {
            CardTraitChanges result = (CardTraitChanges)super.clone();
            result.abilities = Lists.newArrayList();
            for (SpellAbility spellAbility : this.abilities) {
                result.abilities.add(spellAbility.copy(host, lki));
            }
            result.removedAbilities = Lists.newArrayList();
            for (SpellAbility spellAbility : this.removedAbilities) {
                result.removedAbilities.add(spellAbility.copy(host, lki));
            }
            result.triggers = Lists.newArrayList();
            for (Trigger trigger : this.triggers) {
                result.triggers.add(trigger.copy(host, lki));
            }
            result.replacements = Lists.newArrayList();
            for (ReplacementEffect replacementEffect : this.replacements) {
                result.replacements.add(replacementEffect.copy(host, lki));
            }
            result.staticAbilities = Lists.newArrayList();
            for (StaticAbility staticAbility : this.staticAbilities) {
                result.staticAbilities.add(staticAbility.copy(host, lki));
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException("CardTraitChanges : clone() error", ex);
        }
    }

    public void changeText() {
        for (SpellAbility spellAbility : this.abilities) {
            spellAbility.changeText();
        }
        for (Trigger trigger : this.triggers) {
            trigger.changeText();
        }
        for (ReplacementEffect replacementEffect : this.replacements) {
            replacementEffect.changeText();
        }
        for (StaticAbility staticAbility : this.staticAbilities) {
            staticAbility.changeText();
        }
    }
}

