/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.CardTypeView;
import forge.card.mana.ManaCost;
import forge.game.CardTraitBase;
import forge.game.ForgeScript;
import forge.game.GameObject;
import forge.game.IHasSVars;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardView;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordCollection;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.spellability.SpellPermanent;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.util.ITranslatable;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CardState
extends GameObject
implements IHasSVars,
ITranslatable {
    private String name = "";
    private CardType type = new CardType(false);
    private ManaCost manaCost = ManaCost.NO_COST;
    private byte color = 0;
    private String oracleText = "";
    private String functionalVariantName = null;
    private int basePower = 0;
    private int baseToughness = 0;
    private String basePowerString = null;
    private String baseToughnessString = null;
    private String baseLoyalty = "";
    private String baseDefense = "";
    private KeywordCollection intrinsicKeywords = new KeywordCollection();
    private Set<Integer> attractionLights = null;
    private final FCollection<SpellAbility> nonManaAbilities = new FCollection();
    private final FCollection<SpellAbility> manaAbilities = new FCollection();
    private FCollection<Trigger> triggers = new FCollection();
    private FCollection<ReplacementEffect> replacementEffects = new FCollection();
    private FCollection<StaticAbility> staticAbilities = new FCollection();
    private String imageKey = "";
    private Map<String, String> sVars = Maps.newTreeMap();
    private KeywordCollection cachedKeywords = new KeywordCollection();
    private CardRarity rarity = CardRarity.Unknown;
    private String setCode = CardEdition.UNKNOWN.getCode();
    private final CardView.CardStateView view;
    private final Card card;
    private ReplacementEffect loyaltyRep;
    private ReplacementEffect defenseRep;
    private ReplacementEffect battleTypeRep;
    private ReplacementEffect sagaRep;
    private SpellAbility manifestUp;
    private SpellAbility cloakUp;

    public CardState(Card card, CardStateName name) {
        this(card.getView().createAlternateState(name), card);
    }

    public CardState(CardView.CardStateView view0, Card card0) {
        this.view = view0;
        this.card = card0;
        this.view.updateRarity(this);
        this.view.updateSetCode(this);
    }

    public CardView.CardStateView getView() {
        return this.view;
    }

    public Card getCard() {
        return this.card;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String name0) {
        this.name = name0;
        this.view.updateName(this);
    }

    public CardStateName getStateName() {
        return this.getView().getState();
    }

    public String toString() {
        return this.name + " (" + (Object)((Object)this.view.getState()) + ")";
    }

    public CardTypeView getTypeWithChanges() {
        return this.getType().getTypeWithChanges(this.card.getChangedCardTypes());
    }

    public final CardTypeView getType() {
        return this.type;
    }

    public final void addType(String type0) {
        if (this.type.add(type0)) {
            this.view.updateType(this);
        }
    }

    public final void addType(Iterable<String> type0) {
        if (this.type.addAll(type0)) {
            this.view.updateType(this);
        }
    }

    public final void setType(CardType type0) {
        if (type0 == this.type) {
            return;
        }
        if (type0.isEmpty() && this.type.isEmpty()) {
            return;
        }
        this.type.clear();
        this.type.addAll(type0);
        this.view.updateType(this);
    }

    public final void removeType(CardType.Supertype st) {
        if (this.type.remove(st)) {
            this.view.updateType(this);
        }
    }

    public final void removeCardTypes(boolean sanisfy) {
        this.type.removeCardTypes();
        if (sanisfy) {
            this.type.sanisfySubtypes();
        }
    }

    public final void setCreatureTypes(Collection<String> ctypes) {
        if (this.type.setCreatureTypes(ctypes)) {
            this.view.updateType(this);
        }
    }

    public final ManaCost getManaCost() {
        return this.manaCost;
    }

    public final void setManaCost(ManaCost manaCost0) {
        this.manaCost = manaCost0;
        this.view.updateManaCost(this);
    }

    public final byte getColor() {
        return this.color;
    }

    public final void addColor(byte color) {
        this.color = (byte)(this.color | color);
        this.view.updateColors(this.card);
    }

    public final void setColor(byte color) {
        this.color = color;
        this.view.updateColors(this.card);
    }

    public String getOracleText() {
        return this.oracleText;
    }

    public void setOracleText(String oracleText) {
        this.oracleText = oracleText;
        this.view.setOracleText(oracleText);
    }

    public String getFunctionalVariantName() {
        return this.functionalVariantName;
    }

    public void setFunctionalVariantName(String functionalVariantName) {
        if (functionalVariantName != null && functionalVariantName.isEmpty()) {
            functionalVariantName = null;
        }
        this.functionalVariantName = functionalVariantName;
        this.view.setFunctionalVariantName(functionalVariantName);
    }

    public final int getBasePower() {
        return this.basePower;
    }

    public final void setBasePower(int basePower0) {
        if (this.basePower == basePower0) {
            return;
        }
        this.basePower = basePower0;
        this.view.updatePower(this);
    }

    public final int getBaseToughness() {
        return this.baseToughness;
    }

    public final void setBaseToughness(int baseToughness0) {
        if (this.baseToughness == baseToughness0) {
            return;
        }
        this.baseToughness = baseToughness0;
        this.view.updateToughness(this);
    }

    public final String getBasePowerString() {
        return this.basePowerString;
    }

    public final String getBaseToughnessString() {
        return this.baseToughnessString;
    }

    public final void setBasePowerString(String s2) {
        this.basePowerString = s2;
    }

    public final void setBaseToughnessString(String s2) {
        this.baseToughnessString = s2;
    }

    public String getBaseLoyalty() {
        return this.baseLoyalty;
    }

    public final void setBaseLoyalty(String string) {
        this.baseLoyalty = string;
        this.view.updateLoyalty(this);
    }

    public String getBaseDefense() {
        return this.baseDefense;
    }

    public final void setBaseDefense(String string) {
        this.baseDefense = string;
        this.view.updateDefense(this);
    }

    public Set<Integer> getAttractionLights() {
        return this.attractionLights;
    }

    public final void setAttractionLights(Set<Integer> attractionLights) {
        this.attractionLights = attractionLights;
        this.view.updateAttractionLights(this);
    }

    public final Collection<KeywordInterface> getCachedKeywords() {
        return this.cachedKeywords.getValues();
    }

    public final Collection<KeywordInterface> getCachedKeyword(Keyword keyword) {
        return this.cachedKeywords.getValues(keyword);
    }

    public final void setCachedKeywords(KeywordCollection col) {
        this.cachedKeywords = col;
    }

    public final boolean hasKeyword(Keyword key) {
        return this.cachedKeywords.contains(key);
    }

    public final Collection<KeywordInterface> getIntrinsicKeywords() {
        return this.intrinsicKeywords.getValues();
    }

    public final boolean hasIntrinsicKeyword(String k) {
        return this.intrinsicKeywords.contains(k);
    }

    public final void setIntrinsicKeywords(Iterable<KeywordInterface> intrinsicKeyword0, boolean lki) {
        this.intrinsicKeywords.clear();
        for (KeywordInterface k : intrinsicKeyword0) {
            this.intrinsicKeywords.insert(k.copy(this.card, lki));
        }
        this.card.updateKeywordsCache(this);
    }

    public final KeywordInterface addIntrinsicKeyword(String s2, boolean initTraits) {
        if (s2.trim().length() == 0) {
            return null;
        }
        KeywordInterface inst = null;
        try {
            inst = this.intrinsicKeywords.add(s2);
        }
        catch (Exception e) {
            String msg = "CardState:addIntrinsicKeyword: failed to parse Keyword";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Card", this.card.getName());
            bread.setData("Keyword", s2);
            Sentry.addBreadcrumb(bread);
            throw new RuntimeException("Error in Keyword " + s2 + " for card " + this.card.getName(), e);
        }
        if (inst != null && initTraits) {
            inst.createTraits(this.card, true);
        }
        return inst;
    }

    public final boolean addIntrinsicKeywords(Iterable<String> keywords) {
        return this.addIntrinsicKeywords(keywords, true);
    }

    public final boolean addIntrinsicKeywords(Iterable<String> keywords, boolean initTraits) {
        boolean changed = false;
        for (String k : keywords) {
            if (this.addIntrinsicKeyword(k, initTraits) == null) continue;
            changed = true;
        }
        return changed;
    }

    public final boolean removeIntrinsicKeyword(String s2) {
        return this.intrinsicKeywords.remove(s2);
    }

    public final boolean removeIntrinsicKeyword(KeywordInterface s2) {
        return this.intrinsicKeywords.remove(s2);
    }

    public final boolean removeIntrinsicKeyword(Keyword k) {
        return this.intrinsicKeywords.removeAll(k);
    }

    public final FCollectionView<SpellAbility> getSpellAbilities() {
        FCollection<SpellAbility> newCol = new FCollection<SpellAbility>(this.manaAbilities);
        newCol.addAll((Collection<SpellAbility>)this.nonManaAbilities);
        this.card.updateSpellAbilities(newCol, this, null);
        return newCol;
    }

    public final FCollectionView<SpellAbility> getManaAbilities() {
        FCollection<SpellAbility> newCol = new FCollection<SpellAbility>(this.manaAbilities);
        this.card.updateSpellAbilities(newCol, this, true);
        return newCol;
    }

    public final FCollectionView<SpellAbility> getNonManaAbilities() {
        FCollection<SpellAbility> newCol = new FCollection<SpellAbility>(this.nonManaAbilities);
        this.card.updateSpellAbilities(newCol, this, false);
        return newCol;
    }

    public final Iterable<SpellAbility> getIntrinsicSpellAbilities() {
        return Iterables.filter(this.getSpellAbilities(), SpellAbilityPredicates.isIntrinsic());
    }

    public final SpellAbility getFirstAbility() {
        return Iterables.getFirst(this.getIntrinsicSpellAbilities(), null);
    }

    public final SpellAbility getFirstSpellAbility() {
        return Iterables.getFirst(this.getNonManaAbilities(), null);
    }

    public final SpellAbility getFirstSpellAbilityWithFallback() {
        SpellAbility sa = this.getFirstSpellAbility();
        if (sa != null || this.getTypeWithChanges().isLand()) {
            return sa;
        }
        return new SpellPermanent(this.getCard(), this);
    }

    public final boolean hasSpellAbility(SpellAbility sa) {
        return this.getSpellAbilities().contains(sa);
    }

    public final boolean hasSpellAbility(int id) {
        for (SpellAbility sa : this.getSpellAbilities()) {
            if (id != sa.getId()) continue;
            return true;
        }
        return false;
    }

    public final void setNonManaAbilities(SpellAbility sa) {
        this.nonManaAbilities.clear();
        if (sa != null) {
            this.nonManaAbilities.add(sa);
        }
    }

    public final boolean addSpellAbility(SpellAbility a) {
        if (a.isManaAbility()) {
            return this.manaAbilities.add(a);
        }
        return this.nonManaAbilities.add(a);
    }

    public final boolean removeSpellAbility(SpellAbility a) {
        if (a.isManaAbility()) {
            return this.manaAbilities.remove(a);
        }
        return this.nonManaAbilities.remove(a);
    }

    public final boolean addManaAbility(SpellAbility a) {
        return this.manaAbilities.add(a);
    }

    public final boolean addManaAbilities(Iterable<SpellAbility> a) {
        return this.manaAbilities.addAll(a);
    }

    public final boolean removeManaAbility(SpellAbility a) {
        return this.manaAbilities.remove(a);
    }

    public final boolean addNonManaAbility(SpellAbility a) {
        return this.nonManaAbilities.add(a);
    }

    public final boolean addNonManaAbilities(Iterable<SpellAbility> a) {
        return this.nonManaAbilities.addAll(a);
    }

    public final boolean removeNonManaAbility(SpellAbility a) {
        return this.nonManaAbilities.remove(a);
    }

    public final void clearFirstSpell() {
        for (int i = 0; i < this.nonManaAbilities.size(); ++i) {
            if (!this.nonManaAbilities.get((SpellAbility)i).isSpell()) continue;
            this.nonManaAbilities.remove(i);
            return;
        }
    }

    public final FCollectionView<Trigger> getTriggers() {
        FCollection<Trigger> result = new FCollection<Trigger>(this.triggers);
        this.card.updateTriggers(result, this);
        return result;
    }

    public final boolean hasTrigger(Trigger t2) {
        return this.getTriggers().contains(t2);
    }

    public final boolean hasTrigger(int id) {
        for (Trigger t2 : this.getTriggers()) {
            if (id != t2.getId()) continue;
            return true;
        }
        return false;
    }

    public final void setTriggers(FCollection<Trigger> triggers0) {
        this.triggers = triggers0;
    }

    public final boolean addTrigger(Trigger t2) {
        return this.triggers.add(t2);
    }

    public final boolean removeTrigger(Trigger t2) {
        return this.triggers.remove(t2);
    }

    public final void clearTriggers() {
        this.triggers.clear();
    }

    public final FCollectionView<StaticAbility> getStaticAbilities() {
        FCollection<StaticAbility> result = new FCollection<StaticAbility>(this.staticAbilities);
        this.card.updateStaticAbilities(result, this);
        return result;
    }

    public final boolean addStaticAbility(StaticAbility stab) {
        return this.staticAbilities.add(stab);
    }

    public final boolean removeStaticAbility(StaticAbility stab) {
        return this.staticAbilities.remove(stab);
    }

    public final void setStaticAbilities(Iterable<StaticAbility> staticAbilities0) {
        this.staticAbilities = new FCollection<StaticAbility>(staticAbilities0);
    }

    public final void clearStaticAbilities() {
        this.staticAbilities.clear();
    }

    public final String getImageKey() {
        return this.imageKey;
    }

    public final void setImageKey(String imageFilename0) {
        this.imageKey = imageFilename0;
        this.view.updateImageKey(this);
    }

    public FCollectionView<ReplacementEffect> getReplacementEffects() {
        FCollection<ReplacementEffect> result = new FCollection<ReplacementEffect>(this.replacementEffects);
        CardTypeView type = this.getTypeWithChanges();
        if (type.isPlaneswalker()) {
            if (this.loyaltyRep == null) {
                this.loyaltyRep = CardFactoryUtil.makeEtbCounter("etbCounter:LOYALTY:" + this.baseLoyalty, this, true);
            }
            result.add(this.loyaltyRep);
        }
        if (type.isBattle()) {
            if (this.defenseRep == null) {
                this.defenseRep = CardFactoryUtil.makeEtbCounter("etbCounter:DEFENSE:" + this.baseDefense, this, true);
            }
            result.add(this.defenseRep);
            if (this.battleTypeRep != null || type.hasSubtype("Siege")) {
                // empty if block
            }
        }
        if (type.hasSubtype("Saga") && !this.hasKeyword(Keyword.READ_AHEAD)) {
            if (this.sagaRep == null) {
                this.sagaRep = CardFactoryUtil.makeEtbCounter("etbCounter:LORE:1", this, true);
            }
            result.add(this.sagaRep);
        }
        this.card.updateReplacementEffects(result, this);
        return result;
    }

    public boolean addReplacementEffect(ReplacementEffect replacementEffect) {
        return this.replacementEffects.add(replacementEffect);
    }

    public boolean removeReplacementEffect(ReplacementEffect replacementEffect) {
        return this.replacementEffects.remove(replacementEffect);
    }

    public void clearReplacementEffects() {
        this.replacementEffects.clear();
    }

    public final boolean hasReplacementEffect(ReplacementEffect re) {
        return this.getReplacementEffects().contains(re);
    }

    public final boolean hasReplacementEffect(int id) {
        return this.getReplacementEffect(id) != null;
    }

    public final ReplacementEffect getReplacementEffect(int id) {
        for (ReplacementEffect r : this.getReplacementEffects()) {
            if (id != r.getId()) continue;
            return r;
        }
        return null;
    }

    @Override
    public final Map<String, String> getSVars() {
        return this.sVars;
    }

    @Override
    public Map<String, String> getDirectSVars() {
        return this.sVars;
    }

    @Override
    public final String getSVar(String var) {
        if (this.sVars.containsKey(var)) {
            return this.sVars.get(var);
        }
        return "";
    }

    @Override
    public final boolean hasSVar(String var) {
        if (var == null) {
            return false;
        }
        return this.sVars.containsKey(var);
    }

    @Override
    public final void setSVar(String var, String str) {
        this.sVars.put(var, str);
        this.view.updateFoilIndex(this.card.getState(CardStateName.Original));
    }

    @Override
    public final void setSVars(Map<String, String> newSVars) {
        this.sVars = Maps.newTreeMap();
        this.sVars.putAll(newSVars);
        this.view.updateFoilIndex(this.card.getState(CardStateName.Original));
    }

    @Override
    public final void removeSVar(String var) {
        this.sVars.remove(var);
    }

    public final int getFoil() {
        String foil = this.getSVar("Foil");
        if (!foil.isEmpty()) {
            return Integer.parseInt(foil);
        }
        return 0;
    }

    public final void copyFrom(CardState source, boolean lki) {
        this.copyFrom(source, lki, null);
    }

    public final void copyFrom(CardState source, boolean lki, CardTraitBase ctb) {
        SpellAbility root;
        this.setName(source.getName());
        this.setType(source.type);
        this.setManaCost(source.getManaCost());
        this.setColor(source.getColor());
        this.setOracleText(source.getOracleText());
        this.setFunctionalVariantName(source.getFunctionalVariantName());
        this.setBasePower(source.getBasePower());
        this.setBaseToughness(source.getBaseToughness());
        this.setBaseLoyalty(source.getBaseLoyalty());
        this.setBaseDefense(source.getBaseDefense());
        this.setAttractionLights(source.getAttractionLights());
        this.setSVars(source.getSVars());
        this.manaAbilities.clear();
        for (SpellAbility sa : source.manaAbilities) {
            if (!sa.isIntrinsic()) continue;
            this.manaAbilities.add(sa.copy(this.card, lki));
        }
        this.nonManaAbilities.clear();
        for (SpellAbility sa : source.nonManaAbilities) {
            if (!sa.isIntrinsic()) continue;
            this.nonManaAbilities.add(sa.copy(this.card, lki));
        }
        this.setIntrinsicKeywords(source.intrinsicKeywords.getValues(), lki);
        this.setImageKey(source.getImageKey());
        this.setRarity(source.rarity);
        this.setSetCode(source.setCode);
        Trigger dontCopyTr = null;
        if (ctb != null && ctb.hasParam("DoesntHaveThisAbility") && (root = ((SpellAbility)ctb).getRootAbility()).isTrigger()) {
            dontCopyTr = root.getTrigger();
        }
        this.triggers.clear();
        for (Trigger tr : source.triggers) {
            if (tr.equals(dontCopyTr) || !tr.isIntrinsic()) continue;
            this.triggers.add(tr.copy(this.card, lki));
        }
        this.replacementEffects.clear();
        for (ReplacementEffect re : source.replacementEffects) {
            if (!re.isIntrinsic()) continue;
            this.replacementEffects.add(re.copy(this.card, lki));
        }
        this.staticAbilities.clear();
        for (StaticAbility sa : source.staticAbilities) {
            if (!sa.isIntrinsic()) continue;
            this.staticAbilities.add(sa.copy(this.card, lki));
        }
        if (lki) {
            if (source.loyaltyRep != null) {
                this.loyaltyRep = source.loyaltyRep.copy(this.card, true);
            }
            if (source.defenseRep != null) {
                this.defenseRep = source.defenseRep.copy(this.card, true);
            }
            if (source.sagaRep != null) {
                this.sagaRep = source.sagaRep.copy(this.card, true);
            }
        }
    }

    public final void addAbilitiesFrom(CardState source, boolean lki) {
        for (SpellAbility spellAbility : source.manaAbilities) {
            if (!spellAbility.isIntrinsic()) continue;
            this.manaAbilities.add(spellAbility.copy(this.card, lki));
        }
        for (SpellAbility spellAbility : source.nonManaAbilities) {
            if (!spellAbility.isIntrinsic() || spellAbility.getApi() == ApiType.PermanentCreature || spellAbility.getApi() == ApiType.PermanentNoncreature) continue;
            this.nonManaAbilities.add(spellAbility.copy(this.card, lki));
        }
        for (KeywordInterface keywordInterface : source.intrinsicKeywords) {
            this.intrinsicKeywords.insert(keywordInterface.copy(this.card, lki));
        }
        for (Trigger trigger : source.triggers) {
            if (!trigger.isIntrinsic()) continue;
            this.triggers.add(trigger.copy(this.card, lki));
        }
        for (ReplacementEffect replacementEffect : source.replacementEffects) {
            if (!replacementEffect.isIntrinsic()) continue;
            this.replacementEffects.add(replacementEffect.copy(this.card, lki));
        }
        for (StaticAbility staticAbility : source.staticAbilities) {
            if (!staticAbility.isIntrinsic()) continue;
            this.staticAbilities.add(staticAbility.copy(this.card, lki));
        }
    }

    public CardState copy(Card host, CardStateName name, boolean lki) {
        CardState result = new CardState(host, name);
        result.copyFrom(this, lki);
        return result;
    }

    public CardRarity getRarity() {
        return this.rarity;
    }

    public void setRarity(CardRarity rarity0) {
        this.rarity = rarity0;
        this.view.updateRarity(this);
    }

    public String getSetCode() {
        return this.setCode;
    }

    public void setSetCode(String setCode0) {
        this.setCode = setCode0;
        this.view.updateSetCode(this);
    }

    @Override
    public boolean hasProperty(String property, Player sourceController, Card source, CardTraitBase spellAbility) {
        return ForgeScript.cardStateHasProperty(this, property, sourceController, source, spellAbility);
    }

    public void addIntrinsicKeywords(Collection<KeywordInterface> intrinsicKeywords2) {
        for (KeywordInterface inst : intrinsicKeywords2) {
            this.intrinsicKeywords.insert(inst);
        }
    }

    public ImmutableList<CardTraitBase> getTraits() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.manaAbilities)).addAll(this.nonManaAbilities)).addAll(this.triggers)).addAll(this.replacementEffects)).addAll(this.staticAbilities)).build();
    }

    public void resetOriginalHost(Card oldHost) {
        for (CardTraitBase ctb : this.getTraits()) {
            if (!ctb.isIntrinsic() || ctb.getOriginalHost() == null || !ctb.getOriginalHost().equals(oldHost)) continue;
            ctb.setCardState(this);
        }
    }

    public void updateChangedText() {
        for (CardTraitBase ctb : this.getTraits()) {
            if (!ctb.isIntrinsic()) continue;
            ctb.changeText();
        }
    }

    public void changeTextIntrinsic(Map<String, String> colorMap, Map<String, String> typeMap) {
        for (CardTraitBase ctb : this.getTraits()) {
            if (!ctb.isIntrinsic()) continue;
            ctb.changeTextIntrinsic(colorMap, typeMap);
        }
    }

    public final int getFinalChapterNr() {
        int n = 0;
        for (Trigger t2 : this.getTriggers()) {
            if (!t2.isChapter()) continue;
            n = Math.max(n, t2.getChapter());
        }
        return n;
    }

    public SpellAbility getManifestUp() {
        if (this.manifestUp == null) {
            this.manifestUp = CardFactoryUtil.abilityTurnFaceUp(this, "ManifestUp", "Unmanifest");
        }
        return this.manifestUp;
    }

    public SpellAbility getCloakUp() {
        if (this.cloakUp == null) {
            this.cloakUp = CardFactoryUtil.abilityTurnFaceUp(this, "CloakUp", "Uncloak");
        }
        return this.cloakUp;
    }

    @Override
    public String getTranslationKey() {
        if (StringUtils.isNotEmpty(this.functionalVariantName)) {
            return this.name + " $" + this.functionalVariantName;
        }
        return this.name;
    }

    @Override
    public String getUntranslatedType() {
        return this.getType().toString();
    }

    @Override
    public String getUntranslatedOracle() {
        return this.getOracleText();
    }
}

