/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.StaticData;
import forge.card.CardDb;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.game.CardTraitBase;
import forge.game.EvenOdd;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterType;
import forge.game.combat.AttackRequirement;
import forge.game.combat.AttackingBand;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.mana.Mana;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.PlayerZone;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.Expressions;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CardProperty {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean cardHasProperty(final Card card, String property, Player sourceController, Card source, final CardTraitBase spellAbility) {
        Game game = card.getGame();
        Combat combat = game.getCombat();
        Card lki = game.getChangeZoneLKIInfo(card);
        Player controller = lki.getController();
        if (card.isPhasedOut()) {
            if (!property.startsWith("phasedOut")) return false;
            property = property.substring(9);
        }
        if (property.equals("noName")) {
            if (card.hasNoName()) return true;
            return false;
        }
        if (property.startsWith("named")) {
            String name = TextUtil.fastReplace(property.substring(5), ";", ",");
            if (card.sharesNameWith(name = TextUtil.fastReplace(name, "_", " "))) return true;
            return false;
        }
        if (property.startsWith("notnamed")) {
            String name = TextUtil.fastReplace(property.substring(8), ";", ",");
            if (!card.sharesNameWith(name = TextUtil.fastReplace(name, "_", " "))) return true;
            return false;
        }
        if (property.equals("NamedCard")) {
            String name;
            boolean found = false;
            Iterator<String> iterator = source.getNamedCards().iterator();
            do {
                if (!iterator.hasNext()) return found;
            } while (!card.sharesNameWith(name = iterator.next()));
            return true;
        }
        if (property.equals("NamedByRememberedPlayer")) {
            Object e;
            Object newCard;
            if (!source.hasRemembered()) {
                newCard = game.getCardState(source);
                for (Object o : ((Card)newCard).getRemembered()) {
                    if (!(o instanceof Player) || card.sharesNameWith(((Player)o).getNamedCard())) continue;
                    return false;
                }
            }
            newCard = source.getRemembered().iterator();
            do {
                if (!newCard.hasNext()) return true;
            } while (!((e = newCard.next()) instanceof Player) || card.sharesNameWith(((Player)e).getNamedCard()));
            return false;
        }
        if (property.startsWith("BorderColor")) {
            if (property.toUpperCase().contains(card.borderColor().toString())) return true;
            return false;
        }
        if (property.equals("Permanent")) {
            if (card.isPermanent()) return true;
            return false;
        }
        if (property.equals("Historic")) {
            if (card.isHistoric()) return true;
            return false;
        }
        if (property.startsWith("CardUID_")) {
            if (card.getId() == Integer.parseInt(property.split("CardUID_")[1])) return true;
            return false;
        }
        if (property.startsWith("ChosenCard")) {
            CardCollectionView chosen = source.getChosenCards();
            int n = chosen.indexOf(card);
            if (n == -1) {
                return false;
            }
            if (!property.contains("Strict")) return true;
            if (((Card)chosen.get(n)).equalsWithGameTimestamp(card)) return true;
            return false;
        }
        if (property.equals("nonChosenCard")) {
            if (!source.hasChosenCard(card)) return true;
            return false;
        }
        if (property.startsWith("ChosenMode")) {
            if (card.getChosenMode().equals(property.substring(10))) return true;
            return false;
        }
        if (property.equals("ChosenSector")) {
            if (source.getChosenSector().equals(card.getSector())) return true;
            return false;
        }
        if (property.equals("DifferentSector")) {
            if (!source.getSector().equals(card.getSector())) return true;
            return false;
        }
        if (property.equals("DoubleFaced")) {
            if (card.isDoubleFaced()) return true;
            return false;
        }
        if (property.equals("FrontSide")) {
            if (!card.isBackSide()) return true;
            return false;
        }
        if (property.equals("BackSide")) {
            if (card.isBackSide()) return true;
            return false;
        }
        if (property.equals("CanTransform")) {
            if (card.isTransformable()) return true;
            return false;
        }
        if (property.equals("Transformed")) {
            if (card.isTransformed()) return true;
            return false;
        }
        if (property.equals("Flip")) {
            if (card.isFlipCard()) return true;
            return false;
        }
        if (property.equals("Split")) {
            if (card.isSplitCard()) return true;
            return false;
        }
        if (property.equals("AdventureCard")) {
            if (card.isAdventureCard()) return true;
            return false;
        }
        if (property.equals("IsRingbearer")) {
            if (card.isRingBearer()) return true;
            return false;
        }
        if (property.equals("IsTriggerRemembered")) {
            boolean found = false;
            for (Object o : spellAbility.getTriggerRemembered()) {
                Card trigRem;
                if (!(o instanceof Card) || !(trigRem = (Card)o).equalsWithGameTimestamp(card)) continue;
                return true;
            }
            if (found) return true;
            return false;
        }
        if (property.startsWith("YouCtrl")) {
            if (controller.equals(sourceController)) return true;
            return false;
        }
        if (property.startsWith("YourTeamCtrl")) {
            if (controller.getTeam() == sourceController.getTeam()) return true;
            return false;
        }
        if (property.startsWith("YouDontCtrl")) {
            if (!controller.equals(sourceController)) return true;
            return false;
        }
        if (property.startsWith("OppCtrl")) {
            if (controller.getOpponents().contains(sourceController)) return true;
            return false;
        }
        if (property.startsWith("ChosenCtrl")) {
            if (controller.equals(source.getChosenPlayer())) return true;
            return false;
        }
        if (property.startsWith("DefenderCtrl")) {
            if (!game.getPhaseHandler().inCombat()) {
                return false;
            }
            if (property.endsWith("ForRemembered")) {
                if (!source.hasRemembered()) {
                    return false;
                }
                if (combat.getDefendingPlayerRelatedTo((Card)source.getFirstRemembered()) == controller) return true;
                return false;
            }
            if (combat.getDefendingPlayerRelatedTo(source) == controller) return true;
            return false;
        }
        if (property.startsWith("OppProtect")) {
            if (card.getProtectingPlayer() == null) return false;
            if (sourceController.getOpponents().contains(card.getProtectingPlayer())) return true;
            return false;
        }
        if (property.startsWith("ProtectedBy")) {
            if (card.getProtectingPlayer() == null) {
                return false;
            }
            PlayerCollection lp = AbilityUtils.getDefinedPlayers(source, property.substring(12), spellAbility);
            if (lp.contains(card.getProtectingPlayer())) return true;
            return false;
        }
        if (property.equals("Defending")) {
            if (game.getCombat() == null) return false;
            if (game.getCombat().getAttackersAndDefenders().values().contains(card)) return true;
            return false;
        }
        if (property.startsWith("DefendingPlayer")) {
            Player p;
            Player player = p = property.endsWith("Ctrl") ? controller : card.getOwner();
            if (!game.getPhaseHandler().inCombat()) {
                return false;
            }
            if (combat.isPlayerAttacked(p)) return true;
            return false;
        }
        if (property.startsWith("EnchantedPlayer")) {
            Player p = property.endsWith("Ctrl") ? controller : card.getOwner();
            GameEntity gameEntity = source.getEntityAttachedTo();
            if (!(gameEntity instanceof Player)) return false;
            if (p.equals(gameEntity)) return true;
            return false;
        }
        if (property.startsWith("EnchantedController")) {
            Player p = property.endsWith("Ctrl") ? controller : card.getOwner();
            GameEntity gameEntity = source.getEntityAttachedTo();
            if (!(gameEntity instanceof Card)) return false;
            if (p.equals(((Card)gameEntity).getController())) return true;
            return false;
        }
        if (property.startsWith("RememberedPlayer")) {
            Card card2;
            Player p;
            Player player = p = property.endsWith("Ctrl") ? controller : card.getOwner();
            if (!source.hasRemembered() && !(card2 = game.getCardState(source)).isRemembered(p)) {
                return false;
            }
            if (source.isRemembered(p)) return true;
            return false;
        }
        if (property.equals("targetedBy")) {
            if (!(spellAbility instanceof SpellAbility)) {
                return false;
            }
            SpellAbility sp = (SpellAbility)spellAbility;
            if (sp.getRootAbility().isTargeting(card)) return true;
            return false;
        }
        if (property.equals("TargetedPlayerCtrl")) {
            if (AbilityUtils.getDefinedPlayers(source, "TargetedPlayer", spellAbility).contains(controller)) return true;
            return false;
        }
        if (property.startsWith("ActivePlayerCtrl")) {
            if (game.getPhaseHandler().isPlayerTurn(controller)) return true;
            return false;
        }
        if (property.startsWith("YouOwn")) {
            if (card.getOwner().equals(sourceController)) return true;
            return false;
        }
        if (property.startsWith("YouDontOwn")) {
            if (!card.getOwner().equals(sourceController)) return true;
            return false;
        }
        if (property.startsWith("OppOwn")) {
            if (card.getOwner().getOpponents().contains(sourceController)) return true;
            return false;
        }
        if (property.equals("TargetedPlayerOwn")) {
            if (AbilityUtils.getDefinedPlayers(source, "TargetedPlayer", spellAbility).contains(card.getOwner())) return true;
            return false;
        }
        if (property.startsWith("OwnedBy")) {
            String valid = property.substring(8);
            if (card.getOwner().isValid(valid, sourceController, source, spellAbility)) return true;
            PlayerCollection playerCollection = AbilityUtils.getDefinedPlayers(source, valid, spellAbility);
            if (playerCollection.contains(card.getOwner())) return true;
            return false;
        }
        if (property.startsWith("ControlledBy")) {
            String valid = property.substring(13);
            if (controller.isValid(valid, sourceController, source, spellAbility)) return true;
            PlayerCollection playerCollection = AbilityUtils.getDefinedPlayers(source, valid, spellAbility);
            if (playerCollection.contains(controller)) return true;
            return false;
        }
        if (property.startsWith("OwnerDoesntControl")) {
            if (!card.getOwner().equals(controller)) return true;
            return false;
        }
        if (property.startsWith("ControllerControls")) {
            String type = property.substring(18);
            if (type.startsWith("More")) {
                String string = type.split("More")[1];
                CardCollection cards = CardLists.getType(controller.getCardsIn(ZoneType.Battlefield), string);
                CardCollection yours = CardLists.getType(sourceController.getCardsIn(ZoneType.Battlefield), string);
                if (cards.size() > yours.size()) return true;
                return false;
            }
            if (type.startsWith("AtLeastAsMany")) {
                String string = type.split("AtLeastAsMany")[1];
                CardCollection cards = CardLists.getType(controller.getCardsIn(ZoneType.Battlefield), string);
                CardCollection yours = CardLists.getType(sourceController.getCardsIn(ZoneType.Battlefield), string);
                if (cards.size() >= yours.size()) return true;
                return false;
            }
            CardCollectionView cardCollectionView = controller.getCardsIn(ZoneType.Battlefield);
            if (type.contains("_")) {
                String[] parts = type.split("_", 2);
                CardCollection found = CardLists.getType(cardCollectionView, parts[0]);
                int num = AbilityUtils.calculateAmount(card, parts[1].substring(2), spellAbility);
                if (Expressions.compare(found.size(), parts[1].substring(0, 2), num)) return true;
                return false;
            }
            if (!CardLists.getType(cardCollectionView, type).isEmpty()) return true;
            return false;
        }
        if (property.startsWith("StrictlyOther")) {
            if (!card.equalsWithGameTimestamp(source)) return true;
            return false;
        }
        if (property.startsWith("Other")) {
            if (!card.equals(source)) return true;
            return false;
        }
        if (property.startsWith("StrictlySelf")) {
            if (card.equalsWithGameTimestamp(source)) return true;
            return false;
        }
        if (property.startsWith("Self")) {
            if (card.equals(source)) return true;
            return false;
        }
        if (property.startsWith("ExiledByYou")) {
            if (card.getExiledBy() == null) {
                return false;
            }
            if (card.getExiledBy().equals(sourceController)) return true;
            return false;
        }
        if (property.startsWith("ExiledWithSourceLKI")) {
            List<Card> exiled = card.getZone().getCardsAddedThisTurn(null);
            exiled.sort(CardPredicates.compareByGameTimestamp());
            int n = exiled.lastIndexOf(card);
            if (n == -1) {
                return false;
            }
            Card lkiExiled = exiled.get(n);
            if (lkiExiled.getExiledWith() == null) {
                return false;
            }
            Card host = source;
            if (spellAbility != null && (host = spellAbility.getOriginalHost()) == null) {
                host = spellAbility.getHostCard();
            }
            if (lkiExiled.getExiledWith().equalsWithGameTimestamp(host)) return true;
            return false;
        }
        if (property.startsWith("ExiledWithSource")) {
            if (card.getExiledWith() == null) {
                return false;
            }
            Card host = source;
            if (spellAbility != null && (host = spellAbility.getOriginalHost()) == null) {
                host = spellAbility.getHostCard();
            }
            if (!source.hasExiledCard(card)) return false;
            if (card.getExiledWith().equalsWithGameTimestamp(host)) return true;
            return false;
        }
        if (property.equals("ExiledWithEffectSource")) {
            if (card.getExiledWith() == null) {
                return false;
            }
            if (card.getExiledWith().equalsWithGameTimestamp(source.getEffectSource())) return true;
            return false;
        }
        if (property.equals("EncodedWithSource")) {
            if (card.getEncodedCards().contains(source)) return true;
            return false;
        }
        if (property.equals("EffectSource")) {
            if (!source.isImmutable()) {
                return false;
            }
            if (card.equals(source.getEffectSource())) return true;
            return false;
        }
        if (property.equals("CanBeSacrificedBy") && spellAbility instanceof SpellAbility) {
            if (card.canBeSacrificedBy((SpellAbility)spellAbility, false)) return true;
            return false;
        }
        if (property.equals("Attached")) {
            if (source.hasCardAttachment(card)) return true;
            return false;
        }
        if (property.startsWith("AttachedTo")) {
            String restriction = property.split("AttachedTo ")[1];
            if (!card.isAttachedToEntity()) {
                return false;
            }
            if (card.getEntityAttachedTo().isValid(restriction, sourceController, source, spellAbility)) return true;
            if ((restriction.contains("Player") ? AbilityUtils.getDefinedPlayers(source, restriction, spellAbility) : AbilityUtils.getDefinedCards(source, restriction, spellAbility)).contains(card.getEntityAttachedTo())) return true;
            return false;
        }
        if (property.equals("NameNotEnchantingEnchantedPlayer")) {
            Player enchantedPlayer = source.getPlayerAttachedTo();
            if (enchantedPlayer == null) return false;
            if (!enchantedPlayer.isEnchantedBy(card.getName())) return true;
            return false;
        }
        if (property.startsWith("EnchantedBy")) {
            String restriction;
            if (property.equals("EnchantedBy")) {
                if (card.isEnchantedBy(source)) return true;
                if (card.equals(source.getEntityAttachedTo())) return true;
                return false;
            }
            switch (restriction = property.split("EnchantedBy ")[1]) {
                case "Imprinted": {
                    Card c2;
                    Iterator host = source.getImprintedCards().iterator();
                    do {
                        if (!host.hasNext()) return true;
                    } while (card.isEnchantedBy(c2 = (Card)host.next()) || card.equals(c2.getEntityAttachedTo()));
                    return false;
                }
                case "Targeted": {
                    Card c3;
                    Iterator host = AbilityUtils.getDefinedCards(source, "Targeted", spellAbility).iterator();
                    do {
                        if (!host.hasNext()) return true;
                    } while (card.isEnchantedBy(c3 = (Card)host.next()) || card.equals(c3.getEntityAttachedTo()));
                    return false;
                }
                default: {
                    Card aura;
                    Iterator host = card.getEnchantedBy().iterator();
                    do {
                        if (!host.hasNext()) return false;
                    } while (!(aura = (Card)host.next()).isValid(restriction, sourceController, source, spellAbility));
                    return true;
                }
            }
        }
        if (property.startsWith("NotEnchantedBy")) {
            if (property.substring(14).equals("Targeted")) {
                Card card3;
                Iterator restriction = AbilityUtils.getDefinedCards(source, "Targeted", spellAbility).iterator();
                do {
                    if (!restriction.hasNext()) return true;
                } while (!card.isEnchantedBy(card3 = (Card)restriction.next()));
                return false;
            }
            if (!card.isEnchantedBy(source)) return true;
            return false;
        }
        if (property.startsWith("Enchanted")) {
            if (source.equals(card.getEntityAttachedTo())) return true;
            return false;
        }
        if (property.startsWith("CanEnchant")) {
            String restriction = property.substring(10);
            if (restriction.equals("EquippedBy")) {
                if (!source.isEquipping()) return false;
                if (!source.getEquipping().canBeAttached(card, null)) {
                    return false;
                }
            }
            if (restriction.equals("Remembered")) {
                Object rem;
                Iterator<Object> iterator = source.getRemembered().iterator();
                do {
                    if (!iterator.hasNext()) return true;
                    rem = iterator.next();
                    if (!(rem instanceof Card)) return false;
                } while (((Card)rem).canBeAttached(card, null));
                return false;
            }
            if (!restriction.equals("Source")) return true;
            if (source.canBeAttached(card, null)) return true;
            return false;
        }
        if (property.startsWith("CanBeEnchantedBy")) {
            if (property.substring(16).equals("Targeted")) {
                Card card4;
                Iterator restriction = AbilityUtils.getDefinedCards(source, "Targeted", spellAbility).iterator();
                do {
                    if (!restriction.hasNext()) return true;
                } while (card.canBeAttached(card4 = (Card)restriction.next(), null));
                return false;
            }
            if (property.substring(16).equals("AllRemembered")) {
                Card c4;
                Object object;
                Iterator<Object> restriction = source.getRemembered().iterator();
                do {
                    if (!restriction.hasNext()) return true;
                } while (!((object = restriction.next()) instanceof Card) || card.canBeAttached(c4 = (Card)object, null));
                return false;
            }
            if (card.canBeAttached(source, null)) return true;
            return false;
        }
        if (property.startsWith("EquippedBy") || property.startsWith("AttachedBy")) {
            String prop = property.substring(10);
            if (prop.equals("Enchanted")) {
                if (source.getEnchantingCard() == null) return false;
                if (card.hasCardAttachment(source.getEnchantingCard())) return true;
                return false;
            }
            if (!StringUtils.isBlank(prop)) {
                boolean bl;
                boolean bl2 = false;
                for (Card c5 : AbilityUtils.getDefinedCards(source, prop, spellAbility)) {
                    if (!card.hasCardAttachment(c5)) continue;
                    return true;
                }
                if (bl) return true;
                return false;
            }
            if (card.hasCardAttachment(source)) return true;
            return false;
        }
        if (property.startsWith("FortifiedBy")) {
            if (card.hasCardAttachment(source)) return true;
            return false;
        }
        if (property.startsWith("CanBeAttachedBy")) {
            if (card.canBeAttached(source, null)) return true;
            return false;
        }
        if (property.startsWith("CanBeTargetedBy")) {
            void var10_130;
            String def = property.substring(15);
            SpellAbility spellAbility2 = AbilityUtils.getDefinedSpellAbilities(source, def, spellAbility).get((SpellAbility)false);
            while (var10_130 != null) {
                if (var10_130.usesTargeting() && !var10_130.canTarget(card)) {
                    return false;
                }
                AbilitySub abilitySub = var10_130.getSubAbility();
            }
            return true;
        }
        if (property.startsWith("HauntedBy")) {
            if (card.isHauntedBy(source)) return true;
            return false;
        }
        if (property.startsWith("notTributed")) {
            if (!card.isTributed()) return true;
            return false;
        }
        if (property.startsWith("madness")) {
            if (card.isMadness()) return true;
            return false;
        }
        if (property.startsWith("Paired")) {
            if (!card.isPaired()) {
                return false;
            }
            if (!property.endsWith("With")) return true;
            if (card.getPairedWith() == source) return true;
            return false;
        }
        if (property.startsWith("Above")) {
            CardCollectionView cards = card.getOwner().getCardsIn(ZoneType.Graveyard);
            if (cards.indexOf(source) < cards.indexOf(card)) return true;
            return false;
        }
        if (property.startsWith("DirectlyAbove")) {
            CardCollectionView cards = card.getOwner().getCardsIn(ZoneType.Graveyard);
            if (cards.indexOf(card) - cards.indexOf(source) == 1) return true;
            return false;
        }
        if (property.startsWith("TopGraveyardCreature")) {
            CardCollection cards = CardLists.filter((Iterable<Card>)card.getOwner().getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES);
            Collections.reverse(cards);
            if (cards.isEmpty()) return false;
            if (card.equals(cards.get(false))) return true;
            return false;
        }
        if (property.startsWith("TopGraveyard")) {
            CardCollection cards = new CardCollection(card.getOwner().getCardsIn(ZoneType.Graveyard));
            Collections.reverse(cards);
            if (property.substring(12).matches("[0-9][0-9]?")) {
                int n = Integer.parseInt(property.substring(12));
                int num = Math.min(n, cards.size());
                CardCollection newlist = new CardCollection();
                for (int i = 0; i < num; ++i) {
                    newlist.add((Card)cards.get(i));
                }
                if (cards.isEmpty()) return false;
                if (newlist.contains(card)) return true;
                return false;
            }
            if (cards.isEmpty()) return false;
            if (card.equals(cards.get(false))) return true;
            return false;
        }
        if (property.startsWith("BottomGraveyard")) {
            CardCollectionView cards = card.getOwner().getCardsIn(ZoneType.Graveyard);
            if (cards.isEmpty()) return false;
            if (card.equals(cards.get(false))) return true;
            return false;
        }
        if (property.startsWith("TopLibraryLand")) {
            CardCollection cards = CardLists.filter((Iterable<Card>)card.getOwner().getCardsIn(ZoneType.Library), CardPredicates.Presets.LANDS);
            if (cards.isEmpty()) return false;
            if (card.equals(cards.get(false))) return true;
            return false;
        }
        if (property.startsWith("TopLibrary")) {
            CardCollectionView cards = card.getOwner().getCardsIn(ZoneType.Library);
            if (cards.isEmpty()) return false;
            if (card.equals(cards.get(false))) return true;
            return false;
        }
        if (property.startsWith("BottomLibrary")) {
            CardCollection cards = new CardCollection(card.getOwner().getCardsIn(ZoneType.Library));
            if (property.startsWith("BottomLibrary_")) {
                cards = CardLists.getValidCards((Iterable<Card>)cards, property.substring(14), sourceController, source, spellAbility);
            }
            Collections.reverse(cards);
            if (cards.isEmpty()) return false;
            if (card.equals(cards.get(false))) return true;
            return false;
        }
        if (property.startsWith("Cloned")) {
            if (card.getCloneOrigin() == null) return false;
            if (card.getCloneOrigin().equals(source)) return true;
            return false;
        }
        if (property.startsWith("SharesCMCWith")) {
            if (property.equals("SharesCMCWith")) {
                if (card.sharesCMCWith(source)) return true;
                return false;
            }
            String restriction = property.split("SharesCMCWith ")[1];
            CardCollection cardCollection = AbilityUtils.getDefinedCards(source, restriction, spellAbility);
            return Iterables.any(cardCollection, CardPredicates.sharesCMCWith(card));
        }
        if (property.startsWith("SharesColorWith")) {
            String restriction;
            if (card.isColorless()) {
                return false;
            }
            if (property.equals("SharesColorWith")) {
                if (card.sharesColorWith(source)) return true;
                return false;
            }
            if (property.startsWith("SharesColorWithOther")) {
                String restriction2 = property.split("SharesColorWithOther ")[1];
                CardCollection cardCollection = AbilityUtils.getDefinedCards(source, restriction2, spellAbility);
                cardCollection.remove(card);
                return Iterables.any(cardCollection, CardPredicates.sharesColorWith(card));
            }
            switch (restriction = property.split("SharesColorWith ")[1]) {
                case "MostProminentColor": {
                    byte mask = CardFactoryUtil.getMostProminentColors(game.getCardsIn(ZoneType.Battlefield));
                    if (card.getColor().hasAnyColor(mask)) return true;
                    return false;
                }
                case "LastCastThisTurn": {
                    List<Card> c6 = game.getStack().getSpellsCastThisTurn();
                    if (c6.isEmpty()) return false;
                    if (card.sharesColorWith(c6.get(c6.size() - 1))) return true;
                    return false;
                }
                case "ActivationColor": {
                    SpellAbilityStackInstance castSA = game.getStack().getInstanceMatchingSpellAbilityID((SpellAbility)spellAbility);
                    if (castSA == null) {
                        return false;
                    }
                    List<Mana> payingMana = castSA.getSpellAbility().getPayingMana();
                    if (payingMana.isEmpty()) return false;
                    if (card.getColor().hasAnyColor(payingMana.get(0).getColor())) return true;
                    return false;
                }
                case "TriggeredProduced": {
                    SpellAbility root = ((SpellAbility)spellAbility).getRootAbility();
                    Object prod = root.getTriggeringObject(AbilityKey.Produced);
                    if (!(prod instanceof String)) {
                        return false;
                    }
                    String produced = (String)prod;
                    ColorSet cs = ColorSet.fromNames(produced.split(" "));
                    if (card.getColor().hasAnyColor(cs.getColor())) return true;
                    return false;
                }
                default: {
                    if (Iterables.any(AbilityUtils.getDefinedCards(source, restriction, spellAbility), CardPredicates.sharesColorWith(card))) return true;
                    return false;
                }
            }
        }
        if (property.startsWith("MostProminentColor")) {
            String[] props = property.split(" ");
            if (props.length == 1) {
                System.out.println("WARNING! Using MostProminentColor property without a color.");
                return false;
            }
            String string = props[1];
            byte mostProm = CardFactoryUtil.getMostProminentColors(game.getCardsIn(ZoneType.Battlefield));
            return ColorSet.fromMask(mostProm).hasAnyColor(MagicColor.fromName(string));
        }
        if (property.startsWith("MostProminentCreatureTypeInLibrary")) {
            String s2;
            CardCollectionView list = sourceController.getCardsIn(ZoneType.Library);
            Iterator<String> iterator = CardFactoryUtil.getMostProminentCreatureType(list).iterator();
            do {
                if (!iterator.hasNext()) return true;
                s2 = iterator.next();
            } while (card.getType().hasCreatureType(s2));
            return false;
        }
        if (property.equals("Party")) {
            String t2;
            boolean isParty = false;
            HashSet<String> hashSet = Sets.newHashSet("Cleric", "Rogue", "Warrior", "Wizard");
            Set<String> cTypes = card.getType().getCreatureTypes();
            Iterator mask = hashSet.iterator();
            do {
                if (!mask.hasNext()) return isParty;
            } while (!cTypes.contains(t2 = (String)mask.next()));
            return true;
        }
        if (property.startsWith("sharesCreatureTypeWith")) {
            String restriction;
            if (property.equals("sharesCreatureTypeWith")) {
                if (card.sharesCreatureTypeWith(source)) return true;
                return false;
            }
            switch (restriction = property.split(" ", 2)[1]) {
                case "Commander": {
                    Card cmdr;
                    List<Card> cmdrs = sourceController.getCommanders();
                    Iterator<Card> t2 = cmdrs.iterator();
                    do {
                        if (!t2.hasNext()) return false;
                        cmdr = t2.next();
                    } while ((cmdr = game.getCardState(cmdr)).getZone().getZoneType().isHidden() || cmdr.isPhasedOut() || !card.sharesCreatureTypeWith(cmdr));
                    return true;
                }
            }
            CardCollection def = AbilityUtils.getDefinedCards(source, restriction, spellAbility);
            if (property.contains("WithAll")) {
                if (Iterables.all(def, CardPredicates.sharesCreatureTypeWith(card))) return true;
                return false;
            }
            if (Iterables.any(def, CardPredicates.sharesCreatureTypeWith(card))) return true;
            return false;
        }
        if (property.startsWith("sharesCardTypeWith")) {
            String restriction;
            if (property.equals("sharesCardTypeWith")) {
                if (card.sharesCardTypeWith(source)) return true;
                return false;
            }
            if (property.startsWith("sharesCardTypeWithOther")) {
                String restriction3 = property.split("sharesCardTypeWithOther ")[1];
                CardCollection cardCollection = AbilityUtils.getDefinedCards(source, restriction3, spellAbility);
                cardCollection.remove(card);
                return Iterables.any(cardCollection, CardPredicates.sharesCardTypeWith(card));
            }
            switch (restriction = property.split("sharesCardTypeWith ")[1]) {
                case "Imprinted": {
                    if (!source.hasImprintedCard()) return false;
                    if (card.sharesCardTypeWith(Iterables.getFirst(source.getImprintedCards(), null))) return true;
                    return false;
                }
                case "EachTopLibrary": {
                    Card c7;
                    CardCollection cards2 = new CardCollection();
                    for (Player p : game.getPlayers()) {
                        Card top = (Card)p.getCardsIn(ZoneType.Library).get(false);
                        cards2.add(top);
                    }
                    Iterator def = cards2.iterator();
                    do {
                        if (!def.hasNext()) return false;
                    } while (!card.sharesCardTypeWith(c7 = (Card)def.next()));
                    return true;
                }
                default: {
                    if (Iterables.any(AbilityUtils.getDefinedCards(source, restriction, spellAbility), CardPredicates.sharesCardTypeWith(card))) return true;
                    return false;
                }
            }
        }
        if (property.startsWith("sharesAllCardTypesWithOther")) {
            String restriction = property.split("sharesAllCardTypesWithOther ")[1];
            CardCollection cardCollection = AbilityUtils.getDefinedCards(source, restriction, spellAbility);
            cardCollection.remove(card);
            return Iterables.any(cardCollection, CardPredicates.sharesAllCardTypesWith(card));
        }
        if (property.startsWith("sharesLandTypeWith")) {
            String restriction = property.split("sharesLandTypeWith ")[1];
            if (Iterables.any(AbilityUtils.getDefinedCards(source, restriction, spellAbility), CardPredicates.sharesLandTypeWith(card))) return true;
            return false;
        }
        if (property.equals("sharesPermanentTypeWith")) {
            if (card.sharesPermanentTypeWith(source)) return true;
            return false;
        }
        if (property.equals("canProduceSameManaTypeWith")) {
            if (card.canProduceSameManaTypeWith(source)) return true;
            return false;
        }
        if (property.startsWith("canProduceManaColor")) {
            SpellAbility ma;
            String color = property.split("canProduceManaColor ")[1];
            Iterator iterator = card.getManaAbilities().iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(ma = (SpellAbility)iterator.next()).canProduce(MagicColor.toShortString(color)));
            return true;
        }
        if (property.equals("canProduceMana")) {
            if (card.getManaAbilities().isEmpty()) return false;
            return true;
        }
        if (property.startsWith("sameName")) {
            if (card.sharesNameWith(source)) return true;
            return false;
        }
        if (property.startsWith("sharesNameWith")) {
            if (property.equals("sharesNameWith")) {
                if (card.sharesNameWith(source)) return true;
                return false;
            }
            String restriction = property.split("sharesNameWith ")[1];
            if (restriction.equals("YourGraveyard")) {
                return Iterables.any(sourceController.getCardsIn(ZoneType.Graveyard), CardPredicates.sharesNameWith(card));
            }
            if (restriction.equals(ZoneType.Graveyard.toString())) {
                return Iterables.any(game.getCardsIn(ZoneType.Graveyard), CardPredicates.sharesNameWith(card));
            }
            if (restriction.equals(ZoneType.Battlefield.toString())) {
                return Iterables.any(game.getCardsIn(ZoneType.Battlefield), CardPredicates.sharesNameWith(card));
            }
            if (restriction.equals("ThisTurnCast")) {
                return Iterables.any(CardUtil.getThisTurnCast("Card", source, spellAbility, sourceController), CardPredicates.sharesNameWith(card));
            }
            if (restriction.equals("MovedToGrave")) {
                String name;
                if (spellAbility instanceof SpellAbility) return false;
                SpellAbility spellAbility3 = ((SpellAbility)spellAbility).getRootAbility();
                if (spellAbility3 == null) return false;
                if (spellAbility3.getPaidList("MovedToGrave", true) == null) return false;
                if (spellAbility3.getPaidList("MovedToGrave", true).isEmpty()) return false;
                CardCollection cards = spellAbility3.getPaidList("MovedToGrave", true);
                Iterator cards2 = cards.iterator();
                do {
                    if (!cards2.hasNext()) return false;
                    Card c8 = (Card)cards2.next();
                    name = c8.getName();
                    if (!StringUtils.isEmpty(name)) continue;
                    name = c8.getPaperCard().getName();
                } while (!card.getName().equals(name));
                return true;
            }
            if (restriction.equals("NonToken")) {
                if (CardLists.filter(game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.NON_TOKEN, CardPredicates.sharesNameWith(card)).isEmpty()) return false;
                return true;
            }
            if (restriction.equals("TriggeredCard")) {
                if (spellAbility instanceof SpellAbility) {
                    Card card5 = (Card)((SpellAbility)spellAbility).getRootAbility().getTriggeringObject(AbilityKey.Card);
                    if (card5 == null) return false;
                    if (!card.sharesNameWith(card5)) return false;
                    return true;
                }
                System.out.println("Looking at TriggeredCard but no SA?");
                return false;
            }
            if (Iterables.any(AbilityUtils.getDefinedCards(source, restriction, spellAbility), CardPredicates.sharesNameWith(card))) return true;
            return false;
        }
        if (property.startsWith("doesNotShareNameWith")) {
            if (property.equals("doesNotShareNameWith")) {
                if (!card.sharesNameWith(source)) return true;
                return false;
            }
            String restriction = property.split("doesNotShareNameWith ")[1];
            if (restriction.startsWith("Remembered") || restriction.startsWith("Imprinted")) {
                CardCollection cardCollection = AbilityUtils.getDefinedCards(source, restriction, spellAbility);
                if (Iterables.any(cardCollection, CardPredicates.sharesNameWith(card))) return false;
                return true;
            }
            if (restriction.equals("YourGraveyard")) {
                if (Iterables.any(sourceController.getCardsIn(ZoneType.Graveyard), CardPredicates.sharesNameWith(card))) return false;
                return true;
            }
            if (restriction.equals("OtherYourBattlefield")) {
                CardCollection cardCollection = CardLists.filter((Iterable<Card>)sourceController.getCardsIn(ZoneType.Battlefield), CardPredicates.sharesNameWith(card));
                if (cardCollection.size() != 1) return cardCollection.isEmpty();
                Card c9 = (Card)cardCollection.getFirst();
                if (!c9.equalsWithGameTimestamp(card)) return cardCollection.isEmpty();
                cardCollection.remove(card);
                return cardCollection.isEmpty();
            }
            CardCollection cardCollection = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), restriction, sourceController, source, spellAbility);
            if (Iterables.any(cardCollection, CardPredicates.sharesNameWith(card))) return false;
            return true;
        }
        if (property.startsWith("sharesControllerWith")) {
            if (property.equals("sharesControllerWith")) {
                if (card.sharesControllerWith(source)) return true;
                return false;
            }
            String restriction = property.split("sharesControllerWith ")[1];
            CardCollection cardCollection = AbilityUtils.getDefinedCards(source, restriction, spellAbility);
            if (Iterables.any(cardCollection, CardPredicates.sharesControllerWith(card))) return true;
            return false;
        }
        if (property.startsWith("sharesOwnerWith")) {
            if (property.equals("sharesOwnerWith")) {
                if (card.getOwner().equals(source.getOwner())) return true;
                return false;
            }
            String restriction = property.split("sharesOwnerWith ")[1];
            CardCollection cardCollection = AbilityUtils.getDefinedCards(source, restriction, spellAbility);
            if (Iterables.all(cardCollection, CardPredicates.isOwner(card.getOwner()))) return true;
            return false;
        }
        if (property.startsWith("SecondSpellCastThisTurn")) {
            List<Card> cards = CardUtil.getThisTurnCast("Card", source, spellAbility, sourceController);
            if (cards.size() < 2) {
                return false;
            }
            if (cards.get(1).equalsWithGameTimestamp(card)) return true;
            return false;
        }
        if (property.equals("ThisTurnCast")) {
            Card card6;
            Iterator<Card> cards = CardUtil.getThisTurnCast("Card", source, spellAbility, sourceController).iterator();
            do {
                if (!cards.hasNext()) return false;
            } while (!card.equals(card6 = cards.next()));
            return true;
        }
        if (property.startsWith("EnteredUnder")) {
            Player u = card.getTurnInController();
            if (u == null) {
                return false;
            }
            String string = property.substring(13);
            if (u.isValid(string, sourceController, source, spellAbility)) return true;
            PlayerCollection lp = AbilityUtils.getDefinedPlayers(source, string, spellAbility);
            if (lp.contains(u)) return true;
            return false;
        }
        if (property.equals("EnteredSinceYourLastTurn")) {
            if (card.getTurnInZone() > sourceController.getLastTurnNr()) return true;
            return false;
        }
        if (property.startsWith("ThisTurnEnteredFrom")) {
            String restrictions = property.split("ThisTurnEnteredFrom_")[1];
            String[] stringArray = restrictions.split("_");
            ZoneType origin = ZoneType.smartValueOf(stringArray[0]);
            if (card.getTurnInZone() != game.getPhaseHandler().getTurn()) {
                return false;
            }
            if (card.getZone().isCardAddedThisTurn(card, origin)) return true;
            return false;
        }
        if (property.startsWith("ThisTurnEntered")) {
            if (card.getTurnInZone() != game.getPhaseHandler().getTurn()) {
                return false;
            }
            if (property.equals("ThisTurnEntered")) return true;
            boolean your = property.contains("Your");
            ZoneType zoneType = ZoneType.smartValueOf(property.substring(your ? 19 : 15));
            PlayerZone z = sourceController.getZone(zoneType);
            if (!z.getCardsAddedThisTurn(null).contains(card)) {
                return false;
            }
            if (!your) return true;
            if (card.getOwner().equals(sourceController)) return true;
            return false;
        }
        if (property.equals("DiscardedThisTurn")) {
            if (card.getTurnInZone() != game.getPhaseHandler().getTurn()) {
                return false;
            }
            if (card.wasDiscarded()) return true;
            return false;
        }
        if (property.equals("surveilledThisTurn")) {
            if (card.getTurnInZone() != game.getPhaseHandler().getTurn()) {
                return false;
            }
            if (card.wasSurveilled()) return true;
            return false;
        }
        if (property.equals("milledThisTurn")) {
            if (card.getTurnInZone() != game.getPhaseHandler().getTurn()) {
                return false;
            }
            if (card.wasMilled()) return true;
            return false;
        }
        if (property.equals("hasABasicLandType")) {
            if (card.hasABasicLandType()) return true;
            return false;
        }
        if (property.equals("hasANonBasicLandType")) {
            if (card.hasANonBasicLandType()) return true;
            return false;
        }
        if (property.startsWith("hasKeyword")) {
            if (card.hasKeyword(property.substring(10))) return true;
            return false;
        }
        if (property.startsWith("with")) {
            if (property.startsWith("without") && card.hasStartOfUnHiddenKeyword(property.substring(7))) {
                return false;
            }
            if (property.startsWith("without")) return true;
            if (card.hasStartOfUnHiddenKeyword(property.substring(4))) return true;
            return false;
        }
        if (property.startsWith("activated")) {
            if (card.activatedThisTurn()) return true;
            return false;
        }
        if (property.startsWith("tapped")) {
            if (card.isTapped()) return true;
            return false;
        }
        if (property.startsWith("untapped")) {
            if (card.isUntapped()) return true;
            return false;
        }
        if (property.startsWith("faceDown")) {
            if (card.isFaceDown()) return true;
            return false;
        }
        if (property.startsWith("faceUp")) {
            if (!card.isFaceDown()) return true;
            return false;
        }
        if (property.startsWith("turnedFaceUpThisTurn")) {
            if (card.wasTurnedFaceUpThisTurn()) return true;
            return false;
        }
        if (property.startsWith("phasedOut")) {
            if (card.isPhasedOut()) return true;
            return false;
        }
        if (property.startsWith("phasedIn")) {
            if (!card.isPhasedOut()) return true;
            return false;
        }
        if (property.equals("manifested")) {
            if (card.isManifested()) return true;
            return false;
        }
        if (property.equals("cloaked")) {
            if (card.isCloaked()) return true;
            return false;
        }
        if (property.startsWith("DrawnThisTurn")) {
            if (card.getDrawnThisTurn()) return true;
            return false;
        }
        if (property.startsWith("FoughtThisTurn")) {
            if (card.getFoughtThisTurn()) return true;
            return false;
        }
        if (property.startsWith("firstTurnControlled")) {
            if (card.isFirstTurnControlled()) return true;
            return false;
        }
        if (property.startsWith("startedTheTurnUntapped")) {
            if (card.hasStartedTheTurnUntapped()) return true;
            return false;
        }
        if (property.startsWith("cameUnderControlSinceLastUpkeep")) {
            if (card.cameUnderControlSinceLastUpkeep()) return true;
            return false;
        }
        if (property.equals("attackedOrBlockedSinceYourLastUpkeep")) {
            if (card.getDamageHistory().hasAttackedSinceLastUpkeepOf(sourceController)) return true;
            if (card.getDamageHistory().hasBlockedSinceLastUpkeepOf(sourceController)) return true;
            return false;
        }
        if (property.equals("blockedOrBeenBlockedSinceYourLastUpkeep")) {
            if (card.getDamageHistory().hasBeenBlockedSinceLastUpkeepOf(sourceController)) return true;
            if (card.getDamageHistory().hasBlockedSinceLastUpkeepOf(sourceController)) return true;
            return false;
        }
        if (property.startsWith("DamagedBy")) {
            String prop = property.substring("DamagedBy".length());
            Object var10_155 = null;
            if (prop.startsWith(" ")) {
                CardCollection cardCollection = AbilityUtils.getDefinedCards(source, prop.substring(1), spellAbility);
            }
            boolean found = false;
            for (Pair<Integer, Boolean> p : card.getDamageReceivedThisTurn()) {
                void var10_157;
                Card dmgSource = game.getDamageLKI(p).getLeft();
                if (var10_157 != null) {
                    for (Card c10 : var10_157) {
                        if (!dmgSource.equalsWithGameTimestamp(c10)) continue;
                        found = true;
                    }
                } else {
                    if (prop.isEmpty() && dmgSource.equalsWithGameTimestamp(source)) {
                        return true;
                    }
                    if (dmgSource.isValid(prop.split(","), sourceController, source, spellAbility)) {
                        return true;
                    }
                }
                if (!found) continue;
                break;
            }
            if (found) return true;
            return false;
        }
        if (property.equals("isDamaged")) {
            if (card.getDamage() > 0) return true;
            return false;
        }
        if (property.startsWith("Damaged")) {
            boolean found = false;
            for (Pair<Integer, Boolean> p : source.getDamageReceivedThisTurn()) {
                if (!game.getDamageLKI(p).getLeft().equalsWithGameTimestamp(card)) continue;
                return true;
            }
            if (found) return true;
            return false;
        }
        if (property.startsWith("dealtCombatDamageThisCombat")) {
            if (!card.getDamageHistory().getThisCombatDamaged().isEmpty()) return true;
            return false;
        }
        if (property.startsWith("dealtDamageToYouThisTurn")) {
            if (card.getDamageHistory().getDamageDoneThisTurn(null, true, null, "You", card, sourceController, spellAbility) != 0) return true;
            return false;
        }
        if (property.startsWith("dealtDamageToOppThisTurn")) {
            if (card.hasDealtDamageToOpponentThisTurn()) return true;
            return false;
        }
        if (property.startsWith("dealtCombatDamageThisTurn")) {
            if (card.getDamageHistory().getDamageDoneThisTurn(true, true, null, property.split(" ")[1], card, sourceController, spellAbility) != 0) return true;
            return false;
        }
        if (property.startsWith("controllerWasDealtCombatDamageByThisTurn")) {
            if (source.getDamageHistory().getDamageDoneThisTurn(true, true, null, "You", card, controller, spellAbility) != 0) return true;
            return false;
        }
        if (property.startsWith("controllerWasDealtDamageByThisTurn")) {
            if (source.getDamageHistory().getDamageDoneThisTurn(null, true, null, "You", card, controller, spellAbility) != 0) return true;
            return false;
        }
        if (property.startsWith("wasDealtDamageThisTurn")) {
            if (card.getAssignedDamage() != 0) return true;
            return false;
        }
        if (property.equals("wasDealtNonCombatDamageThisTurn")) {
            if (card.getAssignedDamage(false, null) != 0) return true;
            return false;
        }
        if (property.startsWith("wasDealtExcessDamageThisTurn")) {
            if (card.hasBeenDealtExcessDamageThisTurn()) return true;
            return false;
        }
        if (property.startsWith("wasDealtDamageByThisGame")) {
            int idx = source.getDamageHistory().getThisGameDamaged().indexOf(card);
            if (idx == -1) {
                return false;
            }
            Card card7 = (Card)source.getDamageHistory().getThisGameDamaged().get((GameEntity)idx);
            if (card7.equalsWithGameTimestamp(game.getCardState(card))) return true;
            return false;
        }
        if (property.startsWith("dealtDamageThisTurn")) {
            if (card.getTotalDamageDoneBy() != 0) return true;
            return false;
        }
        if (property.startsWith("dealtDamagetoAny")) {
            return card.getDamageHistory().getHasdealtDamagetoAny();
        }
        if (property.startsWith("attackedThisTurn")) {
            if (card.getDamageHistory().getCreatureAttacksThisTurn() != 0) return true;
            return false;
        }
        if (property.startsWith("attackedBattleThisTurn")) {
            if (card.getDamageHistory().hasAttackedBattleThisTurn()) return true;
            return false;
        }
        if (property.startsWith("attackedYouThisTurn")) {
            if (card.getDamageHistory().hasAttackedThisTurn(sourceController)) return true;
            return false;
        }
        if (property.startsWith("attackedLastTurn")) {
            return card.getDamageHistory().getCreatureAttackedLastTurnOf(controller);
        }
        if (property.startsWith("blockedThisTurn")) {
            if (!card.getBlockedThisTurn().isEmpty()) return true;
            return false;
        }
        if (property.startsWith("notExertedThisTurn")) {
            if (card.getExertedThisTurn() <= 0) return true;
            return false;
        }
        if (property.startsWith("gotBlockedThisTurn")) {
            if (!card.getBlockedByThisTurn().isEmpty()) return true;
            return false;
        }
        if (property.startsWith("notAttackedThisTurn")) {
            if (card.getDamageHistory().getCreatureAttacksThisTurn() <= 0) return true;
            return false;
        }
        if (property.startsWith("greatestPower")) {
            Card crd;
            PlayerCollection playerCollection;
            CardCollection cards = CardLists.filter((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES);
            if (property.contains("ControlledBy") && !(cards = CardLists.filterControlledBy((Iterable<Card>)cards, playerCollection = AbilityUtils.getDefinedPlayers(source, property.split("ControlledBy")[1], spellAbility))).contains(card)) {
                return false;
            }
            Iterator iterator = cards.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while ((crd = (Card)iterator.next()).getNetPower() <= card.getNetPower());
            return false;
        }
        if (property.startsWith("yardGreatestPower")) {
            Card crd;
            CardCollection cards = CardLists.filter((Iterable<Card>)sourceController.getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES);
            Iterator iterator = cards.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while ((crd = (Card)iterator.next()).getNetPower() <= card.getNetPower());
            return false;
        }
        if (property.startsWith("leastPower")) {
            Card crd;
            PlayerCollection playerCollection;
            CardCollection cards = CardLists.filter((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES);
            if (property.contains("ControlledBy") && !(cards = CardLists.filterControlledBy((Iterable<Card>)cards, playerCollection = AbilityUtils.getDefinedPlayers(source, property.split("ControlledBy")[1], spellAbility))).contains(card)) {
                return false;
            }
            Iterator iterator = cards.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while ((crd = (Card)iterator.next()).getNetPower() >= card.getNetPower());
            return false;
        }
        if (property.startsWith("leastToughness")) {
            Card crd;
            PlayerCollection playerCollection;
            CardCollection cards = CardLists.filter((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES);
            if (property.contains("ControlledBy") && !(cards = CardLists.filterControlledBy((Iterable<Card>)cards, playerCollection = AbilityUtils.getDefinedPlayers(source, property.split("ControlledBy")[1], spellAbility))).contains(card)) {
                return false;
            }
            Iterator iterator = cards.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while ((crd = (Card)iterator.next()).getNetToughness() >= card.getNetToughness());
            return false;
        }
        if (property.startsWith("greatestCMC_")) {
            void var10_169;
            CardCollectionView cards = game.getCardsIn(ZoneType.Battlefield);
            String string = property.substring("greatestCMC_".length());
            if (string.contains("ControlledBy")) {
                String string2 = string.split("ControlledBy")[0];
                PlayerCollection p = AbilityUtils.getDefinedPlayers(source, property.split("ControlledBy")[1], null);
                cards = CardLists.filterControlledBy((Iterable<Card>)cards, p);
            }
            cards = "NonLandPermanent".equals(var10_169) ? CardLists.filter((Iterable<Card>)cards, CardPredicates.Presets.NONLAND_PERMANENTS) : CardLists.getType(cards, (String)var10_169);
            cards = CardLists.getCardsWithHighestCMC(cards);
            if (cards.contains(card)) return true;
            return false;
        }
        if (property.startsWith("greatestRememberedCMC")) {
            CardCollection cards = new CardCollection();
            for (Object o : source.getRemembered()) {
                if (!(o instanceof Card)) continue;
                cards.add(game.getCardState((Card)o));
            }
            if (!cards.contains(card)) {
                return false;
            }
            if ((cards = CardLists.getCardsWithHighestCMC(cards)).contains(card)) return true;
            return false;
        }
        if (property.startsWith("lowestRememberedCMC")) {
            CardCollection cards = new CardCollection();
            for (Object o : source.getRemembered()) {
                if (!(o instanceof Card)) continue;
                cards.add(game.getCardState((Card)o));
            }
            if (!cards.contains(card)) {
                return false;
            }
            if ((cards = CardLists.getCardsWithLowestCMC(cards)).contains(card)) return true;
            return false;
        }
        if (property.startsWith("lowestCMC")) {
            Card crd;
            CardCollectionView cards = game.getCardsIn(ZoneType.Battlefield);
            Iterator iterator = cards.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while ((crd = (Card)iterator.next()).isLand() || crd.isImmutable() || crd.getCMC() >= card.getCMC());
            return false;
        }
        if (property.startsWith("enchanted")) {
            if (card.isEnchanted()) return true;
            return false;
        }
        if (property.startsWith("unenchanted")) {
            if (!card.isEnchanted()) return true;
            return false;
        }
        if (property.startsWith("enchanting")) {
            if (card.isEnchanting()) return true;
            return false;
        }
        if (property.startsWith("equipped")) {
            if (card.isEquipped()) return true;
            return false;
        }
        if (property.startsWith("unequipped")) {
            if (!card.isEquipped()) return true;
            return false;
        }
        if (property.startsWith("equipping")) {
            if (card.isEquipping()) return true;
            return false;
        }
        if (property.startsWith("modified")) {
            if (card.isModified()) return true;
            return false;
        }
        if (property.startsWith("token")) {
            if (!card.isToken() && !card.isTokenCard()) {
                return false;
            }
            if (!property.contains("Created")) return true;
            if (card.getCastSA() == null) return true;
            return false;
        }
        if (property.startsWith("nonToken")) {
            if (card.isToken()) return false;
            if (!card.isTokenCard()) return true;
            return false;
        }
        if (property.startsWith("copiedSpell")) {
            if (card.isCopiedSpell()) return true;
            return false;
        }
        if (property.startsWith("hasXCost")) {
            ManaCost cost = card.getManaCost();
            if (cost == null) return false;
            if (cost.countX() > 0) return true;
            return false;
        }
        if (property.startsWith("suspended")) {
            if (card.hasSuspend()) return true;
            return false;
        }
        if (property.startsWith("delved")) {
            if (source.getDelved().contains(card)) return true;
            return false;
        }
        if (property.startsWith("convoked")) {
            if (source.getConvoked().contains(card)) return true;
            return false;
        }
        if (property.startsWith("exploited")) {
            if (source.getExploited().contains(card)) return true;
            return false;
        }
        if (property.startsWith("equalPT")) {
            if (card.getNetPower() == card.getNetToughness()) return true;
            return false;
        }
        if (property.equals("powerGTtoughness")) {
            if (card.getNetPower() > card.getNetToughness()) return true;
            return false;
        }
        if (property.equals("powerGTbasePower")) {
            if (card.getNetPower() > card.getCurrentPower()) return true;
            return false;
        }
        if (property.equals("powerNOTbasePower")) {
            if (card.getNetPower() != card.getCurrentPower()) return true;
            return false;
        }
        if (property.equals("powerLTtoughness")) {
            if (card.getNetPower() < card.getNetToughness()) return true;
            return false;
        }
        if (property.equals("cmcEven")) {
            if (card.getCMC() % 2 == 0) return true;
            return false;
        }
        if (property.equals("cmcOdd")) {
            if (card.getCMC() % 2 == 1) return true;
            return false;
        }
        if (property.equals("powerEven")) {
            if (card.getNetPower() % 2 == 0) return true;
            return false;
        }
        if (property.equals("powerOdd")) {
            if (card.getNetPower() % 2 == 1) return true;
            return false;
        }
        if (property.equals("cmcChosenEvenOdd")) {
            if (!source.hasChosenEvenOdd()) {
                return false;
            }
            if (card.getCMC() % 2 == 0 == (source.getChosenEvenOdd() == EvenOdd.Even)) return true;
            return false;
        }
        if (property.equals("cmcNotChosenEvenOdd")) {
            if (!source.hasChosenEvenOdd()) {
                return false;
            }
            if (card.getCMC() % 2 == 0 != (source.getChosenEvenOdd() == EvenOdd.Even)) return true;
            return false;
        }
        if (property.equals("cmcChosen")) {
            if (!source.hasChosenNumber()) {
                return false;
            }
            if (card.getCMC() == source.getChosenNumber().intValue()) return true;
            return false;
        }
        if (property.startsWith("power") || property.startsWith("toughness") || property.startsWith("cmc") || property.startsWith("totalPT") || property.startsWith("numColors") || property.startsWith("basePower") || property.startsWith("baseToughness") || property.startsWith("numTypes")) {
            void var10_182;
            boolean bl = false;
            String rhs = "";
            if (property.startsWith("power")) {
                rhs = property.substring(7);
                int n = card.getNetPower();
            } else if (property.startsWith("basePower")) {
                rhs = property.substring(11);
                int n = card.getCurrentPower();
            } else if (property.startsWith("toughness")) {
                rhs = property.substring(11);
                int n = card.getNetToughness();
            } else if (property.startsWith("baseToughness")) {
                rhs = property.substring(15);
                int n = card.getCurrentToughness();
            } else if (property.startsWith("cmc")) {
                rhs = property.substring(5);
                int n = card.getCMC();
            } else if (property.startsWith("totalPT")) {
                rhs = property.substring(10);
                int n = card.getNetPower() + card.getNetToughness();
            } else if (property.startsWith("numColors")) {
                rhs = property.substring(11);
                int n = card.getColor().countColors();
            } else if (property.startsWith("numTypes")) {
                rhs = property.substring(10);
                int n = Iterables.size(card.getType().getCoreTypes());
            }
            int x = AbilityUtils.calculateAmount(source, rhs, spellAbility);
            if (Expressions.compare((int)var10_182, property, x)) return true;
            return false;
        }
        if (property.startsWith("ManaCost")) {
            if (card.getManaCost().getShortString().equals(property.substring(8))) return true;
            return false;
        }
        if (property.equals("HasCounters")) {
            if (card.hasCounters()) return true;
            return false;
        }
        if (property.equals("NoCounters")) {
            if (!card.hasCounters()) return true;
            return false;
        }
        if (property.startsWith("counters")) {
            String[] splitProperty = property.split("_");
            String string = splitProperty[1].substring(2);
            String comparator = splitProperty[1].substring(0, 2);
            String counterType = splitProperty[2];
            int number = AbilityUtils.calculateAmount(source, string, spellAbility);
            int actualnumber = card.getCounters(CounterType.getType(counterType));
            if (Expressions.compare(actualnumber, comparator, number)) return true;
            return false;
        }
        if (property.startsWith("attacking")) {
            GameEntity gameEntity;
            GameEntity attacked;
            if (null == combat) {
                return false;
            }
            if (!(property.contains("LKI") ? lki : card).isAttacking()) {
                return false;
            }
            if (property.equals("attacking")) {
                return true;
            }
            if (property.endsWith("Alone")) {
                if (CardLists.count(card.getGame().getLastStateBattlefield(), Card::isAttacking) != 1) return false;
                return true;
            }
            if (property.equals("attackingYou")) {
                return combat.isAttacking(card, sourceController);
            }
            if (property.equals("attackingSame") && !combat.isAttacking(card, attacked = combat.getDefenderByAttacker(source))) {
                return false;
            }
            if (property.equals("attackingBattle")) {
                attacked = combat.getDefenderByAttacker(source);
                if (!(attacked instanceof Card)) {
                    return false;
                }
                if (!((Card)attacked).isBattle()) {
                    return false;
                }
            }
            if (property.startsWith("attackingYouOrYourPW")) {
                GameEntity defender = combat.getDefenderByAttacker(card);
                if (defender instanceof Card) {
                    if (!((Card)defender).isPlaneswalker()) {
                        return false;
                    }
                    defender = ((Card)defender).getController();
                }
                if (!sourceController.equals(defender)) {
                    return false;
                }
            }
            if (!property.startsWith("attacking ")) return true;
            FCollection<GameEntity> defined = AbilityUtils.getDefinedEntities(source, property.split(" ")[1], spellAbility);
            if (defined.contains(gameEntity = combat.getDefenderByAttacker(card))) return true;
            return false;
        }
        if (property.startsWith("notattacking")) {
            if (null == combat) return true;
            if (combat.isAttacking(card)) return false;
            return true;
        }
        if (property.startsWith("enlistedThisCombat")) {
            if (card.getEnlistedThisCombat()) return true;
            return false;
        }
        if (property.startsWith("attackedThisCombat")) {
            if (null == combat) return false;
            if (card.getDamageHistory().getCreatureAttackedThisCombat() == 0) {
                return false;
            }
            if (property.length() <= 18) return true;
            int x = AbilityUtils.calculateAmount(source, property.substring(21), spellAbility);
            if (Expressions.compare(card.getDamageHistory().getCreatureAttackedThisCombat(), property, x)) return true;
            return false;
        }
        if (property.equals("blockedThisCombat")) {
            if (null == combat) return false;
            if (card.getDamageHistory().getCreatureBlockedThisCombat()) return true;
            return false;
        }
        if (property.equals("attackedBySourceThisCombat")) {
            if (null == combat) {
                return false;
            }
            GameEntity defender = combat.getDefenderByAttacker(source);
            if (!(defender instanceof Card)) return true;
            if (card.equals(defender)) return true;
            return false;
        }
        if (property.startsWith("blocking")) {
            Card c11;
            if (combat == null) return false;
            if (!combat.isBlocking(card)) {
                return false;
            }
            String what = property.substring("blocking".length());
            if (what.endsWith("Alone")) {
                if (CardLists.count(card.getGame().getLastStateBattlefield(), c -> c.getCombatLKI() != null && !c.getCombatLKI().isAttacker) != 1) return false;
                return true;
            }
            if (what.startsWith("Source")) {
                return combat.isBlocking(card, source);
            }
            if (what.startsWith("CreatureYouCtrl")) {
                Card c12;
                Iterator iterator = sourceController.getCreaturesInPlay().iterator();
                do {
                    if (!iterator.hasNext()) return false;
                } while (!combat.isBlocking(card, c12 = (Card)iterator.next()));
                return true;
            }
            if (StringUtils.isEmpty(what)) return true;
            Iterator iterator = AbilityUtils.getDefinedCards(source, what, spellAbility).iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!combat.isBlocking(card, c11 = (Card)iterator.next()));
            return true;
        }
        if (property.startsWith("sharesBlockingAssignmentWith")) {
            if (null == combat) {
                return false;
            }
            if (null == combat.getAttackersBlockedBy(source)) return false;
            if (null == combat.getAttackersBlockedBy(card)) {
                return false;
            }
            if (!Collections.disjoint(combat.getAttackersBlockedBy(source), combat.getAttackersBlockedBy(card))) return true;
            return false;
        }
        if (property.startsWith("notblocking")) {
            if (null == combat) return true;
            if (combat.isBlocking(card)) return false;
            return true;
        }
        if (property.equals("blocked")) {
            if (null == combat) return false;
            if (!combat.isBlocked(card)) return false;
            return true;
        }
        if (property.startsWith("blockedBySourceThisTurn")) {
            return card.getBlockedByThisTurn().contains(source);
        }
        if (property.startsWith("blockedBySourceLKI")) {
            if (null == combat) return false;
            if (!combat.isBlocking(game.getChangeZoneLKIInfo(source), card)) return false;
            return true;
        }
        if (property.startsWith("blockedBySource")) {
            if (null == combat) return false;
            if (!combat.isBlocking(source, card)) return false;
            return true;
        }
        if (property.startsWith("blockedThisTurn")) {
            if (card.getBlockedThisTurn().isEmpty()) return false;
            return true;
        }
        if (property.startsWith("blockedByThisTurn")) {
            if (card.getBlockedByThisTurn().isEmpty()) return false;
            return true;
        }
        if (property.startsWith("blockedValidThisTurn ")) {
            Card c13;
            List<Card> blocked = card.getBlockedThisTurn();
            if (blocked.isEmpty()) {
                return false;
            }
            String string = property.split(" ")[1];
            if (Iterables.any(blocked, CardPredicates.restriction(string, card.getController(), source, spellAbility))) {
                return true;
            }
            Iterator c11 = AbilityUtils.getDefinedCards(source, string, spellAbility).iterator();
            do {
                if (!c11.hasNext()) return false;
            } while (!blocked.contains(c13 = (Card)c11.next()));
            return true;
        }
        if (property.startsWith("blockedByValidThisTurn ")) {
            Card c14;
            List<Card> blocked = card.getBlockedByThisTurn();
            if (blocked.isEmpty()) {
                return false;
            }
            String string = property.split(" ")[1];
            if (Iterables.any(blocked, CardPredicates.restriction(string, card.getController(), source, spellAbility))) {
                return true;
            }
            Iterator c11 = AbilityUtils.getDefinedCards(source, string, spellAbility).iterator();
            do {
                if (!c11.hasNext()) return false;
            } while (!blocked.contains(c14 = (Card)c11.next()));
            return true;
        }
        if (property.startsWith("isBlockedByRemembered")) {
            Object object;
            if (null == combat) {
                return false;
            }
            Iterator<Object> blocked = source.getRemembered().iterator();
            do {
                if (!blocked.hasNext()) return false;
            } while (!((object = blocked.next()) instanceof Card) || !combat.isBlocking((Card)object, card));
            return true;
        }
        if (property.startsWith("blockedRemembered")) {
            Iterator<Object> iterator = source.getRemembered().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof Card)) continue;
                Card rememberedcard = (Card)o;
                if (card.getBlockedThisTurn().contains(rememberedcard)) return true;
            }
            return false;
        }
        if (property.startsWith("blockedByRemembered")) {
            Iterator<Object> iterator = source.getRemembered().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof Card)) continue;
                Card rememberedcard = (Card)o;
                if (card.getBlockedByThisTurn().contains(rememberedcard)) return true;
            }
            return false;
        }
        if (property.startsWith("unblocked")) {
            if (combat == null) return false;
            if (combat.isUnblocked(card)) return true;
            return false;
        }
        if (property.equals("attackersBandedWith")) {
            if (card.equals(source)) {
                return false;
            }
            if (combat == null) {
                return false;
            }
            AttackingBand attackingBand = combat.getBandOfAttacker(source);
            AttackingBand band = attackingBand;
            if (band == null) return false;
            if (band.getAttackers().contains(card)) return true;
            return false;
        }
        if (property.equals("hadToAttackThisCombat")) {
            if (combat == null) {
                return false;
            }
            AttackRequirement attackRequirement = combat.getAttackConstraints().getRequirements().get(card);
            AttackRequirement e = attackRequirement;
            if (e == null) return false;
            if (!e.hasRequirement()) return false;
            if (e.getAttacker().equalsWithGameTimestamp(card)) return true;
            return false;
        }
        if (property.equals("couldAttackButNotAttacking")) {
            if (game.getPhaseHandler().isPlayerTurn(controller)) return CombatUtil.couldAttackButNotAttacking(combat, card);
            return false;
        }
        if (property.equals("linkedCastSA")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return true;
            return false;
        }
        if (property.startsWith("kicked")) {
            if (AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) {
                return false;
            }
            if (property.equals("kicked")) {
                if (card.getKickerMagnitude() != 0) return true;
                return false;
            }
            String s3 = property.split("kicked ")[1];
            if ("1".equals(s3) && !card.isOptionalCostPaid(OptionalCost.Kicker1)) {
                return false;
            }
            if (!"2".equals(s3)) return true;
            if (card.isOptionalCostPaid(OptionalCost.Kicker2)) return true;
            return false;
        }
        if (property.equals("bargained")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return card.getCastSA().isBargained();
            return false;
        }
        if (property.equals("surged")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return card.getCastSA().isSurged();
            return false;
        }
        if (property.equals("blitzed")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return card.getCastSA().isBlitz();
            return false;
        }
        if (property.equals("dashed")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return card.getCastSA().isDash();
            return false;
        }
        if (property.equals("escaped")) {
            if (card.getCastSA() != null) return card.getCastSA().isEscape();
            return false;
        }
        if (property.equals("evoked")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return card.getCastSA().isEvoke();
            return false;
        }
        if (property.equals("PromisedGift")) {
            if (card.getCastSA() != null) return card.getCastSA().isOptionalCostPaid(OptionalCost.PromiseGift);
            return false;
        }
        if (property.equals("impended")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return card.getCastSA().isImpending();
            return false;
        }
        if (property.equals("prowled")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return card.getCastSA().isProwl();
            return false;
        }
        if (property.equals("spectacle")) {
            if (card.getCastSA() == null) {
                return false;
            }
            if (!AbilityUtils.isUnlinkedFromCastSA(spellAbility, card)) return card.getCastSA().isSpectacle();
            return false;
        }
        if (property.equals("foretold")) {
            if (card.isForetold()) return true;
            return false;
        }
        if (property.equals("CrewedThisTurn")) {
            if (CardProperty.hasTimestampMatch(card, source.getCrewedByThisTurn())) return true;
            return false;
        }
        if (property.equals("HasDevoured")) {
            if (!card.getDevouredCards().isEmpty()) return true;
            return false;
        }
        if (property.equals("IsMonstrous")) {
            if (card.isMonstrous()) return true;
            return false;
        }
        if (property.equals("IsUnearthed")) {
            if (card.isUnearthed()) return true;
            return false;
        }
        if (property.equals("IsRenowned")) {
            if (card.isRenowned()) return true;
            return false;
        }
        if (property.equals("IsSolved")) {
            if (card.isSolved()) return true;
            return false;
        }
        if (property.equals("IsUnsolved")) {
            if (!card.isSolved()) return true;
            return false;
        }
        if (property.equals("IsSaddled")) {
            if (card.isSaddled()) return true;
            return false;
        }
        if (property.equals("SaddledThisTurn")) {
            if (CardProperty.hasTimestampMatch(card, source.getSaddledByThisTurn())) return true;
            return false;
        }
        if (property.equals("VisitedThisTurn")) {
            if (card.wasVisitedThisTurn()) return true;
            return false;
        }
        if (property.equals("IsSuspected")) {
            if (card.isSuspected()) return true;
            return false;
        }
        if (property.equals("IsRemembered")) {
            if (source.isRemembered(card)) return true;
            return false;
        }
        if (property.equals("IsNotRemembered")) {
            if (!source.isRemembered(card)) return true;
            return false;
        }
        if (property.equals("IsImprinted")) {
            if (source.hasImprintedCard(card)) return true;
            return false;
        }
        if (property.equals("IsNotImprinted")) {
            if (!source.hasImprintedCard(card)) return true;
            return false;
        }
        if (property.equals("IsGoaded")) {
            if (card.isGoaded()) return true;
            return false;
        }
        if (property.equals("FullyUnlocked")) {
            if (card.getUnlockedRooms().size() >= 2) return true;
            return false;
        }
        if (property.startsWith("canReceiveCounters")) {
            if (card.canReceiveCounters(CounterType.getType(property.split(" ")[1]))) return true;
            return false;
        }
        if (property.equals("canBeTurnedFaceUp")) {
            if (card.canBeTurnedFaceUp()) return true;
            return false;
        }
        if (property.equals("NoAbilities")) {
            if (card.hasNoAbilities()) return true;
            return false;
        }
        if (property.equals("castKeyword")) {
            SpellAbility castSA = card.getCastSA();
            if (castSA == null) {
                return false;
            }
            if (!castSA.isIntrinsic()) return Objects.equals(castSA.getKeyword(), spellAbility.getKeyword());
            if (spellAbility.isIntrinsic()) return true;
            return false;
        }
        if (property.equals("CastSaSource")) {
            SpellAbility castSA = card.getCastSA();
            if (castSA == null) {
                return false;
            }
            if (castSA.equals(source.getCastSA())) return true;
            return false;
        }
        if (property.startsWith("CastSa")) {
            SpellAbility castSA = card.getCastSA();
            if (castSA == null) {
                return false;
            }
            String string = property.substring(7);
            if (castSA.isValid(string, sourceController, source, spellAbility)) return true;
            return false;
        }
        if (property.startsWith("wasCastFrom")) {
            void var10_199;
            boolean byYou = property.contains("ByYou");
            String string = property.substring(11);
            Player zoneOwner = null;
            if (property.contains("Your")) {
                String string3 = string.substring(4);
                zoneOwner = sourceController;
            }
            if (property.contains("Their")) {
                void var10_195;
                String string4 = var10_195.substring(5);
                zoneOwner = controller;
            }
            if (byYou) {
                void var10_197;
                String string5 = var10_197.substring(0, var10_197.indexOf("ByYou", 0));
            }
            ZoneType realZone = ZoneType.smartValueOf((String)var10_199);
            if (card.getCastFrom() == null) return false;
            if (card.getCastSA() == null) return false;
            if (zoneOwner != null) {
                if (!card.getCastFrom().getPlayer().equals(zoneOwner)) return false;
            }
            if (byYou) {
                if (!sourceController.equals(card.getCastSA().getActivatingPlayer())) return false;
            }
            if (realZone == card.getCastFrom().getZoneType()) return true;
            return false;
        }
        if (property.startsWith("wasCast")) {
            if (!card.wasCast()) {
                return false;
            }
            if (!property.contains("ByYou")) return true;
            if (card.getCastSA() == null) return true;
            if (sourceController.equals(card.getCastSA().getActivatingPlayer())) return true;
            return false;
        }
        if (property.equals("wasNotCast")) {
            if (!card.wasCast()) return true;
            return false;
        }
        if (property.startsWith("set")) {
            String setCode = property.substring(3, 6);
            if (card.getName().isEmpty()) {
                return false;
            }
            PaperCard paperCard = StaticData.instance().getCommonCards().getCardFromEditions(card.getName(), CardDb.CardArtPreference.ORIGINAL_ART_ALL_EDITIONS);
            if (paperCard == null) return true;
            if (paperCard.getEdition().equals(setCode)) return true;
            return false;
        }
        if (property.startsWith("inZone")) {
            String strZone = property.substring(6);
            ZoneType zoneType = ZoneType.smartValueOf(strZone);
            Zone lkiZone = lki.getLastKnownZone();
            if (lkiZone == null) return false;
            if (lkiZone.is(zoneType)) return true;
            return false;
        }
        if (property.startsWith("inRealZone")) {
            String strZone = property.substring(10);
            ZoneType zoneType = ZoneType.smartValueOf(strZone);
            if (card.isInZone(zoneType)) return true;
            return false;
        }
        if (property.equals("IsCommander")) {
            if (card.isCommander()) return true;
            return false;
        }
        if (property.equals("IsNotCommander")) {
            if (!card.isCommander()) return true;
            return false;
        }
        if (property.startsWith("NotedFor")) {
            String note;
            String key = property.substring("NotedFor".length());
            Iterator<String> iterator = sourceController.getNotesForName(key).iterator();
            do {
                if (!iterator.hasNext()) return false;
                note = iterator.next();
                if (!note.equals("Name:" + card.getName())) continue;
                return true;
            } while (!note.equals("Id:" + card.getId()));
            return true;
        }
        if (property.equals("NotedColor")) {
            String colors = sourceController.getDraftNotes().get("Regicide");
            if (colors == null) {
                return false;
            }
            if (colors.contains("white")) {
                if (card.getColor().hasWhite()) return true;
            }
            if (colors.contains("blue")) {
                if (card.getColor().hasBlue()) return true;
            }
            if (colors.contains("black")) {
                if (card.getColor().hasBlack()) return true;
            }
            if (colors.contains("red")) {
                if (card.getColor().hasRed()) return true;
            }
            if (!colors.contains("green")) return false;
            if (!card.getColor().hasGreen()) return false;
            return true;
        }
        if (property.equals("NotedNameNobleBanneret")) {
            String names = sourceController.getDraftNotes().get("Noble Banneret");
            if (names == null) return false;
            if (names.isEmpty()) {
                return false;
            }
            ArrayList<String> arrayList = Lists.newArrayList(names.split(";"));
            return arrayList.contains(card.getName());
        }
        if (property.equals("NotedNameAetherSearcher")) {
            String names = sourceController.getDraftNotes().get("Aether Searcher");
            if (names == null) return false;
            if (names.isEmpty()) {
                return false;
            }
            ArrayList<String> arrayList = Lists.newArrayList(names.split(";"));
            return arrayList.contains(card.getName());
        }
        if (property.equals("NotedNameSmugglerCaptain")) {
            String names = sourceController.getDraftNotes().get("Smuggler Captain");
            if (names == null) return false;
            if (names.isEmpty()) {
                return false;
            }
            ArrayList<String> arrayList = Lists.newArrayList(names.split(";"));
            return arrayList.contains(card.getName());
        }
        if (property.equals("NotedGuessPhantasm")) {
            String names = sourceController.getDraftNotes().get("Spire Phantasm");
            if (names == null) return false;
            if (names.isEmpty()) return false;
            return true;
        }
        if (property.equals("NotedTypes")) {
            String types = sourceController.getDraftNotes().get("Paliano Vanguard");
            if (types == null) return false;
            if (types.isEmpty()) {
                return false;
            }
            ArrayList<String> arrayList = Lists.newArrayList(types.split(","));
            return Iterables.any(card.getType().getCreatureTypes(), arrayList::contains);
        }
        if (property.startsWith("Triggered")) {
            if (!(spellAbility instanceof SpellAbility)) return false;
            String key = property.substring(9);
            SpellAbility spellAbility4 = (SpellAbility)spellAbility;
            Object o = spellAbility4.getRootAbility().getTriggeringObject(AbilityKey.fromString(key));
            boolean found = false;
            if (o != null) {
                found = o instanceof CardCollection ? ((CardCollection)o).contains(card) : card.equals(o);
            }
            if (found) return true;
            return false;
        }
        if (property.startsWith("NotTriggered")) {
            String key = property.substring("NotTriggered".length());
            if (!(spellAbility instanceof SpellAbility)) return false;
            SpellAbility spellAbility5 = (SpellAbility)spellAbility;
            if (!card.equals(spellAbility5.getRootAbility().getTriggeringObject(AbilityKey.fromString(key)))) return true;
            return false;
        }
        if (property.startsWith("NotDefined")) {
            String key = property.substring("NotDefined".length());
            if (!Iterables.contains(AbilityUtils.getDefinedCards(source, key, spellAbility), card)) return true;
            return false;
        }
        if (property.equals("CanPayManaCost")) {
            if (spellAbility instanceof SpellAbility) {
                final class CheckCanPayManaCost {
                    private List<Mana> manaPaid;
                    private List<ManaCostShard> manaCost;

                    CheckCanPayManaCost() {
                    }

                    boolean checkShard(int index) {
                        if (index >= this.manaCost.size()) {
                            return true;
                        }
                        ManaCostShard shard = this.manaCost.get(index);
                        if (shard == ManaCostShard.X) {
                            return this.checkShard(index + 1);
                        }
                        for (int i = 0; i < this.manaPaid.size(); ++i) {
                            Mana mana = this.manaPaid.get(i);
                            if (shard.isColor(mana.getColor()) || shard.isSnow() && mana.isSnow()) {
                                this.manaPaid.remove(i);
                                if (this.checkShard(index + 1)) {
                                    return true;
                                }
                                this.manaPaid.add(i, mana);
                            }
                            if (!shard.isGeneric() || shard.isSnow()) continue;
                            if (shard.getCmc() == 2) {
                                this.manaCost.add(ManaCostShard.GENERIC);
                            }
                            this.manaPaid.remove(i);
                            if (this.checkShard(index + 1)) {
                                return true;
                            }
                            this.manaPaid.add(i, mana);
                            if (shard.getCmc() != 2) continue;
                            this.manaCost.remove(this.manaCost.size() - 1);
                        }
                        return false;
                    }

                    boolean check() {
                        this.manaPaid = Lists.newArrayList(((SpellAbility)spellAbility).getPayingMana());
                        this.manaCost = Lists.newArrayList(card.getManaCost());
                        Collections.sort(this.manaCost);
                        int genericCost = card.getManaCost().getGenericCost();
                        while (genericCost-- > 0) {
                            this.manaCost.add(ManaCostShard.GENERIC);
                        }
                        return this.checkShard(0);
                    }
                }
                return new CheckCanPayManaCost().check();
            }
            return false;
        }
        if (card.getCurrentState().hasProperty(property, sourceController, source, spellAbility)) return true;
        return false;
    }

    private static boolean hasTimestampMatch(Card card, CardCollection coll) {
        if (coll == null) {
            return false;
        }
        boolean match = false;
        for (Card c : coll) {
            if (!c.equalsWithGameTimestamp(card)) continue;
            match = true;
            break;
        }
        return match;
    }
}

