/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.mana.ManaConversionMatrix;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;

public final class CardPlayOption {
    private final Player player;
    private final StaticAbility sta;
    private final PayManaCost payManaCost;
    private final boolean withFlash;
    private final boolean grantsZonePermissions;
    private final Cost altManaCost;

    public CardPlayOption(Player player, StaticAbility sta, boolean withoutManaCost, Cost altManaCost, boolean withFlash, boolean grantZonePermissions) {
        this(player, sta, withoutManaCost ? PayManaCost.NO : PayManaCost.YES, altManaCost, withFlash, grantZonePermissions);
    }

    private CardPlayOption(Player player, StaticAbility sta, PayManaCost payManaCost, Cost altManaCost, boolean withFlash, boolean grantZonePermissions) {
        this.player = player;
        this.sta = sta;
        this.payManaCost = payManaCost;
        this.withFlash = withFlash;
        this.grantsZonePermissions = grantZonePermissions;
        this.altManaCost = altManaCost;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Card getHost() {
        return this.sta.getHostCard();
    }

    public StaticAbility getAbility() {
        return this.sta;
    }

    public PayManaCost getPayManaCost() {
        return this.payManaCost;
    }

    public boolean isIgnoreManaCostColor() {
        return this.sta.hasParam("MayPlayIgnoreColor");
    }

    public boolean isIgnoreManaCostType() {
        return this.sta.hasParam("MayPlayIgnoreType");
    }

    public boolean isIgnoreSnowSourceManaCostColor() {
        return this.sta.hasParam("MayPlaySnowIgnoreColor");
    }

    public boolean applyManaConvert(ManaConversionMatrix matrix) {
        if (this.isIgnoreManaCostType()) {
            AbilityUtils.applyManaColorConversion(matrix, "AnyType->AnyType");
            return true;
        }
        if (this.isIgnoreManaCostColor()) {
            AbilityUtils.applyManaColorConversion(matrix, "AnyType->AnyColor");
            return true;
        }
        return false;
    }

    public boolean isWithFlash() {
        return this.withFlash;
    }

    public boolean grantsZonePermissions() {
        return this.grantsZonePermissions;
    }

    public Cost getAltManaCost() {
        return this.altManaCost;
    }

    private String getFormattedAltManaCost() {
        return this.altManaCost.toSimpleString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withPlayer) {
        StringBuilder sb = new StringBuilder(withPlayer ? this.player.toString() : "");
        switch (this.getPayManaCost()) {
            case YES: {
                if (this.altManaCost != null) {
                    String insteadCost = this.getFormattedAltManaCost();
                    insteadCost = insteadCost.replace("Pay ", "");
                    sb.append(" (by paying ").append(insteadCost).append(" instead of paying its mana cost");
                    if (this.isWithFlash()) {
                        sb.append(" and as though it has flash");
                    }
                    sb.append(")");
                }
                if (this.isIgnoreManaCostType()) {
                    sb.append(" (may spend mana as though it were mana of any type to cast it)");
                } else if (this.isIgnoreManaCostColor()) {
                    sb.append(" (may spend mana as though it were mana of any color to cast it)");
                }
                if (!this.sta.hasParam("RaiseCost")) break;
                String desc = this.sta.getParam("Description");
                sb.append(" (").append(desc, desc.indexOf("by ") + desc.indexOf("pay "), desc.indexOf(".")).append(")");
                break;
            }
            case NO: {
                sb.append(" (without paying its mana cost");
                if (this.isWithFlash()) {
                    sb.append(" and as though it has flash");
                }
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public static enum PayManaCost {
        YES,
        NO;

    }
}

