/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.ImageKeys;
import forge.StaticData;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.GamePieceType;
import forge.card.ICardFace;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.IHasSVars;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCloneStates;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardState;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.LandAbility;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityCondition;
import forge.game.spellability.SpellAbilityRestriction;
import forge.game.spellability.SpellPermanent;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.WrappedAbility;
import forge.item.IPaperCard;
import forge.util.CardTranslation;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CardFactory {
    private static Card copySpellHost(SpellAbility sourceSA, SpellAbility targetSA, Player controller) {
        Card source = sourceSA.getHostCard();
        Card original = targetSA.getHostCard();
        Game game = source.getGame();
        int id = game.nextCardId();
        Card copy = CardFactory.getCard(original.getPaperCard(), controller, id, game);
        if (original.isTransformable()) {
            copy.setBackSide(original.isBackSide());
            if (original.isTransformed()) {
                copy.incrementTransformedTimestamp();
            }
        }
        copy.setStates(CardFactory.getCloneStates(original, copy, sourceSA));
        if (original.isTransformable()) {
            copy.setState(original.isTransformed() ? CardStateName.Transformed : CardStateName.Original, true, true);
        } else {
            copy.setState(copy.getCurrentStateName(), true, true);
        }
        copy.setGamePieceType(GamePieceType.COPIED_SPELL);
        copy.setCopiedPermanent(original);
        copy.setXManaCostPaidByColor(original.getXManaCostPaidByColor());
        copy.setPromisedGift(original.getPromisedGift());
        if (targetSA.isBestow()) {
            copy.animateBestow();
        }
        if (sourceSA.hasParam("RememberNewCard")) {
            source.addRemembered(copy);
        }
        return copy;
    }

    public static final SpellAbility copySpellAbilityAndPossiblyHost(SpellAbility sourceSA, SpellAbility targetSA, Player controller) {
        SpellAbility copySA;
        Card c;
        Card card = c = targetSA.isSpell() && !sourceSA.hasParam("UseOriginalHost") ? CardFactory.copySpellHost(sourceSA, targetSA, controller) : targetSA.getHostCard();
        if (targetSA.isTrigger() && targetSA.isWrapper()) {
            copySA = CardFactory.getCopiedTriggeredAbility((WrappedAbility)targetSA, c, controller);
        } else {
            copySA = targetSA.copy(c, controller, false);
            if (targetSA.getKeyword() != null) {
                KeywordInterface kw = targetSA.getKeyword().copy(c, false);
                copySA.setKeyword(kw);
                c.addKeywordForStaticAbility(kw);
            }
        }
        copySA.setCopied(true);
        if (targetSA.isAbility()) {
            copySA.setOriginalAbility(targetSA);
        }
        if (copySA instanceof Spell) {
            Spell spell = (Spell)copySA;
            spell.setCastFaceDown(false);
            c.setCastSA(copySA);
        }
        copySA.clearManaPaid();
        if (!copySA.isTrigger()) {
            copySA.setPayCosts(new Cost("", targetSA.isAbility()));
        }
        return copySA;
    }

    public static Card getCard(IPaperCard cp, Player owner, Game game) {
        return CardFactory.getCard(cp, owner, owner == null ? -1 : owner.getGame().nextCardId(), game);
    }

    public static Card getCard(IPaperCard cp, Player owner, int cardId, Game game) {
        CardRules cardRules = cp.getRules();
        Card c = CardFactory.readCard(cardRules, cp, cardId, game);
        c.setRules(cardRules);
        c.setOwner(owner);
        CardFactory.buildAbilities(c);
        c.setSetCode(cp.getEdition());
        c.setRarity(cp.getRarity());
        String originalPicture = cp.getImageKey(false);
        c.setImageKey(originalPicture);
        if (cp.isToken()) {
            c.setGamePieceType(GamePieceType.TOKEN);
        } else {
            c.setGamePieceType(c.getRules().getType().getGamePieceType());
        }
        if (c.hasAlternateState()) {
            if (c.isFlipCard()) {
                c.setState(CardStateName.Flipped, false);
                c.setImageKey(cp.getImageKey(true));
            } else if (c.isDoubleFaced() && cardRules != null) {
                c.setState(cardRules.getSplitType().getChangedStateName(), false);
                c.setImageKey(cp.getImageKey(true));
            } else if (c.isSplitCard()) {
                c.setState(CardStateName.LeftSplit, false);
                c.setImageKey(originalPicture);
                c.setSetCode(cp.getEdition());
                c.setRarity(cp.getRarity());
                c.setState(CardStateName.RightSplit, false);
                c.setImageKey(originalPicture);
            } else if (c.isAdventureCard()) {
                c.setState(CardStateName.Adventure, false);
                c.setImageKey(originalPicture);
            } else if (c.canSpecialize()) {
                c.setState(CardStateName.SpecializeW, false);
                c.setImageKey(cp.getImageKey(false) + "$wspec");
                c.setSetCode(cp.getEdition());
                c.setRarity(cp.getRarity());
                c.setState(CardStateName.SpecializeU, false);
                c.setImageKey(cp.getImageKey(false) + "$uspec");
                c.setSetCode(cp.getEdition());
                c.setRarity(cp.getRarity());
                c.setState(CardStateName.SpecializeB, false);
                c.setImageKey(cp.getImageKey(false) + "$bspec");
                c.setSetCode(cp.getEdition());
                c.setRarity(cp.getRarity());
                c.setState(CardStateName.SpecializeR, false);
                c.setImageKey(cp.getImageKey(false) + "$rspec");
                c.setSetCode(cp.getEdition());
                c.setRarity(cp.getRarity());
                c.setState(CardStateName.SpecializeG, false);
                c.setImageKey(cp.getImageKey(false) + "$gspec");
                c.setSetCode(cp.getEdition());
                c.setRarity(cp.getRarity());
            }
            c.setSetCode(cp.getEdition());
            c.setRarity(cp.getRarity());
            c.setState(CardStateName.Original, false);
        }
        return c;
    }

    private static void buildAbilities(Card card) {
        for (CardStateName state : card.getStates()) {
            if (card.isDoubleFaced() && state == CardStateName.FaceDown) continue;
            card.setState(state, false);
            if (state == CardStateName.LeftSplit || state == CardStateName.RightSplit) {
                for (SpellAbility sa : card.getSpellAbilities()) {
                    sa.setCardState(card.getState(state));
                }
                CardFactoryUtil.setupKeywordedAbilities(card);
                CardState original = card.getState(CardStateName.Original);
                original.addNonManaAbilities(card.getCurrentState().getNonManaAbilities());
                original.addIntrinsicKeywords(card.getCurrentState().getIntrinsicKeywords());
                for (Trigger t2 : card.getCurrentState().getTriggers()) {
                    if (!t2.isIntrinsic()) continue;
                    original.addTrigger(t2.copy(card, false));
                }
                for (StaticAbility st : card.getCurrentState().getStaticAbilities()) {
                    if (!st.isIntrinsic()) continue;
                    original.addStaticAbility(st.copy(card, false));
                }
                for (ReplacementEffect re : card.getCurrentState().getReplacementEffects()) {
                    if (!re.isIntrinsic()) continue;
                    original.addReplacementEffect(re.copy(card, false));
                }
                original.getSVars().putAll(card.getCurrentState().getSVars());
            } else if (state != CardStateName.Original) {
                CardFactoryUtil.setupKeywordedAbilities(card);
            }
            if (state != CardStateName.Adventure) continue;
            CardFactoryUtil.setupAdventureAbility(card);
        }
        card.setState(CardStateName.Original, false);
        if (card.isSplitCard()) {
            card.updateKeywordsCache(card.getCurrentState());
        }
        CardFactory.buildBattleAbilities(card);
        CardFactoryUtil.setupKeywordedAbilities(card);
        card.updateStateForView();
    }

    private static void buildBattleAbilities(Card card) {
        if (!card.isBattle()) {
            return;
        }
        if (card.getType().hasSubtype("Siege")) {
            CardFactoryUtil.setupSiegeAbilities(card);
        }
    }

    public static SpellAbility buildBasicLandAbility(CardState state, byte color) {
        String strcolor = MagicColor.toShortString(color);
        String abString = "AB$ Mana | Cost$ T | Produced$ " + strcolor + " | Secondary$ True | SpellDescription$ Add {" + strcolor + "}.";
        SpellAbility sa = AbilityFactory.getAbility(abString, state);
        sa.setIntrinsic(true);
        return sa;
    }

    private static Card readCard(CardRules rules, IPaperCard paperCard, int cardId, Game game) {
        Card card = new Card(cardId, paperCard, game);
        CardSplitType st = rules.getSplitType();
        if (st == CardSplitType.Split) {
            card.addAlternateState(CardStateName.LeftSplit, false);
            card.setState(CardStateName.LeftSplit, false);
        }
        CardFactory.readCardFace(card, rules.getMainPart());
        if (st == CardSplitType.Specialize) {
            for (Map.Entry<CardStateName, ICardFace> e : rules.getSpecializeParts().entrySet()) {
                card.addAlternateState(e.getKey(), false);
                card.setState(e.getKey(), false);
                if (e.getValue() == null) continue;
                CardFactory.readCardFace(card, e.getValue());
            }
        } else if (st != CardSplitType.None) {
            card.addAlternateState(st.getChangedStateName(), false);
            card.setState(st.getChangedStateName(), false);
            if (rules.getOtherPart() != null) {
                CardFactory.readCardFace(card, rules.getOtherPart());
            } else if (!rules.getMeldWith().isEmpty()) {
                CardFactory.readCardFace(card, StaticData.instance().getCommonCards().getRules(rules.getMeldWith()).getOtherPart());
            }
        }
        if (card.isInAlternateState()) {
            card.setState(CardStateName.Original, false);
        }
        if (st == CardSplitType.Split) {
            card.setName(rules.getName());
            ManaCost combinedManaCost = ManaCost.combine(rules.getMainPart().getManaCost(), rules.getOtherPart().getManaCost());
            card.setManaCost(combinedManaCost);
            byte combinedColor = (byte)(rules.getMainPart().getColor().getColor() | rules.getOtherPart().getColor().getColor());
            card.setColor(combinedColor);
            card.setType(new CardType(rules.getType()));
            String combinedText = String.format("(%s) %s\r\n\r\n(%s) %s", rules.getMainPart().getName(), rules.getMainPart().getOracleText(), rules.getOtherPart().getName(), rules.getOtherPart().getOracleText());
            card.getState(CardStateName.Original).setOracleText(combinedText);
        }
        return card;
    }

    private static void readCardFace(Card c, ICardFace face) {
        String variantName = null;
        if (face.hasFunctionalVariants() && !"".equals(variantName = c.getPaperCard().getFunctionalVariant())) {
            ICardFace variant = face.getFunctionalVariant(variantName);
            if (variant != null) {
                face = variant;
                c.getCurrentState().setFunctionalVariantName(variantName);
            } else {
                System.err.printf("Tried to apply unknown or unsupported variant - Card: \"%s\"; Variant: %s\n", face.getName(), variantName);
            }
        }
        if (c.getId() >= 0) {
            CardTranslation.buildOracleMapping(face.getName(), face.getOracleText(), variantName);
        }
        c.setName(face.getName());
        for (Map.Entry entry : face.getVariables()) {
            c.setSVar((String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : face.getReplacements()) {
            c.addReplacementEffect(ReplacementHandler.parseReplacement(string, c, true, (IHasSVars)c.getCurrentState()));
        }
        for (String string : face.getStaticAbilities()) {
            c.addStaticAbility(string);
        }
        for (String string : face.getTriggers()) {
            c.addTrigger(TriggerHandler.parseTrigger(string, c, true, (IHasSVars)c.getCurrentState()));
        }
        c.addIntrinsicKeywords(face.getKeywords(), false);
        if (face.getDraftActions() != null) {
            face.getDraftActions().forEach(c::addDraftAction);
        }
        c.setManaCost(face.getManaCost());
        c.setText(face.getNonAbilityText());
        c.getCurrentState().setBaseLoyalty(face.getInitialLoyalty());
        c.getCurrentState().setBaseDefense(face.getDefense());
        c.getCurrentState().setOracleText(face.getOracleText());
        c.setType(new CardType(face.getType()));
        c.setColor(face.getColor().getColor());
        if (face.getIntPower() != Integer.MAX_VALUE) {
            c.setBasePower(face.getIntPower());
            c.setBasePowerString(face.getPower());
        }
        if (face.getIntToughness() != Integer.MAX_VALUE) {
            c.setBaseToughness(face.getIntToughness());
            c.setBaseToughnessString(face.getToughness());
        }
        c.setAttractionLights(face.getAttractionLights());
        if (c.getCurrentStateName() == CardStateName.Original || c.getCurrentStateName() == CardStateName.LeftSplit || c.getCurrentStateName() == CardStateName.RightSplit || c.getCurrentStateName() == CardStateName.Modal || c.getCurrentStateName().toString().startsWith("Specialize")) {
            SpellAbility sa;
            if (c.isLand()) {
                sa = new LandAbility(c);
                sa.setCardState(c.getCurrentState());
                c.addSpellAbility(sa);
            } else if (c.isPermanent() && !c.isAura()) {
                sa = new SpellPermanent(c);
                sa.setCardState(c.getCurrentState());
                c.addSpellAbility(sa);
            }
        }
        CardFactoryUtil.addAbilityFactoryAbilities(c, face.getAbilities());
    }

    public static void copySpellAbility(SpellAbility from, SpellAbility to, Card host, Player p, boolean lki, boolean keepTextChanges) {
        if (from.usesTargeting()) {
            to.setTargetRestrictions(from.getTargetRestrictions());
        }
        to.setDescription(from.getOriginalDescription());
        to.setStackDescription(from.getOriginalStackDescription());
        if (from.getSubAbility() != null) {
            to.setSubAbility((AbilitySub)from.getSubAbility().copy(host, p, lki, keepTextChanges));
        }
        for (Map.Entry<String, SpellAbility> entry : from.getAdditionalAbilities().entrySet()) {
            to.setAdditionalAbility(entry.getKey(), entry.getValue().copy(host, p, lki, keepTextChanges));
        }
        for (Map.Entry<String, Object> entry : from.getAdditionalAbilityLists().entrySet()) {
            to.setAdditionalAbilityList(entry.getKey(), Lists.transform((List)entry.getValue(), input -> (AbilitySub)input.copy(host, p, lki, keepTextChanges)));
        }
        if (from.getRestrictions() != null) {
            to.setRestrictions((SpellAbilityRestriction)from.getRestrictions().copy());
        }
        if (from.getConditions() != null) {
            to.setConditions((SpellAbilityCondition)from.getConditions().copy());
        }
        if (p != null) {
            to.setActivatingPlayer(p, lki);
        }
    }

    public static SpellAbility getCopiedTriggeredAbility(WrappedAbility sa, Card newHost, Player controller) {
        if (!sa.isTrigger()) {
            return null;
        }
        return new WrappedAbility(sa.getTrigger(), sa.getWrappedAbility().copy(newHost, controller, false), sa.getDecider());
    }

    /*
     * Could not resolve type clashes
     */
    public static CardCloneStates getCloneStates(Card in, Card out, CardTraitBase sa) {
        CardState ret2;
        CardState ret1;
        CardState ret;
        Card host = sa.getHostCard();
        Map<String, String> origSVars = host.getSVars();
        ArrayList<String> types = Lists.newArrayList();
        ArrayList<String> keywords = Lists.newArrayList();
        boolean KWifNew = false;
        ArrayList<String> removeKeywords = Lists.newArrayList();
        ImmutableList<String> creatureTypes = null;
        CardCloneStates result = new CardCloneStates(in, sa);
        String newName = sa.getParam("NewName");
        ColorSet colors = null;
        if (sa.hasParam("AddTypes")) {
            types.addAll(Arrays.asList(sa.getParam("AddTypes").split(" & ")));
        }
        if (sa.hasParam("SetCreatureTypes")) {
            creatureTypes = ImmutableList.copyOf(sa.getParam("SetCreatureTypes").split(" "));
        }
        if (sa.hasParam("AddKeywords")) {
            String kwString = sa.getParam("AddKeywords");
            if (kwString.startsWith("IfNew ")) {
                KWifNew = true;
                kwString = kwString.substring(6);
            }
            keywords.addAll(Arrays.asList(kwString.split(" & ")));
        }
        if (sa.hasParam("RemoveKeywords")) {
            removeKeywords.addAll(Arrays.asList(sa.getParam("RemoveKeywords").split(" & ")));
        }
        if (sa.hasParam("AddColors")) {
            colors = ColorSet.fromNames(sa.getParam("AddColors").split(","));
        }
        if (sa.hasParam("SetColor")) {
            colors = ColorSet.fromNames(sa.getParam("SetColor").split(","));
        }
        if (sa.hasParam("SetColorByManaCost")) {
            colors = sa.hasParam("SetManaCost") ? ColorSet.fromManaCost(new ManaCost(new ManaCostParser(sa.getParam("SetManaCost")))) : ColorSet.fromManaCost(host.getManaCost());
        }
        if (in.isFaceDown()) {
            ret = new CardState(out, CardStateName.Original);
            ret.copyFrom(in.getFaceDownState(), false, sa);
            result.put(CardStateName.Original, ret);
        } else if (in.isFlipCard()) {
            ret1 = new CardState(out, CardStateName.Original);
            ret1.copyFrom(in.getState(CardStateName.Original), false, sa);
            result.put(CardStateName.Original, ret1);
            ret2 = new CardState(out, CardStateName.Flipped);
            ret2.copyFrom(in.getState(CardStateName.Flipped), false, sa);
            result.put(CardStateName.Flipped, ret2);
        } else if (in.isAdventureCard()) {
            ret1 = new CardState(out, CardStateName.Original);
            ret1.copyFrom(in.getState(CardStateName.Original), false, sa);
            result.put(CardStateName.Original, ret1);
            ret2 = new CardState(out, CardStateName.Adventure);
            ret2.copyFrom(in.getState(CardStateName.Adventure), false, sa);
            result.put(CardStateName.Adventure, ret2);
        } else if (in.isTransformable() && sa instanceof SpellAbility && (ApiType.CopyPermanent.equals((Object)((SpellAbility)sa).getApi()) || ApiType.CopySpellAbility.equals((Object)((SpellAbility)sa).getApi()) || ApiType.ReplaceToken.equals((Object)((SpellAbility)sa).getApi()))) {
            ret1 = new CardState(out, CardStateName.Original);
            ret1.copyFrom(in.getState(CardStateName.Original), false, sa);
            result.put(CardStateName.Original, ret1);
            ret2 = new CardState(out, CardStateName.Transformed);
            ret2.copyFrom(in.getState(CardStateName.Transformed), false, sa);
            result.put(CardStateName.Transformed, ret2);
        } else if (in.isSplitCard()) {
            ret1 = new CardState(out, CardStateName.Original);
            ret1.copyFrom(in.getState(CardStateName.Original), false, sa);
            result.put(CardStateName.Original, ret1);
            ret2 = new CardState(out, CardStateName.LeftSplit);
            ret2.copyFrom(in.getState(CardStateName.LeftSplit), false, sa);
            result.put(CardStateName.LeftSplit, ret2);
            CardState ret3 = new CardState(out, CardStateName.RightSplit);
            ret3.copyFrom(in.getState(CardStateName.RightSplit), false, sa);
            result.put(CardStateName.RightSplit, ret3);
        } else {
            ret = new CardState(out, CardStateName.Original);
            ret.copyFrom(in.getState(in.getCurrentStateName()), false, sa);
            result.put(CardStateName.Original, ret);
        }
        for (Map.Entry e : result.entrySet()) {
            String name;
            Object str;
            ArrayList<String> finalizedKWs;
            CardState originalState = out.getState((CardStateName)((Object)e.getKey()));
            CardState state = (CardState)e.getValue();
            if (sa.hasParam("Embalm") && !out.isEmbalmed()) continue;
            if (sa.hasParam("KeepName")) {
                state.setName(originalState.getName());
            } else if (newName != null) {
                state.setName(newName);
            }
            if (sa.hasParam("AddColors")) {
                state.addColor(colors.getColor());
            }
            if (sa.hasParam("SetColor") || sa.hasParam("SetColorByManaCost")) {
                state.setColor(colors.getColor());
            }
            if (sa.hasParam("NonLegendary")) {
                state.removeType(CardType.Supertype.Legendary);
            }
            if (sa.hasParam("RemoveCardTypes")) {
                state.removeCardTypes(sa.hasParam("RemoveSubTypes"));
            }
            state.addType(types);
            if (creatureTypes != null) {
                state.setCreatureTypes(creatureTypes);
            }
            ArrayList<String> arrayList = finalizedKWs = KWifNew ? Lists.newArrayList() : keywords;
            if (KWifNew) {
                for (String k : keywords) {
                    Keyword toAdd = Keyword.getInstance(k).getKeyword();
                    int match = 0;
                    for (KeywordInterface kw : state.getIntrinsicKeywords()) {
                        if (!kw.getKeyword().equals((Object)toAdd)) continue;
                        match = 1;
                        break;
                    }
                    if (match != 0) continue;
                    finalizedKWs.add(k);
                }
            }
            state.addIntrinsicKeywords((Iterable<String>)finalizedKWs);
            for (String[] kw : removeKeywords) {
                state.removeIntrinsicKeyword((String)kw);
            }
            if ((sa.hasParam("SetPower") || sa.hasParam("SetToughness")) && (state.getType().isCreature() || originalState != null && in.getOriginalState(originalState.getStateName()).getBasePowerString() != null)) {
                if (sa.hasParam("SetPower")) {
                    state.setBasePower(AbilityUtils.calculateAmount(host, sa.getParam("SetPower"), sa));
                }
                if (sa.hasParam("SetToughness")) {
                    state.setBaseToughness(AbilityUtils.calculateAmount(host, sa.getParam("SetToughness"), sa));
                }
            }
            if (state.getType().isPlaneswalker() && sa.hasParam("SetLoyalty")) {
                state.setBaseLoyalty(String.valueOf(AbilityUtils.calculateAmount(host, sa.getParam("SetLoyalty"), sa)));
            }
            if (sa.hasParam("RemoveCost")) {
                state.setManaCost(ManaCost.NO_COST);
            }
            if (sa.hasParam("SetManaCost")) {
                state.setManaCost(new ManaCost(new ManaCostParser(sa.getParam("SetManaCost"))));
            }
            if (sa.hasParam("AddSVars") || sa.hasParam("GainTextSVars")) {
                str = sa.getParamOrDefault("GainTextSVars", sa.getParam("AddSVars"));
                for (String s2 : ((String)str).split(",")) {
                    if (!origSVars.containsKey(s2)) continue;
                    String actualsVar = origSVars.get(s2);
                    state.setSVar(s2, actualsVar);
                }
            }
            if (sa.hasParam("AddTriggers")) {
                for (String s3 : sa.getParam("AddTriggers").split(",")) {
                    if (!origSVars.containsKey(s3)) continue;
                    String actualTrigger = origSVars.get(s3);
                    Trigger parsedTrigger = TriggerHandler.parseTrigger(actualTrigger, out, true, (IHasSVars)state);
                    state.addTrigger(parsedTrigger);
                }
            }
            if (sa.hasParam("AddAbilities") || sa.hasParam("GainTextAbilities")) {
                str = sa.getParamOrDefault("GainTextAbilities", sa.getParam("AddAbilities"));
                for (String s2 : ((String)str).split(",")) {
                    if (!origSVars.containsKey(s2)) continue;
                    String actualAbility = origSVars.get(s2);
                    SpellAbility grantedAbility = AbilityFactory.getAbility(actualAbility, out);
                    grantedAbility.setIntrinsic(true);
                    state.addSpellAbility(grantedAbility);
                }
            }
            if (sa.hasParam("AddStaticAbilities")) {
                str = sa.getParam("AddStaticAbilities");
                for (String s2 : ((String)str).split(",")) {
                    if (!origSVars.containsKey(s2)) continue;
                    String actualStatic = origSVars.get(s2);
                    state.addStaticAbility(StaticAbility.create(actualStatic, out, sa.getCardState(), true));
                }
            }
            if (sa.hasParam("GainThisAbility") && sa instanceof SpellAbility) {
                SpellAbility root = ((SpellAbility)sa).getRootAbility();
                if (root.isTrigger() && root.getTrigger().getSpawningAbility() != null) {
                    root = root.getTrigger().getSpawningAbility();
                }
                if (root.isTrigger()) {
                    state.addTrigger(root.getTrigger().copy(out, false));
                } else if (root.isReplacementAbility()) {
                    state.addReplacementEffect(root.getReplacementEffect().copy(out, false));
                } else {
                    state.addSpellAbility(root.copy(out, false));
                }
            }
            if (sa.isEmbalm() && sa.isIntrinsic()) {
                name = TextUtil.fastReplace(TextUtil.fastReplace(host.getName(), ",", ""), " ", "_").toLowerCase();
                String set = host.getSetCode().toLowerCase();
                state.setImageKey(ImageKeys.getTokenKey("embalm_" + name + "_" + set));
            }
            if (sa.isEternalize() && sa.isIntrinsic()) {
                name = TextUtil.fastReplace(TextUtil.fastReplace(host.getName(), ",", ""), " ", "_").toLowerCase();
                String set = host.getSetCode().toLowerCase();
                state.setImageKey(ImageKeys.getTokenKey("eternalize_" + name + "_" + set));
            }
            if (sa.isKeyword(Keyword.OFFSPRING) && sa.isIntrinsic()) {
                name = TextUtil.fastReplace(TextUtil.fastReplace(host.getName(), ",", ""), " ", "_").toLowerCase();
                String set = host.getSetCode().toLowerCase();
                state.setImageKey(ImageKeys.getTokenKey("offspring_" + name + "_" + set));
            }
            if (sa.hasParam("GainTextOf") && originalState != null) {
                state.setSetCode(originalState.getSetCode());
                state.setRarity(originalState.getRarity());
                state.setImageKey(originalState.getImageKey());
            }
            for (StaticAbility sta : state.getStaticAbilities()) {
                if (!sta.hasParam("CharacteristicDefining")) continue;
                if (sa.hasParam("SetPower") && sta.hasParam("SetPower")) {
                    state.removeStaticAbility(sta);
                }
                if (sa.hasParam("SetToughness") && sta.hasParam("SetToughness")) {
                    state.removeStaticAbility(sta);
                }
                if (sa.hasParam("SetCreatureTypes") && sta.hasParam("AddAllCreatureTypes")) {
                    state.removeStaticAbility(sta);
                }
                if (!sa.hasParam("SetColor") && !sa.hasParam("SetColorByManaCost") || !sta.hasParam("SetColor")) continue;
                state.removeStaticAbility(sta);
            }
            if (sa.hasParam("SetCreatureTypes")) {
                state.removeIntrinsicKeyword(Keyword.CHANGELING);
            }
            if (!sa.hasParam("SetColor") && !sa.hasParam("SetColorByManaCost")) continue;
            state.removeIntrinsicKeyword(Keyword.DEVOID);
        }
        return result;
    }

    public static CardCloneStates getMutatedCloneStates(Card card, CardTraitBase sa) {
        Card top = card.getTopMergedCard();
        CardStateName state = top.getCurrentStateName();
        CardState ret = new CardState(card, state);
        if (top.isCloned()) {
            ret.copyFrom(top.getState(state), false, sa);
        } else {
            ret.copyFrom(top.getOriginalState(state), false, sa);
        }
        boolean first = true;
        for (Card c : card.getMergedCards()) {
            if (first) {
                first = false;
                continue;
            }
            ret.addAbilitiesFrom(c.getCurrentState(), false);
        }
        CardCloneStates result = new CardCloneStates(top, sa);
        result.put(state, ret);
        if (state != CardStateName.Original) {
            CardState ret1 = new CardState(card, CardStateName.Original);
            ret1.copyFrom(top.getState(CardStateName.Original), false, sa);
            result.put(CardStateName.Original, ret1);
        }
        return result;
    }
}

