/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.util.collect.FCollection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class CardDamageHistory {
    private int attacksThisGame = 0;
    private int creatureAttackedThisCombat = 0;
    private boolean creatureBlockedThisCombat = false;
    private boolean creatureGotBlockedThisCombat = false;
    private List<GameEntity> attackedThisTurn = Lists.newArrayList();
    private boolean attackedBattleThisTurn = false;
    private final List<Player> creatureAttackedLastTurnOf = Lists.newArrayList();
    private final List<Player> NotAttackedSinceLastUpkeepOf = Lists.newArrayList();
    private final List<Player> NotBlockedSinceLastUpkeepOf = Lists.newArrayList();
    private final List<Player> NotBeenBlockedSinceLastUpkeepOf = Lists.newArrayList();
    private List<Pair<Integer, Boolean>> damageDoneThisTurn = Lists.newArrayList();
    private final List<Player> damagedThisCombat = Lists.newArrayList();
    private final FCollection<GameEntity> damagedThisGame = new FCollection();
    boolean hasdealtDamagetoAny = false;

    public final boolean getHasdealtDamagetoAny() {
        return this.hasdealtDamagetoAny;
    }

    public final void setCreatureAttackedThisCombat(GameEntity defender, int numOtherAttackers) {
        this.creatureAttackedThisCombat = 1 + numOtherAttackers;
        if (defender != null) {
            Card def;
            ++this.attacksThisGame;
            this.attackedThisTurn.add(defender);
            if (defender instanceof Card && (def = (Card)defender).isBattle()) {
                this.attackedBattleThisTurn = true;
            }
        }
    }

    public final int getCreatureAttackedThisCombat() {
        return this.creatureAttackedThisCombat;
    }

    public final int getCreatureAttacksThisTurn() {
        return this.attackedThisTurn.size();
    }

    public final boolean hasAttackedThisTurn(GameEntity e) {
        return this.attackedThisTurn.contains(e);
    }

    public final boolean hasAttackedBattleThisTurn() {
        return this.attackedBattleThisTurn;
    }

    public final int getAttacksThisGame() {
        return this.attacksThisGame;
    }

    public final void setCreatureAttackedLastTurnOf(Player p, boolean value) {
        if (value && !this.creatureAttackedLastTurnOf.contains(p)) {
            this.creatureAttackedLastTurnOf.add(p);
        }
        while (!value && this.creatureAttackedLastTurnOf.remove(p)) {
        }
    }

    public final boolean getCreatureAttackedLastTurnOf(Player p) {
        return this.creatureAttackedLastTurnOf.contains(p);
    }

    public final void setNotAttackedSinceLastUpkeepOf(Player p) {
        this.NotAttackedSinceLastUpkeepOf.add(p);
    }

    public final void clearNotAttackedSinceLastUpkeepOf() {
        this.NotAttackedSinceLastUpkeepOf.clear();
    }

    public final boolean hasAttackedSinceLastUpkeepOf(Player p) {
        return !this.NotAttackedSinceLastUpkeepOf.contains(p);
    }

    public final void setNotBlockedSinceLastUpkeepOf(Player p) {
        this.NotBlockedSinceLastUpkeepOf.add(p);
    }

    public final void clearNotBlockedSinceLastUpkeepOf() {
        this.NotBlockedSinceLastUpkeepOf.clear();
    }

    public final boolean hasBlockedSinceLastUpkeepOf(Player p) {
        return !this.NotBlockedSinceLastUpkeepOf.contains(p);
    }

    public final void setNotBeenBlockedSinceLastUpkeepOf(Player p) {
        this.NotBeenBlockedSinceLastUpkeepOf.add(p);
    }

    public final void clearNotBeenBlockedSinceLastUpkeepOf() {
        this.NotBeenBlockedSinceLastUpkeepOf.clear();
    }

    public final boolean hasBeenBlockedSinceLastUpkeepOf(Player p) {
        return !this.NotBeenBlockedSinceLastUpkeepOf.contains(p);
    }

    public final void setCreatureBlockedThisCombat(boolean b) {
        this.creatureBlockedThisCombat = b;
    }

    public final boolean getCreatureBlockedThisCombat() {
        return this.creatureBlockedThisCombat;
    }

    public final void setCreatureGotBlockedThisCombat(boolean b) {
        this.creatureGotBlockedThisCombat = b;
    }

    public final boolean getCreatureGotBlockedThisCombat() {
        return this.creatureGotBlockedThisCombat;
    }

    public final List<Player> getThisCombatDamaged() {
        return this.damagedThisCombat;
    }

    public final FCollection<GameEntity> getThisGameDamaged() {
        return this.damagedThisGame;
    }

    public void registerDamage(int damage, boolean isCombat, Card sourceLKI, GameEntity target, Map<Integer, Card> lkiCache) {
        if (damage <= 0) {
            return;
        }
        this.damagedThisGame.add(target);
        this.hasdealtDamagetoAny = true;
        if (isCombat && target instanceof Player) {
            Player pTgt = (Player)target;
            this.damagedThisCombat.add(pTgt);
            if (pTgt.getLastTurnNr() > 0 && !pTgt.getGame().getPhaseHandler().isPlayerTurn(pTgt)) {
                pTgt.setBeenDealtCombatDamageSinceLastTurn(true);
            }
        }
        Pair<Integer, Boolean> dmg = Pair.of(damage, isCombat);
        this.damageDoneThisTurn.add(dmg);
        target.receiveDamage(dmg);
        sourceLKI.getGame().addGlobalDamageHistory(this, dmg, sourceLKI.isLKI() ? sourceLKI : CardCopyService.getLKICopy(sourceLKI, lkiCache), CardCopyService.getLKICopy(target, lkiCache));
    }

    public int getDamageDoneThisTurn(Boolean isCombat, boolean anyIsEnough, String validSourceCard, String validTargetEntity, Card source, Player sourceController, CardTraitBase ctb) {
        int sum = 0;
        for (Pair<Integer, Boolean> damage : this.damageDoneThisTurn) {
            Pair<Card, GameEntity> sourceToTarget = sourceController.getGame().getDamageLKI(damage);
            if (isCombat != null && damage.getRight() != isCombat || sourceToTarget != null && (validSourceCard != null && !sourceToTarget.getLeft().isValid(validSourceCard.split(","), sourceController, source == null ? sourceToTarget.getLeft() : source, ctb) || validTargetEntity != null && !sourceToTarget.getRight().isValid(validTargetEntity.split(","), sourceController, source, ctb))) continue;
            sum += damage.getLeft().intValue();
            if (!anyIsEnough) continue;
            break;
        }
        return sum;
    }

    public void newTurn() {
        this.attackedThisTurn.clear();
        this.attackedBattleThisTurn = false;
        this.damagedThisCombat.clear();
        this.damageDoneThisTurn.clear();
        CardCollection toRemove = new CardCollection();
        for (GameEntity e : this.damagedThisGame) {
            if (!(e instanceof Card) || ((Card)e).getZone().getZoneType() == ZoneType.Battlefield) continue;
            toRemove.add((Card)e);
        }
        this.damagedThisGame.removeAll(toRemove);
    }

    public void endCombat() {
        this.damagedThisCombat.clear();
        this.setCreatureAttackedThisCombat(null, -1);
        this.setCreatureBlockedThisCombat(false);
        this.setCreatureGotBlockedThisCombat(false);
    }
}

