/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.HashMap;
import java.util.Map;

public final class CardChangedWords
extends ForwardingMap<String, String> {
    private final Table<Long, Long, WordHolder> map = TreeBasedTable.create();
    private boolean isDirty = false;
    private Map<String, String> resultCache = Maps.newHashMap();

    public Long addEmpty(long timestamp, long staticId) {
        Long stamp = timestamp;
        this.map.put(stamp, staticId, new WordHolder());
        this.isDirty = true;
        return stamp;
    }

    public Long add(long timestamp, long staticId, String originalWord, String newWord) {
        Long stamp = timestamp;
        this.map.put(stamp, staticId, new WordHolder(originalWord, newWord));
        this.isDirty = true;
        return stamp;
    }

    public boolean remove(Long timestamp, long staticId) {
        this.isDirty = true;
        return this.map.remove(timestamp, staticId) != null;
    }

    @Override
    public void clear() {
        super.clear();
        this.map.clear();
        this.isDirty = true;
    }

    void copyFrom(CardChangedWords other) {
        this.map.clear();
        this.map.putAll(other.map);
        this.isDirty = true;
    }

    @Override
    protected Map<String, String> delegate() {
        this.refreshCache();
        return this.resultCache;
    }

    private void refreshCache() {
        if (this.isDirty) {
            this.resultCache.clear();
            for (WordHolder ccw : this.map.values()) {
                if (ccw.clear) {
                    this.resultCache.clear();
                    continue;
                }
                HashMap<String, String> toBeChanged = Maps.newHashMap();
                for (Map.Entry<String, String> e : this.resultCache.entrySet()) {
                    if (!e.getValue().equals(ccw.oldWord)) continue;
                    toBeChanged.put(e.getKey(), ccw.newWord);
                }
                this.resultCache.putAll(toBeChanged);
                this.resultCache.put(ccw.oldWord, ccw.newWord);
            }
            this.isDirty = false;
        }
    }

    class WordHolder {
        public String oldWord;
        public String newWord;
        public boolean clear = false;

        WordHolder() {
            this.clear = true;
        }

        WordHolder(String oldWord, String newWord) {
            this.oldWord = oldWord;
            this.newWord = newWord;
        }
    }
}

