/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.esotericsoftware.minlog.Log;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.TreeBasedTable;
import forge.GameCommand;
import forge.StaticData;
import forge.card.CardChangedType;
import forge.card.CardDb;
import forge.card.CardEdition;
import forge.card.CardRarity;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.CardTypeView;
import forge.card.ColorSet;
import forge.card.GamePieceType;
import forge.card.ICardFace;
import forge.card.MagicColor;
import forge.card.RemoveType;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.game.CardTraitBase;
import forge.game.Direction;
import forge.game.EvenOdd;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameStage;
import forge.game.IHasSVars;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.ActivationTable;
import forge.game.card.CardChangedName;
import forge.game.card.CardChangedWords;
import forge.game.card.CardCloneStates;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardColor;
import forge.game.card.CardDamageHistory;
import forge.game.card.CardFactory;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPlayOption;
import forge.game.card.CardPredicates;
import forge.game.card.CardProperty;
import forge.game.card.CardState;
import forge.game.card.CardTraitChanges;
import forge.game.card.CardUtil;
import forge.game.card.CardView;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.combat.CombatLki;
import forge.game.cost.Cost;
import forge.game.event.GameEventCardAttachment;
import forge.game.event.GameEventCardCounters;
import forge.game.event.GameEventCardDamaged;
import forge.game.event.GameEventCardPhased;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.event.GameEventCardTapped;
import forge.game.event.GameEventTokenStateUpdate;
import forge.game.keyword.Companion;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordCollection;
import forge.game.keyword.KeywordInterface;
import forge.game.keyword.KeywordsChange;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplaceMoved;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementResult;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.spellability.SpellPermanent;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityActivateAbilityAsIfHaste;
import forge.game.staticability.StaticAbilityAssignNoCombatDamage;
import forge.game.staticability.StaticAbilityAttackVigilance;
import forge.game.staticability.StaticAbilityCantAttackBlock;
import forge.game.staticability.StaticAbilityCantBeSuspected;
import forge.game.staticability.StaticAbilityCantCrew;
import forge.game.staticability.StaticAbilityCantExile;
import forge.game.staticability.StaticAbilityCantPhase;
import forge.game.staticability.StaticAbilityCantPreventDamage;
import forge.game.staticability.StaticAbilityCantPutCounter;
import forge.game.staticability.StaticAbilityCantRegenerate;
import forge.game.staticability.StaticAbilityCantSacrifice;
import forge.game.staticability.StaticAbilityCantTarget;
import forge.game.staticability.StaticAbilityCantTransform;
import forge.game.staticability.StaticAbilityCombatDamageToughness;
import forge.game.staticability.StaticAbilityIgnoreLegendRule;
import forge.game.staticability.StaticAbilityNoCleanupDamage;
import forge.game.staticability.StaticAbilityNumLoyaltyAct;
import forge.game.staticability.StaticAbilityWitherDamage;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.trackable.TrackableProperty;
import forge.trackable.Tracker;
import forge.util.CardTranslation;
import forge.util.ITranslatable;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.Visitor;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class Card
extends GameEntity
implements Comparable<Card>,
IHasSVars,
ITranslatable {
    private Game game;
    private final IPaperCard paperCard;
    private final Map<CardStateName, CardState> states = Maps.newEnumMap(CardStateName.class);
    private CardState currentState;
    private CardStateName currentStateName = CardStateName.Original;
    private GamePieceType gamePieceType = GamePieceType.CARD;
    private Zone castFrom;
    private SpellAbility castSA;
    private CardDamageHistory damageHistory = new CardDamageHistory();
    private final Table<Long, Long, List<String>> hiddenExtrinsicKeywords = TreeBasedTable.create();
    private CardCollection hauntedBy;
    private CardCollection devouredCards;
    private CardCollection exploitedCards;
    private CardCollection delvedCards;
    private CardCollection imprintedCards;
    private CardCollection exiledCards;
    private CardCollection encodedCards;
    private CardCollection gainControlTargets;
    private CardCollection chosenCards;
    private CardCollection mergedCards;
    private Map<Long, CardCollection> mustBlockCards = Maps.newHashMap();
    private List<Card> blockedThisTurn = Lists.newArrayList();
    private List<Card> blockedByThisTurn = Lists.newArrayList();
    private Map<Player, CardCollection> chosenMap = Maps.newHashMap();
    private CardCollection untilLeavesBattlefield = new CardCollection();
    private Card encoding;
    private Card cloneOrigin;
    private Card haunting;
    private Card effectSource;
    private Card pairedWith;
    private Card meldedWith;
    private Card mergedTo;
    private SpellAbility effectSourceAbility;
    private SpellAbility tokenSpawningAbility;
    private GameEntity entityAttachedTo;
    private Map<StaticAbility, CardPlayOption> mayPlay = Maps.newHashMap();
    protected CardChangedType changedTypeByText;
    private final Table<Long, Long, CardChangedType> changedCardTypesByText = TreeBasedTable.create();
    private final Table<Long, Long, CardChangedType> changedCardTypesCharacterDefining = TreeBasedTable.create();
    private final Table<Long, Long, CardChangedType> changedCardTypes = TreeBasedTable.create();
    private final Table<Long, Long, CardChangedName> changedCardNames = TreeBasedTable.create();
    private final Table<Long, Long, KeywordsChange> changedCardKeywordsByText = TreeBasedTable.create();
    protected KeywordsChange changedCardKeywordsByWord = new KeywordsChange((Collection<KeywordInterface>)ImmutableList.of(), (Collection<KeywordInterface>)ImmutableList.of(), false);
    private final Table<Long, Long, KeywordsChange> changedCardKeywords = TreeBasedTable.create();
    private final Map<Triple<String, Long, Long>, KeywordInterface> storedKeywords = Maps.newHashMap();
    private final Table<Long, Long, CardTraitChanges> changedCardTraitsByText = TreeBasedTable.create();
    private final Table<Long, Long, CardTraitChanges> changedCardTraits = TreeBasedTable.create();
    private final Table<StaticAbility, String, SpellAbility> storedSpellAbility = TreeBasedTable.create();
    private final Table<StaticAbility, String, Trigger> storedTrigger = TreeBasedTable.create();
    private final Table<StaticAbility, String, ReplacementEffect> storedReplacementEffect = TreeBasedTable.create();
    private final Table<StaticAbility, String, StaticAbility> storedStaticAbility = TreeBasedTable.create();
    private final Table<StaticAbility, SpellAbility, SpellAbility> storedSpellAbililityByText = HashBasedTable.create();
    private final Table<StaticAbility, String, SpellAbility> storedSpellAbililityGainedByText = TreeBasedTable.create();
    private final Table<StaticAbility, Trigger, Trigger> storedTriggerByText = HashBasedTable.create();
    private final Table<StaticAbility, ReplacementEffect, ReplacementEffect> storedReplacementEffectByText = HashBasedTable.create();
    private final Table<StaticAbility, StaticAbility, StaticAbility> storedStaticAbilityByText = HashBasedTable.create();
    private final Map<Triple<String, Long, Long>, KeywordInterface> storedKeywordByText = Maps.newHashMap();
    private final Table<Long, Long, CardColor> changedCardColorsByText = TreeBasedTable.create();
    private final Table<Long, Long, CardColor> changedCardColorsCharacterDefining = TreeBasedTable.create();
    private final Table<Long, Long, CardColor> changedCardColors = TreeBasedTable.create();
    protected final Table<Long, Long, ManaCost> changedCardManaCost = TreeBasedTable.create();
    private final NavigableMap<Long, CardCloneStates> clonedStates = Maps.newTreeMap();
    private final Table<Long, Long, Map<String, String>> changedSVars = TreeBasedTable.create();
    private final Map<Long, PlayerCollection> mayLook = Maps.newHashMap();
    private final PlayerCollection mayLookFaceDownExile = new PlayerCollection();
    private final PlayerCollection mayLookTemp = new PlayerCollection();
    private final Multimap<Long, Keyword> cantHaveKeywords = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Map<CounterType, Long> counterTypeTimestamps = Maps.newHashMap();
    private final Map<Long, Integer> canBlockAdditional = Maps.newTreeMap();
    private final Set<Long> canBlockAny = Sets.newHashSet();
    private final CardChangedWords changedTextColors = new CardChangedWords();
    private final CardChangedWords changedTextTypes = new CardChangedWords();
    private final Set<Object> rememberedObjects = Sets.newLinkedHashSet();
    private final List<String> draftActions = Lists.newArrayList();
    private Map<Player, String> flipResult;
    private List<Integer> storedRolls;
    private boolean isCommander = false;
    private boolean canMoveToCommandZone = false;
    private boolean startsGameInPlay = false;
    private boolean drawnThisTurn = false;
    private boolean foughtThisTurn = false;
    private boolean becameTargetThisTurn;
    private boolean valiant = false;
    private boolean enlistedThisCombat = false;
    private boolean startedTheTurnUntapped = false;
    private boolean cameUnderControlSinceLastUpkeep = true;
    private boolean tapped = false;
    private boolean sickness = true;
    private boolean collectible = false;
    private boolean tokenCard = false;
    private Card copiedPermanent;
    private boolean unearthed;
    private boolean ringbearer;
    private boolean monstrous;
    private boolean renowned;
    private boolean solved = false;
    private Long suspectedTimestamp = null;
    private StaticAbility suspectedStatic = null;
    private boolean manifested;
    private boolean cloaked;
    private boolean foretold;
    private boolean foretoldCostByEffect;
    private boolean plotted;
    private Set<CardStateName> unlockedRooms = EnumSet.noneOf(CardStateName.class);
    private Map<CardStateName, SpellAbility> unlockAbilities = Maps.newEnumMap(CardStateName.class);
    private boolean specialized;
    private int timesCrewedThisTurn = 0;
    private CardCollection crewedByThisTurn;
    private boolean saddled = false;
    private int timesSaddledThisTurn = 0;
    private CardCollection saddledByThisTurn;
    private boolean visitedThisTurn = false;
    private int classLevel = 1;
    private long bestowTimestamp = -1L;
    private long transformedTimestamp = 0L;
    private long prototypeTimestamp = -1L;
    private long mutatedTimestamp = -1L;
    private int timesMutated = 0;
    private boolean tributed = false;
    private boolean discarded;
    private boolean surveilled;
    private boolean milled;
    private boolean flipped = false;
    private boolean facedown = false;
    private boolean turnedFaceUpThisTurn = false;
    private boolean backside = false;
    private Player phasedOut;
    private boolean directlyPhasedOut = true;
    private boolean wontPhaseInNormal = false;
    private boolean usedToPayCost = false;
    private boolean isEmblem = false;
    private boolean isBoon = false;
    private int exertThisTurn = 0;
    private PlayerCollection exertedByPlayer = new PlayerCollection();
    private long gameTimestamp = -1L;
    private long layerTimestamp = -1L;
    private Table<Long, Long, Pair<Integer, Integer>> newPTText = TreeBasedTable.create();
    private Table<Long, Long, Pair<Integer, Integer>> newPTCharacterDefining = TreeBasedTable.create();
    private Table<Long, Long, Pair<Integer, Integer>> newPT = TreeBasedTable.create();
    private Table<Long, Long, Pair<Integer, Integer>> boostPT = TreeBasedTable.create();
    private final Map<Card, Integer> assignedDamageMap = Maps.newTreeMap();
    private Map<Integer, Integer> damage = Maps.newHashMap();
    private boolean hasBeenDealtDeathtouchDamage;
    private boolean hasBeenDealtExcessDamageThisTurn;
    private int excessDamageThisTurnAmount = 0;
    private int shieldCount = 0;
    private int regeneratedThisTurn;
    private int turnInZone;
    private Player turnInController;
    private Map<String, Integer> xManaCostPaidByColor;
    private Player owner;
    private Player controller;
    private long controllerTimestamp;
    private NavigableMap<Long, Player> tempControllers = Maps.newTreeMap();
    private String originalText = "";
    private String text = "";
    private String chosenType = "";
    private String chosenType2 = "";
    private List<String> notedTypes = new ArrayList<String>();
    private List<String> chosenColors;
    private List<String> chosenName = new ArrayList<String>();
    private Integer chosenNumber;
    private Player chosenPlayer;
    private Player promisedGift;
    private Player protectingPlayer;
    private EvenOdd chosenEvenOdd = null;
    private Direction chosenDirection = null;
    private String chosenMode = "";
    private String currentRoom = null;
    private String sector = null;
    private String chosenSector = null;
    private Card exiledWith;
    private Player exiledBy;
    private Map<Long, Player> goad = Maps.newTreeMap();
    private List<GameCommand> leavePlayCommandList = Lists.newArrayList();
    private final List<GameCommand> untapCommandList = Lists.newArrayList();
    private final List<GameCommand> changeControllerCommandList = Lists.newArrayList();
    private final List<GameCommand> unattachCommandList = Lists.newArrayList();
    private final List<GameCommand> faceupCommandList = Lists.newArrayList();
    private final List<GameCommand> facedownCommandList = Lists.newArrayList();
    private final List<GameCommand> phaseOutCommandList = Lists.newArrayList();
    private final List<Object[]> staticCommandList = Lists.newArrayList();
    private Zone currentZone;
    private Zone savedLastKnownZone;
    private int lkiCMC = -1;
    private CardRules cardRules;
    private final CardView view;
    private SpellAbility[] basicLandAbilities = new SpellAbility[MagicColor.WUBRG.length];
    private int planeswalkerAbilityActivated;
    private boolean planeswalkerActivationLimitUsed;
    private final ActivationTable numberTurnActivations = new ActivationTable();
    private final ActivationTable numberGameActivations = new ActivationTable();
    private final ActivationTable numberAbilityResolved = new ActivationTable();
    private final Map<SpellAbility, List<String>> chosenModesTurn = Maps.newHashMap();
    private final Map<SpellAbility, List<String>> chosenModesGame = Maps.newHashMap();
    private final Map<SpellAbility, List<String>> chosenModesYourCombat = Maps.newHashMap();
    private final Map<SpellAbility, List<String>> chosenModesYourLastCombat = Maps.newHashMap();
    private final Table<SpellAbility, StaticAbility, List<String>> chosenModesTurnStatic = HashBasedTable.create();
    private final Table<SpellAbility, StaticAbility, List<String>> chosenModesGameStatic = HashBasedTable.create();
    private final Table<SpellAbility, StaticAbility, List<String>> chosenModesYourCombatStatic = HashBasedTable.create();
    private final Table<SpellAbility, StaticAbility, List<String>> chosenModesYourLastCombatStatic = HashBasedTable.create();
    private CombatLki combatLKI;
    private ReplacementEffect shieldCounterReplaceDamage = null;
    private ReplacementEffect shieldCounterReplaceDestroy = null;
    private ReplacementEffect stunCounterReplaceUntap = null;
    private ReplacementEffect finalityReplaceDying = null;
    private int intensity = 0;
    private List<Map<String, Object>> perpetual = new ArrayList<Map<String, Object>>();
    private static final Map<PaperCard, Card> cp2card = Maps.newHashMap();

    public Card(int id0, Game game0) {
        this(id0, null, game0);
    }

    public Card(int id0, IPaperCard paperCard0, Game game0) {
        this(id0, paperCard0, game0, game0 == null ? null : game0.getTracker());
    }

    public Card(int id0, IPaperCard paperCard0, Game game0, Tracker tracker0) {
        super(id0);
        this.game = game0;
        this.paperCard = paperCard0;
        this.view = new CardView(id0, tracker0);
        this.currentState = new CardState(this.view.getCurrentState(), this);
        this.states.put(CardStateName.Original, this.currentState);
        this.view.updateChangedColorWords(this);
        this.view.updateChangedTypes(this);
        this.view.updateSickness(this);
        this.view.updateClassLevel(this);
        this.view.updateDraftAction(this);
    }

    public boolean changeToState(CardStateName state) {
        if (this.hasState(state)) {
            return this.setState(state, true);
        }
        return false;
    }

    public long getPrototypeTimestamp() {
        return this.prototypeTimestamp;
    }

    public long getTransformedTimestamp() {
        return this.transformedTimestamp;
    }

    public void incrementTransformedTimestamp() {
        ++this.transformedTimestamp;
    }

    public void undoIncrementTransformedTimestamp() {
        --this.transformedTimestamp;
    }

    public CardState getCurrentState() {
        return this.currentState;
    }

    public CardStateName getAlternateStateName() {
        if (this.hasAlternateState()) {
            CardStateName changedState;
            if (this.isSplitCard()) {
                return this.currentStateName == CardStateName.RightSplit ? CardStateName.LeftSplit : CardStateName.RightSplit;
            }
            if (this.getRules() != null && this.currentStateName != (changedState = this.getRules().getSplitType().getChangedStateName())) {
                return changedState;
            }
            return CardStateName.Original;
        }
        if (this.isFaceDown()) {
            return CardStateName.Original;
        }
        return null;
    }

    public CardState getAlternateState() {
        if (this.hasAlternateState() || this.isFaceDown()) {
            return this.states.get((Object)this.getAlternateStateName());
        }
        return null;
    }

    public CardState getState(CardStateName state) {
        if (state == CardStateName.FaceDown) {
            return this.getFaceDownState();
        }
        if (state == CardStateName.EmptyRoom) {
            return this.getEmptyRoomState();
        }
        CardCloneStates clStates = this.getLastClonedState();
        if (clStates == null) {
            return this.getOriginalState(state);
        }
        return clStates.get(state);
    }

    public boolean hasState(CardStateName state) {
        if (state == CardStateName.FaceDown || state == CardStateName.EmptyRoom) {
            return true;
        }
        CardCloneStates clStates = this.getLastClonedState();
        if (clStates == null) {
            return this.states.containsKey((Object)state);
        }
        return clStates.containsKey((Object)state);
    }

    public CardState getOriginalState(CardStateName state) {
        if (state == CardStateName.FaceDown) {
            return this.getFaceDownState();
        }
        if (state == CardStateName.EmptyRoom) {
            return this.getEmptyRoomState();
        }
        return this.states.get((Object)state);
    }

    public CardState getFaceDownState() {
        if (!this.states.containsKey((Object)CardStateName.FaceDown)) {
            this.states.put(CardStateName.FaceDown, CardUtil.getFaceDownCharacteristic(this));
        }
        return this.states.get((Object)CardStateName.FaceDown);
    }

    public void setOriginalStateAsFaceDown() {
        this.currentState = CardUtil.getFaceDownCharacteristic(this, CardStateName.Original);
        this.states.put(CardStateName.Original, this.currentState);
    }

    public boolean setState(CardStateName state, boolean updateView) {
        return this.setState(state, updateView, false);
    }

    public boolean setState(CardStateName state, boolean updateView, boolean forceUpdate) {
        boolean needsTransformAnimation;
        boolean rollback = state == CardStateName.Original && (this.currentStateName == CardStateName.Flipped || this.currentStateName == CardStateName.Transformed);
        boolean transform = state == CardStateName.Flipped || state == CardStateName.Transformed || state == CardStateName.Meld;
        boolean bl = needsTransformAnimation = transform || rollback;
        if (state != CardStateName.FaceDown && state != CardStateName.EmptyRoom) {
            CardCloneStates cloneStates = this.getLastClonedState();
            if (cloneStates != null) {
                if (!cloneStates.containsKey((Object)state)) {
                    throw new RuntimeException(this.getName() + " tried to switch to non-existant cloned state \"" + (Object)((Object)state) + "\"!");
                }
            } else if (!this.states.containsKey((Object)state)) {
                System.out.println(this.getName() + " tried to switch to non-existant state \"" + (Object)((Object)state) + "\"!");
                return false;
            }
        }
        if (state.equals((Object)this.currentStateName) && !forceUpdate) {
            return false;
        }
        if (this.currentStateName.equals((Object)CardStateName.FaceDown) && state.equals((Object)CardStateName.Original)) {
            this.setManifested(false);
            this.setCloaked(false);
        }
        this.currentStateName = state;
        this.currentState = this.getState(state);
        if (updateView) {
            this.view.updateState(this);
            this.view.updateNeedsTransformAnimation(needsTransformAnimation);
            if (this.game != null) {
                if (!this.changedCardTypes.isEmpty()) {
                    this.updateTypesForView();
                }
                this.updateColorForView();
                if (!this.changedCardKeywords.isEmpty()) {
                    this.updateKeywords();
                }
                if (state == CardStateName.FaceDown) {
                    this.view.updateHiddenId(this.game.nextHiddenCardId());
                }
                this.game.fireEvent(new GameEventCardStatsChanged(this));
            }
        }
        return true;
    }

    public Set<CardStateName> getStates() {
        return this.states.keySet();
    }

    public CardStateName getCurrentStateName() {
        return this.currentStateName;
    }

    public void setStates(Map<CardStateName, CardState> map) {
        this.states.clear();
        this.states.putAll(map);
    }

    public final void addAlternateState(CardStateName state, boolean updateView) {
        this.states.put(state, new CardState(this, state));
        if (updateView) {
            this.view.updateState(this);
        }
    }

    public void clearStates(CardStateName state, boolean updateView) {
        if (this.states.remove((Object)state) == null) {
            return;
        }
        if (state == this.currentStateName) {
            this.currentStateName = CardStateName.Original;
        }
        if (updateView) {
            this.view.updateState(this);
        }
    }

    public void updateStateForView() {
        this.view.updateState(this);
    }

    public void updateAbilityTextForView() {
        this.updateKeywords();
    }

    public void updateManaCostForView() {
        this.currentState.getView().updateManaCost(this);
    }

    public final void updatePowerToughnessForView() {
        this.view.updateCounters(this);
    }

    public final void updateTypesForView() {
        this.currentState.getView().updateType(this.currentState);
    }

    public boolean changeCardState(String mode, String customState, SpellAbility cause) {
        if (this.isPhasedOut()) {
            return false;
        }
        if (mode == null) {
            return this.changeToState(CardStateName.smartValueOf(customState));
        }
        if (mode.equals("Transform") && (this.isTransformable() || this.hasMergedCard())) {
            if (!this.canTransform(cause)) {
                return false;
            }
            if (this.hasMergedCard()) {
                this.removeMutatedStates();
            }
            long ts = this.game.getNextTimestamp();
            CardCollectionView cards = this.hasMergedCard() ? this.getMergedCards() : new CardCollection(this);
            boolean retResult = false;
            for (Card c : cards) {
                if (!c.isTransformable()) continue;
                c.backside = !c.backside;
                c.setLayerTimestamp(ts);
                boolean result = c.changeToState(c.backside ? CardStateName.Transformed : CardStateName.Original);
                retResult = retResult || result;
            }
            if (this.hasMergedCard()) {
                this.rebuildMutatedStates(cause);
            }
            this.getGame().getReplacementHandler().run(ReplacementType.Transform, AbilityKey.mapFromAffected(this));
            this.getGame().getTriggerHandler().clearActiveTriggers(this, null);
            this.getGame().getTriggerHandler().registerActiveTrigger(this, false);
            if (cause == null || !cause.hasParam("ETB")) {
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
                this.getGame().getTriggerHandler().runTrigger(TriggerType.Transformed, runParams, false);
            }
            this.incrementTransformedTimestamp();
            return retResult;
        }
        if (mode.equals("Flip")) {
            if (this.isFlipped()) {
                return false;
            }
            boolean retResult = false;
            if (this.isFlipCard() || this.hasMergedCard()) {
                if (this.hasMergedCard()) {
                    this.removeMutatedStates();
                }
                CardCollectionView cards = this.hasMergedCard() ? this.getMergedCards() : new CardCollection(this);
                for (Card c : cards) {
                    c.flipped = true;
                    if (c.facedown) continue;
                    boolean result = c.changeToState(CardStateName.Flipped);
                    retResult = retResult || result;
                }
                if (this.hasMergedCard()) {
                    this.rebuildMutatedStates(cause);
                    this.game.getTriggerHandler().clearActiveTriggers(this, null);
                    this.game.getTriggerHandler().registerActiveTrigger(this, false);
                }
            } else {
                retResult = true;
                this.flipped = true;
            }
            return retResult;
        }
        if (mode.equals("TurnFaceUp")) {
            if (this.isFaceDown()) {
                return this.turnFaceUp(cause);
            }
        } else if (mode.equals("TurnFaceDown")) {
            CardStateName oldState = this.getCurrentStateName();
            if (oldState == CardStateName.Original || oldState == CardStateName.Flipped) {
                return this.turnFaceDown();
            }
        } else {
            if (mode.equals("Meld") && this.isMeldable()) {
                return this.changeToState(CardStateName.Meld);
            }
            if (mode.equals("Specialize") && this.canSpecialize()) {
                if (customState.equalsIgnoreCase("white")) {
                    return this.changeToState(CardStateName.SpecializeW);
                }
                if (customState.equalsIgnoreCase("blue")) {
                    return this.changeToState(CardStateName.SpecializeU);
                }
                if (customState.equalsIgnoreCase("black")) {
                    return this.changeToState(CardStateName.SpecializeB);
                }
                if (customState.equalsIgnoreCase("red")) {
                    return this.changeToState(CardStateName.SpecializeR);
                }
                if (customState.equalsIgnoreCase("green")) {
                    return this.changeToState(CardStateName.SpecializeG);
                }
            } else if (mode.equals("Unspecialize") && this.isSpecialized()) {
                return this.changeToState(CardStateName.Original);
            }
        }
        return false;
    }

    public Card manifest(Player p, SpellAbility sa, Map<AbilityKey, Object> params) {
        if (!this.turnFaceDown(true) && !this.isFaceDown()) {
            return null;
        }
        this.setController(p, this.game.getNextTimestamp());
        this.setManifested(true);
        Card c = this.game.getAction().moveToPlay(this, p, sa, params);
        if (c.isInPlay()) {
            c.setManifested(true);
            c.turnFaceDown(true);
            c.updateStateForView();
        }
        return c;
    }

    public Card cloak(Player p, SpellAbility sa, Map<AbilityKey, Object> params) {
        if (!this.turnFaceDown(true) && !this.isFaceDown()) {
            return null;
        }
        this.setController(p, this.game.getNextTimestamp());
        this.setCloaked(true);
        this.getFaceDownState().addIntrinsicKeyword("Ward:2", true);
        Card c = this.game.getAction().moveToPlay(this, p, sa, params);
        if (c.isInPlay()) {
            c.setCloaked(true);
            c.turnFaceDown(true);
            c.updateStateForView();
        }
        return c;
    }

    public boolean turnFaceDown() {
        return this.turnFaceDown(false);
    }

    public boolean turnFaceDown(boolean override) {
        CardCollectionView cards = this.hasMergedCard() ? this.getMergedCards() : new CardCollection(this);
        boolean retResult = false;
        long ts = this.game.getNextTimestamp();
        for (Card c : cards) {
            if (!override && c.isDoubleFaced()) continue;
            c.facedown = true;
            c.setLayerTimestamp(ts);
            if (!c.setState(CardStateName.FaceDown, true)) continue;
            c.runFacedownCommands();
            retResult = true;
        }
        if (retResult && this.hasMergedCard()) {
            this.removeMutatedStates();
            this.rebuildMutatedStates(null);
            this.game.getTriggerHandler().clearActiveTriggers(this, null);
            this.game.getTriggerHandler().registerActiveTrigger(this, false);
        }
        return retResult;
    }

    public boolean turnFaceDownNoUpdate() {
        this.facedown = true;
        return this.setState(CardStateName.FaceDown, false);
    }

    public boolean canBeTurnedFaceUp() {
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        return !this.getGame().getReplacementHandler().cantHappenCheck(ReplacementType.TurnFaceUp, repParams);
    }

    public void forceTurnFaceUp() {
        this.turnFaceUp(false, null);
    }

    public boolean turnFaceUp(SpellAbility cause) {
        return this.turnFaceUp(true, cause);
    }

    public boolean turnFaceUp(boolean runTriggers, SpellAbility cause) {
        if (!this.isFaceDown() || !this.canBeTurnedFaceUp()) {
            return false;
        }
        CardCollectionView cards = this.hasMergedCard() ? this.getMergedCards() : new CardCollection(this);
        boolean retResult = false;
        long ts = this.game.getNextTimestamp();
        for (Card c : cards) {
            boolean result = c.isFlipped() && c.isFlipCard() ? c.setState(CardStateName.Flipped, true) : c.setState(CardStateName.Original, true);
            c.facedown = false;
            c.setLayerTimestamp(ts);
            c.turnedFaceUpThisTurn = true;
            c.updateStateForView();
            if (result) {
                c.runFaceupCommands();
            }
            retResult = retResult || result;
        }
        if (!retResult) {
            return false;
        }
        TriggerHandler triggerHandler = this.game.getTriggerHandler();
        if (this.hasMergedCard()) {
            this.removeMutatedStates();
            this.rebuildMutatedStates(cause);
            triggerHandler.clearActiveTriggers(this, null);
            triggerHandler.registerActiveTrigger(this, false);
        }
        if (runTriggers) {
            Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
            this.game.getReplacementHandler().run(ReplacementType.TurnFaceUp, repParams);
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
            runParams.put(AbilityKey.Cause, cause);
            triggerHandler.registerActiveTrigger(this, false);
            triggerHandler.runTrigger(TriggerType.TurnFaceUp, runParams, false);
        }
        return true;
    }

    public boolean wasTurnedFaceUpThisTurn() {
        return this.turnedFaceUpThisTurn;
    }

    public boolean canTransform(SpellAbility cause) {
        CardStateName destState;
        if (this.isFaceDown()) {
            return false;
        }
        Card transformCard = this;
        if (this.hasMergedCard()) {
            boolean hasTransformCard = false;
            for (Card c : this.getMergedCards()) {
                if (!c.isTransformable()) continue;
                hasTransformCard = true;
                transformCard = c;
                break;
            }
            if (!hasTransformCard) {
                return false;
            }
        } else if (!this.isTransformable()) {
            return false;
        }
        if (!this.isInPlay()) {
            return true;
        }
        CardStateName cardStateName = destState = transformCard.backside ? CardStateName.Original : CardStateName.Transformed;
        if (!transformCard.getOriginalState(destState).getType().isPermanent()) {
            return false;
        }
        return !StaticAbilityCantTransform.cantTransform(this, cause);
    }

    public int getHiddenId() {
        return this.view.getHiddenId();
    }

    public void updateAttackingForView() {
        this.view.updateAttacking(this);
        this.getGame().updateCombatForView();
    }

    public void updateBlockingForView() {
        this.view.updateBlocking(this);
        this.getGame().updateCombatForView();
    }

    @Override
    public final String getName() {
        return this.getName(this.currentState, false);
    }

    public final String getName(boolean alt) {
        return this.getName(this.currentState, alt);
    }

    public final String getName(CardStateName stateName) {
        return this.getName(this.getState(stateName), false);
    }

    public final String getName(CardState state, boolean alt) {
        String name = state.getName();
        for (CardChangedName change : this.changedCardNames.values()) {
            if (!change.isOverwrite()) continue;
            name = change.getNewName();
        }
        return alt ? StaticData.instance().getCommonCards().getName(name, true) : name;
    }

    public final boolean hasNameOverwrite() {
        return this.changedCardNames.values().stream().anyMatch(CardChangedName::isOverwrite);
    }

    public final boolean hasNonLegendaryCreatureNames() {
        boolean result = false;
        for (CardChangedName change : this.changedCardNames.values()) {
            if (change.isOverwrite()) {
                result = false;
                continue;
            }
            if (!change.isAddNonLegendaryCreatureNames()) continue;
            result = true;
        }
        return result;
    }

    @Override
    public final void setName(String name0) {
        this.currentState.setName(name0);
    }

    public void addChangedName(String name0, boolean addNonLegendaryCreatureNames, long timestamp, long staticId) {
        this.changedCardNames.put(timestamp, staticId, new CardChangedName(name0, addNonLegendaryCreatureNames));
        this.updateNameforView();
    }

    public void removeChangedName(long timestamp, long staticId) {
        if (this.changedCardNames.remove(timestamp, staticId) != null) {
            this.updateNameforView();
        }
    }

    public boolean clearChangedName() {
        boolean changed = !this.changedCardNames.isEmpty();
        this.changedCardNames.clear();
        return changed;
    }

    public void updateNameforView() {
        this.currentState.getView().updateName(this.currentState);
    }

    public Table<Long, Long, CardChangedName> getChangedCardNames() {
        return this.changedCardNames;
    }

    public void setChangedCardNames(Table<Long, Long, CardChangedName> changedCardNames) {
        this.changedCardNames.clear();
        this.changedCardNames.putAll(changedCardNames);
    }

    public void setGamePieceType(GamePieceType gamePieceType) {
        this.gamePieceType = gamePieceType;
        this.view.updateGamePieceType(this);
        this.view.updateToken(this);
    }

    public GamePieceType getGamePieceType() {
        return this.gamePieceType;
    }

    public final boolean isToken() {
        if (this.isInPlay() && this.hasMergedCard()) {
            return this.getTopMergedCard().gamePieceType == GamePieceType.TOKEN;
        }
        return this.gamePieceType == GamePieceType.TOKEN;
    }

    public final boolean isRealToken() {
        return this.gamePieceType == GamePieceType.TOKEN;
    }

    public final boolean isCopiedSpell() {
        return this.gamePieceType == GamePieceType.COPIED_SPELL;
    }

    public final boolean isImmutable() {
        return this.gamePieceType == GamePieceType.EFFECT;
    }

    public final boolean isInAlternateState() {
        return this.currentStateName != CardStateName.Original;
    }

    public final boolean hasAlternateState() {
        int threshold = this.states.containsKey((Object)CardStateName.FaceDown) ? 2 : 1;
        int numStates = this.states.keySet().size();
        return numStates > threshold;
    }

    public final boolean isTransformable() {
        return this.getRules() != null && this.getRules().getSplitType() == CardSplitType.Transform;
    }

    public final boolean isMeldable() {
        return this.getRules() != null && this.getRules().getSplitType() == CardSplitType.Meld;
    }

    public final boolean isModal() {
        return this.getRules() != null && this.getRules().getSplitType() == CardSplitType.Modal;
    }

    public final boolean isDoubleFaced() {
        return this.isTransformable() || this.isMeldable() || this.isModal();
    }

    public final boolean isFlipCard() {
        return this.hasState(CardStateName.Flipped);
    }

    public final boolean isSplitCard() {
        if (this.getRules() != null && this.getRules().getSplitType() == CardSplitType.Split) {
            return true;
        }
        return this.hasState(CardStateName.LeftSplit);
    }

    public final boolean isAdventureCard() {
        return this.hasState(CardStateName.Adventure);
    }

    public final boolean isBackSide() {
        return this.backside;
    }

    public final void setBackSide(boolean value) {
        this.backside = value;
    }

    public boolean isCloned() {
        return !this.clonedStates.isEmpty() && this.clonedStates.lastEntry().getKey() != this.mutatedTimestamp && this.clonedStates.lastEntry().getKey() != this.prototypeTimestamp;
    }

    public final CardCollectionView getDevouredCards() {
        return CardCollection.getView(this.devouredCards);
    }

    public final void addDevoured(Card c) {
        if (this.devouredCards == null) {
            this.devouredCards = new CardCollection();
        }
        this.devouredCards.add(c);
    }

    public final void clearDevoured() {
        this.devouredCards = null;
    }

    public final CardCollectionView getExploited() {
        return CardCollection.getView(this.exploitedCards);
    }

    public final void addExploited(Card c) {
        if (this.exploitedCards == null) {
            this.exploitedCards = new CardCollection();
        }
        this.exploitedCards.add(c);
    }

    public final void clearExploited() {
        this.exploitedCards = null;
    }

    public final CardCollectionView getDelved() {
        return CardCollection.getView(this.delvedCards);
    }

    public final void addDelved(Card c) {
        if (this.delvedCards == null) {
            this.delvedCards = new CardCollection();
        }
        this.delvedCards.add(c);
    }

    public final void clearDelved() {
        this.delvedCards = null;
    }

    public final CardCollectionView getConvoked() {
        if (this.getCastSA() == null) {
            return CardCollection.EMPTY;
        }
        return this.getCastSA().getTappedForConvoke();
    }

    public final CardCollectionView getEmerged() {
        if (this.getCastSA() == null) {
            return CardCollection.EMPTY;
        }
        return new CardCollection(this.getCastSA().getSacrificedAsEmerge());
    }

    public final Iterable<Object> getRemembered() {
        return this.rememberedObjects;
    }

    public final boolean hasRemembered() {
        return !this.rememberedObjects.isEmpty();
    }

    public final int getRememberedCount() {
        return this.rememberedObjects.size();
    }

    public final Object getFirstRemembered() {
        return Iterables.getFirst(this.rememberedObjects, null);
    }

    public final <T> boolean isRemembered(T o) {
        return this.rememberedObjects.contains(o);
    }

    public final <T> void addRemembered(T o) {
        if (this.rememberedObjects.add(o)) {
            this.view.updateRemembered(this);
        }
    }

    public final <T> void addRemembered(Iterable<T> objects) {
        boolean changed = false;
        for (T o : objects) {
            if (!this.rememberedObjects.add(o)) continue;
            changed = true;
        }
        if (changed) {
            this.view.updateRemembered(this);
        }
    }

    public final <T> void removeRemembered(T o) {
        if (this.rememberedObjects.remove(o)) {
            this.view.updateRemembered(this);
        }
    }

    public final <T> void removeRemembered(Iterable<T> list) {
        boolean changed = false;
        for (T o : list) {
            if (!this.rememberedObjects.remove(o)) continue;
            changed = true;
        }
        if (changed) {
            this.view.updateRemembered(this);
        }
    }

    public final void clearRemembered() {
        if (this.rememberedObjects.isEmpty()) {
            return;
        }
        this.rememberedObjects.clear();
        this.view.updateRemembered(this);
    }

    public final void updateRemembered() {
        this.view.updateRemembered(this);
    }

    public final CardCollectionView getImprintedCards() {
        return CardCollection.getView(this.imprintedCards);
    }

    public final boolean hasImprintedCard() {
        return FCollection.hasElements(this.imprintedCards);
    }

    public final boolean hasImprintedCard(Card c) {
        return FCollection.hasElement(this.imprintedCards, c);
    }

    public final void addImprintedCard(Card c) {
        this.imprintedCards = this.view.addCard(this.imprintedCards, c, TrackableProperty.ImprintedCards);
    }

    public final void addImprintedCards(Iterable<Card> cards) {
        this.imprintedCards = this.view.addCards(this.imprintedCards, cards, TrackableProperty.ImprintedCards);
    }

    public final void removeImprintedCard(Card c) {
        this.imprintedCards = this.view.removeCard(this.imprintedCards, c, TrackableProperty.ImprintedCards);
    }

    public final void removeImprintedCards(Iterable<Card> cards) {
        this.imprintedCards = this.view.removeCards(this.imprintedCards, cards, TrackableProperty.ImprintedCards);
    }

    public final void clearImprintedCards() {
        this.imprintedCards = this.view.clearCards(this.imprintedCards, TrackableProperty.ImprintedCards);
    }

    public final void addToChosenMap(Player p, CardCollection chosen) {
        this.chosenMap.put(p, chosen);
    }

    public final Map<Player, CardCollection> getChosenMap() {
        return this.chosenMap;
    }

    public final CardCollectionView getExiledCards() {
        return CardCollection.getView(this.exiledCards);
    }

    public final boolean hasExiledCard() {
        return FCollection.hasElements(this.exiledCards);
    }

    public final boolean hasExiledCard(Card c) {
        return FCollection.hasElement(this.exiledCards, c);
    }

    public final void addExiledCard(Card c) {
        this.exiledCards = this.view.addCard(this.exiledCards, c, TrackableProperty.ExiledCards);
    }

    public final void addExiledCards(Iterable<Card> cards) {
        this.exiledCards = this.view.addCards(this.exiledCards, cards, TrackableProperty.ExiledCards);
    }

    public final void removeExiledCard(Card c) {
        this.exiledCards = this.view.removeCard(this.exiledCards, c, TrackableProperty.ExiledCards);
    }

    public final void removeExiledCards(Iterable<Card> cards) {
        this.exiledCards = this.view.removeCards(this.exiledCards, cards, TrackableProperty.ExiledCards);
    }

    public final void clearExiledCards() {
        this.exiledCards = this.view.clearCards(this.exiledCards, TrackableProperty.ExiledCards);
    }

    public final CardCollectionView getEncodedCards() {
        return CardCollection.getView(this.encodedCards);
    }

    public final boolean hasEncodedCard() {
        return FCollection.hasElements(this.encodedCards);
    }

    public final boolean hasEncodedCard(Card c) {
        return FCollection.hasElement(this.encodedCards, c);
    }

    public final void addEncodedCard(Card c) {
        this.encodedCards = this.view.addCard(this.encodedCards, c, TrackableProperty.EncodedCards);
    }

    public final void addEncodedCards(Iterable<Card> cards) {
        this.encodedCards = this.view.addCards(this.encodedCards, cards, TrackableProperty.EncodedCards);
    }

    public final void removeEncodedCard(Card c) {
        this.encodedCards = this.view.removeCard(this.encodedCards, c, TrackableProperty.EncodedCards);
    }

    public final void clearEncodedCards() {
        this.encodedCards = this.view.clearCards(this.encodedCards, TrackableProperty.EncodedCards);
    }

    public final Card getEncodingCard() {
        return this.encoding;
    }

    public final void setEncodingCard(Card e) {
        this.encoding = e;
    }

    public final CardCollectionView getMergedCards() {
        return CardCollection.getView(this.mergedCards);
    }

    public final Card getTopMergedCard() {
        return (Card)this.mergedCards.get(false);
    }

    public final boolean hasMergedCard() {
        return FCollection.hasElements(this.mergedCards);
    }

    public final void addMergedCard(Card c) {
        if (this.mergedCards == null) {
            this.mergedCards = new CardCollection();
        }
        this.mergedCards.add(c);
    }

    public final void addMergedCardToTop(Card c) {
        this.mergedCards.add(0, c);
    }

    public final void removeMergedCard(Card c) {
        this.mergedCards.remove(c);
    }

    public final void clearMergedCards() {
        this.mergedCards.clear();
    }

    public final Card getMergedToCard() {
        return this.mergedTo;
    }

    public final void setMergedToCard(Card c) {
        this.mergedTo = c;
    }

    public final boolean isMerged() {
        return this.getMergedToCard() != null;
    }

    public final boolean isMutated() {
        return this.mutatedTimestamp != -1L;
    }

    public final long getMutatedTimestamp() {
        return this.mutatedTimestamp;
    }

    public final void setMutatedTimestamp(long t2) {
        this.mutatedTimestamp = t2;
    }

    public final int getTimesMutated() {
        return this.timesMutated;
    }

    public final void setTimesMutated(int t2) {
        this.timesMutated = t2;
    }

    public final void removeMutatedStates() {
        if (this.isMutated()) {
            this.removeCloneState(this.getMutatedTimestamp());
        }
    }

    public final void rebuildMutatedStates(CardTraitBase sa) {
        if (!this.isFaceDown()) {
            CardCloneStates mutatedStates = CardFactory.getMutatedCloneStates(this, sa);
            this.addCloneState(mutatedStates, this.getMutatedTimestamp());
        }
    }

    public final CardCollection getAllComponentCards(boolean includeSelf) {
        CardCollection out = new CardCollection();
        if (includeSelf) {
            out.add(this);
        }
        if (this.getMeldedWith() != null) {
            out.add(this.getMeldedWith());
        }
        if (this.mergedTo != null) {
            out.addAll(this.mergedTo.getAllComponentCards(true));
        }
        if (this.hasMergedCard()) {
            out.addAll(this.mergedCards);
        }
        if (!includeSelf) {
            out.remove(this);
        }
        return out;
    }

    public final void moveMergedToSubgame(SpellAbility cause) {
        Card topCard;
        if (this.hasMergedCard()) {
            Zone zone = this.getZone();
            int pos = -1;
            for (int i = 0; i < zone.size(); ++i) {
                if (zone.get(i) != this) continue;
                pos = i;
                break;
            }
            Card newTop = null;
            for (Card c : this.mergedCards) {
                if (c == this) continue;
                newTop = c;
            }
            if (newTop != null) {
                this.removeMutatedStates();
                newTop.mergedCards = this.mergedCards;
                newTop.mergedTo = null;
                this.mergedCards = null;
                this.mergedTo = newTop;
                newTop.mutatedTimestamp = this.mutatedTimestamp;
                newTop.timesMutated = this.timesMutated;
                this.mutatedTimestamp = -1L;
                this.timesMutated = 0;
                zone.remove(this);
                newTop.getZone().add(this);
                this.setZone(newTop.getZone());
                newTop.getZone().remove(newTop);
                zone.add(newTop, pos);
                newTop.setZone(zone);
            }
        }
        if ((topCard = this.getMergedToCard()) != null) {
            this.setMergedToCard(null);
            topCard.removeMergedCard(this);
            topCard.removeMutatedStates();
            topCard.rebuildMutatedStates(cause);
        }
    }

    public final void retainPaidList(SpellAbility cause, String list) {
        for (Card craft : cause.getPaidList(list)) {
            if (craft.equals(this) || craft.isToken()) continue;
            this.addExiledCard(craft);
            craft.setExiledWith(this);
            craft.setExiledBy(cause.getActivatingPlayer());
        }
    }

    public final List<Integer> getStoredRolls() {
        return this.storedRolls;
    }

    public final List<String> getStoredRollsForView() {
        ArrayList<String> forView = new ArrayList<String>();
        for (Integer i : this.storedRolls) {
            forView.add(String.valueOf(i));
        }
        return forView;
    }

    public final void addStoredRolls(List<Integer> results) {
        if (this.storedRolls == null) {
            this.storedRolls = Lists.newArrayList();
        }
        this.storedRolls.addAll(results);
        this.storedRolls.sort(null);
        this.view.updateStoredRolls(this);
    }

    public final void replaceStoredRoll(Map<Integer, Integer> replaceMap) {
        for (Integer oldValue : replaceMap.keySet()) {
            this.storedRolls.remove(oldValue);
            this.storedRolls.add(replaceMap.get(oldValue));
        }
        this.storedRolls.sort(null);
        this.view.updateStoredRolls(this);
    }

    public final String getFlipResult(Player flipper) {
        if (this.flipResult == null) {
            return null;
        }
        return this.flipResult.get(flipper);
    }

    public final void addFlipResult(Player flipper, String result) {
        if (this.flipResult == null) {
            this.flipResult = Maps.newTreeMap();
        }
        this.flipResult.put(flipper, result);
    }

    public final void clearFlipResult() {
        this.flipResult = null;
    }

    public final FCollectionView<Trigger> getTriggers() {
        return this.currentState.getTriggers();
    }

    public final Trigger addTrigger(Trigger t2) {
        this.currentState.addTrigger(t2);
        return t2;
    }

    public final boolean hasTrigger(Trigger t2) {
        return this.currentState.hasTrigger(t2);
    }

    public final boolean hasTrigger(int id) {
        return this.currentState.hasTrigger(id);
    }

    public void updateTriggers(List<Trigger> list, CardState state) {
        for (CardTraitChanges ck : this.getChangedCardTraitsList(state)) {
            if (ck.isRemoveAll()) {
                list.clear();
            }
            list.addAll(ck.getTriggers());
        }
        for (KeywordInterface kw : this.getUnhiddenKeywords(state)) {
            list.addAll(kw.getTriggers());
        }
    }

    public final int getXManaCostPaid() {
        if (this.getCastSA() != null) {
            Integer paid = this.getCastSA().getXManaCostPaid();
            return paid == null ? 0 : paid;
        }
        return 0;
    }

    public final Map<String, Integer> getXManaCostPaidByColor() {
        return this.xManaCostPaidByColor;
    }

    public final void setXManaCostPaidByColor(Map<String, Integer> xByColor) {
        this.xManaCostPaidByColor = xByColor;
    }

    public final int getXManaCostPaidCount(String colors) {
        int count = 0;
        if (this.xManaCostPaidByColor != null) {
            for (Map.Entry<String, Integer> m4 : this.xManaCostPaidByColor.entrySet()) {
                if (!colors.contains(m4.getKey())) continue;
                count += m4.getValue().intValue();
            }
        }
        return count;
    }

    public List<Card> getBlockedThisTurn() {
        return this.blockedThisTurn;
    }

    public void addBlockedThisTurn(Card attacker) {
        this.blockedThisTurn.add(attacker);
    }

    public void clearBlockedThisTurn() {
        this.blockedThisTurn.clear();
    }

    public List<Card> getBlockedByThisTurn() {
        return this.blockedByThisTurn;
    }

    public void addBlockedByThisTurn(Card blocker) {
        this.blockedByThisTurn.add(blocker);
    }

    public void clearBlockedByThisTurn() {
        this.blockedByThisTurn.clear();
    }

    public final CardCollectionView getMustBlockCards() {
        return CardCollection.getView(Iterables.concat(this.mustBlockCards.values()));
    }

    public final void addMustBlockCard(long ts, Card c) {
        this.mustBlockCards.put(ts, new CardCollection(c));
        this.view.updateMustBlockCards(this);
    }

    public final void addMustBlockCards(long ts, Iterable<Card> attackersToBlock) {
        this.mustBlockCards.put(ts, new CardCollection(attackersToBlock));
        this.view.updateMustBlockCards(this);
    }

    public final void removeMustBlockCards(long ts) {
        this.mustBlockCards.remove(ts);
        this.view.updateMustBlockCards(this);
    }

    public final void clearMustBlockCards() {
        this.mustBlockCards.clear();
        this.view.updateMustBlockCards(this);
    }

    public final Card getCloneOrigin() {
        return this.cloneOrigin;
    }

    public final void setCloneOrigin(Card cloneOrigin0) {
        this.cloneOrigin = this.view.setCard(this.cloneOrigin, cloneOrigin0, TrackableProperty.CloneOrigin);
    }

    public final boolean hasFirstStrike() {
        return this.hasKeyword(Keyword.FIRST_STRIKE);
    }

    public final boolean hasDoubleStrike() {
        return this.hasKeyword(Keyword.DOUBLE_STRIKE);
    }

    public final boolean hasDoubleTeam() {
        return this.hasKeyword(Keyword.DOUBLE_TEAM);
    }

    public final boolean hasSecondStrike() {
        return this.hasDoubleStrike() || !this.hasFirstStrike();
    }

    public final boolean hasConverge() {
        return "Count$Converge".equals(this.getSVar("X")) || "Count$Converge".equals(this.getSVar("Y")) || this.hasKeyword(Keyword.SUNBURST) || this.hasKeyword("Modular:Sunburst");
    }

    @Override
    public final boolean canReceiveCounters(CounterType type) {
        if (this.isPhasedOut()) {
            return false;
        }
        return !StaticAbilityCantPutCounter.anyCantPutCounter(this, type);
    }

    @Override
    public final boolean canRemoveCounters(CounterType type) {
        if (this.isPhasedOut()) {
            return false;
        }
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.CounterType, type);
        repParams.put(AbilityKey.Result, 0);
        repParams.put(AbilityKey.IsDamage, false);
        return !this.game.getReplacementHandler().cantHappenCheck(ReplacementType.RemoveCounter, repParams);
    }

    @Override
    public void addCounterInternal(CounterType counterType, int n, Player source, boolean fireEvents, GameEntityCounterTable table, Map<AbilityKey, Object> params) {
        int addAmount = n;
        if (counterType.is(CounterEnumType.DREAM) && this.hasKeyword("CARDNAME can't have more than seven dream counters on it.")) {
            addAmount = Math.min(addAmount, 7 - this.getCounters(CounterEnumType.DREAM));
        }
        if (addAmount <= 0 || !this.canReceiveCounters(counterType)) {
            return;
        }
        int oldValue = this.getCounters(counterType);
        int newValue = addAmount + oldValue;
        if (fireEvents) {
            this.getGame().updateLastStateForCard(this);
            SpellAbility cause = (SpellAbility)params.get((Object)AbilityKey.Cause);
            int powerBonusBefore = this.getPowerBonusFromCounters();
            int toughnessBonusBefore = this.getToughnessBonusFromCounters();
            int loyaltyBefore = this.getCurrentLoyalty();
            int addedThisTurn = this.getGame().getCounterAddedThisTurn(counterType, this);
            this.setCounters(counterType, (Integer)newValue);
            this.getGame().addCounterAddedThisTurn(source, counterType, this, addAmount);
            this.view.updateCounters(this);
            if (powerBonusBefore != this.getPowerBonusFromCounters() || toughnessBonusBefore != this.getToughnessBonusFromCounters() || loyaltyBefore != this.getCurrentLoyalty()) {
                this.getGame().fireEvent(new GameEventCardStatsChanged(this));
            }
            this.getGame().fireEvent(new GameEventCardCounters(this, counterType, oldValue, newValue));
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
            runParams.put(AbilityKey.Source, source);
            runParams.put(AbilityKey.CounterType, counterType);
            if (params != null) {
                runParams.putAll(params);
            }
            for (int i = 0; i < addAmount; ++i) {
                runParams.put(AbilityKey.CounterAmount, oldValue + i + 1);
                this.getGame().getTriggerHandler().runTrigger(TriggerType.CounterAdded, AbilityKey.newMap(runParams), false);
            }
            if (addAmount > 0) {
                runParams.put(AbilityKey.CounterAmount, addAmount);
                runParams.put(AbilityKey.FirstTime, addedThisTurn == 0);
                this.getGame().getTriggerHandler().runTrigger(TriggerType.CounterAddedOnce, AbilityKey.newMap(runParams), false);
                if (cause != null) {
                    if (cause.isKeyword(Keyword.EVOLVE) && counterType.is(CounterEnumType.P1P1)) {
                        this.getGame().getTriggerHandler().runTrigger(TriggerType.Evolved, AbilityKey.mapFromCard(this), false);
                    }
                    if (cause.isKeyword(Keyword.TRAINING) && counterType.is(CounterEnumType.P1P1)) {
                        this.getGame().getTriggerHandler().runTrigger(TriggerType.Trains, AbilityKey.mapFromCard(this), false);
                    }
                }
            }
        } else {
            this.setCounters(counterType, (Integer)newValue);
            this.getGame().addCounterAddedThisTurn(source, counterType, this, addAmount);
            this.view.updateCounters(this);
        }
        if (newValue <= 0) {
            this.removeCounterTimestamp(counterType);
        } else if (this.addCounterTimestamp(counterType)) {
            this.updateAbilityTextForView();
        }
        if (table != null) {
            table.put(source, this, counterType, addAmount);
        }
    }

    public boolean addCounterTimestamp(CounterType counterType) {
        return this.addCounterTimestamp(counterType, true);
    }

    public boolean addCounterTimestamp(CounterType counterType, boolean updateView) {
        if (counterType.is(CounterEnumType.MANABOND)) {
            this.removeCounterTimestamp(counterType);
            long timestamp = this.game.getNextTimestamp();
            this.counterTypeTimestamps.put(counterType, timestamp);
            this.addChangedCardTypes(new CardType(ImmutableList.of("Land"), false), (CardType)null, false, (Set<RemoveType>)EnumSet.of(RemoveType.CardTypes, RemoveType.SubTypes), timestamp, 0L, updateView, false);
            String abStr = "AB$ ManaReflected | Cost$ T | Valid$ Defined.Self | ColorOrType$ Color | ReflectProperty$ Is | SpellDescription$ Add one mana of any of this card's colors.";
            SpellAbility sa = AbilityFactory.getAbility(abStr, this);
            sa.setIntrinsic(false);
            this.addChangedCardTraits(ImmutableList.of(sa), null, null, null, null, true, false, timestamp, 0L);
            return true;
        }
        if (!counterType.isKeywordCounter()) {
            return false;
        }
        this.removeCounterTimestamp(counterType);
        long timestamp = this.game.getNextTimestamp();
        this.counterTypeTimestamps.put(counterType, timestamp);
        int num = 1;
        if (!Keyword.smartValueOf(counterType.toString().split(":")[0]).isMultipleRedundant()) {
            num = this.getCounters(counterType);
        }
        this.addChangedCardKeywords(Collections.nCopies(num, counterType.toString()), null, false, timestamp, null, updateView);
        return true;
    }

    public boolean removeCounterTimestamp(CounterType counterType) {
        return this.removeCounterTimestamp(counterType, true);
    }

    public boolean removeCounterTimestamp(CounterType counterType, boolean updateView) {
        Long old = this.counterTypeTimestamps.remove(counterType);
        if (old != null) {
            this.removeChangedCardTypes(old, 0L, updateView);
            this.removeChangedCardTraits(old, 0L);
            this.removeChangedCardKeywords(old, 0L, updateView);
        }
        return old != null;
    }

    @Override
    public final int subtractCounter(CounterType counterName, int n, Player remover) {
        return this.subtractCounter(counterName, n, remover, false);
    }

    public final int subtractCounter(CounterType counterName, int n, Player remover, boolean isDamage) {
        int oldValue = this.getCounters(counterName);
        int newValue = Math.max(oldValue - n, 0);
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.CounterType, counterName);
        repParams.put(AbilityKey.Result, newValue);
        repParams.put(AbilityKey.IsDamage, isDamage);
        switch (this.getGame().getReplacementHandler().run(ReplacementType.RemoveCounter, repParams)) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                int result;
                newValue = result = ((Integer)repParams.get((Object)AbilityKey.Result)).intValue();
                if (newValue > 0) break;
                newValue = 0;
                break;
            }
            case Replaced: {
                return 0;
            }
        }
        int delta = oldValue - newValue;
        if (delta == 0) {
            return 0;
        }
        int powerBonusBefore = this.getPowerBonusFromCounters();
        int toughnessBonusBefore = this.getToughnessBonusFromCounters();
        int loyaltyBefore = this.getCurrentLoyalty();
        this.setCounters(counterName, (Integer)newValue);
        this.view.updateCounters(this);
        if (newValue <= 0 && this.removeCounterTimestamp(counterName)) {
            this.updateAbilityTextForView();
        }
        if (powerBonusBefore != this.getPowerBonusFromCounters() || toughnessBonusBefore != this.getToughnessBonusFromCounters() || loyaltyBefore != this.getCurrentLoyalty()) {
            this.getGame().fireEvent(new GameEventCardStatsChanged(this));
        }
        this.getGame().fireEvent(new GameEventCardCounters(this, counterName, oldValue, newValue));
        this.getGame().addCounterRemovedThisTurn(counterName, this, (Integer)delta);
        int curCounters = oldValue;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
        runParams.put(AbilityKey.CounterType, counterName);
        runParams.put(AbilityKey.Player, remover);
        for (int i = 0; i < delta && curCounters != 0; ++i) {
            runParams.put(AbilityKey.NewCounterAmount, --curCounters);
            this.getGame().getTriggerHandler().runTrigger(TriggerType.CounterRemoved, AbilityKey.newMap(runParams), false);
        }
        runParams.put(AbilityKey.CounterAmount, delta);
        runParams.put(AbilityKey.NewCounterAmount, newValue);
        this.getGame().getTriggerHandler().runTrigger(TriggerType.CounterRemovedOnce, runParams, false);
        return delta;
    }

    @Override
    public final void setCounters(Map<CounterType, Integer> allCounters) {
        boolean changed = false;
        for (CounterType ct : this.counters.keySet()) {
            if (!this.removeCounterTimestamp(ct, false)) continue;
            changed = true;
        }
        this.counters = allCounters;
        this.view.updateCounters(this);
        for (CounterType ct : this.counters.keySet()) {
            if (!this.addCounterTimestamp(ct, false)) continue;
            changed = true;
        }
        if (changed) {
            this.updateKeywords();
            this.updateAbilityTextForView();
        }
    }

    @Override
    public final void clearCounters() {
        if (this.counters.isEmpty()) {
            return;
        }
        this.counters.clear();
        this.view.updateCounters(this);
        boolean changed = false;
        for (CounterType ct : Lists.newArrayList(this.counterTypeTimestamps.keySet())) {
            if (!this.removeCounterTimestamp(ct, false)) continue;
            changed = true;
        }
        if (changed) {
            this.updateKeywords();
            this.updateAbilityTextForView();
        }
    }

    public final int sumAllCounters() {
        int count = 0;
        for (Integer value2 : this.counters.values()) {
            count += value2.intValue();
        }
        return count;
    }

    @Override
    public final String getSVar(String var) {
        for (Map<String, String> map : this.changedSVars.values()) {
            if (!map.containsKey(var)) continue;
            return map.get(var);
        }
        return this.currentState.getSVar(var);
    }

    @Override
    public final boolean hasSVar(String var) {
        for (Map<String, String> map : this.changedSVars.values()) {
            if (!map.containsKey(var)) continue;
            return true;
        }
        return this.currentState.hasSVar(var);
    }

    @Override
    public final void setSVar(String var, String str) {
        this.currentState.setSVar(var, str);
    }

    public final void copyChangedSVarsFrom(Card other) {
        this.changedSVars.clear();
        this.changedSVars.putAll(other.changedSVars);
    }

    @Override
    public final Map<String, String> getSVars() {
        return this.currentState.getSVars();
    }

    @Override
    public Map<String, String> getDirectSVars() {
        return ImmutableMap.of();
    }

    @Override
    public final void setSVars(Map<String, String> newSVars) {
        this.currentState.setSVars(newSVars);
    }

    @Override
    public final void removeSVar(String var) {
        this.currentState.removeSVar(var);
    }

    public final void addChangedSVars(Map<String, String> map, long timestamp, long staticId) {
        this.changedSVars.put(timestamp, staticId, map);
    }

    public final void removeChangedSVars(long timestamp, long staticId) {
        this.changedSVars.remove(timestamp, staticId);
    }

    public final int getTurnInZone() {
        return this.turnInZone;
    }

    public final void setTurnInZone(int turn) {
        this.turnInZone = turn;
    }

    public final boolean enteredThisTurn() {
        return this.getTurnInZone() == this.game.getPhaseHandler().getTurn();
    }

    public final Player getTurnInController() {
        return this.turnInController;
    }

    public final void setTurnInController(Player p) {
        this.turnInController = p;
    }

    public final void setManaCost(ManaCost s2) {
        this.currentState.setManaCost(s2);
    }

    public final ManaCost getOriginalManaCost() {
        return this.currentState.getManaCost();
    }

    public final ManaCost getManaCost() {
        ManaCost result = this.getOriginalManaCost();
        Iterator<ManaCost> iterator = this.changedCardManaCost.values().iterator();
        while (iterator.hasNext()) {
            ManaCost mc;
            result = mc = iterator.next();
        }
        return result;
    }

    public void addChangedManaCost(ManaCost cost, long timestamp, long staticId) {
        this.changedCardManaCost.put(timestamp, staticId, cost);
    }

    public boolean removeChangedManaCost(long timestamp, long staticId) {
        return this.changedCardManaCost.remove(timestamp, staticId) != null;
    }

    public final boolean hasChosenPlayer() {
        return this.chosenPlayer != null;
    }

    public final Player getChosenPlayer() {
        return this.chosenPlayer;
    }

    public final void setChosenPlayer(Player p) {
        if (this.chosenPlayer == p) {
            return;
        }
        this.chosenPlayer = p;
        this.view.updateChosenPlayer(this);
    }

    public final boolean hasPromisedGift() {
        return this.promisedGift != null;
    }

    public final Player getPromisedGift() {
        return this.promisedGift;
    }

    public final void setPromisedGift(Player p) {
        if (this.promisedGift == p) {
            return;
        }
        this.promisedGift = p;
        this.view.updatePromisedGift(this);
    }

    public final Player getProtectingPlayer() {
        return this.protectingPlayer;
    }

    public final void setProtectingPlayer(Player p) {
        if (this.protectingPlayer == p) {
            return;
        }
        this.protectingPlayer = p;
        this.view.updateProtectingPlayer(this);
    }

    public final void setSecretChosenPlayer(Player p) {
        this.chosenPlayer = p;
    }

    public final void revealChosenPlayer() {
        this.view.updateChosenPlayer(this);
    }

    public final boolean hasChosenNumber() {
        return this.chosenNumber != null;
    }

    public final Integer getChosenNumber() {
        return this.chosenNumber;
    }

    public final void setChosenNumber(int i) {
        this.setChosenNumber(i, false);
    }

    public final void setChosenNumber(int i, boolean secret) {
        this.chosenNumber = i;
        if (!secret) {
            this.view.updateChosenNumber(this);
        }
    }

    public final void clearChosenNumber() {
        this.chosenNumber = null;
        this.view.clearChosenNumber();
    }

    public final Card getExiledWith() {
        return this.exiledWith;
    }

    public final void setExiledWith(Card e) {
        this.exiledWith = this.view.setCard(this.exiledWith, e, TrackableProperty.ExiledWith);
    }

    public final void cleanupExiledWith() {
        if (this.exiledWith == null || this.exiledWith.isLKI()) {
            return;
        }
        this.exiledWith.removeExiledCard(this);
        this.exiledWith.removeUntilLeavesBattlefield(this);
        this.exiledWith = null;
        this.exiledBy = null;
    }

    public final Player getExiledBy() {
        return this.exiledBy;
    }

    public final void setExiledBy(Player ep) {
        this.exiledBy = ep;
    }

    public final String getChosenType() {
        return this.chosenType;
    }

    public final void setChosenType(String s2) {
        this.chosenType = s2;
        this.view.updateChosenType(this);
    }

    public final boolean hasChosenType() {
        return this.chosenType != null && !this.chosenType.isEmpty();
    }

    public final void setSecretChosenType(String s2) {
        this.chosenType = s2;
    }

    public final void revealChosenType() {
        this.view.updateChosenType(this);
    }

    public final String getChosenType2() {
        return this.chosenType2;
    }

    public final void setChosenType2(String s2) {
        this.chosenType2 = s2;
        this.view.updateChosenType2(this);
    }

    public final boolean hasChosenType2() {
        return this.chosenType2 != null && !this.chosenType2.isEmpty();
    }

    public final boolean hasAnyNotedType() {
        return this.notedTypes != null && !this.notedTypes.isEmpty();
    }

    public final void addNotedType(String type) {
        this.notedTypes.add(type);
        this.view.updateNotedTypes(this);
    }

    public final Iterable<String> getNotedTypes() {
        if (this.notedTypes == null) {
            return Lists.newArrayList();
        }
        return this.notedTypes;
    }

    public final int getNumNotedTypes() {
        if (this.notedTypes == null) {
            return 0;
        }
        return this.notedTypes.size();
    }

    public final String getChosenColor() {
        if (this.hasChosenColor()) {
            return this.chosenColors.get(0);
        }
        return "";
    }

    public final Iterable<String> getChosenColors() {
        if (this.chosenColors == null) {
            return Lists.newArrayList();
        }
        return this.chosenColors;
    }

    public final void setChosenColors(List<String> s2) {
        this.chosenColors = s2;
        this.view.updateChosenColors(this);
    }

    public boolean hasChosenColor() {
        return this.chosenColors != null && !this.chosenColors.isEmpty();
    }

    public boolean hasChosenColor(String s2) {
        return this.chosenColors != null && this.chosenColors.contains(s2);
    }

    public final Card getChosenCard() {
        return (Card)this.getChosenCards().getFirst();
    }

    public final CardCollectionView getChosenCards() {
        return CardCollection.getView(this.chosenCards);
    }

    public final void setChosenCards(Iterable<Card> cards) {
        this.chosenCards = this.view.setCards(this.chosenCards, cards, TrackableProperty.ChosenCards);
    }

    public boolean hasChosenCard() {
        return FCollection.hasElements(this.chosenCards);
    }

    public boolean hasChosenCard(Card c) {
        return FCollection.hasElement(this.chosenCards, c);
    }

    public Direction getChosenDirection() {
        return this.chosenDirection;
    }

    public void setChosenDirection(Direction chosenDirection0) {
        if (this.chosenDirection == chosenDirection0) {
            return;
        }
        this.chosenDirection = chosenDirection0;
        this.view.updateChosenDirection(this);
    }

    public String getChosenMode() {
        return this.chosenMode;
    }

    public void setChosenMode(String mode) {
        this.chosenMode = mode;
        this.view.updateChosenMode(this);
    }

    public String getCurrentRoom() {
        return this.currentRoom;
    }

    public void setCurrentRoom(String room) {
        this.currentRoom = room;
        this.view.updateCurrentRoom(this);
        this.view.getCurrentState().updateAbilityText(this, this.getCurrentState());
    }

    public boolean isInLastRoom() {
        for (Trigger t2 : this.getTriggers()) {
            SpellAbility sa = t2.getOverridingAbility();
            if (!sa.getParam("RoomName").equals(this.currentRoom) || sa.hasParam("NextRoom")) continue;
            return true;
        }
        return false;
    }

    public String getSector() {
        return this.sector;
    }

    public void assignSector(String s2) {
        this.sector = s2;
        this.view.updateSector(this);
    }

    public boolean hasSector() {
        return this.sector != null;
    }

    public String getChosenSector() {
        return this.chosenSector;
    }

    public final void setChosenSector(String s2) {
        this.chosenSector = s2;
    }

    public final String getNamedCard() {
        return this.hasNamedCard() ? Iterables.getLast(this.chosenName) : "";
    }

    public final List<String> getNamedCards() {
        return this.chosenName;
    }

    public final void setNamedCards(List<String> s2) {
        this.chosenName = s2;
        this.view.updateNamedCard(this);
    }

    public final void addNamedCard(String s2) {
        this.chosenName.add(s2);
        this.view.updateNamedCard(this);
    }

    public boolean hasNamedCard() {
        return !this.chosenName.isEmpty();
    }

    public boolean hasChosenEvenOdd() {
        return this.chosenEvenOdd != null;
    }

    public EvenOdd getChosenEvenOdd() {
        return this.chosenEvenOdd;
    }

    public void setChosenEvenOdd(EvenOdd chosenEvenOdd0) {
        if (this.chosenEvenOdd == chosenEvenOdd0) {
            return;
        }
        this.chosenEvenOdd = chosenEvenOdd0;
        this.view.updateChosenEvenOdd(this);
    }

    public final boolean getDrawnThisTurn() {
        return this.drawnThisTurn;
    }

    public final void setDrawnThisTurn(boolean b) {
        this.drawnThisTurn = b;
    }

    public final boolean getFoughtThisTurn() {
        return this.foughtThisTurn;
    }

    public final void setFoughtThisTurn(boolean b) {
        this.foughtThisTurn = b;
    }

    public final boolean getEnlistedThisCombat() {
        return this.enlistedThisCombat;
    }

    public final void setEnlistedThisCombat(boolean b) {
        this.enlistedThisCombat = b;
    }

    public final CardCollectionView getGainControlTargets() {
        return CardCollection.getView(this.gainControlTargets);
    }

    public final void addGainControlTarget(Card c) {
        this.gainControlTargets = this.view.addCard(this.gainControlTargets, c, TrackableProperty.GainControlTargets);
    }

    public final void removeGainControlTargets(Card c) {
        this.gainControlTargets = this.view.removeCard(this.gainControlTargets, c, TrackableProperty.GainControlTargets);
    }

    public final boolean hasGainControlTarget() {
        return FCollection.hasElements(this.gainControlTargets);
    }

    public final boolean hasGainControlTarget(Card c) {
        return FCollection.hasElement(this.gainControlTargets, c);
    }

    public final String getSpellText() {
        return this.text;
    }

    public final void setText(String t2) {
        this.text = this.originalText = t2;
    }

    public final String getNonAbilityText() {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbLong = new StringBuilder();
        for (String keyword : this.getHiddenExtrinsicKeywords()) {
            sbLong.append(keyword).append("\r\n");
        }
        if (sb.length() > 0) {
            sb.append("\r\n");
            if (sbLong.length() > 0) {
                sb.append("\r\n");
            }
        }
        if (sbLong.length() > 0) {
            sbLong.append("\r\n");
        }
        sb.append((CharSequence)sbLong);
        return CardTranslation.translateMultipleDescriptionText(sb.toString(), this);
    }

    public final String keywordsToText(Collection<KeywordInterface> keywords) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbLong = new StringBuilder();
        ArrayList<String> printedKW = new ArrayList<String>();
        int i = 0;
        for (KeywordInterface inst : keywords) {
            String keyword = inst.getOriginal();
            try {
                if (keyword.startsWith("etbCounter")) {
                    String[] p = keyword.split(":");
                    StringBuilder s2 = new StringBuilder();
                    if (p.length > 4) {
                        if (!"no desc".equals(p[4])) {
                            s2.append(p[4]);
                        }
                    } else {
                        s2.append(this.getName()).append(" enters with ");
                        s2.append(Lang.nounWithNumeralExceptOne(p[2], CounterType.getType(p[1]).getName().toLowerCase() + " counter"));
                        s2.append(" on it.");
                    }
                    sbLong.append((CharSequence)s2).append("\r\n");
                } else if (keyword.startsWith("DeckLimit")) {
                    String[] k = keyword.split(":");
                    sbLong.append(k[2]).append("\r\n");
                } else if (keyword.startsWith("Enchant")) {
                    String k = keyword;
                    k = TextUtil.fastReplace(k, "Curse", "");
                    sbLong.append(k).append("\r\n");
                } else if (keyword.startsWith("Ripple")) {
                    sbLong.append(TextUtil.fastReplace(keyword, ":", " ")).append("\r\n");
                } else if (keyword.startsWith("Morph") || keyword.startsWith("Megamorph") || keyword.startsWith("Disguise") || keyword.startsWith("Escape") || keyword.startsWith("Foretell:") || keyword.startsWith("Madness:") || keyword.startsWith("Recover") || keyword.startsWith("Reconfigure") || keyword.startsWith("Squad") || keyword.startsWith("Miracle") || keyword.startsWith("More Than Meets the Eye") || keyword.startsWith("Level up") || keyword.startsWith("Plot") || keyword.startsWith("Offspring")) {
                    String[] k = keyword.split(":");
                    sbLong.append(k[0]);
                    if (k.length > 1) {
                        Cost mCost = new Cost(k[1], true);
                        if (mCost.isOnlyManaCost()) {
                            sbLong.append(" ");
                        } else {
                            sbLong.append("\u2014");
                        }
                        if (keyword.startsWith("Reconfigure") && k.length > 2) {
                            String[] altCost = new Cost(k[2], true).toString().split(" ");
                            sbLong.append("\u2014").append(altCost[0]).append(" ").append(mCost.toString()).append(" or ").append(altCost[1]);
                        } else {
                            sbLong.append(mCost.toString());
                            if (!mCost.isOnlyManaCost()) {
                                sbLong.append(".");
                            }
                            if (k.length > 2) {
                                sbLong.append(". " + k[3]);
                            }
                        }
                        sbLong.append(" (").append(inst.getReminderText()).append(")");
                        sbLong.append("\r\n");
                    }
                } else if (keyword.startsWith("Madness")) {
                    sbLong.append("Madness ").append(this.getManaCost()).append(" (").append(inst.getReminderText());
                    sbLong.append(")").append("\r\n");
                } else if (keyword.startsWith("Reflect")) {
                    String[] k = keyword.split(":");
                    sbLong.append(k[0]).append(" ").append(ManaCostParser.parse(k[1]));
                    sbLong.append(" (").append(inst.getReminderText()).append(")");
                    sbLong.append("\r\n");
                } else if (keyword.startsWith("Echo")) {
                    sbLong.append("Echo ");
                    String[] upkeepCostParams = keyword.split(":");
                    sbLong.append(upkeepCostParams.length > 2 ? "\u2014 " + upkeepCostParams[2] : ManaCostParser.parse(upkeepCostParams[1]));
                    sbLong.append(" (At the beginning of your upkeep, if CARDNAME came under your control since the beginning of your last upkeep, sacrifice it unless you pay its echo cost.)");
                    sbLong.append("\r\n");
                } else if (keyword.startsWith("Cumulative upkeep")) {
                    sbLong.append("Cumulative upkeep ");
                    String[] upkeepCostParams = keyword.split(":");
                    sbLong.append(upkeepCostParams.length > 2 ? "\u2014 " + upkeepCostParams[2] : ManaCostParser.parse(upkeepCostParams[1]));
                    sbLong.append("\r\n");
                } else if (keyword.startsWith("AlternateAdditionalCost")) {
                    String[] costs = keyword.split(":", 2)[1].split(":");
                    sbLong.append("As an additional cost to cast this spell, ");
                    for (int n = 0; n < costs.length; ++n) {
                        Cost cost = new Cost(costs[n], false);
                        if (cost.isOnlyManaCost()) {
                            sbLong.append(" pay ");
                        }
                        sbLong.append(StringUtils.uncapitalize(cost.toSimpleString()));
                        sbLong.append(n + 1 == costs.length ? ".\r\n\r\n" : (n + 2 == costs.length && costs.length > 2 ? ", or " : (n + 2 == costs.length ? " or " : ", ")));
                    }
                } else if (keyword.startsWith("Multikicker")) {
                    String[] n = keyword.split(":");
                    Cost cost = new Cost(n[1], false);
                    sbLong.append("Multikicker ").append(cost.toSimpleString());
                    sbLong.append(" (").append(inst.getReminderText()).append(")").append("\r\n");
                } else if (keyword.startsWith("Kicker")) {
                    sbLong.append(this.kickerDesc(keyword, inst.getReminderText())).append("\r\n");
                } else if (keyword.startsWith("Trample:")) {
                    sbLong.append("Trample over planeswalkers").append(" (").append(inst.getReminderText()).append(")").append("\r\n");
                } else if (keyword.startsWith("Hexproof:")) {
                    String[] k = keyword.split(":");
                    if (!k[2].equals("Secondary")) {
                        sbLong.append("Hexproof from ");
                        if (k[2].equals("chosen")) {
                            k[2] = k[1].substring(5).toLowerCase();
                        }
                        sbLong.append(k[2]);
                        if (!k[2].contains(" and ") && !k[2].contains("each")) {
                            sbLong.append(" (").append(inst.getReminderText().replace("chosen", k[2]));
                            sbLong.append(")");
                        }
                        sbLong.append("\r\n");
                    }
                } else if (keyword.startsWith("Protection:")) {
                    String[] k = keyword.split(":");
                    sbLong.append("Protection from ");
                    if (k.length > 2) {
                        sbLong.append(k[2]);
                    } else if (MagicColor.Constant.ONLY_COLORS.contains(k[1])) {
                        sbLong.append(k[1]);
                    } else {
                        sbLong.append(CardType.getPluralType(k[1]));
                    }
                    sbLong.append("\r\n");
                } else if (keyword.startsWith("Emerge")) {
                    String[] k = keyword.split(":");
                    sbLong.append(k[0]);
                    if (k.length > 2) {
                        sbLong.append(" from ").append(k[2].toLowerCase());
                    }
                    sbLong.append(" ").append(ManaCostParser.parse(k[1]));
                    sbLong.append(" (").append(inst.getReminderText()).append(")");
                    sbLong.append("\r\n");
                } else if (inst.getKeyword().equals((Object)Keyword.COMPANION)) {
                    sbLong.append("Companion \u2014 ");
                    sbLong.append(((Companion)inst).getDescription());
                } else if (keyword.startsWith("MayFlash")) {
                    sbLong.append(inst.getReminderText()).append("\r\n");
                } else if (!(keyword.startsWith("Strive") || keyword.startsWith("Escalate") || keyword.startsWith("ETBReplacement") || keyword.startsWith("Affinity") || keyword.startsWith("UpkeepCost"))) {
                    if (keyword.equals("Provoke") || keyword.equals("Ingest") || keyword.equals("Unleash") || keyword.equals("Soulbond") || keyword.equals("Partner") || keyword.equals("Retrace") || keyword.equals("Living Weapon") || keyword.equals("Myriad") || keyword.equals("Exploit") || keyword.equals("Changeling") || keyword.equals("Delve") || keyword.equals("Decayed") || keyword.equals("Split second") || keyword.equals("Sunburst") || keyword.equals("Double team") || keyword.equals("Living metal") || keyword.equals("Suspend") || keyword.equals("Foretell") || keyword.equals("Ascend") || keyword.equals("Umbra armor") || keyword.equals("Battle cry") || keyword.equals("Devoid") || keyword.equals("Riot") || keyword.equals("Daybound") || keyword.equals("Nightbound") || keyword.equals("Friends forever") || keyword.equals("Choose a Background") || keyword.equals("Space sculptor") || keyword.equals("Doctor's companion")) {
                        sbLong.append(keyword).append(" (").append(inst.getReminderText()).append(")");
                    } else if (keyword.startsWith("Partner:")) {
                        String[] k = keyword.split(":");
                        sbLong.append("Partner with ").append(k[1]).append(" (").append(inst.getReminderText()).append(")");
                    } else if (keyword.equals("Compleated")) {
                        sbLong.append(keyword).append(" (");
                        ManaCost mc = this.getManaCost();
                        if (mc != ManaCost.NO_COST && mc.hasPhyrexian()) {
                            String pip = mc.getFirstPhyrexianPip();
                            String[] parts = pip.substring(1, pip.length() - 1).split("/");
                            StringBuilder rem = new StringBuilder();
                            rem.append(pip).append(" can be paid with {").append(parts[0]).append("}");
                            if (parts.length > 2) {
                                rem.append(", {").append(parts[1]).append("},");
                            }
                            rem.append(" or 2 life. ");
                            if (mc.getPhyrexianCount() > 1) {
                                rem.append("For each ").append(pip).append(" paid with life,");
                            } else {
                                rem.append("If life was paid,");
                            }
                            rem.append(" this planeswalker enters with two fewer loyalty counters.");
                            sbLong.append(rem.toString());
                        }
                        sbLong.append(")");
                    } else if (keyword.startsWith("Devour ")) {
                        String[] k = keyword.split(":");
                        String[] s3 = k[0].split(" ");
                        String t2 = s3[1];
                        sbLong.append(k[0]).append(" ").append(k[1]).append(" (As this enters, you may ");
                        sbLong.append("sacrifice any number of ").append(t2).append("s. This creature enters ");
                        sbLong.append("with that many +1/+1 counters on it.)");
                    } else if (keyword.startsWith("Prototype")) {
                        String[] k = keyword.split(":");
                        Cost cost = new Cost(k[1], false);
                        sbLong.append(k[0]).append(" ").append(cost.toSimpleString()).append(" ").append("[").append(k[2]);
                        sbLong.append("/").append(k[3]).append("] ").append("(").append(inst.getReminderText()).append(")");
                    } else if (keyword.startsWith("Modular") || keyword.startsWith("Bloodthirst") || keyword.startsWith("Dredge") || keyword.startsWith("Fabricate") || keyword.startsWith("Soulshift") || keyword.startsWith("Bushido") || keyword.startsWith("Saddle") || keyword.startsWith("Tribute") || keyword.startsWith("Absorb") || keyword.startsWith("Graft") || keyword.startsWith("Fading") || keyword.startsWith("Vanishing:") || keyword.startsWith("Afterlife") || keyword.startsWith("Hideaway") || keyword.startsWith("Toxic") || keyword.startsWith("Afflict") || keyword.startsWith("Poisonous") || keyword.startsWith("Rampage") || keyword.startsWith("Renown") || keyword.startsWith("Annihilator") || keyword.startsWith("Devour")) {
                        String[] k = keyword.split(":");
                        sbLong.append(k[0]).append(" ").append(k[1]).append(" (").append(inst.getReminderText()).append(")");
                    } else if (keyword.startsWith("Crew")) {
                        String[] k = keyword.split(":");
                        sbLong.append("Crew ").append(k[1]);
                        if (k.length > 2 && k[2].contains("ActivationLimit$ 1")) {
                            sbLong.append(". Activate only once each turn.");
                        }
                        sbLong.append(" (").append(inst.getReminderText()).append(")");
                    } else if (keyword.startsWith("Casualty")) {
                        String[] k = keyword.split(":");
                        sbLong.append("Casualty ").append(k[1]);
                        if (k.length >= 4) {
                            sbLong.append(". ").append(k[3]);
                        }
                        sbLong.append(" (").append(inst.getReminderText()).append(")");
                    } else if (keyword.equals("Gift")) {
                        sbLong.append(keyword);
                        Trigger trig = inst.getTriggers().stream().findFirst().orElse(null);
                        if (trig != null && trig.getCardState().getFirstSpellAbility().hasAdditionalAbility("GiftAbility")) {
                            sbLong.append(" ").append(trig.getCardState().getFirstSpellAbility().getAdditionalAbility("GiftAbility").getParam("GiftDescription"));
                        }
                        sbLong.append("\r\n");
                    } else if (keyword.startsWith("Starting intensity")) {
                        sbLong.append(TextUtil.fastReplace(keyword, ":", " "));
                    } else if (keyword.contains("Haunt")) {
                        sb.append("\r\nHaunt (");
                        if (this.isCreature()) {
                            sb.append("When this creature dies, exile it haunting target creature.");
                        } else {
                            sb.append("When this spell card is put into a graveyard after resolving, ");
                            sb.append("exile it haunting target creature.");
                        }
                        sb.append(")");
                    } else if (keyword.startsWith("Bands with other")) {
                        String[] k = keyword.split(":");
                        String desc = k.length > 2 ? k[2] : CardType.getPluralType(k[1]);
                        sbLong.append(k[0]).append(" ").append(desc).append(" (").append(inst.getReminderText()).append(")");
                    } else if (keyword.equals("Convoke") || keyword.equals("Dethrone") || keyword.equals("Fear") || keyword.equals("Melee") || keyword.equals("Improvise") || keyword.equals("Shroud") || keyword.equals("Banding") || keyword.equals("Intimidate") || keyword.equals("Evolve") || keyword.equals("Exalted") || keyword.equals("Extort") || keyword.equals("Flanking") || keyword.equals("Horsemanship") || keyword.equals("Infect") || keyword.equals("Persist") || keyword.equals("Phasing") || keyword.equals("Shadow") || keyword.equals("Skulk") || keyword.equals("Undying") || keyword.equals("Wither") || keyword.equals("Bargain") || keyword.equals("Mentor") || keyword.equals("Training")) {
                        if (sb.length() != 0) {
                            sb.append("\r\n");
                        }
                        sb.append(keyword);
                        if (!printedKW.contains(keyword)) {
                            sb.append(" (").append(inst.getReminderText()).append(")");
                            printedKW.add(keyword);
                        }
                    } else if (keyword.equals("Cascade")) {
                        if (printedKW.contains(keyword)) continue;
                        if (sb.length() != 0) {
                            sb.append("\r\n");
                        }
                        StringBuilder descStr = new StringBuilder(keyword);
                        int times = 0;
                        for (KeywordInterface keyw : keywords) {
                            String kw = keyw.getOriginal();
                            if (!kw.equals(keyword)) continue;
                            descStr.append(times == 0 ? "" : ", " + StringUtils.uncapitalize(keyword));
                            ++times;
                        }
                        sb.append((CharSequence)descStr).append(" ").append(" (").append(inst.getReminderText()).append(")");
                        printedKW.add(keyword);
                    } else if (keyword.startsWith("Ward")) {
                        String[] k = keyword.split(":");
                        Cost cost = new Cost(k[1], false);
                        boolean onlyMana = cost.isOnlyManaCost();
                        boolean complex = k[1].contains("X") || k[1].contains(" ") && k[1].contains("<");
                        String extra = k.length > 2 ? ", " + k[2] + "." : "";
                        sbLong.append(k[0]).append(onlyMana ? " " : "\u2014").append(cost.toSimpleString());
                        sbLong.append(onlyMana ? "" : ".").append(extra);
                        sbLong.append(!complex ? " (" + inst.getReminderText() + ")" : "");
                        sbLong.append("\r\n");
                    } else if (keyword.endsWith(" offering")) {
                        String offeringType = keyword.split(" ")[0];
                        if (sb.length() != 0) {
                            sb.append("\r\n");
                        }
                        sbLong.append(keyword);
                        sbLong.append(" (").append(Keyword.getInstance("Offering:" + offeringType).getReminderText()).append(")");
                    } else if (!(keyword.startsWith("Equip") || keyword.startsWith("Fortify") || keyword.startsWith("Outlast") || keyword.startsWith("Unearth") || keyword.startsWith("Scavenge") || keyword.startsWith("Spectacle") || keyword.startsWith("Evoke") || keyword.startsWith("Bestow") || keyword.startsWith("Surge") || keyword.startsWith("Transmute") || keyword.startsWith("Suspend") || keyword.startsWith("Dash") || keyword.startsWith("Disturb") || keyword.equals("Undaunted") || keyword.startsWith("Monstrosity") || keyword.startsWith("Impending") || keyword.startsWith("Embalm") || keyword.equals("Prowess") || keyword.startsWith("Eternalize") || keyword.startsWith("Reinforce") || keyword.startsWith("Champion") || keyword.startsWith("Freerunning") || keyword.startsWith("Prowl") || keyword.startsWith("Adapt") || keyword.startsWith("Amplify") || keyword.startsWith("Ninjutsu") || keyword.startsWith("Chapter") || keyword.startsWith("Transfigure") || keyword.startsWith("Aura swap") || keyword.startsWith("Cycling") || keyword.startsWith("TypeCycling") || keyword.startsWith("Encore") || keyword.startsWith("Mutate") || keyword.startsWith("Dungeon") || keyword.startsWith("Class") || keyword.startsWith("Blitz") || keyword.startsWith("Specialize") || keyword.equals("Ravenous") || keyword.equals("For Mirrodin") || keyword.startsWith("Craft") || keyword.startsWith("Landwalk") || keyword.startsWith("Visit"))) {
                        if (keyword.equals("Read ahead")) {
                            sb.append(Localizer.getInstance().getMessage("lblReadAhead", new Object[0])).append(" (").append(Localizer.getInstance().getMessage("lblReadAheadDesc", new Object[0]));
                            sb.append(" ").append(Localizer.getInstance().getMessage("lblSagaFooter", new Object[0])).append(" ").append(TextUtil.toRoman(this.getFinalChapterNr())).append(".");
                            sb.append(")").append("\r\n\r\n");
                        } else if (keyword.startsWith("Backup")) {
                            if (printedKW.contains("Backup")) continue;
                            boolean plural = false;
                            StringBuilder descStr = new StringBuilder("Backup ");
                            int times = 0;
                            for (KeywordInterface keyw : keywords) {
                                String kw = keyw.getOriginal();
                                if (!kw.startsWith("Backup")) continue;
                                String[] k = keyword.split(":");
                                String magnitude = k[1];
                                if (times == 0 && k[2].endsWith("s")) {
                                    plural = true;
                                }
                                descStr.append(times == 0 ? magnitude : ", backup " + magnitude);
                                ++times;
                            }
                            sb.append((CharSequence)descStr).append(" ").append(" (");
                            String remStr = inst.getReminderText();
                            if (plural) {
                                remStr = remStr.replace("ability", "abilities");
                            }
                            sb.append(remStr).append(times > 1 ? " Each backup ability triggers separately." : "").append(")");
                            printedKW.add("Backup");
                        } else if (keyword.startsWith("MayEffectFromOpening")) {
                            String[] k = keyword.split(":");
                            String desc = AbilityFactory.getMapParams(this.getSVar(k[1])).get("SpellDescription");
                            sbLong.append(desc);
                        } else if (keyword.endsWith(".") && !keyword.startsWith("Haunt")) {
                            sbLong.append(keyword).append("\r\n");
                        } else {
                            if (keyword.contains("Strike")) {
                                keyword = keyword.replace("Strike", "strike");
                            }
                            sb.append(i != 0 && sb.length() != 0 ? ", " : "");
                            sb.append(i > 0 && sb.length() != 0 ? StringUtils.uncapitalize(keyword) : keyword);
                        }
                    }
                }
                if (sbLong.length() > 0) {
                    sbLong.append("\r\n");
                }
                if (keyword.equals("Flash") || keyword.startsWith("Backup")) {
                    sb.append("\r\n\r\n");
                    i = 0;
                    continue;
                }
                ++i;
            }
            catch (Exception e) {
                String msg = "Card:keywordToText: crash in Keyword parsing";
                Breadcrumb bread = new Breadcrumb(msg);
                bread.setData("Card", this.getName());
                bread.setData("Keyword", keyword);
                Sentry.addBreadcrumb(bread);
                throw new RuntimeException("Error in Card " + this.getName() + " with Keyword " + keyword, e);
            }
        }
        if (sb.length() > 0) {
            sb.append("\r\n");
            if (sbLong.length() > 0) {
                sb.append("\r\n");
            }
        }
        if (sbLong.length() > 0) {
            sbLong.append("\r\n");
        }
        sb.append((CharSequence)sbLong);
        return CardTranslation.translateMultipleDescriptionText(sb.toString(), this);
    }

    private String kickerDesc(String keyword, String remText) {
        StringBuilder sbx = new StringBuilder();
        String[] n = keyword.split(":");
        Cost cost = new Cost(n[1], false);
        String costStr = cost.toSimpleString();
        boolean manaOnly = cost.isOnlyManaCost();
        sbx.append("Kicker").append(manaOnly ? " " + costStr : "\u2014" + costStr + ".");
        if (Lists.newArrayList(n).size() > 2) {
            sbx.append(" and/or ");
            Cost cost2 = new Cost(n[2], false);
            sbx.append(cost2.toSimpleString());
        }
        if (!manaOnly) {
            if (cost.hasNoManaCost()) {
                remText = remText.replaceFirst(" pay an additional", "");
                remText = remText.replace(remText.charAt(8), Character.toLowerCase(remText.charAt(8)));
            } else {
                remText = remText.replaceFirst(" an additional", "");
                char c = remText.charAt(remText.indexOf(",") + 2);
                remText = remText.replace(c, Character.toLowerCase(c));
                remText = remText.replaceFirst(", ", " and ");
            }
            remText = remText.replaceFirst("as", "in addition to any other costs as");
            if (remText.contains(" tap ")) {
                if (remText.contains("tap a")) {
                    String noun = remText.substring(remText.indexOf("untapped") + 9, remText.indexOf(" in "));
                    remText = remText.replace(remText.substring(12, remText.indexOf(" in ")), Lang.nounWithNumeralExceptOne(1, noun) + " ");
                } else {
                    remText = remText.replaceFirst(" untapped ", "");
                }
            }
        }
        sbx.append(" (").append(remText).append(")\r\n");
        return sbx.toString();
    }

    public String getAbilityText() {
        return this.getAbilityText(this.currentState);
    }

    /*
     * WARNING - void declaration
     */
    public String getAbilityText(CardState state) {
        Cost cost;
        SpellAbility first;
        String linebreak = "\r\n\r\n";
        boolean useGrayTag = true;
        if (this.getGame() != null) {
            useGrayTag = this.game.getRules().useGrayText();
        }
        String grayTag = useGrayTag ? "<span style=\"color:gray;\">" : "";
        String endTag = useGrayTag ? "</span>" : "";
        CardTypeView type = state.getType();
        StringBuilder sb = new StringBuilder();
        if (!this.mayPlay.isEmpty()) {
            HashSet<String> players = new HashSet<String>();
            for (CardPlayOption o : this.mayPlay.values()) {
                if (this.getController() == o.getPlayer()) {
                    players.add(o.getPlayer().getName());
                    continue;
                }
                if (!o.grantsZonePermissions()) continue;
                players.add(o.getPlayer().getName());
            }
            if (!players.isEmpty()) {
                sb.append("May be played by: ");
                sb.append(Lang.joinHomogenous(players));
                sb.append("\r\n");
            }
        }
        if (this.plotted) {
            sb.append("Plotted\r\n");
        }
        if (type.isInstant() || type.isSorcery()) {
            sb.append((CharSequence)this.abilityTextInstantSorcery(state));
            if (this.haunting != null) {
                sb.append("Haunting: ").append(this.haunting);
                sb.append("\r\n");
            }
            String result = sb.toString();
            while (result.endsWith("\r\n")) {
                result = result.substring(0, result.length() - 2);
            }
            return TextUtil.fastReplace(result, "CARDNAME", CardTranslation.getTranslatedName(state.getName()));
        }
        if (type.hasSubtype("Class")) {
            sb.append("(Gain the next level as a sorcery to add its ability.)").append("\r\n\r\n");
        }
        if (state.getStateName().equals((Object)CardStateName.Transformed) && state.getView().getOracleText().startsWith("(Transforms")) {
            sb.append("(").append(Localizer.getInstance().getMessage("lblTransformsFrom", CardTranslation.getTranslatedName(state.getCard().getState(CardStateName.Original).getName())));
            sb.append(")").append("\r\n\r\n");
        }
        if (type.hasSubtype("Saga") && !state.hasKeyword(Keyword.READ_AHEAD)) {
            sb.append("(").append(Localizer.getInstance().getMessage("lblSagaHeader", new Object[0]));
            if (!state.getCard().isTransformable()) {
                sb.append(" ").append(Localizer.getInstance().getMessage("lblSagaFooter", new Object[0])).append(" ").append(TextUtil.toRoman(state.getFinalChapterNr())).append(".");
            }
            sb.append(")").append("\r\n\r\n");
        }
        if ((first = state.getFirstAbility()) != null && type.isPermanent() && first.isSpell() && (cost = first.getPayCosts()) != null && !cost.isOnlyManaCost()) {
            String additionalDesc = "";
            if (first.hasParam("AdditionalDesc")) {
                additionalDesc = first.getParam("AdditionalDesc");
            }
            sb.append(cost.toString().replace("\n", "")).append(" ").append(additionalDesc);
            sb.append("\r\n\r\n");
        }
        if (this.monstrous) {
            sb.append("Monstrous\r\n");
        }
        if (this.renowned) {
            sb.append("Renowned\r\n");
        }
        if (this.solved) {
            sb.append("Solved\r\n");
        }
        if (this.saddled) {
            sb.append("Saddled\r\n");
        }
        if (this.isSuspected()) {
            sb.append("Suspected\r\n");
        }
        if (this.manifested) {
            sb.append("Manifested\r\n");
        }
        if (this.cloaked) {
            sb.append("Cloaked\r\n");
        }
        String keywordText = this.keywordsToText(this.getUnhiddenKeywords(state));
        sb.append(keywordText).append(keywordText.length() > 0 ? "\r\n\r\n" : "");
        StringBuilder replacementEffects = new StringBuilder();
        for (ReplacementEffect replacementEffect : state.getReplacementEffects()) {
            if (replacementEffect.isSecondary() || replacementEffect.isClassAbility()) continue;
            String text = replacementEffect.getDescription();
            if (replacementEffect.hasParam("Description") && replacementEffect.getParam("Description").contains("enters")) {
                sb.append(text).append("\r\n\r\n");
                continue;
            }
            replacementEffects.append(text).append("\r\n\r\n");
        }
        if (this.getRules() != null && state.getView().getState().equals((Object)CardStateName.Original)) {
            boolean hasMeldEffect = this.hasSVar("Meld") || Iterables.any(state.getNonManaAbilities(), SpellAbilityPredicates.isApi(ApiType.Meld));
            String string = this.getRules().getMeldWith();
            if (string != "" && !hasMeldEffect) {
                sb.append("\r\n");
                sb.append("(Melds with ").append(string).append(".)");
                sb.append("\r\n");
            }
        }
        sb.append(this.text.replaceAll("\\\\r\\\\n", "\r\n"));
        sb.append("\r\n\r\n");
        for (Trigger trigger : state.getTriggers()) {
            if (trigger.isSecondary() || trigger.isClassAbility()) continue;
            boolean disabled = type.isDungeon() ? !trigger.getOverridingAbility().getParam("RoomName").equals(this.getCurrentRoom()) : this.getGame() != null && !trigger.requirementsCheck(this.getGame());
            String trigStr = trigger.replaceAbilityText(trigger.toString(), state);
            if (disabled) {
                sb.append(grayTag);
            }
            sb.append(trigStr.replaceAll("\\\\r\\\\n", "\r\n"));
            if (disabled) {
                sb.append(endTag);
            }
            sb.append("\r\n\r\n");
        }
        sb.append((CharSequence)replacementEffects);
        for (StaticAbility staticAbility : state.getStaticAbilities()) {
            boolean disabled;
            String stAbD;
            if (staticAbility.isSecondary() || staticAbility.isClassAbility() || (stAbD = staticAbility.toString()).isEmpty()) continue;
            boolean bl = disabled = this.getGame() != null && this.getController() != null && this.game.getAge() != GameStage.Play && !staticAbility.checkConditions();
            if (disabled) {
                sb.append(grayTag);
            }
            sb.append(stAbD);
            if (disabled) {
                sb.append(endTag);
            }
            sb.append("\r\n\r\n");
        }
        ArrayList<String> addedManaStrings = Lists.newArrayList();
        for (SpellAbility sa : state.getSpellAbilities()) {
            if (sa == null || sa.isSecondary() || sa.isClassAbility() || sa.isCastFaceDown()) continue;
            String sAbility = this.formatSpellAbility(sa);
            if (sa.isAdventure() && state.getStateName().equals((Object)CardStateName.Original)) {
                CardState advState = this.getState(CardStateName.Adventure);
                StringBuilder sbSA = new StringBuilder();
                sbSA.append(Localizer.getInstance().getMessage("lblAdventure", new Object[0]));
                sbSA.append(" \u2014 ").append(CardTranslation.getTranslatedName(advState.getName()));
                sbSA.append(" ").append(sa.getPayCosts().toSimpleString());
                sbSA.append(": ");
                sbSA.append(sAbility);
                sAbility = sbSA.toString();
            } else {
                if (sa.isSpell() && sa.isBasicSpell()) continue;
                if (sa.hasParam("DescriptionFromChosenName") && !this.getNamedCard().isEmpty()) {
                    String name = this.getNamedCard();
                    ICardFace namedFace = StaticData.instance().getCommonCards().getFaceByName(name);
                    StringBuilder sbSA = new StringBuilder(sAbility);
                    sbSA.append("\r\n\r\n");
                    sbSA.append(Localizer.getInstance().getMessage("lblSpell", new Object[0]));
                    sbSA.append(" \u2014 ");
                    if (!namedFace.getManaCost().isNoCost()) {
                        sbSA.append(namedFace.getManaCost().getSimpleString()).append(": ");
                    }
                    sbSA.append(namedFace.getName()).append("\r\n");
                    sbSA.append(namedFace.getType()).append("\r\n");
                    sbSA.append(namedFace.getOracleText().replaceAll("\\\\n", "\r\n"));
                    sbSA.append("\r\n\r\n");
                    sAbility = sbSA.toString();
                }
            }
            if (sa.getManaPart() != null) {
                if (addedManaStrings.contains(sAbility)) continue;
                addedManaStrings.add(sAbility);
            }
            boolean alwaysShow = false;
            if (!sa.isIntrinsic()) {
                alwaysShow = true;
            }
            if (sAbility.endsWith(state.getName() + "\r\n") && !alwaysShow) continue;
            sb.append(sAbility);
            sb.append("\r\n");
        }
        if (this.game != null && this.isCreature() && this.isInPlay()) {
            for (Card ca : this.game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
                if (this.equals(ca)) continue;
                for (StaticAbility stAb : ca.getStaticAbilities()) {
                    if (!stAb.checkConditions()) continue;
                    boolean found = false;
                    if (stAb.checkMode("CantBlockBy")) {
                        if (!stAb.hasParam("ValidAttacker") || stAb.hasParam("ValidBlocker") && stAb.getParam("ValidBlocker").equals("Creature.Self")) continue;
                        if (stAb.matchesValidParam("ValidAttacker", this)) {
                            found = true;
                        }
                    } else if (stAb.checkMode(StaticAbilityCantAttackBlock.MinMaxBlockerMode) && stAb.matchesValidParam("ValidCard", this)) {
                        found = true;
                    }
                    if (!found) continue;
                    Card host = stAb.getHostCard();
                    String currentName = host.getName();
                    String desc = TextUtil.fastReplace(stAb.toString(), "CARDNAME", currentName);
                    desc = TextUtil.fastReplace(desc, "NICKNAME", Lang.getInstance().getNickName(currentName));
                    if (host.getEffectSource() != null) {
                        desc = TextUtil.fastReplace(desc, "EFFECTSOURCE", host.getEffectSource().getName());
                    }
                    sb.append(desc);
                    sb.append("\r\n\r\n");
                }
            }
        }
        if (this.isClassCard()) {
            void var12_24;
            sb.append("\r\n\r\n");
            boolean bl = true;
            while (var12_24 <= 3) {
                boolean disabled = var12_24 > this.getClassLevel() && this.isInPlay();
                for (StaticAbility st : state.getStaticAbilities()) {
                    if (!st.isClassLevelNAbility((int)var12_24) || st.isSecondary()) continue;
                    if (disabled) {
                        sb.append(grayTag);
                    }
                    sb.append(st.toString());
                    if (disabled) {
                        sb.append(endTag);
                    }
                    sb.append("\r\n\r\n");
                }
                for (SpellAbility sa : state.getSpellAbilities()) {
                    if (!sa.isClassLevelNAbility((int)var12_24) || sa.isSecondary()) continue;
                    sb.append(sa.toString()).append("\r\n\r\n");
                }
                ++var12_24;
            }
        }
        if (sb.toString().contains(" (NOTE: ")) {
            sb.insert(sb.indexOf("(NOTE: "), "\r\n");
        }
        if (sb.toString().contains("(NOTE: ") && sb.toString().contains(".) ")) {
            sb.insert(sb.indexOf(".) ") + 3, "\r\n");
        }
        if (this.isGoaded()) {
            sb.append("is goaded by: ").append(Lang.joinHomogenous(this.getGoaded()));
            sb.append("\r\n");
        }
        String string = "\r\n\r\n\r\n";
        int start = sb.lastIndexOf("\r\n\r\n\r\n");
        while (start != -1) {
            sb.replace(start, start + 4, "\r\n");
            start = sb.lastIndexOf("\r\n\r\n\r\n");
        }
        String desc = TextUtil.fastReplace(sb.toString(), "CARDNAME", CardTranslation.getTranslatedName(state.getName()));
        if (this.getEffectSource() != null) {
            desc = TextUtil.fastReplace(desc, "EFFECTSOURCE", this.getEffectSource().getName());
        }
        return desc.trim();
    }

    private StringBuilder abilityTextInstantSorcery(CardState state) {
        StringBuilder sb = new StringBuilder();
        String spellText = this.text.replaceAll("\\\\r\\\\n", "\r\n");
        sb.append(spellText);
        if (spellText.contains(" (NOTE: ")) {
            sb.insert(sb.indexOf("(NOTE: "), "\r\n");
        }
        if (spellText.contains("(NOTE: ") && spellText.endsWith(".)") && !spellText.endsWith("\r\n")) {
            sb.append("\r\n");
        }
        StringBuilder sbSpell = new StringBuilder();
        for (SpellAbility element : state.getSpellAbilities()) {
            if (element.isSecondary()) continue;
            element.usesTargeting();
            sbSpell.append(this.formatSpellAbility(element));
        }
        String strSpell = sbSpell.toString();
        StringBuilder sbBefore = new StringBuilder();
        StringBuilder sbAfter = new StringBuilder();
        for (KeywordInterface inst : this.getKeywords(state)) {
            String keyword = inst.getOriginal();
            try {
                String[] n;
                Cost cost;
                String[] k;
                if (keyword.equals("Ascend") || keyword.equals("Changeling") || keyword.equals("Aftermath") || keyword.equals("Wither") || keyword.equals("Convoke") || keyword.equals("Delve") || keyword.equals("Improvise") || keyword.equals("Retrace") || keyword.equals("Undaunted") || keyword.equals("Cascade") || keyword.equals("Devoid") || keyword.equals("Lifelink") || keyword.equals("Bargain") || keyword.equals("Spree") || keyword.equals("Split second")) {
                    sbBefore.append(keyword).append(" (").append(inst.getReminderText()).append(")");
                    sbBefore.append("\r\n\r\n");
                    continue;
                }
                if (keyword.equals("Conspire") || keyword.equals("Epic") || keyword.equals("Suspend") || keyword.equals("Jump-start") || keyword.equals("Fuse")) {
                    sbAfter.append(keyword).append(" (").append(inst.getReminderText()).append(")");
                    sbAfter.append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Casualty")) {
                    k = keyword.split(":");
                    sbBefore.append("Casualty ").append(k[1]);
                    if (k.length >= 4) {
                        sbBefore.append(". ").append(k[3]);
                    }
                    sbBefore.append(" (").append(inst.getReminderText()).append(")").append("\r\n\r\n");
                    continue;
                }
                if (keyword.startsWith("Dredge") || keyword.startsWith("Ripple")) {
                    sbAfter.append(TextUtil.fastReplace(keyword, ":", " "));
                    sbAfter.append(" (").append(inst.getReminderText()).append(")").append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Starting intensity")) {
                    sbAfter.append(TextUtil.fastReplace(keyword, ":", " ")).append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Escalate") || keyword.startsWith("Buyback") || keyword.startsWith("Freerunning") || keyword.startsWith("Prowl")) {
                    k = keyword.split(":");
                    String manacost = k[1];
                    cost = new Cost(manacost, false);
                    StringBuilder sbCost = new StringBuilder(k[0]);
                    if (!cost.isOnlyManaCost()) {
                        sbCost.append("\u2014");
                    } else {
                        sbCost.append(" ");
                    }
                    sbCost.append(cost.toSimpleString());
                    sbBefore.append((CharSequence)sbCost).append(" (").append(inst.getReminderText()).append(")");
                    sbBefore.append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Multikicker")) {
                    n = keyword.split(":");
                    Cost cost2 = new Cost(n[1], false);
                    sbBefore.append("Multikicker ").append(cost2.toSimpleString()).append(" (").append(inst.getReminderText()).append(")").append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Kicker")) {
                    sbBefore.append(this.kickerDesc(keyword, inst.getReminderText())).append("\r\n");
                    continue;
                }
                if (keyword.startsWith("AlternateAdditionalCost")) {
                    String[] costs = keyword.split(":", 2)[1].split(":");
                    sbBefore.append("As an additional cost to cast this spell, ");
                    for (int n2 = 0; n2 < costs.length; ++n2) {
                        cost = new Cost(costs[n2], false);
                        if (cost.isOnlyManaCost()) {
                            sbBefore.append(" pay ");
                        }
                        sbBefore.append(StringUtils.uncapitalize(cost.toSimpleString()));
                        sbBefore.append(n2 + 1 == costs.length ? ".\r\n\r\n" : (n2 + 2 == costs.length && costs.length > 2 ? ", or " : (n2 + 2 == costs.length ? " or " : ", ")));
                    }
                    continue;
                }
                if (keyword.startsWith("MayFlash")) {
                    sbBefore.append(inst.getReminderText());
                    sbBefore.append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Entwine") || keyword.startsWith("Madness") || keyword.startsWith("Miracle") || keyword.startsWith("Recover") || keyword.startsWith("Escape") || keyword.startsWith("Foretell:") || keyword.startsWith("Disturb") || keyword.startsWith("Overload") || keyword.startsWith("Plot")) {
                    k = keyword.split(":");
                    Cost cost3 = new Cost(k[1], false);
                    StringBuilder sbCost = new StringBuilder(k[0]);
                    if (!cost3.isOnlyManaCost()) {
                        sbCost.append("\u2014");
                    } else {
                        sbCost.append(" ");
                    }
                    sbCost.append(cost3.toSimpleString());
                    sbAfter.append((CharSequence)sbCost).append(" (").append(inst.getReminderText()).append(")");
                    sbAfter.append("\r\n");
                    continue;
                }
                if (keyword.equals("Gift")) {
                    sbBefore.append(keyword);
                    if (state.getFirstAbility().hasAdditionalAbility("GiftAbility")) {
                        sbBefore.append(" ").append(state.getFirstAbility().getAdditionalAbility("GiftAbility").getParam("GiftDescription"));
                    }
                    sbBefore.append("\r\n");
                    continue;
                }
                if (keyword.equals("Remove CARDNAME from your deck before playing if you're not playing for ante.")) {
                    sbBefore.append(keyword);
                    sbBefore.append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Haunt")) {
                    sbAfter.append("Haunt (");
                    sbAfter.append("When this spell card is put into a graveyard after resolving, ");
                    sbAfter.append("exile it haunting target creature.");
                    sbAfter.append(")");
                    sbAfter.append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Splice")) {
                    String desc;
                    n = keyword.split(":");
                    Cost cost4 = new Cost(n[2], false);
                    if (n.length > 3) {
                        desc = n[3];
                    } else {
                        Object[] k2 = n[1].split(",");
                        for (int i = 0; i < k2.length; ++i) {
                            if (!CardType.isACardType(k2[i])) continue;
                            k2[i] = ((String)k2[i]).toLowerCase();
                        }
                        desc = StringUtils.join(k2, " or ");
                    }
                    sbAfter.append("Splice onto ").append(desc).append(" ").append(cost4.toSimpleString());
                    sbAfter.append(" (").append(inst.getReminderText()).append(")").append("\r\n");
                    continue;
                }
                if (keyword.equals("Storm")) {
                    sbAfter.append("Storm (");
                    sbAfter.append("When you cast this spell, copy it for each spell cast before it this turn.");
                    if (strSpell.contains("Target") || strSpell.contains("target")) {
                        sbAfter.append(" You may choose new targets for the copies.");
                    }
                    sbAfter.append(")");
                    sbAfter.append("\r\n");
                    continue;
                }
                if (keyword.startsWith("Replicate")) {
                    n = keyword.split(":");
                    Cost cost5 = new Cost(n[1], false);
                    sbBefore.append("Replicate ").append(cost5.toSimpleString());
                    sbBefore.append(" (When you cast this spell, copy it for each time you paid its replicate cost.");
                    if (strSpell.contains("Target") || strSpell.contains("target")) {
                        sbBefore.append(" You may choose new targets for the copies.");
                    }
                    sbBefore.append(")\r\n");
                    continue;
                }
                if (keyword.equals("Assist")) {
                    sbBefore.append(keyword).append(" (").append(String.format(inst.getReminderText(), "{" + this.getManaCost().getGenericCost() + "}")).append(")");
                    sbBefore.append("\r\n\r\n");
                    continue;
                }
                if (!keyword.startsWith("DeckLimit")) continue;
                k = keyword.split(":");
                sbBefore.append(k[2]).append("\r\n");
            }
            catch (Exception e) {
                String msg = "Card:abilityTextInstantSorcery: crash in Keyword parsing";
                Breadcrumb bread = new Breadcrumb(msg);
                bread.setData("Card", this.getName());
                bread.setData("Keyword", keyword);
                Sentry.addBreadcrumb(bread);
                throw new RuntimeException("Error in Card " + this.getName() + " with Keyword " + keyword, e);
            }
        }
        sb.append(CardTranslation.translateMultipleDescriptionText(sbBefore.toString(), state));
        sb.append(strSpell);
        for (Trigger trig : state.getTriggers()) {
            if (trig.isSecondary()) continue;
            sb.append(trig.replaceAbilityText(trig.toString(), state)).append("\r\n");
        }
        for (ReplacementEffect replacementEffect : state.getReplacementEffects()) {
            if (replacementEffect.isSecondary()) continue;
            sb.append(replacementEffect.getDescription()).append("\r\n");
        }
        for (StaticAbility stAb : state.getStaticAbilities()) {
            String stAbD;
            if (stAb.isSecondary() || (stAbD = stAb.toString()).isEmpty()) continue;
            sb.append(stAbD).append("\r\n");
        }
        sb.append(CardTranslation.translateMultipleDescriptionText(sbAfter.toString(), state));
        return sb;
    }

    private String formatSpellAbility(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(sa.toString()).append("\r\n\r\n");
        return sb.toString();
    }

    public final boolean canProduceColorMana(Set<String> colors) {
        for (SpellAbility mana : this.getManaAbilities()) {
            for (String s2 : colors) {
                if (!(mana.getApi() == ApiType.ManaReflected ? CardUtil.getReflectableManaColors(mana).contains(s2) : mana.canProduce(MagicColor.toShortString(s2)))) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean canProduceSameManaTypeWith(Card c) {
        if (this.getManaAbilities().isEmpty()) {
            return false;
        }
        Set<String> colors = new HashSet<String>();
        for (SpellAbility ab : c.getManaAbilities()) {
            if (ab.getApi() == ApiType.ManaReflected) {
                colors.addAll(CardUtil.getReflectableManaColors(ab));
                continue;
            }
            colors = CardUtil.canProduce(6, ab, colors);
        }
        return this.canProduceColorMana(colors);
    }

    public final void clearFirstSpell() {
        this.currentState.clearFirstSpell();
    }

    public final SpellAbility getFirstSpellAbility() {
        return Iterables.getFirst(this.currentState.getNonManaAbilities(), null);
    }

    public final SpellAbility getFirstAttachSpell() {
        for (SpellAbility sa : this.getSpells()) {
            if (sa.getApi() != ApiType.Attach || sa.isSuppressed()) continue;
            return sa;
        }
        return null;
    }

    public final SpellPermanent getSpellPermanent() {
        for (SpellAbility sa : this.currentState.getNonManaAbilities()) {
            if (!(sa instanceof SpellPermanent)) continue;
            return (SpellPermanent)sa;
        }
        return null;
    }

    public final void addSpellAbility(SpellAbility a) {
        this.addSpellAbility(a, true);
    }

    public final void addSpellAbility(SpellAbility a, boolean updateView) {
        a.setHostCard(this);
        if (this.currentState.addSpellAbility(a) && updateView) {
            this.currentState.getView().updateAbilityText(this, this.currentState);
        }
    }

    @Deprecated
    public final void removeSpellAbility(SpellAbility a) {
        this.removeSpellAbility(a, true);
    }

    @Deprecated
    public final void removeSpellAbility(SpellAbility a, boolean updateView) {
        if (this.currentState.removeSpellAbility(a) && updateView) {
            this.currentState.getView().updateAbilityText(this, this.currentState);
        }
    }

    public final FCollectionView<SpellAbility> getSpellAbilities() {
        return this.currentState.getSpellAbilities();
    }

    public final FCollectionView<SpellAbility> getManaAbilities() {
        return this.currentState.getManaAbilities();
    }

    public final FCollectionView<SpellAbility> getNonManaAbilities() {
        return this.currentState.getNonManaAbilities();
    }

    public final boolean hasSpellAbility(SpellAbility sa) {
        return this.currentState.hasSpellAbility(sa);
    }

    public final boolean hasSpellAbility(int id) {
        return this.currentState.hasSpellAbility(id);
    }

    public boolean hasRemoveIntrinsic() {
        for (CardChangedType ct : this.getChangedCardTypes()) {
            if (!ct.isRemoveLandTypes()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoAbilities() {
        if (!this.getUnhiddenKeywords().isEmpty()) {
            return false;
        }
        if (!this.getStaticAbilities().isEmpty()) {
            return false;
        }
        if (!this.getReplacementEffects().isEmpty()) {
            return false;
        }
        if (!this.getTriggers().isEmpty()) {
            return false;
        }
        for (SpellAbility sa : this.getSpellAbilities()) {
            if (sa instanceof SpellPermanent && sa.isBasicSpell() || sa.isMorphUp() || sa.isDisguiseUp()) continue;
            return false;
        }
        return true;
    }

    public void updateSpellAbilities(List<SpellAbility> list, CardState state, Boolean mana) {
        for (CardTraitChanges ck : this.getChangedCardTraitsList(state)) {
            if (ck.isRemoveNonMana()) {
                if (null == mana) {
                    ArrayList<SpellAbility> toRemove = Lists.newArrayList(Iterables.filter(list, Predicates.not(SpellAbilityPredicates.isManaAbility())));
                    list.removeAll(toRemove);
                } else if (!mana.booleanValue()) {
                    list.clear();
                }
            } else if (ck.isRemoveAll()) {
                list.clear();
            }
            list.removeAll(ck.getRemovedAbilities());
            for (SpellAbility sa : ck.getAbilities()) {
                if (mana != null && mana.booleanValue() != sa.isManaAbility()) continue;
                list.add(sa);
            }
        }
        if (this.isInPlay()) {
            if ((null == mana || !mana.booleanValue()) && this.isFaceDown() && state.getView().getState() == CardStateName.FaceDown) {
                for (SpellAbility sa : this.getState(CardStateName.Original).getNonManaAbilities()) {
                    if (!sa.isTurnFaceUp()) continue;
                    list.add(sa);
                }
            }
        } else if (this.isAdventureCard() && state.getView().getState() == CardStateName.Original) {
            for (SpellAbility sa : this.getState(CardStateName.Adventure).getSpellAbilities()) {
                if (mana != null && mana.booleanValue() != sa.isManaAbility()) continue;
                list.add(sa);
            }
        }
        for (KeywordInterface kw : this.getUnhiddenKeywords(state)) {
            for (SpellAbility sa : kw.getAbilities()) {
                if (mana != null && mana.booleanValue() != sa.isManaAbility()) continue;
                list.add(sa);
            }
        }
    }

    private void updateBasicLandAbilities(List<SpellAbility> list, CardState state) {
        CardTypeView type = state.getTypeWithChanges();
        if (!type.isLand()) {
            return;
        }
        for (int i = 0; i < MagicColor.WUBRG.length; ++i) {
            byte c = MagicColor.WUBRG[i];
            if (!type.hasSubtype((String)MagicColor.Constant.BASIC_LANDS.get(i))) continue;
            SpellAbility sa = this.basicLandAbilities[i];
            if (sa == null) {
                this.basicLandAbilities[i] = sa = CardFactory.buildBasicLandAbility(state, c);
            }
            list.add(sa);
        }
    }

    public final FCollectionView<SpellAbility> getAllSpellAbilities() {
        FCollection<SpellAbility> res = new FCollection<SpellAbility>();
        for (CardStateName key : this.states.keySet()) {
            res.addAll(this.getState(key).getNonManaAbilities());
            res.addAll(this.getState(key).getManaAbilities());
        }
        return res;
    }

    public final FCollectionView<SpellAbility> getSpells() {
        FCollection<SpellAbility> res = new FCollection<SpellAbility>();
        for (SpellAbility sa : this.currentState.getNonManaAbilities()) {
            if (!sa.isSpell()) continue;
            res.add(sa);
        }
        return res;
    }

    public final FCollectionView<SpellAbility> getBasicSpells() {
        return this.getBasicSpells(this.currentState);
    }

    public final FCollectionView<SpellAbility> getBasicSpells(CardState state) {
        FCollection<SpellAbility> res = new FCollection<SpellAbility>();
        for (SpellAbility sa : state.getNonManaAbilities()) {
            if (!sa.isSpell() || !sa.isBasicSpell()) continue;
            res.add(sa);
        }
        return res;
    }

    public final int getShieldCount() {
        return this.shieldCount;
    }

    public final void incShieldCount() {
        ++this.shieldCount;
        this.view.updateShieldCount(this);
    }

    public final void decShieldCount() {
        --this.shieldCount;
        this.view.updateShieldCount(this);
    }

    public final void resetShieldCount() {
        this.shieldCount = 0;
        this.view.updateShieldCount(this);
    }

    public final void addRegeneratedThisTurn() {
        ++this.regeneratedThisTurn;
    }

    public final int getRegeneratedThisTurn() {
        return this.regeneratedThisTurn;
    }

    public final void setRegeneratedThisTurn(int n) {
        this.regeneratedThisTurn = n;
    }

    public final boolean canBeShielded() {
        return !StaticAbilityCantRegenerate.cantRegenerate(this);
    }

    public final void updateTokenView() {
        this.view.updateToken(this);
    }

    public final boolean isTokenCard() {
        if (this.isInPlay() && this.hasMergedCard()) {
            return this.getTopMergedCard().tokenCard;
        }
        return this.tokenCard;
    }

    public final void setTokenCard(boolean tokenC) {
        if (this.tokenCard == tokenC) {
            return;
        }
        this.tokenCard = tokenC;
        this.view.updateTokenCard(this);
    }

    public final void setCollectible(boolean collectible) {
        this.collectible = collectible;
    }

    public final boolean isCollectible() {
        return this.collectible;
    }

    public void updateWasDestroyed(boolean value) {
        this.view.updateWasDestroyed(value);
    }

    public final Card getCopiedPermanent() {
        return this.copiedPermanent;
    }

    public final void setCopiedPermanent(Card c) {
        if (this.copiedPermanent == c) {
            return;
        }
        this.copiedPermanent = c;
        if (c != null) {
            this.currentState.setOracleText(c.getOracleText());
            this.currentState.setFunctionalVariantName(c.getCurrentState().getFunctionalVariantName());
        }
    }

    public final boolean isFaceDown() {
        if (this.hasMergedCard()) {
            return this.getTopMergedCard().facedown;
        }
        return this.facedown;
    }

    public final boolean isRealFaceDown() {
        return this.facedown;
    }

    public final void setFaceDown(boolean value) {
        this.facedown = value;
    }

    public final boolean isTransformed() {
        return this.getTransformedTimestamp() != 0L;
    }

    public final boolean isFlipped() {
        return this.flipped;
    }

    public final void setFlipped(boolean value) {
        this.flipped = value;
    }

    public final void addLeavesPlayCommand(GameCommand c) {
        this.leavePlayCommandList.add(c);
    }

    public final void addUntapCommand(GameCommand c) {
        this.untapCommandList.add(c);
    }

    public final void addUnattachCommand(GameCommand c) {
        this.unattachCommandList.add(c);
    }

    public final void addFaceupCommand(GameCommand c) {
        this.faceupCommandList.add(c);
    }

    public final void addFacedownCommand(GameCommand c) {
        this.facedownCommandList.add(c);
    }

    public final void addChangeControllerCommand(GameCommand c) {
        this.changeControllerCommandList.add(c);
    }

    public final void addPhaseOutCommand(GameCommand c) {
        this.phaseOutCommandList.add(c);
    }

    public final List<GameCommand> getLeavesPlayCommands() {
        return this.leavePlayCommandList;
    }

    public final void setLeavesPlayCommands(List<GameCommand> list) {
        this.leavePlayCommandList = list;
    }

    public final void runLeavesPlayCommands() {
        for (GameCommand c : this.leavePlayCommandList) {
            c.run();
        }
        this.leavePlayCommandList.clear();
    }

    public final void runUntapCommands() {
        for (GameCommand c : this.untapCommandList) {
            c.run();
        }
        this.untapCommandList.clear();
    }

    public final void runUnattachCommands() {
        for (GameCommand c : this.unattachCommandList) {
            c.run();
        }
        this.unattachCommandList.clear();
    }

    public final void runFaceupCommands() {
        for (GameCommand c : this.faceupCommandList) {
            c.run();
        }
        this.faceupCommandList.clear();
    }

    public final void runFacedownCommands() {
        for (GameCommand c : this.facedownCommandList) {
            c.run();
        }
        this.facedownCommandList.clear();
    }

    public final void runChangeControllerCommands() {
        for (GameCommand c : this.changeControllerCommandList) {
            c.run();
        }
        this.changeControllerCommandList.clear();
    }

    public final void runPhaseOutCommands() {
        for (GameCommand c : this.phaseOutCommandList) {
            c.run();
        }
        this.phaseOutCommandList.clear();
    }

    public final void setSickness(boolean sickness0) {
        if (this.sickness == sickness0) {
            return;
        }
        this.sickness = sickness0;
        this.view.updateSickness(this);
    }

    public final boolean hasSickness() {
        return this.sickness && !this.hasKeyword(Keyword.HASTE);
    }

    public final boolean isSick() {
        return this.hasSickness() && this.isCreature();
    }

    public final boolean isFirstTurnControlled() {
        return this.sickness;
    }

    public boolean hasBecomeTargetThisTurn() {
        return this.becameTargetThisTurn;
    }

    public void setBecameTargetThisTurn(boolean becameTargetThisTurn0) {
        this.becameTargetThisTurn = becameTargetThisTurn0;
    }

    public boolean isValiant() {
        return this.valiant;
    }

    public void setValiant(boolean v) {
        this.valiant = v;
    }

    public boolean hasStartedTheTurnUntapped() {
        return this.startedTheTurnUntapped;
    }

    public void setStartedTheTurnUntapped(boolean untapped) {
        this.startedTheTurnUntapped = untapped;
    }

    public boolean cameUnderControlSinceLastUpkeep() {
        return this.cameUnderControlSinceLastUpkeep;
    }

    public void setCameUnderControlSinceLastUpkeep(boolean underControlSinceLastUpkeep) {
        this.cameUnderControlSinceLastUpkeep = underControlSinceLastUpkeep;
    }

    public final Player getOwner() {
        return this.owner;
    }

    public final void setOwner(Player owner0) {
        if (this.owner == owner0) {
            return;
        }
        if (this.owner != null && this.owner.getGame() != this.getGame()) {
            throw new RuntimeException();
        }
        this.owner = owner0;
        this.view.updateOwner(this);
        this.view.updateController(this);
    }

    public final Player getController() {
        long lastTimestamp;
        Map.Entry<Long, Player> lastEntry = this.tempControllers.lastEntry();
        if (lastEntry != null && (lastTimestamp = lastEntry.getKey().longValue()) > this.controllerTimestamp) {
            return lastEntry.getValue();
        }
        if (this.controller != null) {
            return this.controller;
        }
        return this.owner;
    }

    public final void setController(Player player, long tstamp) {
        this.tempControllers.clear();
        this.controller = player;
        this.controllerTimestamp = tstamp;
        this.view.updateController(this);
    }

    public final void addTempController(Player player, long tstamp) {
        this.tempControllers.put(tstamp, player);
        this.view.updateController(this);
    }

    public final void removeTempController(long tstamp) {
        if (this.tempControllers.remove(tstamp) != null) {
            this.view.updateController(this);
        }
    }

    public final void removeTempController(Player player) {
        boolean changed = false;
        while (this.tempControllers.values().remove(player)) {
            changed = true;
        }
        if (changed) {
            this.view.updateController(this);
        }
    }

    public final void clearTempControllers() {
        if (this.tempControllers.isEmpty()) {
            return;
        }
        this.tempControllers.clear();
        this.view.updateController(this);
    }

    public final void clearControllers() {
        if (this.tempControllers.isEmpty() && this.controller == null) {
            return;
        }
        this.tempControllers.clear();
        this.controller = null;
        this.view.updateController(this);
    }

    public boolean mayPlayerLook(Player player) {
        return this.view.mayPlayerLook(player.getView());
    }

    public final void addMayLookFaceDownExile(Player p) {
        this.mayLookFaceDownExile.add(p);
        this.updateMayLook();
    }

    public final void addMayLookAt(long timestamp, Iterable<Player> list) {
        PlayerCollection plist = new PlayerCollection(list);
        this.mayLook.put(timestamp, plist);
        if (this.isFaceDown() && this.isInZone(ZoneType.Exile)) {
            this.mayLookFaceDownExile.addAll(plist);
        }
        this.updateMayLook();
    }

    public final void removeMayLookAt(long timestamp) {
        if (this.mayLook.remove(timestamp) != null) {
            this.updateMayLook();
        }
    }

    public final void addMayLookTemp(Player player) {
        if (this.mayLookTemp.add(player)) {
            if (this.isFaceDown() && this.isInZone(ZoneType.Exile)) {
                this.mayLookFaceDownExile.add(player);
            }
            this.updateMayLook();
        }
    }

    public final void removeMayLookTemp(Player player) {
        if (this.mayLookTemp.remove(player)) {
            this.updateMayLook();
        }
    }

    public final void updateMayLook() {
        PlayerCollection result = new PlayerCollection();
        for (PlayerCollection v : this.mayLook.values()) {
            result.addAll(v);
        }
        result.addAll(this.mayLookFaceDownExile);
        result.addAll(this.mayLookTemp);
        this.getView().setPlayerMayLook(result);
    }

    public final void updateMayPlay() {
        PlayerCollection result = new PlayerCollection();
        for (CardPlayOption o : this.mayPlay.values()) {
            if (!o.grantsZonePermissions()) continue;
            result.add(o.getPlayer());
        }
        this.getView().setMayPlayPlayers(result);
    }

    public final CardPlayOption mayPlay(StaticAbility sta) {
        if (sta == null) {
            return null;
        }
        return this.mayPlay.get(sta);
    }

    public final List<CardPlayOption> mayPlay(Player player) {
        ArrayList<CardPlayOption> result = Lists.newArrayList();
        for (CardPlayOption o : this.mayPlay.values()) {
            if (!o.getPlayer().equals(player)) continue;
            result.add(o);
        }
        return result;
    }

    public final void setMayPlay(Player player, boolean withoutManaCost, Cost altManaCost, boolean withFlash, boolean grantZonePermissions, StaticAbility sta) {
        this.mayPlay.put(sta, new CardPlayOption(player, sta, withoutManaCost, altManaCost, withFlash, grantZonePermissions));
        this.updateMayPlay();
    }

    public final void removeMayPlay(StaticAbility sta) {
        this.mayPlay.remove(sta);
        this.updateMayPlay();
    }

    public final Map<StaticAbility, CardPlayOption> getMayPlay() {
        return Maps.newHashMap(this.mayPlay);
    }

    public final Map<StaticAbility, CardPlayOption> setMayPlay(Map<StaticAbility, CardPlayOption> mp) {
        this.mayPlay = mp;
        return this.mayPlay;
    }

    public void resetMayPlayTurn() {
        for (StaticAbility sta : this.getStaticAbilities()) {
            sta.resetMayPlayTurn();
        }
    }

    public final CardCollectionView getEquippedBy() {
        return CardLists.filter((Iterable<Card>)this.getAttachedCards(), CardPredicates.Presets.EQUIPMENT);
    }

    public final boolean isEquipped() {
        return Iterables.any(this.getAttachedCards(), CardPredicates.Presets.EQUIPMENT);
    }

    public final boolean isEquippedBy(Card c) {
        return this.hasCardAttachment(c);
    }

    public final boolean isEquippedBy(String cardName) {
        return this.hasCardAttachment(cardName);
    }

    public final CardCollectionView getFortifiedBy() {
        return CardLists.filter((Iterable<Card>)this.getAttachedCards(), CardPredicates.Presets.FORTIFICATION);
    }

    public final boolean isFortified() {
        return Iterables.any(this.getAttachedCards(), CardPredicates.Presets.FORTIFICATION);
    }

    public final boolean isFortifiedBy(Card c) {
        return this.hasCardAttachment(c);
    }

    public final boolean isFortifying() {
        return this.isAttachedToEntity();
    }

    public final Card getEquipping() {
        return this.getAttachedTo();
    }

    public final boolean isEquipping() {
        return this.isAttachedToEntity();
    }

    public final GameEntity getEntityAttachedTo() {
        return this.entityAttachedTo;
    }

    public final void setEntityAttachedTo(GameEntity e) {
        if (this.entityAttachedTo == e) {
            return;
        }
        this.entityAttachedTo = e;
        this.view.updateAttachedTo(this);
    }

    public final void removeAttachedTo(GameEntity e) {
        if (this.entityAttachedTo == e) {
            this.setEntityAttachedTo(null);
        }
    }

    public final boolean isAttachedToEntity() {
        return this.entityAttachedTo != null;
    }

    public final boolean isAttachedToEntity(GameEntity e) {
        return this.entityAttachedTo == e;
    }

    public final Card getAttachedTo() {
        if (this.entityAttachedTo instanceof Card) {
            return (Card)this.entityAttachedTo;
        }
        return null;
    }

    public final Card getEnchantingCard() {
        return this.getAttachedTo();
    }

    public final Player getPlayerAttachedTo() {
        if (this.entityAttachedTo instanceof Player) {
            return (Player)this.entityAttachedTo;
        }
        return null;
    }

    public final boolean isEnchanting() {
        return this.isAttachedToEntity();
    }

    public final boolean isEnchantingCard() {
        return this.getEnchantingCard() != null;
    }

    public final void attachToEntity(GameEntity entity, SpellAbility sa) {
        this.attachToEntity(entity, sa, false);
    }

    public final void attachToEntity(GameEntity entity, SpellAbility sa, boolean overwrite) {
        if (!overwrite && !entity.canBeAttached(this, sa)) {
            return;
        }
        GameEntity oldTarget = null;
        if (this.isAttachedToEntity()) {
            oldTarget = this.getEntityAttachedTo();
            if (oldTarget.equals(entity)) {
                return;
            }
            this.unattachFromEntity(oldTarget);
        }
        this.setEntityAttachedTo(entity);
        this.setLayerTimestamp(this.getGame().getNextTimestamp());
        entity.addAttachedCard(this);
        this.getGame().fireEvent(new GameEventCardAttachment(this, oldTarget, entity));
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.AttachTarget, entity);
        this.getGame().getReplacementHandler().run(ReplacementType.Attached, repParams);
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.AttachSource, this);
        runParams.put(AbilityKey.AttachTarget, entity);
        this.getController().getGame().getTriggerHandler().runTrigger(TriggerType.Attached, runParams, false);
        if (this.hasKeyword(Keyword.RECONFIGURE)) {
            final long ts = this.getGame().getNextTimestamp();
            this.addChangedCardTypes((CardType)null, CardType.parse("Creature", true), false, (Set<RemoveType>)EnumSet.noneOf(RemoveType.class), ts, 0L, true, false);
            GameCommand unattach = new GameCommand(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run() {
                    Card.this.removeChangedCardTypes(ts, 0L);
                }
            };
            this.addUnattachCommand(unattach);
        }
    }

    public final void unattachFromEntity(GameEntity entity) {
        if (this.entityAttachedTo == null || !this.entityAttachedTo.equals(entity)) {
            return;
        }
        if (this.isPhasedOut()) {
            return;
        }
        this.setEntityAttachedTo(null);
        entity.removeAttachedCard(this);
        this.unanimateBestow();
        this.getGame().fireEvent(new GameEventCardAttachment(this, entity, null));
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Attach, this);
        runParams.put(AbilityKey.Object, entity);
        this.getGame().getTriggerHandler().runTrigger(TriggerType.Unattach, runParams, false);
        this.runUnattachCommands();
    }

    public final boolean isModified() {
        if (!this.isCreature()) {
            return false;
        }
        if (this.isEquipped() || this.hasCounters()) {
            return true;
        }
        return Iterables.any(this.getEnchantedBy(), CardPredicates.isController(this.getController()));
    }

    public final void setType(CardType type0) {
        this.currentState.setType(type0);
    }

    public final void addType(String type0) {
        this.currentState.addType(type0);
    }

    public final void addType(Iterable<String> type0) {
        this.currentState.addType(type0);
    }

    public final void removeType(CardType.Supertype st) {
        this.currentState.removeType(st);
    }

    public final void setCreatureTypes(Collection<String> ctypes) {
        this.currentState.setCreatureTypes(ctypes);
    }

    public final CardTypeView getType() {
        return this.getType(this.currentState);
    }

    public final CardTypeView getType(CardState state) {
        Iterable<CardChangedType> changedCardTypes = this.getChangedCardTypes();
        if (Iterables.isEmpty(changedCardTypes)) {
            return state.getType();
        }
        return state.getType().getTypeWithChanges(changedCardTypes);
    }

    public final CardTypeView getOriginalType() {
        return this.getOriginalType(this.currentState);
    }

    public final CardTypeView getOriginalType(CardState state) {
        return state.getType();
    }

    public Iterable<CardChangedType> getChangedCardTypes() {
        if (this.changedCardTypesByText.isEmpty() && this.changedTypeByText == null && this.changedCardTypesCharacterDefining.isEmpty() && this.changedCardTypes.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList byText = this.changedTypeByText == null ? ImmutableList.of() : ImmutableList.of(this.changedTypeByText);
        return Iterables.unmodifiableIterable(Iterables.concat(this.changedCardTypesByText.values(), byText, this.changedCardTypesCharacterDefining.values(), this.changedCardTypes.values()));
    }

    public Table<Long, Long, CardChangedType> getChangedCardTypesTable() {
        return Tables.unmodifiableTable(this.changedCardTypes);
    }

    public Table<Long, Long, CardChangedType> getChangedCardTypesCharacterDefiningTable() {
        return Tables.unmodifiableTable(this.changedCardTypesCharacterDefining);
    }

    public boolean clearChangedCardTypes() {
        boolean changed = false;
        if (this.changedTypeByText != null) {
            changed = true;
        }
        this.changedTypeByText = null;
        if (!this.changedCardTypesByText.isEmpty()) {
            changed = true;
        }
        this.changedCardTypesByText.clear();
        if (!this.changedCardTypesCharacterDefining.isEmpty()) {
            changed = true;
        }
        this.changedCardTypesCharacterDefining.clear();
        if (!this.changedCardTypes.isEmpty()) {
            changed = true;
        }
        this.changedCardTypes.clear();
        return changed;
    }

    public boolean clearChangedCardColors() {
        boolean changed = false;
        if (!this.changedCardColorsByText.isEmpty()) {
            changed = true;
        }
        this.changedCardColorsByText.clear();
        if (!this.changedCardTypesCharacterDefining.isEmpty()) {
            changed = true;
        }
        this.changedCardTypesCharacterDefining.clear();
        if (!this.changedCardColors.isEmpty()) {
            changed = true;
        }
        this.changedCardColors.clear();
        return changed;
    }

    public Table<Long, Long, KeywordsChange> getChangedCardKeywordsByText() {
        return this.changedCardKeywordsByText;
    }

    public Iterable<KeywordsChange> getChangedCardKeywordsList() {
        return Iterables.concat(this.changedCardKeywordsByText.values(), ImmutableList.of(this.changedCardKeywordsByWord), ImmutableList.of(new KeywordsChange((Collection<KeywordInterface>)ImmutableList.of(), (Collection<KeywordInterface>)ImmutableList.of(), this.hasRemoveIntrinsic())), this.changedCardKeywords.values());
    }

    public Table<Long, Long, KeywordsChange> getChangedCardKeywords() {
        return this.changedCardKeywords;
    }

    public Table<Long, Long, CardColor> getChangedCardColorsTable() {
        return this.changedCardColors;
    }

    public Table<Long, Long, CardColor> getChangedCardColorsCharacterDefiningTable() {
        return this.changedCardColorsCharacterDefining;
    }

    public Iterable<CardColor> getChangedCardColors() {
        return Iterables.concat(this.changedCardColorsByText.values(), this.changedCardColorsCharacterDefining.values(), this.changedCardColors.values());
    }

    public final void addChangedCardTypesByText(CardType addType, long timestamp, long staticId) {
        this.addChangedCardTypesByText(addType, timestamp, staticId, true);
    }

    public final void addChangedCardTypesByText(CardType addType, long timestamp, long staticId, boolean updateView) {
        this.changedCardTypesByText.put(timestamp, staticId, new CardChangedType(addType, null, false, EnumSet.of(RemoveType.SuperTypes, RemoveType.CardTypes, RemoveType.SubTypes)));
        this.changedTextColors.addEmpty(timestamp, staticId);
        this.changedTextTypes.addEmpty(timestamp, staticId);
        this.updateChangedText();
        if (updateView) {
            this.updateTypesForView();
        }
    }

    public final void addChangedCardTypes(CardType addType, CardType removeType, boolean addAllCreatureTypes, Set<RemoveType> remove, long timestamp, long staticId, boolean updateView, boolean cda) {
        (cda ? this.changedCardTypesCharacterDefining : this.changedCardTypes).put(timestamp, staticId, new CardChangedType(addType, removeType, addAllCreatureTypes, remove));
        if (updateView) {
            this.updateTypesForView();
        }
    }

    public final void addChangedCardTypes(Iterable<String> types, Iterable<String> removeTypes, boolean addAllCreatureTypes, Set<RemoveType> remove, long timestamp, long staticId, boolean updateView, boolean cda) {
        CardType addType = null;
        CardType removeType = null;
        if (types != null) {
            addType = new CardType(types, true);
        }
        if (removeTypes != null) {
            removeType = new CardType(removeTypes, true);
        }
        this.addChangedCardTypes(addType, removeType, addAllCreatureTypes, remove, timestamp, staticId, updateView, cda);
    }

    public final void removeChangedCardTypes(long timestamp, long staticId) {
        this.removeChangedCardTypes(timestamp, staticId, true);
    }

    public final void removeChangedCardTypes(long timestamp, long staticId, boolean updateView) {
        boolean removed = false;
        removed |= this.changedCardTypes.remove(timestamp, staticId) != null;
        if ((removed |= this.changedCardTypesCharacterDefining.remove(timestamp, staticId) != null) && updateView) {
            this.updateTypesForView();
        }
    }

    public void addColorByText(ColorSet color, long timestamp, long staticId) {
        this.changedCardColorsByText.put(timestamp, staticId, new CardColor(color, false));
        this.updateColorForView();
    }

    public final void addColor(ColorSet color, boolean addToColors, long timestamp, long staticId, boolean cda) {
        (cda ? this.changedCardColorsCharacterDefining : this.changedCardColors).put(timestamp, staticId, new CardColor(color, addToColors));
        this.updateColorForView();
    }

    public final void removeColor(long timestampIn, long staticId) {
        boolean removed = false;
        removed |= this.changedCardColorsByText.remove(timestampIn, staticId) != null;
        removed |= this.changedCardColors.remove(timestampIn, staticId) != null;
        if (removed |= this.changedCardColorsCharacterDefining.remove(timestampIn, staticId) != null) {
            this.updateColorForView();
        }
    }

    public final void updateColorForView() {
        this.currentState.getView().updateColors(this);
        this.currentState.getView().updateHasChangeColors(!Iterables.isEmpty(this.getChangedCardColors()));
    }

    public final void setColor(String ... color) {
        this.setColor(ColorSet.fromNames(color).getColor());
    }

    public final void setColor(byte color) {
        this.currentState.setColor(color);
    }

    public final ColorSet getColor() {
        return this.getColor(this.currentState);
    }

    public final ColorSet getColor(CardState state) {
        byte colors = state.getColor();
        for (CardColor cc : this.getChangedCardColors()) {
            if (cc.isAdditional()) {
                colors = (byte)(colors | cc.getColorMask());
                continue;
            }
            colors = cc.getColorMask();
        }
        return ColorSet.fromMask(colors);
    }

    public final int getCurrentLoyalty() {
        return this.getCounters(CounterEnumType.LOYALTY);
    }

    public final void setBaseLoyalty(int n) {
        this.currentState.setBaseLoyalty(Integer.toString(n));
    }

    public final int getCurrentDefense() {
        return this.getCounters(CounterEnumType.DEFENSE);
    }

    public final void setBaseDefense(int n) {
        this.currentState.setBaseDefense(Integer.toString(n));
    }

    public final Set<Integer> getAttractionLights() {
        return this.currentState.getAttractionLights();
    }

    public final void setAttractionLights(Set<Integer> attractionLights) {
        this.currentState.setAttractionLights(attractionLights);
    }

    public final int getBasePower() {
        return this.currentState.getBasePower();
    }

    public final int getBaseToughness() {
        return this.currentState.getBaseToughness();
    }

    public final void setBasePower(int n) {
        this.currentState.setBasePower(n);
    }

    public final void setBaseToughness(int n) {
        this.currentState.setBaseToughness(n);
    }

    public final String getBasePowerString() {
        return null == this.currentState.getBasePowerString() ? String.valueOf(this.getBasePower()) : this.currentState.getBasePowerString();
    }

    public final String getBaseToughnessString() {
        return null == this.currentState.getBaseToughnessString() ? String.valueOf(this.getBaseToughness()) : this.currentState.getBaseToughnessString();
    }

    public final void setBasePowerString(String s2) {
        this.currentState.setBasePowerString(s2);
    }

    public final void setBaseToughnessString(String s2) {
        this.currentState.setBaseToughnessString(s2);
    }

    public final void addCloneState(CardCloneStates states, long timestamp) {
        this.clonedStates.put(timestamp, states);
        this.updateCloneState(true);
    }

    public final boolean removeCloneState(long timestamp) {
        if (this.clonedStates.remove(timestamp) != null) {
            this.updateCloneState(true);
            return true;
        }
        return false;
    }

    public final boolean removeCloneState(CardTraitBase ctb) {
        boolean changed = false;
        ArrayList<Long> toRemove = Lists.newArrayList();
        for (Map.Entry e : this.clonedStates.entrySet()) {
            if (!ctb.equals(((CardCloneStates)e.getValue()).getSource())) continue;
            toRemove.add((Long)e.getKey());
            changed = true;
        }
        for (Long l : toRemove) {
            this.clonedStates.remove(l);
        }
        if (changed) {
            this.updateCloneState(true);
        }
        return changed;
    }

    public final Card getCloner() {
        CardCloneStates clStates = this.getLastClonedState();
        if (!this.isCloned() || clStates == null) {
            return null;
        }
        return clStates.getHost();
    }

    public final boolean removeCloneStates() {
        if (this.clonedStates.isEmpty()) {
            return false;
        }
        this.clonedStates.clear();
        this.updateCloneState(false);
        return true;
    }

    public final Map<Long, CardCloneStates> getCloneStates() {
        return this.clonedStates;
    }

    public final void setCloneStates(Map<Long, CardCloneStates> val) {
        this.clonedStates.clear();
        this.clonedStates.putAll(val);
        this.updateCloneState(true);
    }

    private void updateCloneState(boolean updateView) {
        if (this.isFaceDown()) {
            this.setState(CardStateName.FaceDown, updateView, true);
        } else {
            this.setState(this.getFaceupCardStateName(), updateView, true);
        }
        this.updateChangedText();
    }

    public final CardStateName getFaceupCardStateName() {
        CardStateName stateName;
        if (this.isFlipped() && this.hasState(CardStateName.Flipped)) {
            return CardStateName.Flipped;
        }
        if (this.isSpecialized()) {
            return this.getCurrentStateName();
        }
        if (this.backside && this.isDoubleFaced() && this.hasState(stateName = this.getRules().getSplitType().getChangedStateName())) {
            return stateName;
        }
        return CardStateName.Original;
    }

    private CardCloneStates getLastClonedState() {
        if (this.clonedStates.isEmpty()) {
            return null;
        }
        return this.clonedStates.lastEntry().getValue();
    }

    public final Table<Long, Long, Pair<Integer, Integer>> getSetPTTable() {
        return this.newPT;
    }

    public final void setPTTable(Table<Long, Long, Pair<Integer, Integer>> table) {
        this.newPT.clear();
        this.newPT.putAll(table);
    }

    public final Table<Long, Long, Pair<Integer, Integer>> getSetPTCharacterDefiningTable() {
        return this.newPTCharacterDefining;
    }

    public final void setPTCharacterDefiningTable(Table<Long, Long, Pair<Integer, Integer>> table) {
        this.newPTCharacterDefining.clear();
        this.newPTCharacterDefining.putAll(table);
    }

    public final void addNewPTByText(Integer power, Integer toughness, long timestamp, long staticId) {
        this.newPTText.put(timestamp, staticId, Pair.of(power, toughness));
        this.updatePTforView();
    }

    public final void addNewPT(Integer power, Integer toughness, long timestamp, long staticId) {
        this.addNewPT(power, toughness, timestamp, staticId, false);
    }

    public final void addNewPT(Integer power, Integer toughness, long timestamp, long staticId, boolean cda) {
        (cda ? this.newPTCharacterDefining : this.newPT).put(timestamp, staticId, Pair.of(power, toughness));
        this.updatePTforView();
    }

    public final void removeNewPT(long timestamp, long staticId) {
        boolean removed = false;
        removed |= this.newPTText.remove(timestamp, staticId) != null;
        removed |= this.newPT.remove(timestamp, staticId) != null;
        if (removed |= this.newPTCharacterDefining.remove(timestamp, staticId) != null) {
            this.updatePTforView();
        }
    }

    public void updatePTforView() {
        this.getView().updateLethalDamage(this);
        this.currentState.getView().updatePower(this);
        this.currentState.getView().updateToughness(this);
    }

    public Iterable<Pair<Integer, Integer>> getPTIterable() {
        return Iterables.concat(this.newPTText.values(), this.newPTCharacterDefining.values(), this.newPT.values());
    }

    public final boolean clearNewPT() {
        boolean changed = false;
        if (!this.newPTText.isEmpty()) {
            changed = true;
            this.newPTText.clear();
        }
        if (!this.newPTCharacterDefining.isEmpty()) {
            changed = true;
            this.newPTCharacterDefining.clear();
        }
        if (!this.newPT.isEmpty()) {
            changed = true;
            this.newPT.clear();
        }
        return changed;
    }

    public final int getCurrentPower() {
        int total = this.getBasePower();
        for (Pair<Integer, Integer> p : this.getPTIterable()) {
            if (p.getLeft() == null) continue;
            total = p.getLeft();
        }
        return total;
    }

    public final StatBreakdown getUnswitchedPowerBreakdown() {
        if (this.isInPlay() && !this.isCreature()) {
            return new StatBreakdown();
        }
        return new StatBreakdown(this.getCurrentPower(), this.getTempPowerBoost(), this.getPowerBonusFromCounters());
    }

    public final int getUnswitchedPower() {
        return this.getUnswitchedPowerBreakdown().getTotal();
    }

    public final int getPowerBonusFromCounters() {
        return this.getCounters(CounterEnumType.P1P1) + this.getCounters(CounterEnumType.P1P2) + this.getCounters(CounterEnumType.P1P0) - this.getCounters(CounterEnumType.M1M1) + 2 * this.getCounters(CounterEnumType.P2P2) - 2 * this.getCounters(CounterEnumType.M2M1) - 2 * this.getCounters(CounterEnumType.M2M2) - this.getCounters(CounterEnumType.M1M0) + 2 * this.getCounters(CounterEnumType.P2P0);
    }

    public final StatBreakdown getNetPowerBreakdown() {
        if (this.getAmountOfKeyword("CARDNAME's power and toughness are switched") % 2 != 0) {
            return this.getUnswitchedToughnessBreakdown();
        }
        return this.getUnswitchedPowerBreakdown();
    }

    public final int getNetPower() {
        if (this.getAmountOfKeyword("CARDNAME's power and toughness are switched") % 2 != 0) {
            return this.getUnswitchedToughness();
        }
        return this.getUnswitchedPower();
    }

    public final int getCurrentToughness() {
        int total = this.getBaseToughness();
        for (Pair<Integer, Integer> p : this.getPTIterable()) {
            if (p.getRight() == null) continue;
            total = p.getRight();
        }
        return total;
    }

    public final StatBreakdown getUnswitchedToughnessBreakdown() {
        if (this.isInPlay() && !this.isCreature()) {
            return new StatBreakdown();
        }
        return new StatBreakdown(this.getCurrentToughness(), this.getTempToughnessBoost(), this.getToughnessBonusFromCounters());
    }

    public final int getUnswitchedToughness() {
        return this.getUnswitchedToughnessBreakdown().getTotal();
    }

    public final int getToughnessBonusFromCounters() {
        return this.getCounters(CounterEnumType.P1P1) + 2 * this.getCounters(CounterEnumType.P1P2) - this.getCounters(CounterEnumType.M1M1) + this.getCounters(CounterEnumType.P0P1) - 2 * this.getCounters(CounterEnumType.M0M2) + 2 * this.getCounters(CounterEnumType.P2P2) - this.getCounters(CounterEnumType.M0M1) - this.getCounters(CounterEnumType.M2M1) - 2 * this.getCounters(CounterEnumType.M2M2) + 2 * this.getCounters(CounterEnumType.P0P2);
    }

    public final StatBreakdown getNetToughnessBreakdown() {
        if (this.getAmountOfKeyword("CARDNAME's power and toughness are switched") % 2 != 0) {
            return this.getUnswitchedPowerBreakdown();
        }
        return this.getUnswitchedToughnessBreakdown();
    }

    public final int getNetToughness() {
        return this.getNetToughnessBreakdown().getTotal();
    }

    public final boolean toughnessAssignsDamage() {
        return StaticAbilityCombatDamageToughness.combatDamageToughness(this);
    }

    public final boolean assignNoCombatDamage() {
        return StaticAbilityAssignNoCombatDamage.assignNoCombatDamage(this);
    }

    public final int getNetCombatDamage() {
        return this.assignNoCombatDamage() ? 0 : (this.toughnessAssignsDamage() ? this.getNetToughnessBreakdown() : this.getNetPowerBreakdown()).getTotal();
    }

    public final void addIntensity(int n) {
        this.intensity += n;
        this.view.updateIntensity(this);
    }

    public final int getIntensity(boolean total) {
        if (total && this.hasKeyword(Keyword.STARTING_INTENSITY)) {
            return this.getKeywordMagnitude(Keyword.STARTING_INTENSITY) + this.intensity;
        }
        return this.intensity;
    }

    public final void setIntensity(int n) {
        this.intensity = n;
    }

    public final boolean hasIntensity() {
        return this.intensity > 0;
    }

    public final boolean hasPerpetual() {
        return !this.perpetual.isEmpty();
    }

    public final List<Map<String, Object>> getPerpetual() {
        return this.perpetual;
    }

    public final void addPerpetual(Map<String, Object> p) {
        this.perpetual.add(p);
    }

    public final void executePerpetual(Map<String, Object> p) {
        String category = (String)p.get("Category");
        if (category.equals("NewPT")) {
            this.addNewPT((Integer)p.get("Power"), (Integer)p.get("Toughness"), (Long)p.get("Timestamp"), 0L);
        } else if (category.equals("PTBoost")) {
            this.addPTBoost((Integer)p.get("Power"), (Integer)p.get("Toughness"), (Long)p.get("Timestamp"), 0L);
        } else if (category.equals("Keywords")) {
            boolean removeAll = p.containsKey("RemoveAll") && (Boolean)p.get("RemoveAll") == true;
            this.addChangedCardKeywords((List)p.get("AddKeywords"), Lists.newArrayList(), removeAll, (Long)p.get("Timestamp"), null);
        } else if (category.equals("Types")) {
            this.addChangedCardTypes((CardType)p.get("AddTypes"), (CardType)p.get("RemoveTypes"), false, (Set<RemoveType>)((Set)p.get("RemoveXTypes")), (long)((Long)p.get("Timestamp")), 0L, true, false);
        } else if (category.equals("Colors")) {
            this.addColor((ColorSet)p.get("Colors"), (Boolean)p.get("Overwrite") == false, (Long)p.get("Timestamp"), 0L, false);
        }
    }

    public final void removePerpetual(long timestamp) {
        Map<Object, Object> toRemove = Maps.newHashMap();
        for (Map<String, Object> p : this.perpetual) {
            if (!p.get("Timestamp").equals(timestamp)) continue;
            toRemove = p;
            break;
        }
        this.perpetual.remove(toRemove);
    }

    public final void setPerpetual(Card oldCard) {
        List<Map<String, Object>> perp = oldCard.getPerpetual();
        this.perpetual = perp;
        for (Map<String, Object> p : perp) {
            if (p.get("Category").equals("Abilities")) {
                long timestamp = (Long)p.get("Timestamp");
                CardTraitChanges ctc = oldCard.getChangedCardTraits().get(timestamp, 0L).copy(this, false);
                this.addChangedCardTraits(ctc, timestamp, 0L);
                continue;
            }
            if (p.get("Category").equals("Incorporate")) {
                long ts = (Long)p.get("Timestamp");
                ManaCost cCMC = oldCard.changedCardManaCost.get(ts, 0L);
                this.addChangedManaCost(cCMC, ts, 0L);
                this.updateManaCostForView();
                if (this.getFirstSpellAbility() == null) continue;
                this.getFirstSpellAbility().getPayCosts().add(new Cost((String)p.get("Incorporate"), false));
                continue;
            }
            this.executePerpetual(p);
        }
    }

    public final int getKickerMagnitude() {
        if (this.getCastSA() != null && this.getCastSA().hasOptionalKeywordAmount(Keyword.MULTIKICKER)) {
            return this.getCastSA().getOptionalKeywordAmount(Keyword.MULTIKICKER);
        }
        boolean hasK1 = this.isOptionalCostPaid(OptionalCost.Kicker1);
        return hasK1 == this.isOptionalCostPaid(OptionalCost.Kicker2) ? (hasK1 ? 2 : 0) : 1;
    }

    public final int getTempPowerBoost() {
        int result = 0;
        for (Pair<Integer, Integer> pair : this.boostPT.values()) {
            if (pair.getLeft() == null) continue;
            result += pair.getLeft().intValue();
        }
        return result;
    }

    public final int getTempToughnessBoost() {
        int result = 0;
        for (Pair<Integer, Integer> pair : this.boostPT.values()) {
            if (pair.getRight() == null) continue;
            result += pair.getRight().intValue();
        }
        return result;
    }

    public void addPTBoost(Integer power, Integer toughness, long timestamp, long staticId) {
        this.boostPT.put(timestamp, staticId, Pair.of(power, toughness));
    }

    public void removePTBoost(long timestamp, long staticId) {
        this.boostPT.remove(timestamp, staticId);
    }

    public Table<Long, Long, Pair<Integer, Integer>> getPTBoostTable() {
        return ImmutableTable.copyOf(this.boostPT);
    }

    public void setPTBoost(Table<Long, Long, Pair<Integer, Integer>> table) {
        this.boostPT.clear();
        this.boostPT.putAll(table);
    }

    public final boolean isUntapped() {
        return !this.tapped;
    }

    public final boolean isTapped() {
        return this.tapped;
    }

    public final void setTapped(boolean tapped0) {
        if (this.tapped == tapped0) {
            return;
        }
        this.tapped = tapped0;
        this.view.updateTapped(this);
    }

    public final boolean canTap() {
        return this.canTap(false);
    }

    public final boolean canTap(boolean attacker) {
        if (this.tapped) {
            return false;
        }
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.IsCombat, attacker);
        return !this.getGame().getReplacementHandler().cantHappenCheck(ReplacementType.Tap, repParams);
    }

    public final boolean tap(boolean tapAnimation, SpellAbility cause, Player tapper) {
        return this.tap(false, tapAnimation, cause, tapper);
    }

    public final boolean tap(boolean attacker, boolean tapAnimation, SpellAbility cause, Player tapper) {
        if (this.tapped) {
            return false;
        }
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.IsCombat, attacker);
        switch (this.getGame().getReplacementHandler().run(ReplacementType.Tap, repParams)) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                break;
            }
            default: {
                return false;
            }
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
        runParams.put(AbilityKey.Attacker, attacker);
        runParams.put(AbilityKey.Cause, cause);
        runParams.put(AbilityKey.Player, tapper);
        this.getGame().getTriggerHandler().runTrigger(TriggerType.Taps, runParams, false);
        this.setTapped(true);
        this.view.updateNeedsTapAnimation(tapAnimation);
        this.getGame().fireEvent(new GameEventCardTapped(this, true));
        return true;
    }

    public final boolean untap(boolean untapAnimation) {
        if (!this.tapped) {
            return false;
        }
        if (this.getGame().getReplacementHandler().run(ReplacementType.Untap, AbilityKey.mapFromAffected(this)) != ReplacementResult.NotReplaced) {
            return false;
        }
        this.getGame().getTriggerHandler().runTrigger(TriggerType.Untaps, AbilityKey.mapFromCard(this), false);
        this.runUntapCommands();
        this.setTapped(false);
        this.view.updateNeedsUntapAnimation(untapAnimation);
        this.getGame().fireEvent(new GameEventCardTapped(this, false));
        return true;
    }

    public final Table<Long, Long, CardTraitChanges> getChangedCardTraitsByText() {
        return this.changedCardTraitsByText;
    }

    public final void setChangedCardTraitsByText(Table<Long, Long, CardTraitChanges> changes) {
        this.changedCardTraitsByText.clear();
        for (Table.Cell<Long, Long, CardTraitChanges> e : changes.cellSet()) {
            this.changedCardTraitsByText.put(e.getRowKey(), e.getColumnKey(), e.getValue().copy(this, true));
        }
    }

    public final void addChangedCardTraitsByText(Collection<SpellAbility> spells, Collection<Trigger> trigger, Collection<ReplacementEffect> replacements, Collection<StaticAbility> statics, long timestamp, long staticId) {
        this.changedCardTraitsByText.put(timestamp, staticId, new CardTraitChanges(spells, null, trigger, replacements, statics, true, false));
        this.updateAbilityTextForView();
    }

    public final SpellAbility getSpellAbilityForStaticAbility(String str, StaticAbility stAb) {
        SpellAbility result = this.storedSpellAbility.get(stAb, str);
        if (!this.canUseCachedTrait(result, stAb)) {
            result = AbilityFactory.getAbility(str, this, (IHasSVars)stAb);
            result.changeTextIntrinsic(stAb.getChangedTextColors(), stAb.getChangedTextTypes());
            result.setIntrinsic(false);
            result.setGrantorStatic(stAb);
            this.storedSpellAbility.put(stAb, str, result);
        }
        return result;
    }

    public final Trigger getTriggerForStaticAbility(String str, StaticAbility stAb) {
        Trigger result = this.storedTrigger.get(stAb, str);
        if (!this.canUseCachedTrait(result, stAb)) {
            result = TriggerHandler.parseTrigger(str, this, false, (IHasSVars)stAb);
            result.changeTextIntrinsic(stAb.getChangedTextColors(), stAb.getChangedTextTypes());
            this.storedTrigger.put(stAb, str, result);
        }
        return result;
    }

    public final Trigger addTriggerForStaticAbility(Trigger trig, StaticAbility stAb) {
        String str = trig.toString() + trig.getId();
        Trigger result = this.storedTrigger.get(stAb, str);
        if (result == null) {
            result = trig.copy(this, false);
            this.storedTrigger.put(stAb, str, result);
        }
        return result;
    }

    public void setStoredReplacements(Table<StaticAbility, String, ReplacementEffect> table) {
        this.storedReplacementEffect.clear();
        for (Table.Cell<StaticAbility, String, ReplacementEffect> c : table.cellSet()) {
            this.storedReplacementEffect.put(c.getRowKey(), c.getColumnKey(), c.getValue().copy(this, true));
        }
    }

    public final Table<StaticAbility, String, ReplacementEffect> getStoredReplacements() {
        return this.storedReplacementEffect;
    }

    public final ReplacementEffect getReplacementEffectForStaticAbility(String str, StaticAbility stAb) {
        ReplacementEffect result = this.storedReplacementEffect.get(stAb, str);
        if (!this.canUseCachedTrait(result, stAb)) {
            result = ReplacementHandler.parseReplacement(str, this, false, (IHasSVars)stAb);
            result.changeTextIntrinsic(stAb.getChangedTextColors(), stAb.getChangedTextTypes());
            this.storedReplacementEffect.put(stAb, str, result);
        }
        return result;
    }

    public final StaticAbility getStaticAbilityForStaticAbility(String str, StaticAbility stAb) {
        StaticAbility result = this.storedStaticAbility.get(stAb, str);
        if (!this.canUseCachedTrait(result, stAb)) {
            result = StaticAbility.create(str, this, stAb.getCardState(), false);
            result.changeTextIntrinsic(stAb.getChangedTextColors(), stAb.getChangedTextTypes());
            this.storedStaticAbility.put(stAb, str, result);
        }
        return result;
    }

    public final SpellAbility getSpellAbilityForStaticAbilityByText(SpellAbility sa, StaticAbility stAb) {
        SpellAbility result = this.storedSpellAbililityByText.get(stAb, sa);
        if (result == null) {
            result = sa.copy(this, false);
            result.setOriginalAbility(sa);
            result.setGrantorStatic(stAb);
            result.setIntrinsic(true);
            this.storedSpellAbililityByText.put(stAb, sa, result);
        }
        return result;
    }

    public final SpellAbility getSpellAbilityForStaticAbilityGainedByText(String str, StaticAbility stAb) {
        SpellAbility result = this.storedSpellAbililityGainedByText.get(stAb, str);
        if (result == null) {
            result = AbilityFactory.getAbility(str, this, (IHasSVars)stAb);
            result.setIntrinsic(true);
            result.setGrantorStatic(stAb);
            this.storedSpellAbililityGainedByText.put(stAb, str, result);
        }
        return result;
    }

    public final Trigger getTriggerForStaticAbilityByText(Trigger tr, StaticAbility stAb) {
        Trigger result = this.storedTriggerByText.get(stAb, tr);
        if (result == null) {
            result = tr.copy(this, false);
            result.setIntrinsic(true);
            this.storedTriggerByText.put(stAb, tr, result);
        }
        return result;
    }

    public final ReplacementEffect getReplacementEffectForStaticAbilityByText(ReplacementEffect re, StaticAbility stAb) {
        ReplacementEffect result = this.storedReplacementEffectByText.get(stAb, re);
        if (result == null) {
            result = re.copy(this, false);
            result.setIntrinsic(true);
            this.storedReplacementEffectByText.put(stAb, re, result);
        }
        return result;
    }

    public final StaticAbility getStaticAbilityForStaticAbilityByText(StaticAbility st, StaticAbility stAb) {
        StaticAbility result = this.storedStaticAbilityByText.get(stAb, st);
        if (result == null) {
            result = st.copy(this, false);
            result.setIntrinsic(true);
            this.storedStaticAbilityByText.put(stAb, st, result);
        }
        return result;
    }

    public final KeywordInterface getKeywordForStaticAbilityByText(KeywordInterface ki, StaticAbility stAb, long idx) {
        Triple<String, Long, Long> triple = Triple.of(ki.getOriginal(), Long.valueOf(stAb.getId()), idx);
        KeywordInterface result = this.storedKeywordByText.get(triple);
        if (result == null) {
            result = ki.copy(this, false);
            result.setStatic(stAb);
            result.setIdx(idx);
            result.setIntrinsic(true);
            this.storedKeywordByText.put(triple, result);
        }
        return result;
    }

    private boolean canUseCachedTrait(CardTraitBase cached, CardTraitBase stAb) {
        if (cached == null) {
            return false;
        }
        return cached.getChangedTextColors().equals(stAb.getChangedTextColors()) && cached.getChangedTextTypes().equals(stAb.getChangedTextTypes());
    }

    public final void addChangedCardTraits(Collection<SpellAbility> spells, Collection<SpellAbility> removedAbilities, Collection<Trigger> trigger, Collection<ReplacementEffect> replacements, Collection<StaticAbility> statics, boolean removeAll, boolean removeNonMana, long timestamp, long staticId) {
        this.changedCardTraits.put(timestamp, staticId, new CardTraitChanges(spells, removedAbilities, trigger, replacements, statics, removeAll, removeNonMana));
        this.updateAbilityTextForView();
    }

    public final void addChangedCardTraits(CardTraitChanges ctc, long timestamp, long staticId) {
        this.changedCardTraits.put(timestamp, staticId, ctc);
        this.updateAbilityTextForView();
    }

    public final boolean removeChangedCardTraits(long timestamp, long staticId) {
        boolean changed = false;
        changed |= this.changedCardTraitsByText.remove(timestamp, staticId) != null;
        return changed |= this.changedCardTraits.remove(timestamp, staticId) != null;
    }

    public Iterable<CardTraitChanges> getChangedCardTraitsList(CardState state) {
        ArrayList<SpellAbility> landManaAbilities = Lists.newArrayList();
        this.updateBasicLandAbilities(landManaAbilities, state);
        return Iterables.concat(this.changedCardTraitsByText.values(), ImmutableList.of(new CardTraitChanges(landManaAbilities, null, null, null, null, this.hasRemoveIntrinsic(), false)), this.changedCardTraits.values());
    }

    public final Table<Long, Long, CardTraitChanges> getChangedCardTraits() {
        return this.changedCardTraits;
    }

    public final void setChangedCardTraits(Table<Long, Long, CardTraitChanges> changes) {
        this.changedCardTraits.clear();
        for (Table.Cell<Long, Long, CardTraitChanges> e : changes.cellSet()) {
            this.changedCardTraits.put(e.getRowKey(), e.getColumnKey(), e.getValue().copy(this, true));
        }
    }

    public boolean clearChangedCardTraits() {
        boolean changed = false;
        if (!this.changedCardTraitsByText.isEmpty()) {
            changed = true;
        }
        this.changedCardTraitsByText.clear();
        if (!this.changedCardTraits.isEmpty()) {
            changed = true;
        }
        this.changedCardTraits.clear();
        return changed;
    }

    public final List<KeywordInterface> getKeywords() {
        return this.getKeywords(this.currentState);
    }

    public final List<KeywordInterface> getKeywords(CardState state) {
        ListKeywordVisitor visitor = new ListKeywordVisitor();
        this.visitKeywords(state, visitor);
        return visitor.getKeywords();
    }

    public final void visitKeywords(CardState state, Visitor<KeywordInterface> visitor) {
        this.visitUnhiddenKeywords(state, visitor);
    }

    @Override
    public final boolean hasKeyword(Keyword keyword) {
        return this.hasKeyword(keyword, this.currentState);
    }

    public final boolean hasKeyword(Keyword key, CardState state) {
        return state.hasKeyword(key);
    }

    @Override
    public final boolean hasKeyword(String keyword) {
        return this.hasKeyword(keyword, this.currentState);
    }

    public final boolean hasKeyword(String keyword, CardState state) {
        if (keyword.startsWith("HIDDEN")) {
            keyword = keyword.substring(7);
        }
        for (List<String> kw : this.hiddenExtrinsicKeywords.values()) {
            if (!kw.contains(keyword)) continue;
            return true;
        }
        HasKeywordVisitor visitor = new HasKeywordVisitor(keyword, false);
        this.visitKeywords(state, visitor);
        return visitor.getResult();
    }

    public final void updateKeywords() {
        this.getCurrentState().getView().updateKeywords(this, this.getCurrentState());
        this.getView().updateLethalDamage(this);
    }

    public final void addChangedCardKeywords(List<String> keywords, List<String> removeKeywords, boolean removeAllKeywords, long timestamp, StaticAbility st) {
        this.addChangedCardKeywords(keywords, removeKeywords, removeAllKeywords, timestamp, st, true);
    }

    public final void addChangedCardKeywords(List<String> keywords, List<String> removeKeywords, boolean removeAllKeywords, long timestamp, StaticAbility st, boolean updateView) {
        ArrayList<KeywordInterface> kws = Lists.newArrayList();
        if (keywords != null) {
            long idx = 1L;
            for (String kw : keywords) {
                boolean canHave = true;
                for (Keyword cantKW : this.getCantHaveKeyword()) {
                    if (!kw.startsWith(cantKW.toString())) continue;
                    canHave = false;
                    break;
                }
                if (canHave) {
                    kws.add(this.getKeywordForStaticAbility(kw, st, idx));
                }
                ++idx;
            }
        }
        KeywordsChange newCks = new KeywordsChange((Iterable<KeywordInterface>)kws, (Collection<String>)removeKeywords, removeAllKeywords);
        this.changedCardKeywords.put(timestamp, st == null ? 0L : (long)st.getId(), newCks);
        if (updateView) {
            this.updateKeywords();
            if (this.isToken()) {
                this.game.fireEvent(new GameEventTokenStateUpdate(this));
            }
        }
    }

    public final KeywordInterface getKeywordForStaticAbility(String kw, StaticAbility st, long idx) {
        KeywordInterface result;
        long staticId = st == null ? 0L : (long)st.getId();
        Triple<String, Long, Long> triple = Triple.of(kw, staticId, idx);
        if (staticId < 1L || !this.storedKeywords.containsKey(triple)) {
            result = Keyword.getInstance(kw);
            result.setStatic(st);
            result.setIdx(idx);
            result.createTraits(this, false);
            if (staticId > 0L) {
                this.storedKeywords.put(triple, result);
            }
        } else {
            result = this.storedKeywords.get(triple);
        }
        return result;
    }

    public final void addKeywordForStaticAbility(KeywordInterface kw) {
        if (kw.getStatic() != null) {
            this.storedKeywords.put(Triple.of(kw.getOriginal(), Long.valueOf(kw.getStatic().getId()), kw.getIdx()), kw);
        }
    }

    public Map<Triple<String, Long, Long>, KeywordInterface> getStoredKeywords() {
        return this.storedKeywords;
    }

    public void setStoredKeywords(Map<Triple<String, Long, Long>, KeywordInterface> map, boolean lki) {
        this.storedKeywords.clear();
        for (Map.Entry<Triple<String, Long, Long>, KeywordInterface> e : map.entrySet()) {
            this.storedKeywords.put(e.getKey(), this.getCopyForStoredKeyword(e, lki));
        }
    }

    private KeywordInterface getCopyForStoredKeyword(Map.Entry<Triple<String, Long, Long>, KeywordInterface> e, boolean lki) {
        if (lki) {
            for (KeywordsChange kc : this.changedCardKeywords.column(e.getKey().getMiddle()).values()) {
                for (KeywordInterface kw : kc.getKeywords()) {
                    if (!kw.getOriginal().equals(e.getValue().getOriginal())) continue;
                    return kw;
                }
            }
        }
        return e.getValue().copy(this, lki);
    }

    public final void addChangedCardKeywordsByText(List<KeywordInterface> keywords, long timestamp, long staticId, boolean updateView) {
        this.changedCardKeywordsByText.put(timestamp, staticId, new KeywordsChange((Collection<KeywordInterface>)keywords, (Collection<KeywordInterface>)ImmutableList.of(), true));
        if (updateView) {
            this.updateKeywords();
        }
    }

    public final void addChangedCardKeywordsInternal(Collection<KeywordInterface> keywords, Collection<KeywordInterface> removeKeywords, boolean removeAllKeywords, long timestamp, StaticAbility st, boolean updateView) {
        KeywordsChange newCks = new KeywordsChange(keywords, removeKeywords, removeAllKeywords);
        long staticId = st == null ? 0L : (long)st.getId();
        this.changedCardKeywords.put(timestamp, staticId, newCks);
        if (updateView) {
            this.updateKeywords();
        }
    }

    public final boolean removeChangedCardKeywords(long timestamp, long staticId) {
        return this.removeChangedCardKeywords(timestamp, staticId, true);
    }

    public final boolean removeChangedCardKeywords(long timestamp, long staticId, boolean updateView) {
        boolean changed = false;
        changed |= this.changedCardKeywords.remove(timestamp, staticId) != null;
        changed |= this.changedCardKeywordsByText.remove(timestamp, staticId) != null;
        if (updateView) {
            this.updateKeywords();
            if (this.isToken()) {
                this.game.fireEvent(new GameEventTokenStateUpdate(this));
            }
        }
        return changed;
    }

    public boolean clearChangedCardKeywords() {
        return this.clearChangedCardKeywords(false);
    }

    public final boolean clearChangedCardKeywords(boolean updateView) {
        boolean changed = false;
        if (!this.changedCardKeywordsByText.isEmpty()) {
            changed = true;
        }
        this.changedCardKeywordsByText.clear();
        if (!this.changedCardKeywords.isEmpty()) {
            changed = true;
        }
        this.changedCardKeywords.clear();
        if (changed && updateView) {
            this.updateKeywords();
        }
        return changed;
    }

    public boolean clearStaticChangedCardKeywords(boolean updateView) {
        boolean changed = this.changedCardKeywords.columnKeySet().retainAll(ImmutableList.of(Long.valueOf(0L)));
        if (changed && updateView) {
            this.updateKeywords();
        }
        return changed;
    }

    public final Collection<KeywordInterface> getUnhiddenKeywords() {
        return this.getUnhiddenKeywords(this.currentState);
    }

    public final Collection<KeywordInterface> getUnhiddenKeywords(CardState state) {
        return state.getCachedKeywords();
    }

    public final void updateKeywordsCache(CardState state) {
        KeywordCollection keywords = new KeywordCollection();
        keywords.insertAll(state.getIntrinsicKeywords());
        keywords.applyChanges(this.getChangedCardKeywordsList());
        for (Keyword k : this.getCantHaveKeyword()) {
            keywords.removeAll(k);
        }
        state.setCachedKeywords(keywords);
    }

    private void visitUnhiddenKeywords(CardState state, Visitor<KeywordInterface> visitor) {
        for (KeywordInterface kw : this.getUnhiddenKeywords(state)) {
            if (visitor.visit(kw)) continue;
            return;
        }
    }

    public List<String> getDraftActions() {
        return this.draftActions;
    }

    public void addDraftAction(String s2) {
        this.draftActions.add(s2);
    }

    public final void addChangedTextColorWord(String originalWord, String newWord, Long timestamp, long staticId) {
        if (MagicColor.fromName(newWord) == 0) {
            throw new RuntimeException("Not a color: " + newWord);
        }
        this.changedTextColors.add(timestamp, staticId, StringUtils.capitalize(originalWord), StringUtils.capitalize(newWord));
        this.updateChangedText();
    }

    public final void removeChangedTextColorWord(Long timestamp, long staticId) {
        if (this.changedTextColors.remove(timestamp, staticId)) {
            this.updateChangedText();
        }
    }

    public final void addChangedTextTypeWord(String originalWord, String newWord, Long timestamp, long staticId) {
        this.changedTextTypes.add(timestamp, staticId, originalWord, newWord);
        this.updateChangedText();
    }

    public final void removeChangedTextTypeWord(Long timestamp, long staticId) {
        if (this.changedTextTypes.remove(timestamp, staticId)) {
            this.updateChangedText();
        }
    }

    public void updateChangedText() {
        ArrayList<String> toAdd = Lists.newArrayList();
        ArrayList<String> toRemove = Lists.newArrayList();
        CardTypeView changedByText = this.getOriginalType().getTypeWithChanges(this.changedCardTypesByText.values());
        for (Map.Entry e : this.changedTextTypes.entrySet()) {
            if (!changedByText.hasStringType((String)e.getKey())) continue;
            toRemove.add((String)e.getKey());
            toAdd.add((String)e.getValue());
        }
        this.changedTypeByText = new CardChangedType(new CardType(toAdd, true), new CardType(toRemove, true), false, EnumSet.noneOf(RemoveType.class));
        this.currentState.updateChangedText();
        for (CardTraitChanges change : this.changedCardTraitsByText.values()) {
            change.changeText();
        }
        KeywordCollection beforeKeywords = new KeywordCollection();
        beforeKeywords.insertAll(this.currentState.getIntrinsicKeywords());
        beforeKeywords.applyChanges(this.changedCardKeywordsByText.values());
        ArrayList<KeywordInterface> addKeywords = Lists.newArrayList();
        ArrayList<KeywordInterface> removeKeywords = Lists.newArrayList();
        for (KeywordInterface kw : beforeKeywords) {
            String oldtxt = kw.getOriginal();
            String newtxt = AbilityUtils.applyKeywordTextChangeEffects(oldtxt, this);
            if (!newtxt.equals(oldtxt)) {
                KeywordInterface newKw = Keyword.getInstance(newtxt);
                addKeywords.add(newKw);
                removeKeywords.add(kw);
                continue;
            }
            if (oldtxt.startsWith("Class")) {
                for (StaticAbility staticAbility : kw.getStaticAbilities()) {
                    staticAbility.changeText();
                }
                continue;
            }
            if (!oldtxt.startsWith("Chapter")) continue;
            for (Trigger trigger : kw.getTriggers()) {
                trigger.changeText();
            }
        }
        this.changedCardKeywordsByWord = new KeywordsChange((Collection<KeywordInterface>)addKeywords, (Collection<KeywordInterface>)removeKeywords, false);
        this.text = AbilityUtils.applyDescriptionTextChangeEffects(this.originalText, this);
        this.getView().updateChangedColorWords(this);
        this.getView().updateChangedTypes(this);
        this.updateManaCostForView();
        this.currentState.getView().updateAbilityText(this, this.currentState);
        this.view.updateNonAbilityText(this);
    }

    public final ImmutableMap<String, String> getChangedTextColorWords() {
        return ImmutableMap.copyOf(this.changedTextColors);
    }

    public final ImmutableMap<String, String> getChangedTextTypeWords() {
        return ImmutableMap.copyOf(this.changedTextTypes);
    }

    public final void copyChangedTextFrom(Card other) {
        this.changedTextColors.copyFrom(other.changedTextColors);
        this.changedTextTypes.copyFrom(other.changedTextTypes);
    }

    public final KeywordInterface addIntrinsicKeyword(String s2) {
        KeywordInterface inst = this.currentState.addIntrinsicKeyword(s2, true);
        if (inst != null) {
            this.updateKeywords();
        }
        return inst;
    }

    public final void addIntrinsicKeywords(Iterable<String> s2) {
        this.addIntrinsicKeywords(s2, true);
    }

    public final void addIntrinsicKeywords(Iterable<String> s2, boolean initTraits) {
        if (this.currentState.addIntrinsicKeywords(s2, initTraits)) {
            this.updateKeywords();
        }
    }

    public final void removeIntrinsicKeyword(String s2) {
        if (this.currentState.removeIntrinsicKeyword(s2)) {
            this.updateKeywords();
        }
    }

    public final void removeIntrinsicKeyword(KeywordInterface s2) {
        if (this.currentState.removeIntrinsicKeyword(s2)) {
            this.updateKeywords();
        }
    }

    public final Iterable<String> getHiddenExtrinsicKeywords() {
        return Iterables.concat(this.hiddenExtrinsicKeywords.values());
    }

    public final Table<Long, Long, List<String>> getHiddenExtrinsicKeywordsTable() {
        return this.hiddenExtrinsicKeywords;
    }

    public final void addHiddenExtrinsicKeywords(long timestamp, long staticId, Iterable<String> keywords) {
        this.hiddenExtrinsicKeywords.put(timestamp, staticId, Lists.newArrayList(keywords));
        this.view.updateNonAbilityText(this);
        this.updateKeywords();
    }

    public final void removeHiddenExtrinsicKeywords(long timestamp, long staticId) {
        if (this.hiddenExtrinsicKeywords.remove(timestamp, staticId) != null) {
            this.view.updateNonAbilityText(this);
            this.updateKeywords();
        }
    }

    public final void removeHiddenExtrinsicKeyword(String s2) {
        boolean updated = false;
        for (List<String> list : this.hiddenExtrinsicKeywords.values()) {
            if (!list.remove(s2)) continue;
            updated = true;
        }
        if (updated) {
            this.view.updateNonAbilityText(this);
            this.updateKeywords();
        }
    }

    public void addCantHaveKeyword(Keyword keyword, Long timestamp) {
        this.cantHaveKeywords.put(timestamp, keyword);
        this.getView().updateCantHaveKeyword(this);
    }

    public void addCantHaveKeyword(Long timestamp, Iterable<Keyword> keywords) {
        this.cantHaveKeywords.putAll(timestamp, keywords);
        this.getView().updateCantHaveKeyword(this);
    }

    public boolean removeCantHaveKeyword(Long timestamp) {
        return this.removeCantHaveKeyword(timestamp, true);
    }

    public boolean removeCantHaveKeyword(Long timestamp, boolean updateView) {
        boolean change;
        boolean bl = change = !this.cantHaveKeywords.removeAll(timestamp).isEmpty();
        if (change && updateView) {
            this.getView().updateCantHaveKeyword(this);
            this.updateKeywords();
            if (this.isToken()) {
                this.game.fireEvent(new GameEventTokenStateUpdate(this));
            }
        }
        return change;
    }

    public Collection<Keyword> getCantHaveKeyword() {
        return this.cantHaveKeywords.values();
    }

    public final void setStaticAbilities(List<StaticAbility> a) {
        this.currentState.setStaticAbilities(a);
    }

    public final FCollectionView<StaticAbility> getStaticAbilities() {
        return this.currentState.getStaticAbilities();
    }

    public final StaticAbility addStaticAbility(String s2) {
        if (!s2.trim().isEmpty()) {
            StaticAbility stAb = StaticAbility.create(s2, this, this.currentState, true);
            this.currentState.addStaticAbility(stAb);
            return stAb;
        }
        return null;
    }

    public final StaticAbility addStaticAbility(StaticAbility stAb) {
        this.currentState.addStaticAbility(stAb);
        return stAb;
    }

    @Deprecated
    public final void removeStaticAbility(StaticAbility stAb) {
        this.currentState.removeStaticAbility(stAb);
    }

    public void updateStaticAbilities(List<StaticAbility> list, CardState state) {
        for (CardTraitChanges ck : this.getChangedCardTraitsList(state)) {
            if (ck.isRemoveAll()) {
                list.clear();
            }
            list.addAll(ck.getStaticAbilities());
        }
        for (KeywordInterface kw : this.getUnhiddenKeywords(state)) {
            list.addAll(kw.getStaticAbilities());
        }
    }

    public final boolean isPermanent() {
        return !this.isImmutable() && (this.isInPlay() || this.getType().isPermanent());
    }

    public final boolean isSpell() {
        return this.isInstant() || this.isSorcery() || this.isAura() && !this.isInZone(ZoneType.Battlefield);
    }

    public final boolean hasPlayableLandFace() {
        return this.isLand() || this.isModal() && this.getState(CardStateName.Modal).getType().isLand();
    }

    public final boolean isLand() {
        return this.getType().isLand();
    }

    public final boolean isBasicLand() {
        return this.getType().isBasicLand();
    }

    public final boolean isSnow() {
        return this.getType().isSnow();
    }

    public final boolean isKindred() {
        return this.getType().isKindred();
    }

    public final boolean isSorcery() {
        return this.getType().isSorcery();
    }

    public final boolean isInstant() {
        return this.getType().isInstant();
    }

    public final boolean isCreature() {
        return this.getType().isCreature();
    }

    public final boolean isArtifact() {
        return this.getType().isArtifact();
    }

    public final boolean isPlaneswalker() {
        return this.getType().isPlaneswalker();
    }

    public final boolean isBattle() {
        return this.getType().isBattle();
    }

    public final boolean isEnchantment() {
        return this.getType().isEnchantment();
    }

    public final boolean isEquipment() {
        return this.getType().isEquipment();
    }

    public final boolean isFortification() {
        return this.getType().isFortification();
    }

    public final boolean isAttraction() {
        return this.getType().isAttraction();
    }

    public final boolean isCurse() {
        return this.getType().hasSubtype("Curse");
    }

    public final boolean isAura() {
        return this.getType().isAura();
    }

    public final boolean isShrine() {
        return this.getType().hasSubtype("Shrine");
    }

    public final boolean isSaga() {
        return this.getType().isSaga();
    }

    public final boolean isAttachment() {
        return this.getType().isAttachment();
    }

    public final boolean isHistoric() {
        return this.getType().isHistoric();
    }

    public final boolean isScheme() {
        return this.getType().isScheme();
    }

    public final boolean isPhenomenon() {
        return this.getType().isPhenomenon();
    }

    public final boolean isPlane() {
        return this.getType().isPlane();
    }

    public final boolean isOutlaw() {
        return this.getType().isOutlaw();
    }

    public final boolean isRoom() {
        return this.getType().hasSubtype("Room");
    }

    @Override
    public final int compareTo(Card that) {
        if (that == null) {
            return 1;
        }
        return Integer.compare(this.id, that.id);
    }

    @Override
    public final String toString() {
        if (this.getView() == null) {
            return this.getPaperCard().getName();
        }
        return this.getView().toString();
    }

    public final boolean isUnearthed() {
        return this.unearthed;
    }

    public final void setUnearthed(boolean b) {
        this.unearthed = b;
    }

    public final boolean hasSuspend() {
        return this.hasKeyword(Keyword.SUSPEND) && this.getLastKnownZone().is(ZoneType.Exile) && this.getCounters(CounterEnumType.TIME) >= 1;
    }

    public final boolean isPhasedOut() {
        return this.phasedOut != null;
    }

    public final boolean isPhasedOut(Player turn) {
        return turn.equals(this.phasedOut);
    }

    public final Player getPhasedOut() {
        return this.phasedOut;
    }

    public final void setPhasedOut(Player phasedOut0) {
        if (this.phasedOut == phasedOut0) {
            return;
        }
        this.phasedOut = phasedOut0;
        this.view.updatePhasedOut(this);
    }

    public final void phase(boolean fromUntapStep) {
        this.phase(fromUntapStep, true);
    }

    public final void phase(boolean fromUntapStep, boolean direct) {
        GameEntity ge;
        boolean phasingIn = this.isPhasedOut();
        if (!this.switchPhaseState(fromUntapStep)) {
            return;
        }
        if (!phasingIn) {
            this.setDirectlyPhasedOut(direct);
        }
        if (!this.getAllAttachedCards().isEmpty()) {
            for (Card eq : this.getAllAttachedCards()) {
                if (!eq.isPhasedOut() && StaticAbilityCantPhase.cantPhaseOut(eq) || eq.isPhasedOut() != phasingIn) continue;
                eq.phase(fromUntapStep, false);
            }
        }
        if ((ge = this.getEntityAttachedTo()) != null) {
            ge.updateAttachedCards();
        }
        this.getGame().fireEvent(new GameEventCardPhased(this, this.isPhasedOut()));
    }

    private boolean switchPhaseState(boolean fromUntapStep) {
        if (this.isPhasedOut() && fromUntapStep && this.wontPhaseInNormal) {
            return false;
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
        if (!this.isPhasedOut()) {
            this.getGame().getTriggerHandler().runTrigger(TriggerType.PhaseOut, runParams, true);
            this.runPhaseOutCommands();
            this.clearEncodedCards();
            if (this.isPaired()) {
                this.getPairedWith().setPairedWith(null);
                this.setPairedWith(null);
            }
        }
        this.setPhasedOut(this.isPhasedOut() ? null : this.getController());
        Combat combat = this.getGame().getCombat();
        if (combat != null && this.isPhasedOut()) {
            combat.saveLKI(this);
            combat.removeFromCombat(this);
        }
        if (!this.isPhasedOut()) {
            if (this.isAttachedToEntity()) {
                GameEntity ge = this.getEntityAttachedTo();
                boolean unattach = false;
                if (ge instanceof Player) {
                    unattach = !((Player)ge).isInGame();
                } else {
                    boolean bl = unattach = !((Card)ge).isInPlay();
                }
                if (unattach) {
                    this.unattachFromEntity(ge);
                }
            }
            this.getGame().getTriggerHandler().registerActiveTrigger(this, false);
            this.getGame().getTriggerHandler().runTrigger(TriggerType.PhaseIn, runParams, true);
        }
        this.game.updateLastStateForCard(this);
        return true;
    }

    public final boolean isDirectlyPhasedOut() {
        return this.directlyPhasedOut;
    }

    public final void setDirectlyPhasedOut(boolean direct) {
        this.directlyPhasedOut = direct;
    }

    public final boolean isWontPhaseInNormal() {
        return this.wontPhaseInNormal;
    }

    public final void setWontPhaseInNormal(boolean phaseFlag) {
        this.wontPhaseInNormal = phaseFlag;
    }

    public final boolean isReflectedLand() {
        for (SpellAbility a : this.currentState.getManaAbilities()) {
            if (a.getApi() != ApiType.ManaReflected) continue;
            return true;
        }
        return false;
    }

    public final boolean hasStartOfKeyword(String keyword) {
        return this.hasStartOfKeyword(keyword, this.currentState);
    }

    public final boolean hasStartOfKeyword(String keyword, CardState state) {
        for (String s2 : this.getHiddenExtrinsicKeywords()) {
            if (!s2.startsWith(keyword)) continue;
            return true;
        }
        HasKeywordVisitor visitor = new HasKeywordVisitor(keyword, true);
        this.visitKeywords(state, visitor);
        return visitor.getResult();
    }

    public final boolean hasStartOfUnHiddenKeyword(String keyword) {
        return this.hasStartOfUnHiddenKeyword(keyword, this.currentState);
    }

    public final boolean hasStartOfUnHiddenKeyword(String keyword, CardState state) {
        HasKeywordVisitor visitor = new HasKeywordVisitor(keyword, true);
        this.visitUnhiddenKeywords(state, visitor);
        return visitor.getResult();
    }

    public final boolean hasAnyKeyword(Iterable<String> keywords) {
        return this.hasAnyKeyword(keywords, this.currentState);
    }

    public final boolean hasAnyKeyword(Iterable<String> keywords, CardState state) {
        for (String keyword : keywords) {
            if (!this.hasKeyword(keyword, state)) continue;
            return true;
        }
        return false;
    }

    public final int getAmountOfKeyword(String k) {
        return this.getAmountOfKeyword(k, this.currentState);
    }

    public final int getAmountOfKeyword(String k, CardState state) {
        int count = Iterables.frequency(this.getHiddenExtrinsicKeywords(), k);
        CountKeywordVisitor visitor = new CountKeywordVisitor(k);
        this.visitKeywords(state, visitor);
        return count + visitor.getCount();
    }

    public final int getAmountOfKeyword(Keyword k) {
        return this.getAmountOfKeyword(k, this.currentState);
    }

    public final int getAmountOfKeyword(Keyword k, CardState state) {
        return this.getKeywords(k, state).size();
    }

    public final Collection<KeywordInterface> getKeywords(Keyword k) {
        return this.getKeywords(k, this.currentState);
    }

    public final Collection<KeywordInterface> getKeywords(Keyword k, CardState state) {
        return state.getCachedKeyword(k);
    }

    public final int getKeywordMagnitude(Keyword k) {
        return this.getKeywordMagnitude(k, this.currentState);
    }

    public final int getKeywordMagnitude(Keyword k, CardState state) {
        int count = 0;
        for (KeywordInterface inst : this.getKeywords(k, state)) {
            String[] parse;
            String kw = inst.getOriginal();
            String[] stringArray = parse = kw.contains(":") ? kw.split(":") : kw.split(" ");
            if (parse.length < 2) {
                ++count;
                continue;
            }
            String s2 = parse[1];
            if (StringUtils.isNumeric(s2)) {
                count += Integer.parseInt(s2);
                continue;
            }
            StaticAbility st = inst.getStatic();
            if (st != null && st.hasSVar(s2)) {
                count += AbilityUtils.calculateAmount(this, st.getSVar(s2), null);
                continue;
            }
            String svar = StringUtils.join(parse);
            if (!state.hasSVar(svar)) continue;
            count += AbilityUtils.calculateAmount(this, state.getSVar(svar), null);
        }
        return count;
    }

    @Override
    public final boolean isValid(String restriction, Player sourceController, Card source, CardTraitBase spellAbility) {
        String[] incR = restriction.split("\\.", 2);
        boolean testFailed = false;
        if (incR[0].startsWith("!")) {
            testFailed = true;
            incR[0] = incR[0].substring(1);
        }
        if (incR[0].equals("Spell")) {
            if (!this.isSpell()) {
                return testFailed;
            }
        } else if (incR[0].equals("Permanent")) {
            if (!this.isPermanent()) {
                return testFailed;
            }
        } else if (incR[0].equals("Effect")) {
            if (!this.isImmutable()) {
                return testFailed;
            }
        } else if (incR[0].equals("Emblem")) {
            if (!this.isEmblem()) {
                return testFailed;
            }
        } else if (incR[0].equals("Boon")) {
            if (!this.isBoon()) {
                return testFailed;
            }
        } else if (incR[0].equals("card") || incR[0].equals("Card")) {
            if (this.isImmutable()) {
                return testFailed;
            }
        } else if (incR[0].equals("Any")) {
            if (!(this.isCreature() || this.isPlaneswalker() || this.isBattle())) {
                return false;
            }
        } else if (!this.getType().hasStringType(incR[0])) {
            return testFailed;
        }
        if (incR.length > 1) {
            String[] exRs;
            String excR = incR[1];
            for (String exR : exRs = excR.split("\\+")) {
                if (this.hasProperty(exR, sourceController, source, spellAbility)) continue;
                return testFailed;
            }
        }
        return !testFailed;
    }

    @Override
    public boolean hasProperty(String property, Player sourceController, Card source, CardTraitBase spellAbility) {
        if (property.startsWith("!")) {
            return !CardProperty.cardHasProperty(this, property.substring(1), sourceController, source, spellAbility);
        }
        return CardProperty.cardHasProperty(this, property, sourceController, source, spellAbility);
    }

    public final boolean isEmblem() {
        return this.isEmblem;
    }

    public final void setEmblem(boolean isEmblem0) {
        this.isEmblem = isEmblem0;
        this.view.updateEmblem(this);
    }

    public final boolean isBoon() {
        return this.isBoon;
    }

    public final void setBoon(boolean isBoon0) {
        this.isBoon = isBoon0;
        this.view.updateBoon(this);
    }

    public final boolean isOfColor(String col) {
        return this.getColor().hasAnyColor(MagicColor.fromName(col));
    }

    public final boolean isBlack() {
        return this.getColor().hasBlack();
    }

    public final boolean isBlue() {
        return this.getColor().hasBlue();
    }

    public final boolean isRed() {
        return this.getColor().hasRed();
    }

    public final boolean isGreen() {
        return this.getColor().hasGreen();
    }

    public final boolean isWhite() {
        return this.getColor().hasWhite();
    }

    public final boolean isColorless() {
        return this.getColor().isColorless();
    }

    public final boolean associatedWithColor(String col) {
        HashSet<String> color = new HashSet<String>();
        if (col != null) {
            color.add(col);
        }
        return this.isOfColor(col) || this.canProduceColorMana(color);
    }

    public final boolean hasNoName() {
        return !this.hasNonLegendaryCreatureNames() && this.getName().isEmpty();
    }

    public final boolean sharesNameWith(Card c1) {
        if (c1 == null) {
            return false;
        }
        if (c1.hasNonLegendaryCreatureNames()) {
            if (this.hasNonLegendaryCreatureNames()) {
                return true;
            }
            if (this.getName().isEmpty()) {
                return false;
            }
            if (StaticData.instance().getCommonCards().isNonLegendaryCreatureName(this.getName())) {
                return true;
            }
        }
        return this.sharesNameWith(c1.getName(true));
    }

    public final boolean sharesNameWith(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        boolean shares = this.getName(true).equals(name);
        if (!shares && !this.hasNameOverwrite()) {
            if (this.isInPlay()) {
                for (String door : this.getUnlockedRoomNames()) {
                    shares |= name.equals(door);
                }
            } else {
                if (this.hasState(CardStateName.LeftSplit)) {
                    shares |= name.equals(this.getState(CardStateName.LeftSplit).getName());
                }
                if (this.hasState(CardStateName.RightSplit)) {
                    shares |= name.equals(this.getState(CardStateName.RightSplit).getName());
                }
            }
        }
        if (!shares && this.hasNonLegendaryCreatureNames()) {
            return StaticData.instance().getCommonCards().isNonLegendaryCreatureName(name);
        }
        return shares;
    }

    public final boolean sharesColorWith(Card c1) {
        if (this.isColorless() || c1.isColorless()) {
            return false;
        }
        boolean shares = this.isBlack() && c1.isBlack();
        shares |= this.isBlue() && c1.isBlue();
        shares |= this.isGreen() && c1.isGreen();
        shares |= this.isRed() && c1.isRed();
        return shares |= this.isWhite() && c1.isWhite();
    }

    public final boolean sharesCMCWith(int n) {
        Card host = this.game.getCardState(this);
        return host.getCMC() == n;
    }

    public final boolean sharesCMCWith(Card c1) {
        Card host = this.game.getCardState(this);
        Card other = this.game.getCardState(c1);
        return host.getCMC() == other.getCMC();
    }

    public final boolean sharesCreatureTypeWith(Card c1) {
        if (c1 == null) {
            return false;
        }
        return this.getType().sharesCreaturetypeWith(c1.getType());
    }

    public final boolean sharesLandTypeWith(Card c1) {
        if (c1 == null) {
            return false;
        }
        return this.getType().sharesLandTypeWith(c1.getType());
    }

    public final boolean sharesPermanentTypeWith(Card c1) {
        if (c1 == null) {
            return false;
        }
        return this.getType().sharesPermanentTypeWith(c1.getType());
    }

    public final boolean sharesCardTypeWith(Card c1) {
        if (c1 == null) {
            return false;
        }
        return this.getType().sharesCardTypeWith(c1.getType());
    }

    public final boolean sharesAllCardTypesWith(Card c1) {
        if (c1 == null) {
            return false;
        }
        return this.getType().sharesAllCardTypesWith(c1.getType());
    }

    public final boolean sharesControllerWith(Card c1) {
        return c1 != null && this.getController().equals(c1.getController());
    }

    public final boolean hasABasicLandType() {
        return this.getType().hasABasicLandType();
    }

    public final boolean hasANonBasicLandType() {
        return this.getType().hasANonBasicLandType();
    }

    public final boolean isUsedToPay() {
        return this.usedToPayCost;
    }

    public final void setUsedToPay(boolean b) {
        this.usedToPayCost = b;
    }

    public CardDamageHistory getDamageHistory() {
        return this.damageHistory;
    }

    public void setDamageHistory(CardDamageHistory history) {
        this.damageHistory = history;
    }

    public final boolean hasDealtDamageToOpponentThisTurn() {
        return this.getDamageHistory().getDamageDoneThisTurn(null, true, null, "Player.Opponent", this, this.getController(), null) > 0;
    }

    public final int getTotalDamageDoneBy() {
        return this.getDamageHistory().getDamageDoneThisTurn(null, false, null, null, this, this.getController(), null);
    }

    public final int getLethal() {
        if (this.hasKeyword("Lethal damage dealt to CARDNAME is determined by its power rather than its toughness.")) {
            return this.getNetPower();
        }
        return this.getNetToughness();
    }

    public final int getLethalDamage() {
        for (Card c : this.getAssignedDamageMap().keySet()) {
            if (!c.hasKeyword(Keyword.DEATHTOUCH)) continue;
            return 0;
        }
        return this.getLethal() - this.getDamage() - this.getTotalAssignedDamage();
    }

    public final int getExcessDamageValue(boolean withDeathtouch) {
        ArrayList<Integer> excessCharacteristics = new ArrayList<Integer>();
        if (this.isCreature()) {
            int lethal = this.getLethalDamage();
            if (withDeathtouch && lethal > 0) {
                excessCharacteristics.add(1);
            } else {
                excessCharacteristics.add(Math.max(0, lethal));
            }
        }
        if (this.isPlaneswalker()) {
            excessCharacteristics.add(this.getCurrentLoyalty());
        }
        if (this.isBattle()) {
            excessCharacteristics.add(this.getCurrentDefense());
        }
        if (excessCharacteristics.isEmpty()) {
            return 0;
        }
        return (Integer)Collections.min(excessCharacteristics);
    }

    public final int getDamage() {
        int sum = 0;
        for (int i : this.damage.values()) {
            sum += i;
        }
        return sum;
    }

    public final void setDamage(int damage0) {
        if (this.getDamage() == damage0) {
            return;
        }
        this.damage.clear();
        if (damage0 != 0) {
            this.damage.put(0, damage0);
        }
        this.view.updateDamage(this);
        this.getGame().fireEvent(new GameEventCardStatsChanged(this));
    }

    public int getMaxDamageFromSource() {
        return this.damage.isEmpty() ? 0 : Collections.max(this.damage.values());
    }

    public final boolean hasBeenDealtDeathtouchDamage() {
        return this.hasBeenDealtDeathtouchDamage;
    }

    public final void setHasBeenDealtDeathtouchDamage(boolean hasBeenDealtDeatchtouchDamage) {
        this.hasBeenDealtDeathtouchDamage = hasBeenDealtDeatchtouchDamage;
    }

    public final boolean hasBeenDealtExcessDamageThisTurn() {
        return this.hasBeenDealtExcessDamageThisTurn;
    }

    public final void setHasBeenDealtExcessDamageThisTurn(boolean bool) {
        this.hasBeenDealtExcessDamageThisTurn = bool;
    }

    public final void logExcessDamage(int n) {
        this.excessDamageThisTurnAmount += n;
    }

    public final int getExcessDamageThisTurn() {
        return this.excessDamageThisTurnAmount;
    }

    public final void setExcessDamageReceivedThisTurn(int n) {
        this.excessDamageThisTurnAmount = n;
    }

    private void resetExcessDamage() {
        this.hasBeenDealtExcessDamageThisTurn = false;
        this.excessDamageThisTurnAmount = 0;
    }

    public final Map<Card, Integer> getAssignedDamageMap() {
        return this.assignedDamageMap;
    }

    public final void addAssignedDamage(int assignedDamage0, Card sourceCard) {
        if (assignedDamage0 <= 0) {
            return;
        }
        Log.debug(this + " - was assigned " + assignedDamage0 + " damage, by " + sourceCard);
        if (!this.assignedDamageMap.containsKey(sourceCard)) {
            this.assignedDamageMap.put(sourceCard, assignedDamage0);
        } else {
            this.assignedDamageMap.put(sourceCard, this.assignedDamageMap.get(sourceCard) + assignedDamage0);
        }
        this.view.updateAssignedDamage(this);
    }

    public final void clearAssignedDamage() {
        if (this.assignedDamageMap.isEmpty()) {
            return;
        }
        this.assignedDamageMap.clear();
        this.view.updateAssignedDamage(this);
    }

    public final int getTotalAssignedDamage() {
        int total = 0;
        for (Integer assignedDamage : this.assignedDamageMap.values()) {
            total += assignedDamage.intValue();
        }
        return total;
    }

    public final boolean canDamagePrevented(boolean isCombat) {
        return !StaticAbilityCantPreventDamage.cantPreventDamage(this, isCombat);
    }

    @Override
    public final int staticReplaceDamage(int damage, Card source, boolean isCombat) {
        int restDamage = damage;
        for (Card c : this.getGame().getCardsIn(ZoneType.Battlefield)) {
            if (c.getName().equals("Sulfuric Vapors")) {
                if (!source.isSpell() || !source.isRed()) continue;
                ++restDamage;
                continue;
            }
            if (c.getName().equals("Pyromancer's Swath")) {
                if (!c.getController().equals(source.getController()) || !source.isInstant() && !source.isSorcery() || !this.isCreature()) continue;
                restDamage += 2;
                continue;
            }
            if (c.getName().equals("Furnace of Rath")) {
                if (!this.isCreature()) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Dictate of the Twin Gods")) {
                restDamage += restDamage;
                continue;
            }
            if (c.getName().equals("Gratuitous Violence")) {
                if (!c.getController().equals(source.getController()) || !source.isCreature() || !this.isCreature()) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Fire Servant")) {
                if (!c.getController().equals(source.getController()) || !source.isRed() || !source.isInstant() && !source.isSorcery()) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Gisela, Blade of Goldnight")) {
                if (c.getController().equals(this.getController())) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Inquisitor's Flail")) {
                if (!isCombat || c.getEquipping() == null || !c.getEquipping().equals(this) && !c.getEquipping().equals(source)) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Ghosts of the Innocent")) {
                if (!this.isCreature()) continue;
                restDamage /= 2;
                continue;
            }
            if (c.getName().equals("Benevolent Unicorn")) {
                if (!source.isSpell() || !this.isCreature()) continue;
                --restDamage;
                continue;
            }
            if (c.getName().equals("Divine Presence")) {
                if (restDamage <= 3 || !this.isCreature()) continue;
                restDamage = 3;
                continue;
            }
            if (!c.getName().equals("Lashknife Barrier") || !c.getController().equals(this.getController()) || !this.isCreature()) continue;
            --restDamage;
        }
        for (Card c : this.getGame().getCardsIn(ZoneType.Command)) {
            if (c.getName().equals("Insult Effect")) {
                if (!c.getController().equals(source.getController())) continue;
                restDamage *= 2;
                continue;
            }
            if (!c.getName().equals("Mishra") || !c.isCreature() || !c.getController().equals(source.getController())) continue;
            restDamage *= 2;
        }
        if (this.getName().equals("Phytohydra")) {
            return 0;
        }
        return restDamage;
    }

    @Override
    public final int addDamageAfterPrevention(int damageIn, Card source, SpellAbility cause, boolean isCombat, GameEntityCounterTable counterTable) {
        if (damageIn <= 0) {
            return 0;
        }
        if (!(this.isPlaneswalker() || this.isCreature() || this.isBattle())) {
            return 0;
        }
        if (!this.isInPlay()) {
            return 0;
        }
        this.getGame().getReplacementHandler().run(ReplacementType.DealtDamage, AbilityKey.mapFromAffected(this));
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.DamageSource, source);
        runParams.put(AbilityKey.DamageTarget, this);
        runParams.put(AbilityKey.Cause, cause);
        runParams.put(AbilityKey.DamageAmount, Integer.valueOf(damageIn));
        runParams.put(AbilityKey.IsCombatDamage, Boolean.valueOf(isCombat));
        runParams.put(AbilityKey.DefendingPlayer, this.game.getCombat() != null ? this.game.getCombat().getDefendingPlayerRelatedTo(source) : null);
        this.getGame().getTriggerHandler().runTrigger(TriggerType.DamageDone, runParams, true);
        GameEventCardDamaged.DamageType damageType = GameEventCardDamaged.DamageType.Normal;
        if (this.isPlaneswalker()) {
            this.subtractCounter(CounterType.get(CounterEnumType.LOYALTY), damageIn, null, true);
        }
        if (this.isBattle()) {
            this.subtractCounter(CounterType.get(CounterEnumType.DEFENSE), damageIn, null, true);
        }
        if (this.isCreature()) {
            if (source.isWitherDamage()) {
                this.addCounter(CounterEnumType.M1M1, damageIn, source.getController(), counterTable);
                damageType = GameEventCardDamaged.DamageType.M1M1Counters;
            } else {
                int old = this.damage.getOrDefault(Objects.hash(source.getId(), source.getGameTimestamp()), 0);
                this.damage.put(Objects.hash(source.getId(), source.getGameTimestamp()), old + damageIn);
                this.view.updateDamage(this);
            }
            if (source.hasKeyword(Keyword.DEATHTOUCH)) {
                this.setHasBeenDealtDeathtouchDamage(true);
                damageType = GameEventCardDamaged.DamageType.Deathtouch;
            }
            this.game.fireEvent(new GameEventCardDamaged(this, source, damageIn, damageType));
        }
        return damageIn;
    }

    public final String getSetCode() {
        return this.currentState.getSetCode();
    }

    public final void setSetCode(String setCode) {
        this.currentState.setSetCode(setCode);
    }

    public final CardRarity getRarity() {
        return this.currentState.getRarity();
    }

    public final void setRarity(CardRarity r) {
        this.currentState.setRarity(r);
    }

    public final String getMostRecentSet() {
        return StaticData.instance().getCommonCards().getCard(this.getPaperCard().getName()).getEdition();
    }

    public final String getImageKey() {
        Card uiCard = this.getCardForUi();
        if (uiCard == null) {
            return "";
        }
        return uiCard.currentState.getImageKey();
    }

    public final void setImageKey(String iFN) {
        Card uiCard = this.getCardForUi();
        if (uiCard == null) {
            this.currentState.setImageKey(iFN);
        } else {
            uiCard.currentState.setImageKey(iFN);
        }
    }

    public final void setImageKey(IPaperCard ipc, CardStateName stateName) {
        if (ipc == null) {
            return;
        }
        switch (stateName) {
            case SpecializeB: {
                this.setImageKey(ipc.getCardBSpecImageKey());
                break;
            }
            case SpecializeR: {
                this.setImageKey(ipc.getCardRSpecImageKey());
                break;
            }
            case SpecializeG: {
                this.setImageKey(ipc.getCardGSpecImageKey());
                break;
            }
            case SpecializeU: {
                this.setImageKey(ipc.getCardUSpecImageKey());
                break;
            }
            case SpecializeW: {
                this.setImageKey(ipc.getCardWSpecImageKey());
                break;
            }
        }
    }

    public String getImageKey(CardStateName state) {
        Card uiCard = this.getCardForUi();
        if (uiCard == null) {
            return "";
        }
        CardState c = uiCard.states.get((Object)state);
        return c != null ? c.getImageKey() : "";
    }

    public final boolean isTributed() {
        return this.tributed;
    }

    public final void setTributed(boolean b) {
        this.tributed = b;
    }

    public final SpellAbility getTokenSpawningAbility() {
        return this.tokenSpawningAbility;
    }

    public void setTokenSpawningAbility(SpellAbility sa) {
        this.tokenSpawningAbility = sa;
    }

    public final boolean isEmbalmed() {
        SpellAbility sa = this.getTokenSpawningAbility();
        return sa != null && sa.isEmbalm();
    }

    public final boolean isEternalized() {
        SpellAbility sa = this.getTokenSpawningAbility();
        return sa != null && sa.isEternalize();
    }

    public final int getExertedThisTurn() {
        return this.exertThisTurn;
    }

    public void exert() {
        this.exert(this.getController());
    }

    public void exert(Player p) {
        this.exertedByPlayer.add(p);
        ++this.exertThisTurn;
        this.view.updateExertedThisTurn(this, true);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
        runParams.put(AbilityKey.Player, p);
        this.game.getTriggerHandler().runTrigger(TriggerType.Exerted, runParams, false);
    }

    public boolean isExertedBy(Player player) {
        return this.exertedByPlayer.contains(player);
    }

    public void removeExertedBy(Player player) {
        this.exertedByPlayer.remove(player);
        this.view.updateExertedThisTurn(this, this.getExertedThisTurn() > 0);
    }

    protected void resetExertedThisTurn() {
        this.exertThisTurn = 0;
        this.view.updateExertedThisTurn(this, false);
    }

    public boolean isMadness() {
        if (this.getCastSA() == null) {
            return false;
        }
        return this.getCastSA().isMadness();
    }

    public boolean wasDiscarded() {
        return this.discarded;
    }

    public void setDiscarded(boolean state) {
        this.discarded = state;
    }

    public boolean wasSurveilled() {
        return this.surveilled;
    }

    public void setSurveilled(boolean value) {
        this.surveilled = value;
    }

    public boolean wasMilled() {
        return this.milled;
    }

    public void setMilled(boolean value) {
        this.milled = value;
    }

    public final boolean isRingBearer() {
        return this.ringbearer;
    }

    public final void setRingBearer(boolean ringbearer0) {
        this.ringbearer = ringbearer0;
        this.view.updateRingBearer(this);
    }

    public final void clearRingBearer() {
        this.setRingBearer(false);
    }

    public final boolean isMonstrous() {
        return this.monstrous;
    }

    public final void setMonstrous(boolean monstrous0) {
        this.monstrous = monstrous0;
    }

    public final boolean isRenowned() {
        return this.renowned;
    }

    public final void setRenowned(boolean renowned0) {
        this.renowned = renowned0;
    }

    public final boolean isSolved() {
        return this.solved;
    }

    public final boolean setSolved(boolean solved) {
        this.solved = solved;
        return true;
    }

    public final int getTimesSaddledThisTurn() {
        return this.timesSaddledThisTurn;
    }

    public final CardCollection getSaddledByThisTurn() {
        return this.saddledByThisTurn;
    }

    public final void addSaddledByThisTurn(CardCollection saddlers) {
        if (this.saddledByThisTurn != null) {
            this.saddledByThisTurn.addAll(saddlers);
        } else {
            this.saddledByThisTurn = saddlers;
        }
    }

    public final void setSaddledByThisTurn(CardCollection saddlers) {
        this.saddledByThisTurn = saddlers;
    }

    public void resetSaddled() {
        boolean changed = this.isSaddled();
        this.setSaddled(false);
        if (this.saddledByThisTurn != null) {
            this.saddledByThisTurn = null;
        }
        this.timesSaddledThisTurn = 0;
        if (changed) {
            this.updateAbilityTextForView();
        }
    }

    public final boolean isSaddled() {
        return this.saddled;
    }

    public final boolean setSaddled(boolean saddled) {
        this.saddled = saddled;
        if (saddled) {
            ++this.timesSaddledThisTurn;
        }
        return true;
    }

    public Long getSuspectedTimestamp() {
        return this.suspectedTimestamp;
    }

    public void setSuspectedTimestamp(Long timestamp) {
        this.suspectedTimestamp = timestamp;
    }

    public final boolean isSuspected() {
        return this.suspectedTimestamp != null;
    }

    public final boolean setSuspected(boolean suspected) {
        if (suspected && StaticAbilityCantBeSuspected.cantBeSuspected(this)) {
            return false;
        }
        if (suspected) {
            if (this.suspectedTimestamp != null) {
                return true;
            }
            this.suspectedTimestamp = this.getGame().getNextTimestamp();
            this.addChangedCardKeywords(ImmutableList.of("Menace"), ImmutableList.of(), false, this.suspectedTimestamp, null, true);
            if (this.suspectedStatic == null) {
                String effect = "Mode$ CantBlockBy | ValidBlocker$ Creature.Self | Description$ CARDNAME can't block.";
                this.suspectedStatic = StaticAbility.create(effect, this, this.getCurrentState(), false);
            }
            this.addChangedCardTraits(null, null, null, null, ImmutableList.of(this.suspectedStatic), false, false, this.suspectedTimestamp, 0L);
        } else {
            if (this.suspectedTimestamp != null) {
                this.removeChangedCardKeywords(this.suspectedTimestamp, 0L);
                this.removeChangedCardTraits(this.suspectedTimestamp, 0L);
            }
            this.suspectedTimestamp = null;
        }
        return true;
    }

    public final boolean isManifested() {
        return this.manifested;
    }

    public final void setManifested(boolean manifested) {
        this.manifested = manifested;
    }

    public final boolean isCloaked() {
        return this.cloaked;
    }

    public final void setCloaked(boolean cloaked) {
        this.cloaked = cloaked;
    }

    public final boolean isForetold() {
        if (this.isInZone(ZoneType.Exile)) {
            return this.foretold;
        }
        if (this.getCastSA() != null) {
            return this.getCastSA().isForetold();
        }
        return false;
    }

    public final void setForetold(boolean foretold) {
        this.foretold = foretold;
    }

    public final boolean isPlotted() {
        return this.plotted;
    }

    public final boolean setPlotted(boolean plotted) {
        this.plotted = plotted;
        if (plotted && !this.isLKI()) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
            this.game.getTriggerHandler().runTrigger(TriggerType.BecomesPlotted, runParams, false);
        }
        return true;
    }

    public boolean isForetoldCostByEffect() {
        return this.foretoldCostByEffect;
    }

    public void setForetoldCostByEffect(boolean val) {
        this.foretoldCostByEffect = val;
    }

    public boolean isSpecialized() {
        return this.specialized;
    }

    public final void setSpecialized(boolean bool) {
        this.specialized = bool;
        this.setImageKey(this.getPaperCard(), this.getCurrentStateName());
    }

    public final boolean canSpecialize() {
        return this.getRules() != null && this.getRules().getSplitType() == CardSplitType.Specialize;
    }

    public boolean canCrew() {
        return this.canTap() && !StaticAbilityCantCrew.cantCrew(this);
    }

    public int getTimesCrewedThisTurn() {
        return this.timesCrewedThisTurn;
    }

    public final void setTimesCrewedThisTurn(int t2) {
        this.timesCrewedThisTurn = t2;
    }

    public void resetTimesCrewedThisTurn() {
        this.timesCrewedThisTurn = 0;
    }

    public void becomesCrewed(SpellAbility sa) {
        ++this.timesCrewedThisTurn;
        CardCollection crew = sa.getPaidList("TappedCards", true);
        this.addCrewedByThisTurn(crew);
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Vehicle, this);
        runParams.put(AbilityKey.Crew, crew);
        this.game.getTriggerHandler().runTrigger(TriggerType.BecomesCrewed, runParams, false);
    }

    public void resetCrewed() {
        this.resetTimesCrewedThisTurn();
        if (this.crewedByThisTurn != null) {
            this.crewedByThisTurn = null;
        }
    }

    public final void addCrewedByThisTurn(CardCollection crew) {
        if (this.crewedByThisTurn != null) {
            this.crewedByThisTurn.addAll(crew);
        } else {
            this.crewedByThisTurn = crew;
        }
    }

    public final CardCollection getCrewedByThisTurn() {
        return this.crewedByThisTurn;
    }

    public final void setCrewedByThisTurn(CardCollection crew) {
        this.crewedByThisTurn = crew;
    }

    public final void visitAttraction(Player visitor) {
        this.visitedThisTurn = true;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this);
        runParams.put(AbilityKey.Player, visitor);
        this.game.getTriggerHandler().runTrigger(TriggerType.VisitAttraction, runParams, false);
    }

    public final boolean wasVisitedThisTurn() {
        return this.visitedThisTurn;
    }

    public final int getClassLevel() {
        return this.classLevel;
    }

    public void setClassLevel(int level) {
        this.classLevel = level;
        this.view.updateClassLevel(this);
        this.view.getCurrentState().updateAbilityText(this, this.getCurrentState());
    }

    public boolean isClassCard() {
        return this.getType().hasStringType("Class");
    }

    public final void animateBestow() {
        this.animateBestow(true);
    }

    public final void animateBestow(boolean updateView) {
        if (this.isBestowed()) {
            return;
        }
        this.bestowTimestamp = this.getGame().getNextTimestamp();
        this.addChangedCardTypes(new CardType(Collections.singletonList("Aura"), true), new CardType(Collections.singletonList("Creature"), true), false, (Set<RemoveType>)EnumSet.of(RemoveType.EnchantmentTypes), this.bestowTimestamp, 0L, updateView, false);
        this.addChangedCardKeywords(Collections.singletonList("Enchant creature"), Lists.newArrayList(), false, this.bestowTimestamp, null, updateView);
    }

    public final void unanimateBestow() {
        this.unanimateBestow(true);
    }

    public final void unanimateBestow(boolean updateView) {
        if (!this.isBestowed()) {
            return;
        }
        this.removeChangedCardKeywords(this.bestowTimestamp, 0L, updateView);
        this.removeChangedCardTypes(this.bestowTimestamp, 0L, updateView);
        this.bestowTimestamp = -1L;
    }

    public final boolean isBestowed() {
        return this.bestowTimestamp != -1L;
    }

    public final long getBestowTimestamp() {
        return this.bestowTimestamp;
    }

    public final void setBestowTimestamp(long t2) {
        this.bestowTimestamp = t2;
    }

    public final long getGameTimestamp() {
        return this.gameTimestamp;
    }

    public final void setGameTimestamp(long t2) {
        this.gameTimestamp = t2;
        this.layerTimestamp = t2;
    }

    public final long getLayerTimestamp() {
        return this.layerTimestamp;
    }

    public final void setLayerTimestamp(long t2) {
        this.layerTimestamp = t2;
    }

    public boolean equalsWithGameTimestamp(Card c) {
        return this.equals(c) && c.getGameTimestamp() == this.gameTimestamp;
    }

    public final void setRandomFoil() {
        this.setFoil(CardEdition.getRandomFoil(this.getSetCode()));
    }

    public final void setFoil(int f) {
        this.currentState.setSVar("Foil", Integer.toString(f));
    }

    public final CardCollectionView getHauntedBy() {
        return CardCollection.getView(this.hauntedBy);
    }

    public final boolean isHaunted() {
        return FCollection.hasElements(this.hauntedBy);
    }

    public final boolean isHauntedBy(Card c) {
        return FCollection.hasElement(this.hauntedBy, c);
    }

    public final void addHauntedBy(Card c, boolean update) {
        this.hauntedBy = this.view.addCard(this.hauntedBy, c, TrackableProperty.HauntedBy);
        if (c != null && update) {
            c.setHaunting(this);
        }
    }

    public final void addHauntedBy(Card c) {
        this.addHauntedBy(c, true);
    }

    public final void removeHauntedBy(Card c) {
        this.hauntedBy = this.view.removeCard(this.hauntedBy, c, TrackableProperty.HauntedBy);
    }

    public final Card getHaunting() {
        return this.haunting;
    }

    public final void setHaunting(Card c) {
        this.haunting = this.view.setCard(this.haunting, c, TrackableProperty.Haunting);
    }

    public final Card getPairedWith() {
        return this.pairedWith;
    }

    public final void setPairedWith(Card c) {
        this.pairedWith = this.view.setCard(this.pairedWith, c, TrackableProperty.PairedWith);
    }

    public final boolean isPaired() {
        return this.pairedWith != null;
    }

    public Card getMeldedWith() {
        return this.meldedWith;
    }

    public void setMeldedWith(Card meldedWith) {
        this.meldedWith = meldedWith;
    }

    public String getProtectionKey() {
        String protectKey = "";
        boolean pR = false;
        boolean pG = false;
        boolean pB = false;
        boolean pU = false;
        boolean pW = false;
        for (KeywordInterface inst : this.getKeywords(Keyword.PROTECTION)) {
            String kw = inst.getOriginal();
            if (kw.equals("Protection from red") || kw.contains(":red")) {
                if (pR) continue;
                pR = true;
                protectKey = protectKey + "R";
                continue;
            }
            if (kw.equals("Protection from green") || kw.contains(":green")) {
                if (pG) continue;
                pG = true;
                protectKey = protectKey + "G";
                continue;
            }
            if (kw.equals("Protection from black") || kw.contains(":black")) {
                if (pB) continue;
                pB = true;
                protectKey = protectKey + "B";
                continue;
            }
            if (kw.equals("Protection from blue") || kw.contains(":blue")) {
                if (pU) continue;
                pU = true;
                protectKey = protectKey + "U";
                continue;
            }
            if (kw.equals("Protection from white") || kw.contains(":white")) {
                if (pW) continue;
                pW = true;
                protectKey = protectKey + "W";
                continue;
            }
            if (kw.contains("each color")) {
                protectKey = protectKey + "allcolors:";
                continue;
            }
            if (kw.equals("Protection from everything")) {
                protectKey = protectKey + "everything:";
                continue;
            }
            if (kw.contains("colored spells")) {
                protectKey = protectKey + "coloredspells:";
                continue;
            }
            protectKey = protectKey + "generic";
        }
        return protectKey;
    }

    public String getHexproofKey() {
        String hexproofKey = "";
        boolean hR = false;
        boolean hG = false;
        boolean hB = false;
        boolean hU = false;
        boolean hW = false;
        for (KeywordInterface inst : this.getKeywords(Keyword.HEXPROOF)) {
            String kw = inst.getOriginal();
            if (kw.equals("Hexproof")) {
                hexproofKey = hexproofKey + "generic:";
            }
            if (!kw.startsWith("Hexproof:")) continue;
            String[] k = kw.split(":");
            if (k[2].toString().equals("red")) {
                if (hR) continue;
                hR = true;
                hexproofKey = hexproofKey + "R:";
                continue;
            }
            if (k[2].toString().equals("green")) {
                if (hG) continue;
                hG = true;
                hexproofKey = hexproofKey + "G:";
                continue;
            }
            if (k[2].toString().equals("black")) {
                if (hB) continue;
                hB = true;
                hexproofKey = hexproofKey + "B:";
                continue;
            }
            if (k[2].toString().equals("blue")) {
                if (hU) continue;
                hU = true;
                hexproofKey = hexproofKey + "U:";
                continue;
            }
            if (k[2].toString().equals("white")) {
                if (hW) continue;
                hW = true;
                hexproofKey = hexproofKey + "W:";
                continue;
            }
            if (!k[2].toString().equals("monocolored")) continue;
            hexproofKey = hexproofKey + "monocolored:";
        }
        return hexproofKey;
    }

    public String getKeywordKey() {
        ArrayList<String> ability = new ArrayList<String>();
        for (KeywordInterface inst : this.getKeywords()) {
            ability.add(inst.getOriginal());
        }
        Collections.sort(ability);
        return StringUtils.join(ability.toArray(), ",");
    }

    public Zone getZone() {
        return this.currentZone;
    }

    public void setZone(Zone zone) {
        if (this.currentZone == zone) {
            return;
        }
        this.currentZone = zone;
        this.view.updateZone(this);
    }

    public boolean isInZone(ZoneType zone) {
        Zone z = this.getLastKnownZone();
        return z != null && z.is(zone);
    }

    public boolean isInZones(List<ZoneType> zones) {
        boolean inZones = false;
        Zone z = this.getLastKnownZone();
        for (ZoneType okZone : zones) {
            if (!z.is(okZone)) continue;
            inZones = true;
            break;
        }
        return z != null && inZones;
    }

    public final boolean canBeDestroyed() {
        return this.isInPlay() && !this.isPhasedOut() && (!this.hasKeyword(Keyword.INDESTRUCTIBLE) || this.isCreature() && this.getNetToughness() <= 0);
    }

    @Override
    public final boolean canBeTargetedBy(SpellAbility sa) {
        if (!this.getOwner().isInGame()) {
            return false;
        }
        if (sa == null) {
            return true;
        }
        if (StaticAbilityCantTarget.cantTarget(this, sa)) {
            return false;
        }
        if (!this.isInPlay()) {
            return true;
        }
        return !this.isPhasedOut();
    }

    public final boolean canBeControlledBy(Player newController) {
        return newController.isInGame() && (!this.hasKeyword("Other players can't gain control of CARDNAME.") || this.getController().equals(newController));
    }

    @Override
    protected final boolean canBeEnchantedBy(Card aura) {
        SpellAbility sa = aura.getFirstAttachSpell();
        TargetRestrictions tgt = null;
        if (sa != null) {
            tgt = sa.getTargetRestrictions();
        }
        if (tgt != null) {
            boolean zoneValid = false;
            for (ZoneType zt : tgt.getZone()) {
                if (!this.isInZone(zt)) continue;
                zoneValid = true;
                break;
            }
            if (!zoneValid) {
                return false;
            }
            return this.isValid(tgt.getValidTgts(), aura.getController(), aura, (CardTraitBase)sa);
        }
        return false;
    }

    @Override
    protected final boolean canBeEquippedBy(Card equip, SpellAbility sa) {
        if (!this.isInPlay()) {
            return false;
        }
        if (sa != null && sa.isEquip()) {
            return this.isValid(sa.getTargetRestrictions().getValidTgts(), sa.getActivatingPlayer(), equip, (CardTraitBase)sa);
        }
        return this.isCreature();
    }

    @Override
    protected boolean canBeFortifiedBy(Card fort) {
        return this.isLand() && this.isInPlay() && !fort.isLand();
    }

    @Override
    public boolean canBeAttached(Card attach, SpellAbility sa, boolean checkSBA) {
        if (this.isPhasedOut() && !attach.isPhasedOut()) {
            return false;
        }
        return super.canBeAttached(attach, sa, checkSBA);
    }

    public FCollectionView<ReplacementEffect> getReplacementEffects() {
        return this.currentState.getReplacementEffects();
    }

    public ReplacementEffect addReplacementEffect(ReplacementEffect replacementEffect) {
        this.currentState.addReplacementEffect(replacementEffect);
        return replacementEffect;
    }

    @Deprecated
    public void removeReplacementEffect(ReplacementEffect replacementEffect) {
        this.currentState.removeReplacementEffect(replacementEffect);
    }

    public void updateReplacementEffects(List<ReplacementEffect> list, CardState state) {
        String reStr;
        String sa;
        for (CardTraitChanges ck : this.getChangedCardTraitsList(state)) {
            if (ck.isRemoveAll()) {
                list.clear();
            }
            list.addAll(ck.getReplacements());
        }
        for (KeywordInterface kw : this.getUnhiddenKeywords(state)) {
            list.addAll(kw.getReplacements());
        }
        if (this.getCounters(CounterEnumType.SHIELD) > 0) {
            sa = "DB$ RemoveCounter | Defined$ Self | CounterType$ Shield | CounterNum$ 1";
            if (this.shieldCounterReplaceDamage == null) {
                reStr = "Event$ DamageDone | ActiveZones$ Battlefield | ValidTarget$ Card.Self | PreventionEffect$ True | AlwaysReplace$ True | Secondary$ True | Description$ If damage would be dealt to this permanent, prevent that damage and remove a shield counter from it.";
                this.shieldCounterReplaceDamage = ReplacementHandler.parseReplacement(reStr, this, false, null);
                this.shieldCounterReplaceDamage.setOverridingAbility(AbilityFactory.getAbility(sa, this));
            }
            if (this.shieldCounterReplaceDestroy == null) {
                reStr = "Event$ Destroy | ActiveZones$ Battlefield | ValidCard$ Card.Self | ValidCause$ SpellAbility | Secondary$ True | ShieldCounter$ True | Description$ If this permanent would be destroyed as the result of an effect, instead remove a shield counter from it.";
                this.shieldCounterReplaceDestroy = ReplacementHandler.parseReplacement(reStr, this, false, null);
                this.shieldCounterReplaceDestroy.setOverridingAbility(AbilityFactory.getAbility(sa, this));
            }
            list.add(this.shieldCounterReplaceDamage);
            list.add(this.shieldCounterReplaceDestroy);
        }
        if (this.getCounters(CounterEnumType.STUN) > 0) {
            sa = "DB$ RemoveCounter | Defined$ Self | CounterType$ Stun | CounterNum$ 1";
            if (this.stunCounterReplaceUntap == null) {
                reStr = "Event$ Untap | ActiveZones$ Battlefield | ValidCard$ Card.Self | Secondary$ True | Description$ If this permanent would become untapped, instead remove a stun counter from it.";
                this.stunCounterReplaceUntap = ReplacementHandler.parseReplacement(reStr, this, false, null);
                this.stunCounterReplaceUntap.setOverridingAbility(AbilityFactory.getAbility(sa, this));
            }
            list.add(this.stunCounterReplaceUntap);
        }
        if (this.getCounters(CounterEnumType.FINALITY) > 0) {
            if (this.finalityReplaceDying == null) {
                String reStr2 = "Event$ Moved | ActiveZones$ Battlefield | Origin$ Battlefield | Destination$ Graveyard | ValidCard$ Card.Self | Secondary$ True  | Description$ If CARDNAME would die, exile it instead.";
                String sa2 = "DB$ ChangeZone | Origin$ Battlefield | Destination$ Exile | Defined$ ReplacedCard";
                this.finalityReplaceDying = ReplacementHandler.parseReplacement(reStr2, this, false, null);
                this.finalityReplaceDying.setOverridingAbility(AbilityFactory.getAbility(sa2, this));
            }
            list.add(this.finalityReplaceDying);
        }
    }

    public boolean hasReplacementEffect(ReplacementEffect re) {
        return this.currentState.hasReplacementEffect(re);
    }

    public boolean hasReplacementEffect(int id) {
        return this.currentState.hasReplacementEffect(id);
    }

    public ReplacementEffect getReplacementEffect(int id) {
        return this.currentState.getReplacementEffect(id);
    }

    public Zone getCastFrom() {
        return this.castFrom;
    }

    public void setCastFrom(Zone castFrom0) {
        this.castFrom = castFrom0;
    }

    public boolean wasCast() {
        if (this.hasMergedCard()) {
            boolean wasCast = false;
            for (Card c : this.getMergedCards()) {
                if (null == c.getCastFrom()) continue;
                wasCast = true;
                break;
            }
            return wasCast;
        }
        return this.getCastFrom() != null;
    }

    public SpellAbility getCastSA() {
        return this.castSA;
    }

    public void setCastSA(SpellAbility castSA) {
        this.castSA = castSA;
    }

    public Card getEffectSource() {
        if (this.effectSourceAbility != null) {
            return this.effectSourceAbility.getHostCard();
        }
        return this.effectSource;
    }

    public SpellAbility getEffectSourceAbility() {
        return this.effectSourceAbility;
    }

    public void setEffectSource(Card src) {
        this.effectSource = src;
    }

    public void setEffectSource(SpellAbility sa) {
        this.effectSourceAbility = sa;
    }

    public boolean isStartsGameInPlay() {
        return this.startsGameInPlay;
    }

    public void setStartsGameInPlay(boolean startsGameInPlay0) {
        this.startsGameInPlay = startsGameInPlay0;
    }

    public boolean isInPlay() {
        return this.isInZone(ZoneType.Battlefield);
    }

    public void onEndOfCombat(Player active) {
        this.setEnlistedThisCombat(false);
        if (this.getController().equals(active)) {
            this.chosenModesYourLastCombat.clear();
            this.chosenModesYourLastCombatStatic.clear();
            this.chosenModesYourLastCombat.putAll(this.chosenModesYourCombat);
            this.chosenModesYourLastCombatStatic.putAll(this.chosenModesYourCombatStatic);
            this.chosenModesYourCombat.clear();
            this.chosenModesYourCombatStatic.clear();
            this.updateAbilityTextForView();
        }
    }

    public void onCleanupPhase(Player turn) {
        if (!StaticAbilityNoCleanupDamage.damageNotRemoved(this)) {
            this.setDamage(0);
        }
        this.setHasBeenDealtDeathtouchDamage(false);
        this.resetExcessDamage();
        this.setRegeneratedThisTurn(0);
        this.resetShieldCount();
        this.setBecameTargetThisTurn(false);
        this.setValiant(false);
        this.setFoughtThisTurn(false);
        this.turnedFaceUpThisTurn = false;
        this.clearMustBlockCards();
        this.getDamageHistory().setCreatureAttackedLastTurnOf(turn, this.getDamageHistory().getCreatureAttacksThisTurn() > 0);
        this.getDamageHistory().newTurn();
        this.damageReceivedThisTurn.clear();
        this.clearBlockedByThisTurn();
        this.clearBlockedThisTurn();
        this.resetMayPlayTurn();
        this.resetExertedThisTurn();
        this.resetCrewed();
        this.resetSaddled();
        this.visitedThisTurn = false;
        this.resetChosenModeTurn();
        this.resetAbilityResolvedThisTurn();
    }

    public boolean hasETBTrigger(boolean drawbackOnly) {
        for (Trigger tr : this.getTriggers()) {
            SpellAbility sa;
            if (tr.getMode() != TriggerType.ChangesZone || !ZoneType.Battlefield.toString().equals(tr.getParam("Destination")) || tr.hasParam("ValidCard") && !tr.getParam("ValidCard").contains("Self") || drawbackOnly && ((sa = tr.ensureAbility()) == null || sa.isActivatedAbility())) continue;
            return true;
        }
        return false;
    }

    public boolean hasETBReplacement() {
        for (ReplacementEffect re : this.getReplacementEffects()) {
            Map<String, String> params = re.getMapParams();
            if (!(re instanceof ReplaceMoved) || !ZoneType.Battlefield.toString().equals(params.get("Destination")) || params.containsKey("ValidCard") && !params.get("ValidCard").contains("Self")) continue;
            return true;
        }
        return false;
    }

    public int getCMC() {
        return this.getCMC(SplitCMCMode.CurrentSideCMC);
    }

    public int getCMC(SplitCMCMode mode) {
        if (this.lkiCMC >= 0) {
            return this.lkiCMC;
        }
        int xPaid = 0;
        if (this.isInZone(ZoneType.Stack) && this.getManaCost() != null) {
            xPaid = this.getXManaCostPaid() * this.getManaCost().countX();
        }
        int requestedCMC = 0;
        if (this.isSplitCard()) {
            switch (mode) {
                case CurrentSideCMC: {
                    requestedCMC = this.getManaCost().getCMC() + xPaid;
                    break;
                }
                case LeftSplitCMC: {
                    requestedCMC = this.getState(CardStateName.LeftSplit).getManaCost().getCMC() + xPaid;
                    break;
                }
                case RightSplitCMC: {
                    requestedCMC = this.getState(CardStateName.RightSplit).getManaCost().getCMC() + xPaid;
                    break;
                }
                default: {
                    System.out.println(TextUtil.concatWithSpace("Illegal Split Card CMC mode", mode.toString(), "passed to getCMC!"));
                    break;
                }
            }
        } else if (this.currentStateName == CardStateName.Transformed) {
            if (this.getCopiedPermanent() != null) {
                return 0;
            }
            requestedCMC = this.getState(CardStateName.Original).getManaCost().getCMC();
        } else if (this.currentStateName == CardStateName.Meld) {
            if (this.getCopiedPermanent() != null) {
                return 0;
            }
            requestedCMC = this.getState(CardStateName.Original).getManaCost().getCMC() + this.getMeldedWith().getManaCost().getCMC();
        } else {
            requestedCMC = this.getManaCost().getCMC() + xPaid;
        }
        return requestedCMC;
    }

    public final void setLKICMC(int cmc) {
        this.lkiCMC = cmc;
    }

    public final boolean isLKI() {
        return this.lkiCMC >= 0;
    }

    public final boolean canBeSacrificedBy(SpellAbility source, boolean effect) {
        if (this.isImmutable()) {
            System.out.println("Trying to sacrifice immutables: " + this);
            return false;
        }
        if (!this.isInPlay() || this.isPhasedOut()) {
            return false;
        }
        if (source != null && source.isManaAbility() && this.isUsedToPay()) {
            return false;
        }
        Card gameCard = this.game.getCardState(this, null);
        if (gameCard == null || !this.equalsWithGameTimestamp(gameCard)) {
            return false;
        }
        return !StaticAbilityCantSacrifice.cantSacrifice(this, source, effect);
    }

    public final boolean canExiledBy(SpellAbility source, boolean effect) {
        return !StaticAbilityCantExile.cantExile(this, source, effect);
    }

    public CardRules getRules() {
        return this.cardRules;
    }

    public void setRules(CardRules r) {
        this.cardRules = r;
        this.currentState.getView().updateRulesText(r, this.getType());
    }

    public boolean isCommander() {
        if (this.getMeldedWith() != null && this.getMeldedWith().isCommander()) {
            return true;
        }
        if (this.isInPlay() && this.hasMergedCard()) {
            for (Card c : this.getMergedCards()) {
                if (!c.isCommander) continue;
                return true;
            }
        }
        return this.isCommander;
    }

    public boolean isRealCommander() {
        return this.isCommander;
    }

    public void setCommander(boolean b) {
        if (this.isCommander == b) {
            return;
        }
        this.isCommander = b;
        this.view.updateCommander(this);
    }

    public void updateCommanderView() {
        this.view.updateCommander(this);
    }

    public Card getRealCommander() {
        if (this.isCommander) {
            return this;
        }
        if (this.getMeldedWith() != null && this.getMeldedWith().isCommander()) {
            return this.getMeldedWith();
        }
        if (this.isInPlay() && this.hasMergedCard()) {
            for (Card c : this.getMergedCards()) {
                if (!c.isCommander) continue;
                return c;
            }
        }
        return null;
    }

    public boolean canMoveToCommandZone() {
        return this.canMoveToCommandZone;
    }

    public void setMoveToCommandZone(boolean b) {
        this.canMoveToCommandZone = b;
    }

    public void setSplitStateToPlayAbility(SpellAbility sa) {
        CardStateName stateName;
        if (this.isInPlay()) {
            return;
        }
        if (sa.isBestow()) {
            this.animateBestow();
        }
        if (sa.isDisturb() || sa.hasParam("CastTransformed")) {
            this.incrementTransformedTimestamp();
        }
        if (sa.hasParam("Prototype") && this.prototypeTimestamp == -1L) {
            long next = this.game.getNextTimestamp();
            this.addCloneState(CardFactory.getCloneStates(this, this, sa), next);
            this.prototypeTimestamp = next;
        }
        if ((stateName = sa.getCardStateName()) != null && this.hasState(stateName) && this.getCurrentStateName() != stateName) {
            this.setState(stateName, true);
            if (this.isDoubleFaced()) {
                this.setBackSide(this.getRules().getSplitType().getChangedStateName().equals((Object)stateName));
            }
        }
        if (sa.isCastFaceDown()) {
            this.turnFaceDown(true);
            CardFactoryUtil.setFaceDownState(this, sa);
        }
    }

    public boolean isOptionalCostPaid(OptionalCost cost) {
        return this.getCastSA() == null ? false : this.getCastSA().isOptionalCostPaid(cost);
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    public void dangerouslySetGame(Game newGame) {
        this.game = newGame;
    }

    public List<SpellAbility> getAllPossibleAbilities(Player player, boolean removeUnplayable) {
        CardState oState = this.getState(CardStateName.Original);
        ArrayList<SpellAbility> abilities = Lists.newArrayList();
        for (SpellAbility sa : this.getSpellAbilities()) {
            if (this.isAdventureCard() && sa.isAdventure() && this.getExiledWith() != null && this.getExiledWith().equals(this) && CardStateName.Adventure.equals((Object)this.getExiledWith().getCurrentStateName())) continue;
            abilities.add(sa);
            abilities.addAll(GameActionUtil.getAlternativeCosts(sa, player, false));
        }
        if (this.isFaceDown() && this.isInZone(ZoneType.Exile)) {
            for (SpellAbility sa : oState.getSpellAbilities()) {
                abilities.addAll(GameActionUtil.getAlternativeCosts(sa, player, false));
            }
        }
        if (this.isModal() && this.hasState(CardStateName.Modal)) {
            for (SpellAbility sa : this.getState(CardStateName.Modal).getSpellAbilities()) {
                if (!sa.isSpell() && !sa.isLandAbility()) continue;
                abilities.add(sa);
                abilities.addAll(GameActionUtil.getAlternativeCosts(sa, player, false));
            }
        }
        if (this.isInPlay() && !this.isPhasedOut() && player.canCastSorcery()) {
            if (this.getCurrentStateName() == CardStateName.RightSplit || this.getCurrentStateName() == CardStateName.EmptyRoom) {
                abilities.add(this.getUnlockAbility(CardStateName.LeftSplit));
            }
            if (this.getCurrentStateName() == CardStateName.LeftSplit || this.getCurrentStateName() == CardStateName.EmptyRoom) {
                abilities.add(this.getUnlockAbility(CardStateName.RightSplit));
            }
        }
        if (this.isInPlay() && this.isFaceDown() && oState.getType().isCreature() && oState.getManaCost() != null && !oState.getManaCost().isNoCost()) {
            if (this.isManifested()) {
                abilities.add(oState.getManifestUp());
            }
            if (this.isCloaked()) {
                abilities.add(oState.getCloakUp());
            }
        }
        ArrayList<SpellAbility> toRemove = Lists.newArrayListWithCapacity(abilities.size());
        for (SpellAbility sa : abilities) {
            Player oldController = sa.getActivatingPlayer();
            sa.setActivatingPlayer(player);
            if (sa.canPlay(true) || (!removeUnplayable || sa.canPlay()) && sa.isPossible()) continue;
            if (oldController != null) {
                sa.setActivatingPlayer(oldController);
            }
            toRemove.add(sa);
        }
        abilities.removeAll(toRemove);
        return abilities;
    }

    public static Card fromPaperCard(IPaperCard pc, Player owner) {
        return CardFactory.getCard(pc, owner, owner == null ? null : owner.getGame());
    }

    public static Card getCardForUi(IPaperCard pc) {
        if (pc instanceof PaperCard) {
            Card res = cp2card.get(pc);
            if (res == null) {
                res = Card.fromPaperCard(pc, null);
                cp2card.put((PaperCard)pc, res);
            }
            return res;
        }
        return Card.fromPaperCard(pc, null);
    }

    public static Card getCardForUi(Card c) {
        if (c == null) {
            return null;
        }
        return c.getCardForUi();
    }

    public Card getCardForUi() {
        return this;
    }

    public IPaperCard getPaperCard() {
        IPaperCard cp = this.paperCard;
        if (cp != null) {
            return cp;
        }
        String name = this.getName();
        String set = this.getSetCode();
        if (StringUtils.isNotBlank(set)) {
            cp = StaticData.instance().getVariantCards().getCard(name, set);
            if (cp != null) {
                return cp;
            }
            cp = StaticData.instance().getCommonCards().getCard(name, set);
            if (cp != null) {
                return cp;
            }
        }
        if ((cp = StaticData.instance().getVariantCards().getCard(name)) != null) {
            return cp;
        }
        CardDb.CardArtPreference cardArtPreference = StaticData.instance().getCardArtPreference();
        if (cardArtPreference == null) {
            cardArtPreference = CardDb.CardArtPreference.ORIGINAL_ART_CORE_EXPANSIONS_REPRINT_ONLY;
        }
        if ((cp = StaticData.instance().getCommonCards().getCardFromEditions(name, cardArtPreference)) != null) {
            return cp;
        }
        return StaticData.instance().getCommonCards().getCard(name);
    }

    public static void updateCard(PaperCard pc) {
        Card res = cp2card.get(pc);
        if (res != null) {
            cp2card.put(pc, Card.fromPaperCard(pc, null));
        }
    }

    public List<Object[]> getStaticCommandList() {
        return this.staticCommandList;
    }

    public void addStaticCommandList(Object[] objects) {
        this.staticCommandList.add(objects);
    }

    public String getOracleText() {
        return this.currentState.getOracleText();
    }

    public void setOracleText(String oracleText) {
        this.currentState.setOracleText(oracleText);
    }

    @Override
    public String getTranslationKey() {
        return this.currentState.getTranslationKey();
    }

    @Override
    public String getUntranslatedName() {
        return this.getName();
    }

    @Override
    public String getUntranslatedType() {
        return this.currentState.getUntranslatedType();
    }

    @Override
    public String getUntranslatedOracle() {
        return this.currentState.getUntranslatedOracle();
    }

    @Override
    public CardView getView() {
        return this.view;
    }

    public void setChangedCardTypes(Table<Long, Long, CardChangedType> changedCardTypes) {
        this.changedCardTypes.clear();
        this.changedCardTypes.putAll(changedCardTypes);
    }

    public void setChangedCardTypesCharacterDefining(Table<Long, Long, CardChangedType> changedCardTypes) {
        this.changedCardTypesCharacterDefining.clear();
        this.changedCardTypesCharacterDefining.putAll(changedCardTypes);
    }

    public void setChangedCardKeywords(Table<Long, Long, KeywordsChange> changedCardKeywords) {
        this.changedCardKeywords.clear();
        for (Table.Cell<Long, Long, KeywordsChange> entry : changedCardKeywords.cellSet()) {
            this.changedCardKeywords.put(entry.getRowKey(), entry.getColumnKey(), entry.getValue().copy(this, true));
        }
    }

    public void setChangedCardColors(Table<Long, Long, CardColor> changedCardColors) {
        this.changedCardColors.clear();
        this.changedCardColors.putAll(changedCardColors);
    }

    public void setChangedCardColorsCharacterDefining(Table<Long, Long, CardColor> changedCardColors) {
        this.changedCardColorsCharacterDefining.clear();
        this.changedCardColorsCharacterDefining.putAll(changedCardColors);
    }

    public void cleanupCopiedChangesFrom(Card c) {
        for (StaticAbility stAb : c.getStaticAbilities()) {
            this.removeChangedCardTypes(c.getLayerTimestamp(), stAb.getId(), false);
            this.removeColor(c.getLayerTimestamp(), stAb.getId());
            this.removeChangedCardKeywords(c.getLayerTimestamp(), stAb.getId(), false);
            this.removeChangedCardTraits(c.getLayerTimestamp(), stAb.getId());
        }
    }

    public final void addGoad(Long timestamp, Player p) {
        this.goad.put(timestamp, p);
        this.updateAbilityTextForView();
    }

    public final void removeGoad(Long timestamp) {
        if (this.goad.remove(timestamp) != null) {
            this.updateAbilityTextForView();
        }
    }

    public final boolean isGoaded() {
        return !this.goad.isEmpty();
    }

    public final void unGoad() {
        this.goad = Maps.newTreeMap();
        this.updateAbilityTextForView();
    }

    public final boolean isGoadedBy(Player p) {
        return this.goad.containsValue(p);
    }

    public final PlayerCollection getGoaded() {
        return new PlayerCollection((Iterable<Player>)this.goad.values());
    }

    public final Map<Long, Player> getGoadMap() {
        return this.goad;
    }

    public final Zone getLastKnownZone() {
        return this.savedLastKnownZone != null ? this.savedLastKnownZone : this.getZone();
    }

    public final void setLastKnownZone(Zone zone) {
        this.savedLastKnownZone = zone;
    }

    public final void putEtbCounters(Map<Optional<Player>, Map<CounterType, Integer>> etbCounters) {
        if (etbCounters == null) {
            return;
        }
        for (Map<CounterType, Integer> m4 : etbCounters.values()) {
            for (Map.Entry<CounterType, Integer> e : m4.entrySet()) {
                CounterType ct = e.getKey();
                if (!this.canReceiveCounters(ct)) continue;
                this.setCounters(ct, (Integer)(this.getCounters(ct) + e.getValue()));
            }
        }
    }

    public final int getFinalChapterNr() {
        return this.getCurrentState().getFinalChapterNr();
    }

    public boolean canBeDiscardedBy(SpellAbility sa, boolean effect) {
        if (!this.isInZone(ZoneType.Hand)) {
            return false;
        }
        return this.getOwner().canDiscardBy(sa, effect);
    }

    public boolean activatedThisTurn() {
        return !this.numberTurnActivations.isEmpty();
    }

    public void addAbilityActivated(SpellAbility ability) {
        this.numberTurnActivations.add(ability);
        this.numberGameActivations.add(ability);
        if (ability.isPwAbility()) {
            this.addPlaneswalkerAbilityActivated();
        }
    }

    public ActivationTable getAbilityActivatedThisTurn() {
        return this.numberTurnActivations;
    }

    public ActivationTable getAbilityActivatedThisGame() {
        return this.numberGameActivations;
    }

    public ActivationTable getAbilityResolvedThisTurn() {
        return this.numberAbilityResolved;
    }

    public int getAbilityActivatedThisTurn(SpellAbility ability) {
        return this.numberTurnActivations.get(ability);
    }

    public int getAbilityActivatedThisGame(SpellAbility ability) {
        return this.numberGameActivations.get(ability);
    }

    public int getAbilityResolvedThisTurn(SpellAbility ability) {
        return this.numberAbilityResolved.get(ability);
    }

    public void addAbilityResolved(SpellAbility ability) {
        this.numberAbilityResolved.add(ability);
    }

    public List<Player> getAbilityResolvedThisTurnActivators(SpellAbility ability) {
        return this.numberAbilityResolved.getActivators(ability);
    }

    public void resetAbilityResolvedThisTurn() {
        this.numberAbilityResolved.clear();
    }

    public List<String> getChosenModes(SpellAbility ability, String type) {
        SpellAbility original = null;
        SpellAbility root = ability.getRootAbility();
        if (root.isTrigger()) {
            original = root.getTrigger().getOverridingAbility();
        } else {
            original = ability.getOriginalAbility();
            if (original == null) {
                original = ability;
            }
        }
        if (type.equals("ThisTurn")) {
            if (ability.getGrantorStatic() != null) {
                return this.chosenModesTurnStatic.get(original, ability.getGrantorStatic());
            }
            return this.chosenModesTurn.get(original);
        }
        if (type.equals("ThisGame")) {
            if (ability.getGrantorStatic() != null) {
                return this.chosenModesGameStatic.get(original, ability.getGrantorStatic());
            }
            return this.chosenModesGame.get(original);
        }
        if (type.equals("YourLastCombat")) {
            if (ability.getGrantorStatic() != null) {
                return this.chosenModesYourLastCombatStatic.get(original, ability.getGrantorStatic());
            }
            return this.chosenModesYourLastCombat.get(original);
        }
        return null;
    }

    public void addChosenModes(SpellAbility ability, String mode, boolean yourCombat) {
        SpellAbility original = null;
        SpellAbility root = ability.getRootAbility();
        if (root.isTrigger()) {
            original = root.getTrigger().getOverridingAbility();
        } else {
            original = ability.getOriginalAbility();
            if (original == null) {
                original = ability;
            }
        }
        if (ability.getGrantorStatic() != null) {
            List<String> result = this.chosenModesTurnStatic.get(original, ability.getGrantorStatic());
            if (result == null) {
                result = Lists.newArrayList();
                this.chosenModesTurnStatic.put(original, ability.getGrantorStatic(), result);
            }
            result.add(mode);
            result = this.chosenModesGameStatic.get(original, ability.getGrantorStatic());
            if (result == null) {
                result = Lists.newArrayList();
                this.chosenModesGameStatic.put(original, ability.getGrantorStatic(), result);
            }
            result.add(mode);
            if (yourCombat && (result = this.chosenModesYourCombatStatic.get(original, ability.getGrantorStatic())) == null) {
                result = Lists.newArrayList();
                this.chosenModesYourCombatStatic.put(original, ability.getGrantorStatic(), result);
            }
        } else {
            List result = this.chosenModesTurn.computeIfAbsent(original, k -> Lists.newArrayList());
            result.add(mode);
            result = this.chosenModesGame.computeIfAbsent(original, k -> Lists.newArrayList());
            result.add(mode);
            if (yourCombat) {
                result = this.chosenModesYourCombat.computeIfAbsent(original, k -> Lists.newArrayList());
                result.add(mode);
            }
        }
    }

    public void resetChosenModeTurn() {
        boolean updateView = !this.chosenModesTurn.isEmpty() || !this.chosenModesTurnStatic.isEmpty();
        this.chosenModesTurn.clear();
        this.chosenModesTurnStatic.clear();
        if (updateView) {
            this.updateAbilityTextForView();
        }
    }

    public int getPlaneswalkerAbilityActivated() {
        return this.planeswalkerAbilityActivated;
    }

    public void addPlaneswalkerAbilityActivated() {
        if (++this.planeswalkerAbilityActivated == 2 && StaticAbilityNumLoyaltyAct.limitIncrease(this)) {
            this.planeswalkerActivationLimitUsed = true;
        }
    }

    public boolean planeswalkerActivationLimitUsed() {
        return this.planeswalkerActivationLimitUsed;
    }

    public void resetActivationsPerTurn() {
        this.planeswalkerAbilityActivated = 0;
        this.planeswalkerActivationLimitUsed = false;
        this.numberTurnActivations.clear();
    }

    public void addCanBlockAdditional(int n, long timestamp) {
        if (n <= 0) {
            return;
        }
        this.canBlockAdditional.put(timestamp, n);
        this.getView().updateBlockAdditional(this);
    }

    public boolean removeCanBlockAdditional(long timestamp) {
        boolean result;
        boolean bl = result = this.canBlockAdditional.remove(timestamp) != null;
        if (result) {
            this.getView().updateBlockAdditional(this);
        }
        return result;
    }

    public int canBlockAdditional() {
        int result = 0;
        for (Integer v : this.canBlockAdditional.values()) {
            result += v.intValue();
        }
        return result;
    }

    public void addCanBlockAny(long timestamp) {
        this.canBlockAny.add(timestamp);
        this.getView().updateBlockAdditional(this);
    }

    public boolean removeCanBlockAny(long timestamp) {
        boolean result = this.canBlockAny.remove(timestamp);
        if (result) {
            this.getView().updateBlockAdditional(this);
        }
        return result;
    }

    public boolean canBlockAny() {
        return !this.canBlockAny.isEmpty();
    }

    public boolean removeChangedState() {
        boolean updateState = false;
        updateState |= this.removeCloneStates();
        updateState |= this.clearChangedCardTypes();
        updateState |= this.clearChangedCardKeywords();
        updateState |= this.clearChangedCardColors();
        updateState |= this.clearChangedCardTraits();
        updateState |= this.clearNewPT();
        return updateState |= this.clearChangedName();
    }

    public CardEdition.BorderColor borderColor() {
        CardEdition edition = StaticData.instance().getEditions().get(this.getSetCode());
        if (edition == null || this.isBasicLand()) {
            return CardEdition.BorderColor.BLACK;
        }
        return edition.getBorderColor();
    }

    public final CardCollectionView getUntilLeavesBattlefield() {
        return CardCollection.getView(this.untilLeavesBattlefield);
    }

    public final void addUntilLeavesBattlefield(Card c) {
        this.untilLeavesBattlefield = this.view.addCard(this.untilLeavesBattlefield, c, TrackableProperty.UntilLeavesBattlefield);
    }

    public final void addUntilLeavesBattlefield(Iterable<Card> cards) {
        this.untilLeavesBattlefield = this.view.addCards(this.untilLeavesBattlefield, cards, TrackableProperty.UntilLeavesBattlefield);
    }

    public final void removeUntilLeavesBattlefield(Card c) {
        this.untilLeavesBattlefield = this.view.removeCard(this.untilLeavesBattlefield, c, TrackableProperty.UntilLeavesBattlefield);
    }

    public final void removeUntilLeavesBattlefield(Iterable<Card> cards) {
        this.untilLeavesBattlefield = this.view.removeCards(this.untilLeavesBattlefield, cards, TrackableProperty.UntilLeavesBattlefield);
    }

    public final void clearUntilLeavesBattlefield() {
        this.untilLeavesBattlefield = this.view.clearCards(this.untilLeavesBattlefield, TrackableProperty.UntilLeavesBattlefield);
    }

    public CombatLki getCombatLKI() {
        return this.combatLKI;
    }

    public void setCombatLKI(CombatLki combatLKI) {
        this.combatLKI = combatLKI;
    }

    public boolean isAttacking() {
        if (this.getCombatLKI() != null) {
            return this.getCombatLKI().isAttacker;
        }
        return this.getGame().getCombat().isAttacking(this);
    }

    public boolean ignoreLegendRule() {
        if (!this.getType().isLegendary()) {
            return true;
        }
        if (this.getName().isEmpty() && !this.hasNonLegendaryCreatureNames()) {
            return true;
        }
        return StaticAbilityIgnoreLegendRule.ignoreLegendRule(this);
    }

    public boolean attackVigilance() {
        return StaticAbilityAttackVigilance.attackVigilance(this);
    }

    public boolean isAbilitySick() {
        if (!this.isSick()) {
            return false;
        }
        return !StaticAbilityActivateAbilityAsIfHaste.canActivate(this);
    }

    public boolean isWitherDamage() {
        if (this.hasKeyword(Keyword.WITHER) || this.hasKeyword(Keyword.INFECT)) {
            return true;
        }
        return StaticAbilityWitherDamage.isWitherDamage(this);
    }

    public Set<CardStateName> getUnlockedRooms() {
        return this.unlockedRooms;
    }

    public void setUnlockedRooms(Set<CardStateName> set) {
        this.unlockedRooms = set;
    }

    public List<String> getUnlockedRoomNames() {
        ArrayList<String> result = Lists.newArrayList();
        for (CardStateName stateName : this.unlockedRooms) {
            if (!this.hasState(stateName)) continue;
            result.add(this.getState(stateName).getName());
        }
        return result;
    }

    public Set<CardStateName> getLockedRooms() {
        HashSet<CardStateName> result = Sets.newHashSet(CardStateName.LeftSplit, CardStateName.RightSplit);
        result.removeAll(this.unlockedRooms);
        return result;
    }

    public List<String> getLockedRoomNames() {
        ArrayList<String> result = Lists.newArrayList();
        for (CardStateName stateName : this.getLockedRooms()) {
            if (!this.hasState(stateName)) continue;
            result.add(this.getState(stateName).getName());
        }
        return result;
    }

    public boolean unlockRoom(Player p, CardStateName stateName) {
        if (this.unlockedRooms.contains((Object)stateName) || stateName != CardStateName.LeftSplit && stateName != CardStateName.RightSplit) {
            return false;
        }
        this.unlockedRooms.add(stateName);
        this.updateRooms();
        Map<AbilityKey, Object> unlockParams = AbilityKey.mapFromPlayer(p);
        unlockParams.put(AbilityKey.Card, this);
        unlockParams.put(AbilityKey.CardState, this.getState(stateName));
        this.getGame().getTriggerHandler().runTrigger(TriggerType.UnlockDoor, unlockParams, true);
        if (this.unlockedRooms.size() > 1) {
            Map<AbilityKey, Object> fullyUnlockParams = AbilityKey.mapFromPlayer(p);
            fullyUnlockParams.put(AbilityKey.Card, this);
            this.getGame().getTriggerHandler().runTrigger(TriggerType.FullyUnlock, fullyUnlockParams, true);
        }
        return true;
    }

    public boolean lockRoom(Player p, CardStateName stateName) {
        if (!this.unlockedRooms.contains((Object)stateName) || stateName != CardStateName.LeftSplit && stateName != CardStateName.RightSplit) {
            return false;
        }
        this.unlockedRooms.remove((Object)stateName);
        this.updateRooms();
        return true;
    }

    public void updateRooms() {
        if (!this.isRoom()) {
            return;
        }
        if (this.isFaceDown()) {
            return;
        }
        if (this.unlockedRooms.isEmpty()) {
            this.setState(CardStateName.EmptyRoom, true);
        } else if (this.unlockedRooms.size() > 1) {
            this.setState(CardStateName.Original, true);
        } else {
            for (CardStateName name : this.unlockedRooms) {
                this.setState(name, true);
            }
        }
        this.getGame().getTriggerHandler().clearActiveTriggers(this, null);
        this.getGame().getTriggerHandler().registerActiveTrigger(this, false);
    }

    public CardState getEmptyRoomState() {
        if (!this.states.containsKey((Object)CardStateName.EmptyRoom)) {
            this.states.put(CardStateName.EmptyRoom, CardUtil.getEmptyRoomCharacteristic(this));
        }
        return this.states.get((Object)CardStateName.EmptyRoom);
    }

    public SpellAbility getUnlockAbility(CardStateName state) {
        if (!this.unlockAbilities.containsKey((Object)state)) {
            this.unlockAbilities.put(state, CardFactoryUtil.abilityUnlockRoom(this.getState(state)));
        }
        return this.unlockAbilities.get((Object)state);
    }

    private static final class ListKeywordVisitor
    extends Visitor<KeywordInterface> {
        private List<KeywordInterface> keywords = Lists.newArrayList();

        private ListKeywordVisitor() {
        }

        @Override
        public boolean visit(KeywordInterface kw) {
            this.keywords.add(kw);
            return true;
        }

        public List<KeywordInterface> getKeywords() {
            return this.keywords;
        }
    }

    private static final class HasKeywordVisitor
    extends Visitor<KeywordInterface> {
        private String keyword;
        private final MutableBoolean result = new MutableBoolean(false);
        private boolean startOf;

        private HasKeywordVisitor(String keyword, boolean startOf) {
            this.keyword = keyword;
            this.startOf = startOf;
        }

        @Override
        public boolean visit(KeywordInterface inst) {
            String kw = inst.getOriginal();
            if (this.startOf && kw.startsWith(this.keyword) || kw.equals(this.keyword)) {
                this.result.setTrue();
            }
            return this.result.isFalse();
        }

        public boolean getResult() {
            return this.result.isTrue();
        }
    }

    private static final class CountKeywordVisitor
    extends Visitor<KeywordInterface> {
        private String keyword;
        private int count;

        private CountKeywordVisitor(String keyword) {
            this.keyword = keyword;
            this.count = 0;
        }

        @Override
        public boolean visit(KeywordInterface inst) {
            String kw = inst.getOriginal();
            if (kw.equals(this.keyword)) {
                ++this.count;
            }
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class StatBreakdown {
        public final int currentValue;
        public final int tempBoost;
        public final int bonusFromCounters;

        public StatBreakdown() {
            this.currentValue = 0;
            this.tempBoost = 0;
            this.bonusFromCounters = 0;
        }

        public StatBreakdown(int currentValue, int tempBoost, int bonusFromCounters) {
            this.currentValue = currentValue;
            this.tempBoost = tempBoost;
            this.bonusFromCounters = bonusFromCounters;
        }

        public int getTotal() {
            return this.currentValue + this.tempBoost + this.bonusFromCounters;
        }

        public String toString() {
            return TextUtil.concatWithSpace("c:" + this.currentValue, "tb:" + this.tempBoost, "bfc:" + this.bonusFromCounters);
        }
    }

    public static enum SplitCMCMode {
        CurrentSideCMC,
        LeftSplitCMC,
        RightSplitCMC;

    }
}

