/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.base.Optional;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class ActivationTable
extends ForwardingTable<SpellAbility, Optional<StaticAbility>, List<Player>> {
    Table<SpellAbility, Optional<StaticAbility>, List<Player>> dataTable = HashBasedTable.create();

    @Override
    protected Table<SpellAbility, Optional<StaticAbility>, List<Player>> delegate() {
        return this.dataTable;
    }

    protected SpellAbility getOriginal(SpellAbility sa) {
        SpellAbility original = null;
        SpellAbility root = sa.getRootAbility();
        original = root.isTrigger() ? root.getTrigger().getOverridingAbility() : ObjectUtils.defaultIfNull(root.getOriginalAbility(), root);
        return original;
    }

    public void add(SpellAbility sa) {
        SpellAbility root = sa.getRootAbility();
        SpellAbility original = this.getOriginal(sa);
        if (original != null) {
            Optional<StaticAbility> st = Optional.fromNullable(root.getGrantorStatic());
            ArrayList<Player> activators = (ArrayList<Player>)this.get(original, st);
            if (activators == null) {
                activators = Lists.newArrayList();
            }
            activators.add(sa.getActivatingPlayer());
            this.delegate().put(original, st, activators);
        }
    }

    public Integer get(SpellAbility sa) {
        return this.getActivators(sa).size();
    }

    public List<Player> getActivators(SpellAbility sa) {
        Optional<StaticAbility> st;
        SpellAbility root = sa.getRootAbility();
        SpellAbility original = this.getOriginal(sa);
        if (this.contains(original, st = Optional.fromNullable(root.getGrantorStatic()))) {
            return (List)this.get(original, st);
        }
        return Lists.newArrayList();
    }
}

