/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Predicates;
import forge.StaticData;
import forge.card.CardRulesPredicates;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CounterType;
import forge.game.event.GameEventCardCounters;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityCantVenture;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.trigger.WrappedAbility;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.Localizer;
import forge.util.PredicateString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class VentureEffect
extends SpellAbilityEffect {
    private Card getDungeonCard(SpellAbility sa, Player player, Map<AbilityKey, Object> moveParams) {
        Game game = player.getGame();
        CardCollectionView commandCards = player.getCardsIn(ZoneType.Command);
        for (Card card : commandCards) {
            if (!card.getType().isDungeon()) continue;
            if (!card.isInLastRoom()) {
                return card;
            }
            game.getAction().completeDungeon(player, card);
            break;
        }
        Collection dungeonCards = null;
        if (sa.hasParam("Dungeon")) {
            dungeonCards = StaticData.instance().getVariantCards().getAllCards(Predicates.compose(Predicates.and(CardRulesPredicates.Presets.IS_DUNGEON, CardRulesPredicates.subType(PredicateString.StringOp.EQUALS, sa.getParam("Dungeon"))), PaperCard::getRules));
        } else {
            dungeonCards = StaticData.instance().getVariantCards().getAllCards(Predicates.compose(CardRulesPredicates.Presets.IS_DUNGEON, PaperCard::getRules));
            dungeonCards.removeIf(c -> !c.getRules().isEnterableDungeon());
        }
        String message = Localizer.getInstance().getMessage("lblChooseDungeon", new Object[0]);
        Card dungeon = player.getController().chooseDungeon(player, (List<PaperCard>)dungeonCards, message);
        game.getAction().moveToCommand(dungeon, sa, moveParams);
        return dungeon;
    }

    private String chooseNextRoom(SpellAbility sa, Player player, Card dungeon, String room) {
        String[] nextRoomNames;
        String nextRoomParam = "";
        for (Trigger t2 : dungeon.getTriggers()) {
            String[] roomSA = t2.getOverridingAbility();
            if (!roomSA.getParam("RoomName").equals(room)) continue;
            nextRoomParam = roomSA.getParam("NextRoomName");
            break;
        }
        if ((nextRoomNames = nextRoomParam.split(",")).length > 1) {
            ArrayList<SpellAbility> candidates = new ArrayList<SpellAbility>();
            block1: for (String nextRoomName : nextRoomNames) {
                for (Trigger t3 : dungeon.getTriggers()) {
                    SpellAbility roomSA = t3.getOverridingAbility();
                    if (!roomSA.getParam("RoomName").equals(nextRoomName)) continue;
                    candidates.add(new WrappedAbility(t3, roomSA, player));
                    continue block1;
                }
            }
            String title = Localizer.getInstance().getMessage("lblChooseRoom", new Object[0]);
            SpellAbility chosen = player.getController().chooseSingleSpellForEffect(candidates, sa, title, null);
            return chosen.getParam("RoomName");
        }
        return nextRoomNames[0];
    }

    private void ventureIntoDungeon(SpellAbility sa, Player player, Map<AbilityKey, Object> moveParams) {
        if (StaticAbilityCantVenture.cantVenture(player)) {
            return;
        }
        Game game = player.getGame();
        Card dungeon = this.getDungeonCard(sa, player, moveParams);
        String room = dungeon.getCurrentRoom();
        String nextRoom = null;
        if (room == null || room.isEmpty()) {
            SpellAbility roomSA = dungeon.getTriggers().get((Trigger)false).getOverridingAbility();
            nextRoom = roomSA.getParam("RoomName");
        } else {
            nextRoom = this.chooseNextRoom(sa, player, dungeon, room);
        }
        dungeon.setCurrentRoom(nextRoom);
        game.fireEvent(new GameEventCardCounters(dungeon, CounterType.getType("LEVEL"), 0, 1));
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(dungeon);
        runParams.put(AbilityKey.RoomName, nextRoom);
        game.getTriggerHandler().runTrigger(TriggerType.RoomEntered, runParams, false);
        player.incrementVenturedThisTurn();
    }

    @Override
    public void resolve(SpellAbility sa) {
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, sa.getLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, sa.getLastStateGraveyard());
        for (Player p : VentureEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            this.ventureIntoDungeon(sa, p, moveParams);
        }
    }
}

