/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;

public class UnattachAllEffect
extends SpellAbilityEffect {
    private static void handleUnattachment(GameEntity o, Card cardToUnattach) {
        if (cardToUnattach.isAttachment() && o.hasCardAttachment(cardToUnattach)) {
            cardToUnattach.unattachFromEntity(cardToUnattach.getEntityAttachedTo());
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unattach all valid Equipment and Auras from ");
        sb.append(Lang.joinHomogenous(UnattachAllEffect.getTargetEntities(sa)));
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = sa.getActivatingPlayer().getGame();
        for (GameEntity ge : UnattachAllEffect.getTargetEntities(sa)) {
            String valid = sa.getParam("UnattachValid");
            CardCollectionView unattachList = game.getCardsIn(ZoneType.Battlefield);
            unattachList = CardLists.getValidCards((Iterable<Card>)unattachList, valid, source.getController(), source, (CardTraitBase)sa);
            for (Card c : unattachList) {
                UnattachAllEffect.handleUnattachment(ge, c);
            }
        }
    }
}

