/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import forge.GameCommand;
import forge.card.CardStateName;
import forge.card.GamePieceType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterType;
import forge.game.card.TokenCreateTable;
import forge.game.card.token.TokenInfo;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.player.Player;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class TokenEffectBase
extends SpellAbilityEffect {
    protected TokenCreateTable createTokenTable(Iterable<Player> players, String[] tokenScripts, int finalAmount, SpellAbility sa) {
        TokenCreateTable tokenTable = new TokenCreateTable();
        for (Player owner : players) {
            if (!owner.isInGame()) continue;
            for (String script : tokenScripts) {
                Card result = TokenInfo.getProtoType(script, sa, owner);
                if (result == null) {
                    throw new RuntimeException("don't find Token for TokenScript: " + script);
                }
                result.setTokenSpawningAbility(sa);
                tokenTable.put(owner, result, finalAmount);
            }
        }
        return tokenTable;
    }

    protected TokenCreateTable makeTokenTableInternal(Player owner, String script, int finalAmount, SpellAbility sa) {
        Card result = TokenInfo.getProtoType(script, sa, owner, false);
        if (result == null) {
            throw new RuntimeException("don't find Token for TokenScript: " + script);
        }
        result.setTokenSpawningAbility(sa);
        return this.makeTokenTableInternal(owner, result, finalAmount);
    }

    protected TokenCreateTable makeTokenTableInternal(Player owner, Card result, int finalAmount) {
        TokenCreateTable tokenTable = new TokenCreateTable();
        tokenTable.put(owner, result, finalAmount);
        return tokenTable;
    }

    protected TokenCreateTable makeTokenTable(Iterable<Player> players, String[] tokenScripts, int finalAmount, boolean clone, CardZoneTable triggerList, MutableBoolean combatChanged, SpellAbility sa) {
        return this.makeTokenTable(this.createTokenTable(players, tokenScripts, finalAmount, sa), clone, triggerList, combatChanged, sa);
    }

    protected TokenCreateTable makeTokenTable(TokenCreateTable tokenTable, boolean clone, CardZoneTable triggerList, MutableBoolean combatChanged, SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        long timestamp = game.getNextTimestamp();
        HashSet originalTokens = Sets.newHashSet(tokenTable.columnKeySet());
        HashSet<Player> toRemove = Sets.newHashSet();
        block4: for (Player p : Sets.newHashSet(tokenTable.rowKeySet())) {
            Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(p);
            repParams.put(AbilityKey.Token, tokenTable);
            repParams.put(AbilityKey.Cause, sa);
            repParams.put(AbilityKey.EffectOnly, true);
            switch (game.getReplacementHandler().run(ReplacementType.CreateToken, repParams)) {
                case NotReplaced: {
                    continue block4;
                }
                case Updated: {
                    tokenTable = (TokenCreateTable)repParams.get((Object)AbilityKey.Token);
                    continue block4;
                }
            }
            toRemove.add(p);
        }
        tokenTable.rowKeySet().removeAll(toRemove);
        ArrayList<String> pumpKeywords = Lists.newArrayList();
        if (sa.hasParam("PumpKeywords")) {
            pumpKeywords.addAll(Arrays.asList(sa.getParam("PumpKeywords").split(" & ")));
        }
        ArrayList<Card> allTokens = Lists.newArrayList();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, game.copyLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, game.copyLastStateGraveyard());
        for (Table.Cell c : tokenTable.cellSet()) {
            Card prototype = (Card)c.getColumnKey();
            Player creator = (Player)c.getRowKey();
            Player controller = prototype.getController();
            int cellAmount = (Integer)c.getValue();
            for (int i = 0; i < cellAmount; ++i) {
                Card tok = new CardCopyService(prototype).copyCard(true);
                tok.getStates().forEach(cs -> tok.getState((CardStateName)((Object)((Object)cs))).resetOriginalHost(prototype));
                tok.setOwner(creator);
                if (creator != controller) {
                    tok.setController(controller, timestamp);
                }
                tok.setGameTimestamp(timestamp);
                tok.setGamePieceType(GamePieceType.TOKEN);
                if (sa.hasParam("TokenTapped")) {
                    tok.setTapped(true);
                }
                if (!sa.hasParam("AttachAfter") && sa.hasParam("AttachedTo") && !this.attachTokenTo(tok, sa) && tok.isAura()) continue;
                if (sa.hasParam("WithCountersType")) {
                    CounterType cType = CounterType.getType(sa.getParam("WithCountersType"));
                    int cAmount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("WithCountersAmount", "1"), sa);
                    GameEntityCounterTable table = new GameEntityCounterTable();
                    table.put(creator, tok, cType, cAmount);
                    moveParams.put(AbilityKey.CounterTable, (Object)table);
                }
                if (sa.hasParam("AddTriggersFrom")) {
                    CardCollection cards = AbilityUtils.getDefinedCards(host, sa.getParam("AddTriggersFrom"), sa);
                    for (Card card : cards) {
                        for (Trigger trig : card.getTriggers()) {
                            tok.addTrigger(trig.copy(tok, false));
                        }
                    }
                }
                if (clone || prototype.getCopiedPermanent() != null) {
                    tok.setCopiedPermanent(prototype);
                }
                Card lki = CardCopyService.getLKICopy(tok);
                moveParams.put(AbilityKey.CardLKI, lki);
                Card moved = game.getAction().moveToPlay(tok, sa, moveParams);
                if (moved == null || moved.getZone() == null) {
                    triggerList.put(ZoneType.None, ZoneType.None, moved);
                    continue;
                }
                triggerList.put(ZoneType.None, moved.getZone().getZoneType(), moved);
                triggerList.addToken(lki, creator.getNumTokenCreatedThisTurn() == 0);
                creator.addTokensCreatedThisTurn(lki);
                if (clone) {
                    moved.setCloneOrigin(host);
                }
                if (!pumpKeywords.isEmpty()) {
                    moved.addChangedCardKeywords(pumpKeywords, Lists.newArrayList(), false, timestamp, null);
                    TokenEffectBase.addPumpUntil(sa, moved, timestamp);
                }
                if (sa.hasParam("AtEOTTrig")) {
                    TokenEffectBase.addSelfTrigger(sa, sa.getParam("AtEOTTrig"), moved);
                }
                if (TokenEffectBase.addToCombat(moved, sa, "TokenAttacking", "TokenBlocking")) {
                    combatChanged.setTrue();
                }
                if (sa.hasParam("AttachAfter") && sa.hasParam("AttachedTo")) {
                    this.attachTokenTo(tok, sa);
                }
                moved.updateStateForView();
                if (sa.hasParam("RememberTokens")) {
                    host.addRemembered(moved);
                }
                if (sa.hasParam("RememberOriginalTokens") && originalTokens.contains(prototype)) {
                    host.addRemembered(moved);
                }
                if (sa.hasParam("ImprintTokens")) {
                    host.addImprintedCard(moved);
                }
                if (sa.hasParam("RememberSource")) {
                    moved.addRemembered(host);
                }
                if (sa.hasParam("TokenRemembered")) {
                    moved.addRemembered(AbilityUtils.getDefinedObjects(host, sa.getParam("TokenRemembered"), sa));
                }
                allTokens.add(moved);
                if (!sa.hasParam("CleanupForEach")) continue;
                moved.removeRemembered(prototype.getRemembered());
            }
        }
        if (sa.hasParam("AtEOT")) {
            TokenEffectBase.registerDelayedTrigger(sa, sa.getParam("AtEOT"), allTokens);
        }
        return tokenTable;
    }

    private boolean attachTokenTo(Card tok, SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        GameEntity aTo = Iterables.getFirst(AbilityUtils.getDefinedEntities(host, sa.getParam("AttachedTo"), (CardTraitBase)sa), null);
        if (aTo != null) {
            Card lki = CardCopyService.getLKICopy(tok);
            lki.setLastKnownZone(tok.getController().getZone(ZoneType.Battlefield));
            game.getTracker().freeze();
            CardCollection preList = new CardCollection(lki);
            game.getAction().checkStaticAbilities(false, Sets.newHashSet(lki), preList);
            boolean canAttach = lki.isAttachment();
            if (canAttach && !aTo.canBeAttached(lki, sa)) {
                canAttach = false;
            }
            game.getAction().checkStaticAbilities(false);
            game.getTracker().clearDelayed();
            game.getTracker().unfreeze();
            if (!canAttach) {
                return false;
            }
            tok.attachToEntity(aTo, sa);
            return true;
        }
        return false;
    }

    public static void addPumpUntil(SpellAbility sa, final Card c, final long timestamp) {
        if (!sa.hasParam("PumpDuration")) {
            return;
        }
        String duration = sa.getParam("PumpDuration");
        Card host = sa.getHostCard();
        final Game game = host.getGame();
        GameCommand untilEOT = new GameCommand(){
            private static final long serialVersionUID = -42244224L;

            @Override
            public void run() {
                c.removeChangedCardKeywords(timestamp, 0L);
                game.fireEvent(new GameEventCardStatsChanged(c));
            }
        };
        if ("UntilYourNextTurn".equals(duration)) {
            game.getCleanup().addUntil(sa.getActivatingPlayer(), untilEOT);
        } else {
            game.getEndOfTurn().addUntil(untilEOT);
        }
    }
}

